/*
 * dirtest.c dated 08/22/95
 *
 * Author:
 * Thomas Binder
 * (binder@rbg.informatik.th-darmstadt.de)
 *
 * Purpose:
 * Example program for correct use of alternative
 * file systems, independent of the operating
 * system currently used (it should be TOS-
 * compatible, of course). DirRead reads the
 * directory given in the commandline and displays
 * the filenames to stdout, one per line (without
 * attributes, as the file would get too long,
 * then).
 *
 * History:
 * (Omitted in the English translation)
 */


#include <stdio.h>
#include <stdlib.h>
#ifdef __MINT__
#include <unistd.h>
#include <fcntl.h>
typedef struct xattr
{
    unsigned int    mode;
    long            index;
    unsigned int    dev;
    unsigned int    rdev;
    unsigned int    nlink;
    unsigned int    uid;
    unsigned int    gid;
    long            size;
    long            blksize, nblocks;
    int             mtime, mdate;
    int             atime, adate;
    int             ctime, cdate;
    int             attr;
    int             reserved2;
    long            reserved3[2];
} XATTR;
#endif
#include <mintbind.h>
#include <portab.h>

#define MAX_CONF	8
#define MAX_TRUNC	2
#define MAX_CASE	2

typedef struct
{
	ULONG	bitmask;
	char	*identifier;
} COMPARE;

void print_date(UWORD gemdos_date);
void print_time(UWORD gemdos_time);

WORD main(WORD argc, char *argv[])
{
#ifdef __MINT__
	_CCONLINE	input;
#else
	LINE		input;
#endif
	LONG		value;
	char		*conf_name[] = {
					"Maximum number of open files: ",
					"Maximum number of links to a file: ",
					"Maximum path length: ",
					"Maximum filename length: ",
					"Size of an atomic write: ",
					"Filename truncation: ",
					"Case sensitivity: ",
					"Allowed attributes and filetypes: ",
					"Supported XATTR-fields: "},
				*trunc_name[] = {
					"No truncation\n",
					"Truncation to maximum length\n",
					"8+3-truncation\n"},
				*case_name[] = {
					"Fully case sensitive\n",
					"Case insensitive, case is preserved\n",
					"Case insensitive, case is altered\n"},
				linkdest[256];
	COMPARE		tosattr[] = {
					1,		"Readonly",
					2,		"Hidden",
					4,		"System",
					8,		"Label",
					16,		"Directory",
					32,		"Changed",
					64,		"(Bit 6)",
					128,	"(Bit 7)",
					0,				NULL},
				unixattr[] = {
					04000L << 8L,	"SetUID",
					02000L << 8L,	"SetGID",
					01000L << 8L,	"Sticky",
					0400L << 8L,	"RUSR",
					0200L << 8L,	"WUSR",
					0100L << 8L,	"XUSR",
					040L << 8L,		"RGRP",
					020L << 8L,		"WGRP",
					010L << 8L,		"XGRP",
					04L << 8L,		"ROTH",
					02L << 8L,		"WOTH",
					01L << 8L,		"XOTH",
					0,				NULL},
				filetypes[] = {
					0x00100000L,	"Dir",
					0x00200000L,	"Char",
					0x00400000L,	"Block",
					0x00800000L,	"Regular",
					0x01000000L,	"Symlink",
					0x02000000L,	"Socket",
					0x04000000L,	"FIFO",
					0x08000000L,	"Memory",
					0x10000000L,	"(Bit 28)",
					0x20000000L,	"(Bit 29)",
					0x40000000L,	"(Bit 30)",
					0x80000000L,	"(Bit 31)",
					0,				NULL},
				xattrfields[] = {
					0x0001L,	"index",
					0x0002L,	"dev",
					0x0004L,	"rdev",
					0x0008L,	"nlink",
					0x0010L,	"uid",
					0x0020L,	"gid",
					0x0040L,	"blksize",
					0x0080L,	"size",
					0x0200L,	"nblocks",
					0x0400L,	"atime",
					0x0400L,	"ctime",
					0x0800L,	"mtime",
					0x1000L,	"(Bit 12)",
					0x2000L,	"(Bit 13)",
					0x4000L,	"(Bit 14)",
					0x8000L,	"(Bit 15)",
					0,				NULL};
	WORD		i,
				j,
				k,
				des,
				mode,
				one;
	LONG		max_mode;
	XATTR		attribs;

	if (Dpathconf("U:\\", -1) == -32L)
	{
		puts("Dpathconf() not available!");
		return(1);
	}
	if (argc <= 1)
	{
		Cconws("Enter test directory: ");
		input.maxlen = 254;
		Cconrs(&input);
		input.buffer[input.actuallen] = 0;
		argc = 2;
		argv[1] = input.buffer;
	}
	for (i = 1; i < argc; i++)
	{
		printf("\nInformation for: %s\n", argv[i]);
		if ((max_mode = Dpathconf(argv[i], -1)) < 0)
		{
			puts("None available! (Error)");
			goto get_xattr;
		}
		printf("Highest supported Dpathconf()modes: %ld\n", max_mode);
		for (j = 0; j <= (WORD)max_mode; j++)
		{
			if (j <= MAX_CONF)
				printf(conf_name[j]);
			else
				printf("Mode %d: ", j);
			value = Dpathconf(argv[i], j);
			if (value < 0)
				puts("Couldn't be determined! (Error)");
			else
			{
				switch (j)
				{
					case 5:
						if (value > MAX_TRUNC)
							printf("%ld (0x%lx)\n", value, value);
						else
							printf(trunc_name[value]);
						break;
					case 6:
						if (value > MAX_CASE)
							printf("%ld (0x%lx)\n", value, value);
						else
							printf(case_name[value]);
						break;
					case 7:
						one = 0;
						printf("  GEMDOS-attributes: ");
						for (k = 0; tosattr[k].identifier; k++)
						{
							if (value & tosattr[k].bitmask)
							{
								if (one)
									printf(", ");
								printf(tosattr[k].identifier);
								one = 1;
							}
						}
						if (!one)
							printf("None!");
						puts("");
						one = 0;
						printf("  UNIX-attributes: ");
						for (k = 0; unixattr[k].identifier; k++)
						{
							if (value & unixattr[k].bitmask)
							{
								if (one)
									printf(", ");
								printf(unixattr[k].identifier);
								one = 1;
							}
						}
						if (!one)
							printf("None!");
						puts("");
						one = 0;
						printf("  Filetypes: ");
						for (k = 0; filetypes[k].identifier; k++)
						{
							if (value & filetypes[k].bitmask)
							{
								if (one)
									printf(", ");
								printf(filetypes[k].identifier);
								one = 1;
							}
						}
						if (!one)
							printf("None!");
						puts("");
						break;
					case 8:
						one = 0;
						for (k = 0; xattrfields[k].identifier; k++)
						{
							if (value & xattrfields[k].bitmask)
							{
								if (one)
									printf(", ");
								printf(xattrfields[k].identifier);
								one = 1;
							}
						}
						if (!one)
							printf("None!");
						puts("");
						break;
					default:
						if (value == 0x7fffffffL)
							puts("Unlimited");
						else
						{
							printf("%ld (0x%lx, %#lo)\n", value,
								value, value);
						}
						break;
				}
			}
		}
get_xattr:
		printf("\nFxattr()-result for %s:\n", argv[i]);
		if (Fxattr(1, argv[i], &attribs) != 0)
		{
			puts("Failed!");
			continue;
		}
		switch ((mode = (attribs.mode & 0170000)))
		{
			case 020000:
				puts("BIOS-special");
				break;
			case 040000:
				puts("Directory");
				break;
			case 0100000:
				puts("Regular File");
				break;
			case 0120000:
				puts("FIFO");
				break;
			case 0140000:
				puts("Memory block or process file");
				break;
			case 0160000:
				printf("Symbolic link ");
				if (Freadlink(256, linkdest, argv[i]) != 0)
				 puts ("- destination couldn't be determined!");
				else
				 printf("to %s\n", linkdest);
				break;
			default:
				printf("Unknown type %d (0x%x, %#o)\n",
					mode, mode, mode);
				break;
		}
		printf("Access rights: %#04o\n", attribs.mode & ~0170000);
		printf("Device: %d\n", attribs.dev);
		printf("(BIOS-Device: %d)\n", attribs.rdev);
		printf("Number of hardlinks: %d\n", attribs.nlink);
		printf("Last inode modification: ");
		print_date(attribs.cdate);
		printf(", ");
		print_time(attribs.ctime);
		puts("");
		printf("Last modification: ");
		print_date(attribs.mdate);
		printf(", ");
		print_time(attribs.mtime);
		puts("");
		printf("Last access: ");
		print_date(attribs.adate);
		printf(", ");
		print_time(attribs.atime);
		puts("");
		if ((des = open(argv[i], O_WRONLY)) < 0)
			puts("Can't be opened as a file!");
		else
		{
			if (isatty(des))
				puts("File represents a terminal.");
			close(des);
		}
	}
	return(0);
}

void print_date(UWORD gemdos_date)
{
	UWORD	day, month, year;

	day = gemdos_date & 31;
	month = (gemdos_date >> 5) & 15;
	year = (gemdos_date >> 9) + 1980;
	printf("%02d/%02d/%04d", month, day, year);
}

void print_time(UWORD gemdos_time)
{
	UWORD	h, m, s;

	s = (gemdos_time & 31) * 2;
	m = (gemdos_time >> 5) & 63;
	h = gemdos_time >> 11;
	printf("%02d:%02d:%02d", h, m, s);
}

/* end */
