/*
 * system.c dated 08/22/95
 *
 * Author:
 * Thomas Binder
 * (binder@rbg.informatik.th-darmstadt.de)
 *
 * Purpose:
 * Example program for correct use of alternative
 * file systems, independent of the operating
 * system currently used (it should be TOS-
 * compatible, of course). DirRead reads the
 * directory given in the commandline and displays
 * the filenames to stdout, one per line (without
 * attributes, as the file would get too long,
 * then).
 *
 * History:
 * (Omitted in the English translation)
 */

/*
 * This is part of Thing. dir_check descends a given directory and counts
 * all files, links and directories it encounters. No comments here, as I'm
 * already tired after translating the comments in dirread.c ...
 */

static int build_filename(char *dst, char *a, char *b);

static int build_filename(char *dst, char *a, char *b)
{
 if ((strlen(a) + strlen(b)) < (long)MAX_PLEN)
 {
  strcpy(dst, a);
  strcat(dst, b);
  return(0);
 }
 else
 {
  frm_alert(1,rs_frstr[ALRECURS],altitle,conf.wdial,0L);
  return(1);
 }
}

int dir_check(char *path,int *nfiles,int *nfolders,long *size,
 int *nlinks,int follow,int sub)
{
 int fret,
  xread,
  len;
 static XATTR xattr;
 DTA *old_dta,
  mydta;
 long dirh,
  xfret;
 char fpath[MAX_PLEN];
 static char fname[MAX_FLEN + 4];
 char xname[MAX_PLEN];
 char *p;

 if (sub > 16)
 {
  frm_alert(1,rs_frstr[ALRECURS],altitle,conf.wdial,0L);
  return(1);
 }
 strcpy(fpath, path);
 len = (int)strlen(fpath);
 if (!len)
  return(1);
 if ((fpath[len - 1] == '\\') && (len > 3))
  fpath[len - 1] = 0;
 if (len > 3)
 {
  fret = file_exists(fpath, follow, &xattr);
  if (fret)
  {
   err_file(rs_frstr[ALPREAD], (long)fret, fpath);
   return(fret);
  }
  xattr.mode &= S_IFMT;
  if (xattr.mode != S_IFDIR)
  {
   *size += xattr.size;
   (*nfiles)++;
   if (xattr.mode == S_IFLNK)
    (*nlinks)++;
   return(0);
  }
  (*nfolders)++;
 }
 if (sub == -1)
  return(0);
 dirh = Dopendir(fpath, 0);
 strcat(fpath, "\\");
 if (dirh != -32L)
 {
  if ((dirh & 0xff000000L) == 0xff000000L)
  {
   err_file(rs_frstr[ALPREAD], dirh, fpath);
   return((int)dirh);
  }
 }
 fret = 0;
 if (dirh != -32L)
 {
  xread = 1;
  while (fret == 0)
  {
   if (xread)
    fret = (int)Dxreaddir(MAX_FLEN + 4, dirh, fname, &xattr, &xfret);
   if (follow || !xread || (fret == -32L))
   {
    if (!xread || (fret == -32L))
    {
     xread = 0;
     fret = (int)Dreaddir(MAX_FLEN + 4, dirh, fname);
     if (fret)
      break;
    }
    else
    {
     if (fret)
      break;
    }
    if ((fret = build_filename(xname, fpath, &fname[4])) != 0)
     break;
    xfret = Fxattr(!follow, xname, &xattr);
   }
   if (fret)
    break;
   if (xfret)
   {
    fret = (int)xfret;
    break;
   }
   xattr.mode &= S_IFMT;
   if (xattr.mode == S_IFDIR)
   {
    if (!strcmp(&fname[4], ".") || !strcmp(&fname[4], ".."))
     continue;
    if ((fret = build_filename(xname, fpath, &fname[4])) != 0)
     break;
    fret = dir_check(xname, nfiles, nfolders, size, nlinks, follow,
     sub + 1);
    if (fret)
    {
     fret = 1;
     break;
    }
   }
   else
   {
    (*nfiles)++;
    if (xattr.mode == S_IFLNK)
     (*nlinks)++;
    *size += xattr.size;
   }
  }
  Dclosedir(dirh);
 }
 else
 {
  len = (int)strlen(fpath);
  strcat(fpath, "*.*");
  old_dta = Fgetdta();
  Fsetdta(&mydta);
  for (fret = Fsfirst(fpath, 0x17); fret == 0; fret = Fsnext())
  {
   if (mydta.d_attrib & FA_SUBDIR)
   {
    if (!strcmp(mydta.d_fname, ".") || !strcmp(mydta.d_fname, ".."))
     continue;
    fpath[len] = 0;
    if ((fret = build_filename(xname, fpath, mydta.d_fname)) != 0)
     break;
    fpath[len] = '*';
    fret = dir_check(xname, nfiles, nfolders, size, nlinks, follow,
     sub + 1);
    if (fret)
    {
     fret = 1;
     break;
    }
   }
   else
   {
    (*nfiles)++;
    *size += mydta.d_length;
   }
  }
  fpath[len] = 0;
  Fsetdta(old_dta);
 }
 if(fret && (fret != -49) && (fret != -33))
 {
  if(fret != 1)
  {
   p = strrchr(fname, '\\');
   if (p)
    *p = 0;
   err_file(rs_frstr[ALPREAD],(long)fret,fname);
   if (p)
    *p = '\\';
  }
 }
 else fret=0;
 return(fret);
}

/* end */
