;       Programme de dmonstration pour Pure Assembler

                import _StkSize                 ; dfini par PLINK!

start:          lea.l   start-256, a1           ; Dbut de la page de base
                move.l  12(a1), d1              ; Taille du code (Text)
                add.l   20(a1), d1              ; Taille des donnes (Data)
                add.l   28(a1), d1              ; Taille du segment BSS
                add.l   #256,   d1              ; Taille de la page de base

                move.l  d1,  -(sp)              ; Taille de la zone dsire
                move.l  a1,  -(sp)              ; Adresse de la zone mmoire
                clr     -(sp)                   ; (mot de remplissage)
                move    #74, -(sp)              ; Mshrink
                trap    #1                      ; Gemdos

                add.l   a1, d1                  ; adresse de la pile
                and.b   #$fc, d1                ; alignement de l'adresse
                move.l  d1, sp                  ; (pile dans segment BSS)

                ; Effacement de l'cran:
                move.l  #efface_ecran, -(sp)
                move    #9, -(sp)               ; Cconws
                trap    #1                      ; Gemdos
                addq.l  #6, sp                  ; correction de la pile

                ; Cconws("Bonjour le monde\n\r")
                move.l  #bonjour, -(sp)
                move    #9, -(sp)
                trap    #1
                addq.l  #6, sp

                ; Cconws("Taille de la pile: $");
                move.l  #pile, -(sp)
                move    #9, -(sp)
                trap    #1
                addq.l  #6, sp

                ; Cconws(ltohex(_StkSize))
                move.l  #_StkSize, -(sp)
                jsr     ltohex(pc)
                move.l  a0, (sp)
                move    #9, -(sp)
                trap    #1
                addq.l  #6, sp


                ; Cconws("\n\rJouons aux ds...")
                move.l  #des, -(sp)
                move    #9, -(sp)
                trap    #1
                addq.l  #6, sp

boucle_majeure: ; Cconws("\n\rLe d roule et donne: ");
                move.l  #affichage, -(sp)
                move    #9, -(sp)
                trap    #1
                addq.l  #6, sp

                ; Random()
                move    #17, -(sp)              ; Random
                trap    #14                     ; xbios
                addq.l  #2, sp

                and.l   #$FFFF, d0              ; on ne garde que 16 bits
                divu    #6, d0                  ; on les divise par 6
                swap    d0                      ; on garde le reste(modulo)
                add     #$31, d0                ; on ajoute '1' (Cte ASCII)

                ; Cconout(d0)
                move    d0, -(sp)
                move    #2, -(sp)               ; Cconout
                trap    #1
                addq.l  #4, sp

boucle_mineure: ; Cconws("\n\rencore (o/n)?");
                move.l  #encore, -(sp)
                move    #9, -(sp)
                trap    #1
                addq.l  #6, sp

                ; Cconin()
                move    #1, -(sp)
                trap    #1
                addq.l  #2, sp

                cmp.b   #'o', d0
                beq     boucle_majeure
                cmp.b   #'O', d0
                beq     boucle_majeure

                cmp.b   #'n', d0
                beq     exit
                cmp.b   #'N', d0
                bne     boucle_mineure

exit:           ; Pterm0()
                move    #0, -(sp)
                trap    #1

; Cette routine convertit le mot long qui se trouve au sommet de la
; pile au moment de l'appel en une chane de caractres ASCII qui
; reprsente le nombre sous forme hexadcimale. La routine retourne
; dans a0 l'adresse de la chane de caractres (un petit tampon).

ltohex:         move.l  a1, -(sp)               ; sauvegarde a1
                move.l  d1, -(sp)               ; sauvegarde d1
                move.l  d2, -(sp)               ; sauvegarde d2

                move.l  16(sp), d0              ; rcupre le paramtre
                move.l  #tampon, a0
                move.l  #chiffres, a1

                move    #8, d2
boucle:         move.b  d0, d1
                and.b   #$0f, d1
                ext     d1
                move.b  (a1, d1.w), (a0, d2)
                asr.l   #4, d0
                dbeq    d2, boucle


                move.l  (sp)+, d2
                move.l  (sp)+, d1
                move.l  (sp)+, a1
                rts


                data

efface_ecran:   dc.b    27, 'E', 0
bonjour:        dc.b    "Bonjour le monde!", $d, $a, 0
pile:           dc.b    "Taille de la pile: $", 0
des:            dc.b    $d, $a, "Jouons aux ds...", 0
affichage:      dc.b    $d, $a, "Le d roule et donne: ", 0
encore:         dc.b    $d, $a, "encore (o/n)?", 0
chiffres:       dc.b    "0123456789ABCDEF"
tampon:         dc.b    "00000000", 0
