/************************************************************************/
/*                                                                      */
/*       clockacc.c                                                     */
/*                                                                      */
/*       Exemple d'accessoire. Un accessoire est un programme           */
/*         rsident en mmoire et accessible par le menu du bureau.     */
/*                                                                      */
/*       Si l'extension .ACC du programme est change (ex: .PRG),       */
/*         l'accessoire deviendra alors un simple programme GEM.        */
/*                                                                      */
/*       Ce programme affiche l'heure et la date dans une fentre.      */
/*                                                                      */
/*       Copyright (c) 1989 Borland International                       */
/*       Tous droits rservs.                                          */
/*                                                                      */
/************************************************************************/

/* -------------------------------------------------------------------- */
/*       Inclusion des fichiers de dclarations.                        */
/* -------------------------------------------------------------------- */

#include <aes.h>
#include <vdi.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>

/* -------------------------------------------------------------------- */
/*       Macros.                                                        */
/* -------------------------------------------------------------------- */

#define min(a, b)             ((a) < (b) ? (a) : (b))
#define max(a, b)             ((a) > (b) ? (a) : (b))

/* -------------------------------------------------------------------- */
/*       Dclarations des variables globales externes.                  */
/* -------------------------------------------------------------------- */
                                    /* Cette variable globale permet    */
extern int _app;                    /*   au programme de dterminer     */
                                    /*   s'il a t lanc comme         */
                                    /*   programme ou comme accessoire  */
/* -------------------------------------------------------------------- */
/*       Variables globales.                                            */
/* -------------------------------------------------------------------- */

int    whandle;                     /* Identificateur de la fentre     */
char   title[] = "Horloge Pure C";  /* Titre de la fentre              */
int    gl_wchar,                    /* Largeur et hauteur d'un          */
       gl_hchar,                    /*   caractre                      */
       gl_wbox,                     /* Largeur et hauteur de la         */
       gl_hbox;                     /*   zone d'affichage               */

int    phys_handle,                 /* Identificateur pour GEM et VDI   */
       handle;
int    max_x,                       /* Largeur maximale de l'cran      */
       max_y;                       /* Hauteur maximale de l'cran      */
int    appl_id,                     /* Identificateur du programme      */
       menu_id;                     /* Identificateur dans le menu GEM  */

time_t Tim = 0;                     /* Minuteur                         */

char Time_pattern[40] = "  %H:%M - %a %d.%b %Y";

/* -------------------------------------------------------------------- */
/*       Prototypes des fonctions.                                      */
/* -------------------------------------------------------------------- */

void open_window( void );
int  rc_intersect( GRECT *r1, GRECT *r2 );
void mouse_on( void );
void mouse_off( void );
void redraw_window( int all );
int  handle_message( int pipe[8] );
void event_loop( void );

/* -------------------------------------------------------------------- */
/*       void main( void );                                             */
/*                                                                      */
/*       Programme principal.                                           */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void main( void )
{
   int i;
   int work_in[11];
   int work_out[57];

                                 /* ----------------------------------- */
                                 /* Initialisation du programme:        */
                                 /* ----------------------------------- */
   appl_id = appl_init( );
   if ( appl_id != -1 )
   {
      for ( i = 0; i < 10; i++ )
         work_in[i]  = 1;
      work_in[10] = 2;
      phys_handle = graf_handle( &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox );
      handle = phys_handle;
      v_opnvwk( work_in, &handle, work_out );
      if ( handle != 0 )
      {
         max_x = work_out[0];
         max_y = work_out[1];
         if ( !_app )             /* Si le programme a t lanc en     */
                                  /*   tant qu'accessoire _app vaut 0,  */
                                  /*   sinon _app vaut 1                */

            menu_id = menu_register( appl_id, "  Horloge Pure C" );
         else
         {
            graf_mouse( 0, (void*)0 );
            open_window( );
         }

                                 /* ----------------------------------- */
                                 /* Boucle d'attente des vnements     */
                                 /* ----------------------------------- */
         event_loop( );

                                 /* ----------------------------------- */
                                 /* Fermeture du port graphique         */
                                 /* ----------------------------------- */

         v_clsvwk( handle );
      }
      appl_exit( );
   }
   exit( 0 );
}

/* -------------------------------------------------------------------- */
/*       void open_window( void );                                      */
/*                                                                      */
/*       Ouverture de la fentre d'affichage de l'horloge.              */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void open_window( void )
{
   if ( whandle <= 0 )
   {
      whandle = wind_create( NAME|CLOSER|MOVER, 0, 0, max_x + 1, max_y + 1 );
      if ( whandle <= 0 )
         return;

      wind_set( whandle, WF_NAME, title );
      wind_open( whandle, max_x / 10, max_y / 10, max_x / 3 * 2, max_y / 5 );
   }
   else
      wind_set( whandle, WF_TOP );
}

/* -------------------------------------------------------------------- */
/*       boolean rc_intersect( GRECT *r1, GRECT *r2 );                  */
/*                                                                      */
/*       Calcule l'intersection de deux rgions rectangulaires.         */
/*                                                                      */
/*       -> r1, r2               Pointeurs sur leurs coordonnes.       */
/*                                                                      */
/*       <-                      == 0  si les deux rgions ne se        */
/*                                       touchent pas,                  */
/*                               != 0  si elles se touchent.            */
/*                                     (r2 contient les coordonnes     */
/*                                      du rectangle intersection)      */
/* -------------------------------------------------------------------- */

int rc_intersect( GRECT *r1, GRECT *r2 )
{
   int x, y, w, h;

   x = max( r2->g_x, r1->g_x );
   y = max( r2->g_y, r1->g_y );
   w = min( r2->g_x + r2->g_w, r1->g_x + r1->g_w );
   h = min( r2->g_y + r2->g_h, r1->g_y + r1->g_h );

   r2->g_x = x;
   r2->g_y = y;
   r2->g_w = w - x;
   r2->g_h = h - y;

   return ( ((w > x) && (h > y) ) );
}

/* -------------------------------------------------------------------- */
/*       void mouse_on( void );                                         */
/*                                                                      */
/*       Activation de la souris.                                       */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void mouse_on( void )

{
   graf_mouse( M_ON, (void *)0 );
}

/* -------------------------------------------------------------------- */
/*       void mouse_off( void );                                        */
/*                                                                      */
/*       Dsactivation de la souris.                                    */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void mouse_off( void )
{
   graf_mouse( M_OFF, (void *)0 );
}

/* -------------------------------------------------------------------- */
/*       void redraw_window( int all );                                 */
/*                                                                      */
/*       Rgnration de l'affichage de la fentre,  cause d'un        */
/*         nouvel affichage  l'cran, ou parce que la fentre          */
/*         vient tout juste d'tre ouverte.                             */
/*                                                                      */
/*       -> all                  == 0  Rgnrer l'heure et la date     */
/*                               != 0  Rgnrer compltement la        */
/*                                       fentre                        */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void redraw_window( int all )
{
   GRECT     box,
             work;
   int       clip[4];
   char      s[40];                    /* Tampon pour la date & l'heure */
   time_t    tim;

   if( whandle <= 0 )                  /* Il n'y a aucune fentre       */
      return;                          


                                       /* Une minute vient de passer ?  */
   if ( ((tim = time( &tim ) / 60 ) > Tim ) || all )
   {
      Tim = tim;                       /* Oui, mettre  jour l'heure    */
      tim *= 60;

      strftime( s, 40, Time_pattern, localtime( &tim ));

      mouse_off( );

      vsf_color( handle, 0 );                       /* set white fill   */
      vswr_mode( handle, 1 );                       /* set replace mode */

      wind_get( whandle, WF_WORKXYWH, &work.g_x, &work.g_y, &work.g_w, &work.g_h );
      wind_get( whandle, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h );
      work.g_w = min( work.g_w, max_x - work.g_x + 1 );
      work.g_h = min( work.g_h, max_y - work.g_y + 1 );

      while ( box.g_w > 0 && box.g_h > 0 )
      {
         if( rc_intersect( &work, &box ) )
         {
            clip[0] = box.g_x;
            clip[1] = box.g_y;
            clip[2] = box.g_x + box.g_w - 1;
            clip[3] = box.g_y + box.g_h - 1;

            vs_clip( handle, 1, clip );
            if ( all )
               vr_recfl( handle, clip );              /* fill rectangle */
            v_gtext( handle, (work.g_x + work.g_w / 2) - (int)strlen( s ) * gl_wchar / 2,
                     work.g_y + max_y / 10, s );
         }
         wind_get( whandle, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h );
      }
      mouse_on( );
   }
}

/* -------------------------------------------------------------------- */
/*       int handle_message( int pipe[8] );                             */
/*                                                                      */
/*       Traitement des vnements reus dans le tampon  message.      */
/*                                                                      */
/*       ->                      Pointeur sur le tampon  message.      */
/*                                                                      */
/*       <-                      Si la fentre est referme et si le    */
/*                                 programme n'est pas un accessoire,   */
/*                                 alors la fonction retourne 1 pour    */
/*                                 signaler l'arrt du programme, sinon */
/*                                 la fonction retourne toujours 0.     */
/* -------------------------------------------------------------------- */

int handle_message( int pipe[8] )
{
   switch ( pipe[0] )
   {
      case WM_REDRAW:
         redraw_window( 1 );
      break;

      case WM_TOPPED:
         wind_set( whandle, WF_TOP );
      break;

      case WM_CLOSED:
         if ( pipe[3] == whandle )
         {
            wind_close( whandle );
            wind_delete( whandle );
            whandle = 0;
         }
         if ( _app )
            return ( 1 );
      break;

      case WM_MOVED:
      case WM_SIZED:
         if ( pipe[3] == whandle )
            wind_set( whandle, WF_CURRXYWH,  pipe[4], pipe[5], pipe[6], pipe[7] );
     break;

      case AC_OPEN:
         if ( pipe[4] == menu_id )
            open_window( );
      break;

      case AC_CLOSE:
         if ( pipe[3] == menu_id )
            whandle = 0;
      break;
   }
   return ( 0 );
}

/* -------------------------------------------------------------------- */
/*    event_loop()                                                      */
/*                                                                      */
/*    La boucle d'attente des vnements.                               */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void event_loop( void )
{
   int x, y,
       kstate,
       key,
       clicks,
       event,
       state;
   int pipe[8];
   int quit;

   quit = 0;
   do
   {
      event = evnt_multi( MU_MESAG | MU_TIMER,
                          2, 0x1, 1,
                          0, 0, 0, 0, 0,
                          0, 0, 0, 0, 0,
                          pipe,
                          1000, 0,
                          &x, &y, &state, &kstate, &key, &clicks );

      wind_update( BEG_UPDATE );

      if ( event & MU_MESAG )
         quit = handle_message( pipe );

      if ( event & MU_TIMER )
         redraw_window( 0 );

      wind_update( END_UPDATE );
   }
   while ( !quit );
}

/* -------------------------------------------------------------------- */
/*       Fin de CLOCKACC.C                                              */
/* -------------------------------------------------------------------- */
