/************************************************************************/
/*                                                                      */
/*       Programme de dmonstration utilisant:        APPL_TRECORD( )   */
/*       (Enregistrement, reproduction des vnements)  APPL_TPLAY( )   */
/*                                                                      */
/*       Copyright (c) 1989 Borland International                       */
/*       Tous droits rservs.                                          */
/*                                                                      */
/************************************************************************/

/* -------------------------------------------------------------------- */
/*       Inclusion des fichiers de dclarations.                        */
/* -------------------------------------------------------------------- */

#include <aes.h>

/* -------------------------------------------------------------------- */
/*       Dfinitions des constantes.                                    */
/* -------------------------------------------------------------------- */

#define STARTMES              0
#define EORECORDING           1
#define REPLAYFAST            2
#define REPLAYHURICANE        3
#define GOODBYE               4

#define BUFSIZE               16000

/* -------------------------------------------------------------------- */
/*       Dfinitions de type.                                           */
/* -------------------------------------------------------------------- */

typedef struct
{
    long     code;
    long     event;
}
RECORD;

/* -------------------------------------------------------------------- */
/*    Variables globales.                                               */
/* -------------------------------------------------------------------- */

char *Mess[] =
{
    "[1][Tous les vnements, tous les|mouvements de la souris vont|tre enregistrs pendant|quelques secondes.][OK]",
    "[3][Mouvements enregistrs.|Reproduisons-les maintenant!][OK]",
    "[1][Maintenant reproduisont-les|plus vite...][OK]",
    "[1][Puis, encore plus vite!][OK]",
    "[3][Voila, c'est fini!][Merci]"
};

RECORD Buffer[BUFSIZE];

/* -------------------------------------------------------------------- */
/*       Prototypes des fonctions.                                      */
/* -------------------------------------------------------------------- */

void gem_prg( void );
int usage( int message);

/* -------------------------------------------------------------------- */
/*       void gem_prg( void );                                          */
/*                                                                      */
/*       Exemple d'utilisation des fonctions appl_trecord() et          */
/*         appl_tplay() dans un programme GEM.                          */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void gem_prg( void )
{
   usage( STARTMES );
   appl_trecord( Buffer, 2000 );
   usage( EORECORDING );
   appl_tplay( Buffer, 2000, 5 );
   usage( REPLAYFAST );
   appl_tplay( Buffer, 2000, 20 );
   usage( REPLAYHURICANE );
   appl_tplay( Buffer, 2000, 100 );
   usage( GOODBYE );
}

/* -------------------------------------------------------------------- */
/*       int usage( int message );                                      */
/*                                                                      */
/*       Cette fonction affiche un message pour prvenir l'utilisateur  */
/*         de ce qui l'attend.                                          */
/*                                                                      */
/*       -> message              Pointeur sur le message dsir.        */
/*                                                                      */
/*       <-                      Le numro du bouton qui a t cliqu   */
/*                                 dans la bote d'alerte.              */
/* -------------------------------------------------------------------- */

int usage( int message )
{
   return ( form_alert( 1, *( Mess + message )));
}

/* -------------------------------------------------------------------- */
/* Fin du programme de dmonstration de APPL_TRECORD() et APPL_TPLAY(). */
/* -------------------------------------------------------------------- */
