/************************************************************************/
/*                                                                      */
/*       Programme de dmonstration utilisant:          EVNT_MESAG( )   */
/*       (Attente d'un vnement)                                       */
/*                                                                      */
/*       Copyright (c) 1989 Borland International                       */
/*       Tous droits rservs.                                          */
/*                                                                      */
/************************************************************************/

/* -------------------------------------------------------------------- */
/*       Inclusion des fichiers de dclarations.                        */
/* -------------------------------------------------------------------- */

#include <aes.h>

/* -------------------------------------------------------------------- */
/*       Dfinition des constantes.                                     */
/* -------------------------------------------------------------------- */

#define ME_HIDE               0
#define ME_SHOW               1
#define ME_NORM               1

#define RSC_NAME              "PCTEST.RSC"

/* -------------------------------------------------------------------- */
/*       Dfinitions de type                                            */
/* -------------------------------------------------------------------- */

typedef enum
{
    FALSE,
    TRUE
}
boolean;

/* -------------------------------------------------------------------- */
/*       Variables globales.                                            */
/* -------------------------------------------------------------------- */

OBJECT *M_tree;

/* -------------------------------------------------------------------- */
/*       Prototypes des fonctions.                                      */
/* -------------------------------------------------------------------- */

void gem_prg( void );

/* -------------------------------------------------------------------- */
/*       void gem_prg( void );                                          */
/*                                                                      */
/*       Exemple d'utilisation de la fonction evnt_mesag() dans         */
/*         un programme GEM.                                            */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void gem_prg( void )
{
   int     msgbuff[8];                    /* Tampon  message           */
   boolean done = FALSE;                  /* Drapeau d'attente          */

   if ( rsrc_load( RSC_NAME ) > 0 )       /* Chagement d'un fichier     */
   {                                      /*   ressource                */
      rsrc_gaddr( 0, 0, &M_tree );        /* Adresse de l'arborescence  */
                                          /*   (arbre des menus)        */
      graf_mouse( M_OFF, 0 );             /* Dsactivation de la souris */
      menu_bar( M_tree, ME_SHOW );        /* Affichage du menu          */
      graf_mouse( M_ON, 0 );
      graf_mouse( ARROW, 0 );             /* Activation de la souris    */

      do
      {
         evnt_mesag( msgbuff );           /* Attente d'un vnement     */

         if ( msgbuff[0] == MN_SELECTED ) /* Le menu est slectionn    */
         {
            if ( msgbuff[4] < 16 )        /* Une valeur infrieure  16 */
                                          /*   indique un accessoire    */
               form_alert( 1, "[0][     Dmo Pure C| |(c) 1989 \
Borland Int.  |Tous droits rservs.][ Ok ]" );
            else                          /* Une valeur suprieure  15 */
               done = TRUE;               /*   indique que l'arrt du   */
                                          /*   programme est demand    */

            menu_tnormal( M_tree, msgbuff[3], ME_NORM );
         }                                /* Affichage normal du menu   */
      }
      while ( !done );                    /* Jusqu' la fin!            */

      graf_mouse( M_OFF,0 );
      menu_bar( M_tree, ME_HIDE );        /* Disparition du menu        */
      graf_mouse( M_ON, 0 );
      rsrc_free( );                       /* Abandon de l'arborescence  */
   }                                      /*   du fichier ressource     */
   else
      form_alert( 1, "[3][Fichier ressource introuvable!][Abandon]" );
}

/* -------------------------------------------------------------------- */
/*       Fin du programme de dmonstration de EVNT_MESAG( ).            */
/* -------------------------------------------------------------------- */
