/************************************************************************/
/*                                                                      */
/*       Programme de dmonstration utilisant:         EVNT_MULTI( )    */
/*                    diverses routines de gestion de fentre (WIND_)   */
/*                                                                      */
/*       Copyright (c) 1989 Borland International                       */
/*       Tous droits rservs.                                          */
/*                                                                      */
/************************************************************************/

/* -------------------------------------------------------------------- */
/*       Inclusion des fichiers de dclarations.                        */
/* -------------------------------------------------------------------- */

#include <aes.h>
#include <vdi.h>
#include <stdio.h>

#include "scancode.h"

/* -------------------------------------------------------------------- */
/*       Dfinition des constantes.                                     */
/* -------------------------------------------------------------------- */

#define DESK                  0

#define W_KIND                NAME|CLOSER|FULLER|MOVER|SIZER
#define EV_KIND               MU_MESAG|MU_TIMER|MU_KEYBD

#define WINDOW_NAME           "Dmo Pure C"

#define min(a, b)             ((a) < (b) ? (a) : (b))
#define max(a, b)             ((a) > (b) ? (a) : (b))

/* -------------------------------------------------------------------- */
/*       Dfinitions de type.                                           */
/* -------------------------------------------------------------------- */

typedef enum
{
    FALSE,
    TRUE
}
boolean;

/* -------------------------------------------------------------------- */
/*       Prototypes des fonctions.                                      */
/* -------------------------------------------------------------------- */

void    gem_prg( void );
void    hndl_window( void );
void    do_redraw( int w_handle, int x, int y, int w, int h );
void    new_size( int w_handle, int x, int y, int w, int h );
void    close_window( int w_handle );
void    clipping( int x, int y, int w, int h, int mode );
boolean rc_intersect( GRECT *r1, GRECT *r2 );
boolean open_window( void );

/* -------------------------------------------------------------------- */
/*       Variables globales.                                            */
/* -------------------------------------------------------------------- */

int     Msgbuff[8];                 /* Tampon  message                 */

int     W_handle,                   /* Indentificateur de fentre       */
        Wx, Wy, Ww, Wh;             /* Poisition et taille              */
boolean W_fulled;                   /* Indique si les prcdentes       */
                                    /*   variables sont mises  jour    */
int     pxarray[128];               /* Coordonnes pour le "clipping"   */
boolean Done = FALSE;               /* Drapeau d'attente                */

/* -------------------------------------------------------------------- */
/*       Dclaration des variables globales externes.                   */
/* -------------------------------------------------------------------- */

extern int handle;
extern int gl_wbox,
           gl_hbox;

/* -------------------------------------------------------------------- */
/*       void gem_prg( void );                                          */
/*                                                                      */
/*       Exemple d'utilisation de la fonction evnt_multi(), ainsi       */
/*         que diverses fonctions de gestion de fentre (wind_...).     */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void gem_prg( void )
{
   int      style = 0;              /* Motif de remplissage             */
   int      event,                  /* vnement                        */
            mx, my,                 /* Position de la souris            */
            mbutton,                /* Boutons de la souris actionns   */
            mstate,                 /* tat des boutons de la souris    */
            keycode,                /* "Scancode" des touches presses  */
            mclicks;                /* Nombre de click souris           */

   vsf_color( handle, 1 );          /* Choix de la couleur              */
   vsf_interior( handle, 3 );       /* Choix du style de remplissage    */

   if ( open_window( ) == TRUE )    /* Ouverture de la fentre          */
   {
      do
      {
         event = evnt_multi( EV_KIND,
                             1, 1, 1,
                             0, 0, 0, 0, 0,
                             0, 0, 0, 0, 0,
                             Msgbuff,
                             1000, 0,  /* Attente d'une seconde         */
                             &mx, &my,
                             &mbutton, &mstate,
                             &keycode, &mclicks);

         wind_update( BEG_UPDATE ); /* Dbut de la mise  jour, signale */
                                    /*   au GEM de ne pas interfrer    */
         if ( event & MU_MESAG )    /* Analyse de l'vnement           */
         {
            if ( Msgbuff[0] >= WM_REDRAW && WM_NEWTOP >= Msgbuff[0] )
               hndl_window( );      /* Traitement de l'vnement        */
         }
         else if ( event & MU_TIMER ) /* Aprs une seconde d'inactivit */
         {                            /*   on, modifie le motif de      */
            style++;                  /*   remplissage de la fentre    */
            if ( style == 13 )
               style = 1;
            vsf_style( handle, style );
            do_redraw( W_handle, Wx, Wy, Ww, Wh );

         }
         else if( event & MU_KEYBD )
         {
            if ( keycode == CNTRL_C ) /* Si Control-C survient on ferme */
            {                         /*   la fentre et on termine     */
               if ( W_handle != -1 )
                  close_window( W_handle );
               Done = TRUE;
            }
         }
         wind_update( END_UPDATE );
      }
      while ( !Done );
   }
}

/* -------------------------------------------------------------------- */
/*       void hndl_window( void )                                   	*/
/*                                                                      */
/*       Traite l'vnement et le traduit en action sur la fentre.     */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void hndl_window( void )
{

   switch( Msgbuff[0] )
   {
      case WM_REDRAW:               /* Rgnration de l'affichage      */
         do_redraw( Msgbuff[3], Msgbuff[4], Msgbuff[5], Msgbuff[6], Msgbuff[7] );
      break;

      case WM_CLOSED:               /* Fermeture de la fentre          */
         close_window( Msgbuff[3] );
         Done = TRUE;               /* Arrt du programme               */
      break;

      case WM_MOVED:                /* Dplacement de la fentre        */
      case WM_SIZED:                /* Modification de sa taille        */
         if ( Msgbuff[6] < 10 * gl_wbox )  /* Taille minimale assure   */
            Msgbuff[6] = 10 * gl_wbox;
         if ( Msgbuff[7] < 5 * gl_hbox )
            Msgbuff[7] = 5 * gl_hbox;
         new_size( Msgbuff[3], Msgbuff[4], Msgbuff[5], Msgbuff[6], Msgbuff[7] );
      break;

      case WM_TOPPED:               /* La fentre devient active        */
      case WM_NEWTOP:
         wind_set( Msgbuff[3], WF_TOP, 0, 0, 0, 0 );
         wind_get( Msgbuff[3], WF_WORKXYWH, &Wx, &Wy, &Ww, &Wh );
      break;

      case WM_FULLED:               /* La fentre recouvre tout l'cran */
         if (( W_fulled ^= TRUE ))
            wind_get( Msgbuff[3], WF_FULLXYWH, &Msgbuff[4], &Msgbuff[5], &Msgbuff[6], &Msgbuff[7] );
         else
            wind_get( Msgbuff[3], WF_PREVXYWH, &Msgbuff[4], &Msgbuff[5], &Msgbuff[6], &Msgbuff[7] );
         wind_get( Msgbuff[3], WF_WORKXYWH, &Wx, &Wy, &Ww, &Wh );
         new_size( Msgbuff[3], Msgbuff[4], Msgbuff[5], Msgbuff[6], Msgbuff[7] );
      break;
   }
}

/* -------------------------------------------------------------------- */
/*       boolean open_window( void );                                   */
/*                                                                      */
/*       Ouvre une fentre. Retourne TRUE si la fentre a pu tre       */
/*         ouverte.                                                     */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      TRUE  si la fentre a pu tre ouverte  */
/*                                      selon la spcification contenue */
/*                                      dans les variables globales,    */
/*                               FALSE sinon.                           */
/* -------------------------------------------------------------------- */

boolean open_window( void )
{
   int new,
       xdesk, ydesk, wdesk, hdesk;
                                    /* Dimensions de l'cran (bureau)   */
   wind_get( DESK, WF_WORKXYWH, &xdesk, &ydesk, &wdesk, &hdesk );
   if (( new = wind_create( W_KIND, xdesk, ydesk, wdesk, hdesk )) < 0 )
   {
      form_alert( 1, "[3][Cration de la fentre impossible.][Abandon]" );
      return ( FALSE );
   }
   graf_mouse( M_OFF, 0 );          /* Dsactivation de la souris       */
   wind_set( new, WF_NAME, WINDOW_NAME, 0, 0 ); /* Nom de la fentre    */
                                    /* Dessin du rectangle              */
   graf_growbox( 0, 0, 0, 0, wdesk / 10, hdesk / 10, wdesk / 3, hdesk / 3 );
   wind_open( new, wdesk / 10, hdesk / 10, wdesk / 3, hdesk / 3 );
                                    /* Ouverture de la fentre et       */
                                    /*   dimensionnement optimal        */
   wind_get( new, WF_WORKXYWH, &Wx, &Wy, &Ww, &Wh );
   W_handle = new;
   W_fulled = FALSE;
   graf_mouse( M_ON, 0 );           /* Activation de la souris          */
   graf_mouse( ARROW, 0 );

   return ( TRUE );                 /* Ouverture russie!               */
}

/* -------------------------------------------------------------------- */
/*       void do_redraw( int w_handle, int x, int y, int w, int h );    */
/*                                                                      */
/*       Rgnration de l'affichage d'une rgion de l'cran            */
/*         ventuellement occupe par une partie de la fentre dont     */
/*         l'identificateur est 'w_handle'.                             */
/*                                                                      */
/*       -> w_handle      Identificateur de la fentre.                 */
/*          x, y          Coordonnes du coin suprieur gauche.         */
/*          w, h          Largeur et hauteur de la rgion.              */
/*                                                                      */
/*       <-               Rien.                                         */
/* -------------------------------------------------------------------- */

void do_redraw( int w_handle, int x, int y, int w, int h )
{
   GRECT t1, t2;

   t2.g_x     = pxarray[0] = x;     /* Coordonnes de la rgion         */
   t2.g_y     = pxarray[1] = y;
   t2.g_w     = w;
   t2.g_h     = h;
   pxarray[2] = x + w - 1;
   pxarray[3] = y + h - 1;

   graf_mouse( M_OFF, 0 );
   wind_get( w_handle, WF_FIRSTXYWH, &t1.g_x, &t1.g_y, &t1.g_w, &t1.g_h );
   while ( t1.g_w && t1.g_h )
   {
      if ( rc_intersect( &t2, &t1 ) == TRUE )
      {                             /* La rgnration de l'affichage   */
                                    /*   n'a besoin d'avoir lieu que    */
                                    /*   dans l'intersection de la      */
                                    /*   rgion avec la fentre         */
         clipping( t1.g_x, t1.g_y, t1.g_w, t1.g_h, TRUE );
         v_bar( handle, pxarray );
      }
      wind_get( w_handle, WF_NEXTXYWH, &t1.g_x, &t1.g_y, &t1.g_w, &t1.g_h );
   }
   clipping( t1.g_x, t1.g_y, t1.g_w, t1.g_h, FALSE );

   graf_mouse( M_ON, 0 );
}

/* -------------------------------------------------------------------- */
/*       void new_size( int w_handle, int x, int y, int w, int h );     */
/*                                                                      */
/*       Modification de la taille de la fentre.                       */
/*                                                                      */
/*       -> w_handle             Identificateur de la fentre.          */
/*          x, y, w, h           Nouvelles coordonnes de la fentre.   */
/*                                                                      */
/*       <-                      Les variables globales sont mises     */
/*                                 jour pour tenir compte du changement */
/*                                 de taille de la fentre.             */
/* -------------------------------------------------------------------- */

void new_size( int w_handle, int x, int y, int w, int h )
{
   wind_set( w_handle, WF_CURRXYWH, x, y, w, h );
   wind_get( w_handle, WF_WORKXYWH, &Wx, &Wy, &Ww, &Wh );
}

/* -------------------------------------------------------------------- */
/*       void close_window( int w_handle );                             */
/*                                                                      */
/*       Fermeture d'une fentre.                                       */
/*                                                                      */
/*       -> w_handle             Identificateur de la fentre.          */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void close_window( int w_handle )
{
   int x, y, w, h;

   wind_get( w_handle, WF_CURRXYWH, &x, &y, &w, &h );
   graf_shrinkbox( 0, 0, 0, 0, x, y, w, h );
   wind_close( w_handle );
   wind_delete( w_handle );
}

/* -------------------------------------------------------------------- */
/*       boolean rc_intersect( GRECT *r1, GRECT *r2 );                  */
/*                                                                      */
/*       Calcule l'intersection de deux rgions rectangulaires.         */
/*                                                                      */
/*       -> r1, r2               Pointeurs sur leurs coordonnes.       */
/*                                                                      */
/*       <-                      FALSE si les deux rgions ne se        */
/*                                      touchent pas,                   */
/*                               TRUE  si elles se touchent.            */
/*                                     (r2 contient les coordonnes     */
/*                                      du rectangle intersection)      */
/* -------------------------------------------------------------------- */

boolean rc_intersect( GRECT *r1, GRECT *r2 )
{
   int x, y, w, h;

   x = max( r2->g_x, r1->g_x );
   y = max( r2->g_y, r1->g_y );
   w = min( r2->g_x + r2->g_w, r1->g_x + r1->g_w );
   h = min( r2->g_y + r2->g_h, r1->g_y + r1->g_h );

   r2->g_x = x;
   r2->g_y = y;
   r2->g_w = w - x;
   r2->g_h = h - y;

   return ( (boolean) ((w > x) && (h > y) ) );
}

/* -------------------------------------------------------------------- */
/*       void clipping( int x, int y, int w, int h, int mode );         */
/*                                                                      */
/*       Dfinition de la zone d'affichage autoris ("Clipping").       */
/*                                                                      */
/*       -> x                    Abscisse du coin suprieur gauche.     */
/*          y                    Ordonne du coin suprieur gauche.     */
/*          w                    Largeur.                               */
/*          h                    Hauteur.                               */
/*          mode                 TRUE  - "clipping" actif,              */
/*                               FALSE - "clipping" inactif.            */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void clipping( int x, int y, int w, int h, int mode )
{
   pxarray[0] = x;
   pxarray[1] = y;
   pxarray[2] = x + w - 1;
   pxarray[3] = y + h - 1;

   vs_clip( handle, mode, pxarray );
}

/* -------------------------------------------------------------------- */
/*       Fin du programme de dmonstration de EVNT_MULTI( ).            */
/* -------------------------------------------------------------------- */
