/************************************************************************/
/*                                                                      */
/*       Programme de dmonstration utilisant:          FORM_ALERT( )   */
/*                                                      FORM_ERROR( )   */
/*                                   FSEL_INPUT( ) ou FSEL_EXINPUT( )   */
/*                                                                      */
/*       Ouvre un slecteur de fichier et traite les erreurs.           */
/*                                                                      */
/*       Copyright (c) 1989 Borland International                       */
/*       Tous droits rservs.                                          */
/*                                                                      */
/************************************************************************/

/* -------------------------------------------------------------------- */
/*       Inclusion des fichiers de dclarations.                        */
/* -------------------------------------------------------------------- */

#include <aes.h>
#include <tos.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

/* -------------------------------------------------------------------- */
/*       Dfinitions des constantes.                                    */
/* -------------------------------------------------------------------- */
                                 /* Codes d'erreurs:                    */
                                 /* ----------------------------------- */
#define MOPENED               0  /* Le fichier a t ouvert             */
#define MFSEL                 1  /* Fin du programme                    */
#define MERROR                2  /* Le fichier n'a pas pu tre ouvert   */

#define STFILELEN            13  /* Longueur maxi des noms de fichiers  */
#define STPATHLEN            64  /* Longueur maxi des chemins d'accs   */

#define EOS                '\0'  /* Code final d'une chane (octet nul) */
#define BACKSLASH          '\\'

/* -------------------------------------------------------------------- */
/*       Prototypes des fonctions.                                      */
/* -------------------------------------------------------------------- */

void close_vwork( void );        /* du module PCFRAME.C                 */

void gem_prg( void );
void usage( int m );
void build_fname( char *dest, char *s1, char *s2 );
int  op_fbox( void );

/* -------------------------------------------------------------------- */
/*       Variables globales.                                            */
/* -------------------------------------------------------------------- */

char Path[STPATHLEN] = "A:\\*.*";

char *Mess[] =                      /* Texte des rapports d'erreurs    */
{
    "[2][Le fichier a pu tre ouvert.][Fin|Encore]",
    "[3][Abandon de la slection.][ OK ]"
};

/* -------------------------------------------------------------------- */
/*       void gem_prg( void );                                          */
/*                                                                      */
/*       Exemple d'utilisation de la fonction fsel_input( ).            */
/*       (Appelle le slecteur de fichier du GEM)                       */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void gem_prg( void )
{
   Path[0] = (char) Dgetdrv( ) + 'A';  /* Lettre du lecteur courant     */

   while ( op_fbox( ) != 0 )           /* Tant qu'il n'y a pas d'erreur */
      usage( MOPENED );                /*   on recommence...            */
   usage( MFSEL );                     /* Fin du programme              */
}

/* -------------------------------------------------------------------- */
/*       void usage( int m );                                           */
/*                                                                      */
/*       Affiche un rapport d'erreur.                                   */
/*                                                                      */
/*       -> m                    Numro du rapport d'erreur.            */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void usage( int m )
{
   int endcode = 0;

   if ( m < 2 )
   {
      if( form_alert( 1, Mess[m] ) == 2) /* Si l'utilisateur le dsire, */
                                         /*   et si le fichier existe,  */
                                         /*   alors l'excution du      */
         return;                         /*   programme continue        */
   }
   else                                  /* Le fichier n'existe pas     */
   {
      form_error( ENOENT );
      endcode = -1;
   }

   close_vwork( );                       /* Fermeture du port graphique */
   exit( endcode );
}

/* -------------------------------------------------------------------- */
/*       int op_fbox( void )                                            */
/*                                                                      */
/*       Ouverture du slecteur de fichier.                             */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      0  si le programme doit s'arrter.     */
/* -------------------------------------------------------------------- */

int op_fbox( void )
{
   char n[STFILELEN],                  /* Tampon pour le nom de fichier */
        x[STPATHLEN + STFILELEN];      /* Tampon pour le chemin d'accs */
                                       /*   complet                     */
   int  b;                             /* Contient le numro du bouton  */
                                       /*   qui commande l'abandon du   */
                                       /*   slecteur de fichier        */
   int  version;                       /* Numro de version du GEMDOS   */

   int  result;

   *n = EOS;                           /* Tampon vide au dmarrage      */

   version = Sversion ( );             /* Numro de version du GEMDOS   */
   version >>= 8;                      /* Utile, car fsel_exinput()     */
                                       /*   n'existe qu' partir de la  */
                                       /*   version 1.40!               */

   if ( version <= 20 )                /* 20 = 0x14                     */
                                       /* Slecteur de fichier          */
      result = fsel_input( Path, n, &b );
   else
      result = fsel_exinput( Path, n, &b, "Test de slection" );

   if ( result == 0 )
      usage( result );                 /* Une erreur est survenue       */
   else if ( b != 0)
   {
      build_fname( x, Path, n );       /* Concatnation du chemin       */
                                       /*   avec le nom du fichier      */
      if ( Fattrib( x, 0, 0 ) < 0 )    /* Teste la prsence du fichier  */
         usage( MERROR );              /* Une erreur est survenue       */
   }

   return ( b );
}

/* -------------------------------------------------------------------- */
/*                                                                      */
/*       void build_fname( char *dest, char *s1, char *s2 );            */
/*                                                                      */
/*       Concatne le chemin d'accs avec le nom du fichier.            */
/*                                                                      */
/*       -> dest                 Pointeur sur le tampon de destination. */
/*          s1                   Chemin d'accs.                        */
/*          s2                   Nom du fichier.                        */
/*                                                                      */
/*       <-                      Retourne le pointeur 'dest'.           */
/* -------------------------------------------------------------------- */

void build_fname( char *dest, char *s1, char *s2 )
{
   char *cptr;

   strcpy( dest, s1 );                 /* Copie du chemin d'accs       */
   cptr = strrchr( dest, (int) BACKSLASH);
   strcpy( ++cptr, s2);                /* Copie du nom de fichier      */
}                                      /*   la suite du chemin d'accs  */

/* -------------------------------------------------------------------- */
/*  Fin du programme de dmonstration de FORM_ALERT( ), FORM_ERROR( ),  */
/*                 et FSEL_INPUT() (ou FSEL_EXINPUT( )).                */
/* -------------------------------------------------------------------- */
