/************************************************************************/
/*                                                                      */
/*       CCOUNT.C                                                       */
/*                                                                      */
/*       Un programme de dmonstration pour montrer le fonctionnement   */
/*         de l'outil de mise au point Pure Debugger.                   */
/*                                                                      */
/*       Copyright (c) 1989 Borland International.                      */
/*       Tous droits rservs.                                          */
/*                                                                      */
/************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define NUL   ((char)0)             /* Marque finale (octet nul)        */

extern char *print_cstatist( int *statarray );

/* -------------------------------------------------------------------- */
/*       Programme principal                                            */
/* -------------------------------------------------------------------- */

void main( int argc, char *argv[] )
{
    FILE       *infile;             /* Fichier lu en entre             */
    char       linebuf[1024];       /* "Ligne temporaire"               */
    char       *lineptr;            /* Pointeur sur le premier ou le    */
                                    /*   prochain mot dans la ligne     */
    int        i;                   /* Index de boucle                  */
    static int cfrequence[(int)('Z' - 'A') + 2];
                                    /* Tableau pour mmoriser la        */
                                    /* frquence d'apparition des       */
                                    /* lettres et autres signes         */

    printf( "    CCOUNT dtermine la frquence d'apparition des lettres dans un texte\n" );
    printf( "    --------------------------------------------------------------------\n\n" );

    if ( argc != 2 )
    {
        printf( "Entrez le nom du fichier texte (ex: TEXT.DAT),\n" );
        printf( "ou alors pressez <Return> pour abandonner: " );

        gets( linebuf );            /* nom saisie rang dans linebuf    */

        if ( !strlen( linebuf ))    /* seul RETURN a t entr ?        */
            exit( 1 );              /* alors arrt du programme         */
    }
    else
        strcpy( linebuf, argv[1] );

    infile = fopen( linebuf, "r" ); /* ouverture du fichier             */
    if ( !infile )
    {
        printf( "Erreur lors de l'ouverture du fichier %s\n", linebuf );
        exit( 1 );
    }

    printf( "Lecture du fichier texte %s\n", linebuf );

                                    /* Lecture d'une ligne              */
    while ( fgets(linebuf, (int) sizeof( linebuf ), infile ))
    {
                                    /* Parcourt du tampon et annulation */
                                    /*   des caractres '\n'            */
        i = (int)strlen( linebuf ); /* Longueur de la ligne             */

                                    /* Est-ce un saut de ligne ?        */
        if ( linebuf[i - 1] != '\n' )
            printf( "\nDbut d'une ligne beaucoup trop longue:\n\t%70s\n", linebuf );
        else
            linebuf[i - 1] = NUL;   /* Annulation du caractre '\n'     */

        strupr( linebuf );
        lineptr = linebuf;

        while ( *lineptr )
        {
            if ( isupper( *lineptr ))
                cfrequence[(int)(*lineptr - 'A')]++;
            else
                cfrequence[(int)('Z' - 'A') + 1]++;

            lineptr++;
        }
    }

    print_cstatist( cfrequence );

    puts( "\nAppuyez sur <Return>\n" );
    getchar();

    fclose(infile);                 /* Fermeture du fichier et          */
    exit( 0 );                      /*   terminaison du programme       */
}

/* -------------------------------------------------------------------- */
/*       Fin de CCOUNT.C                                                */
/* -------------------------------------------------------------------- */
