/************************************************************************/
/*                                                                      */
/*       INSPDEMO.C                                                     */
/*                                                                      */
/*       Un programme de dmonstration pour montrer le fonctionnement   */
/*         de l'outil de mise au point Pure Debugger.                   */
/*                                                                      */
/*       Copyright (c) 1989 Borland International.                      */
/*       Tous droits rservs.                                          */
/*                                                                      */
/************************************************************************/

#include <stdio.h>

/* -------------------------------------------------------------------- */
/*       Dfinition d'un type de structure qui dcrit la compositon     */
/*       d'un 'maillon' utilis pour faire des listes chanes.         */
/*                                                                      */
/*       Ici:  La liste dcrit une chane d'Htels ordonns.            */
/*             Chaque maillon contient le nom d'un Htel, sa            */
/*             catgorie et un pointeur sur le maillon suivant.         */
/* -------------------------------------------------------------------- */

typedef struct hlist
{
    char            name[40];
    int             category;
    struct hlist    *next;
}
    HLIST;

/* -------------------------------------------------------------------- */
/*       Initialisation de la liste des Htels:                         */
/* -------------------------------------------------------------------- */

HLIST Hotel6 =
{
    "Strand Motel",
    2,
    0L
};

HLIST Hotel5 =
{
    "Paradise Hotel",
    4,
    &Hotel6
};

HLIST Hotel4 =
{
    "Grillton Hotel",
    5,
    &Hotel5
};

HLIST Hotel3 =
{
    "Last palace",
    0,
    &Hotel4
};

HLIST Hotel2 =
{
    "Grand Holyday",
    3,
    &Hotel3
};

HLIST Hotel1 =
{
    "Hotel Very Best",
    1,
    &Hotel2
};

/* -------------------------------------------------------------------- */
/*       void main( void );                                             */
/*                                                                      */
/*       Affiche la liste des Htels  l'cran.                         */
/* -------------------------------------------------------------------- */

void main( void )
{
    HLIST *hp;                           /* Pointeur sur un lment de  */
                                         /*   la liste chane          */
    hp = &Hotel1;                        /* Initialisation du pointeur  */
                                         /*   avec l'adresse du maillon */
                                         /*   de tte                   */

    puts( "Liste des Htels:" );
    puts( "-----------------" );

    while ( hp != 0L )                   /* Le pointeur du dernier      */
    {                                    /*   lment est nul           */
        printf( "\nName: %s\t\tCategorie: %d", hp->name, hp->category );
        hp = hp->next;                   /* Le pointeur pointe sur      */
    }                                    /*   l'lment suivant         */

    puts( "\n\nAppuyez sur <Return>" );
    getchar( );
}

/* -------------------------------------------------------------------- */
/*       Fin de INSPDEMO.C                                              */
/* -------------------------------------------------------------------- */
