/************************************************************************/
/*                                                                      */
/*       PCFRAME.C                                                      */
/*                                                                      */
/*       Squelette pour crire rapidement un programme GEM              */
/*                                                                      */
/*       Tous les programmes GEM ont cette mme structure.              */
/*       (Votre programme devra s'insrer  la fin de ce source)        */
/*                                                                      */
/*       Copyright (c) 1989 Borland International.                      */
/*       Tous droits rservs.                                          */
/*                                                                      */
/************************************************************************/

/* -------------------------------------------------------------------- */
/*       include - Inclusion des fichiers de dclaration.               */
/* -------------------------------------------------------------------- */

#include <vdi.h>
#include <aes.h>
#include <stdio.h>
#include <stdlib.h>

/* -------------------------------------------------------------------- */
/*       Dfinition de type.                                            */
/* -------------------------------------------------------------------- */

typedef enum
   {
      FALSE,
      TRUE
   }
      boolean;

/* -------------------------------------------------------------------- */
/*       Variables globales.                                            */
/* -------------------------------------------------------------------- */

int work_in[12],
    work_out[57];

int handle,
    phys_handle;

int gl_hchar,
    gl_wchar,
    gl_hbox,
    gl_wbox;

int gl_apid;

/* ------------------------------------------------------------------- */
/*       Prototypes des fonctions.                                     */
/* ------------------------------------------------------------------- */

boolean open_vwork( void );
void    close_vwork( void );
void    gem_prg( void );

/* -------------------------------------------------------------------- */
/*       boolean open_vwork( void );                                    */
/*                                                                      */
/*       Ouverture d'un port graphique ("Workstation")...               */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      TRUE   si le VDI a pu tre initialis, */
/*                               FALSE  sinon.                          */
/* -------------------------------------------------------------------- */

boolean open_vwork( void )
{
   register int i;

   if (( gl_apid = appl_init() ) != -1 )
   {
      for ( i = 1; i < 10; work_in[i++] = 1 );
      work_in[10] = 2;
      phys_handle = graf_handle( &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox );
      work_in[0]  = handle = phys_handle;

      v_opnvwk( work_in, &handle, work_out );

      return ( TRUE );
   }
   else
      return ( FALSE );
}

/* -------------------------------------------------------------------- */
/*       void close_vwork( void );                                      */
/*                                                                      */
/*       ... et fermeture du port.                                      */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void close_vwork( void )
{
   v_clsvwk( handle );

   appl_exit( );
}

/* -------------------------------------------------------------------- */
/*       void main( void )                                              */
/*                                                                      */
/*       Insrez votre programme dans cette fonction!                   */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Code de retour du programme:           */
/*                                         0 Terminaison sans erreurs   */
/*                                        -1 Une erreur s'est produite  */
/*                                           pendant l'initialisation   */
/* -------------------------------------------------------------------- */

void main( void )
{
   if ( open_vwork( ) == TRUE )
   {

      /* ============================ */
      /* Insrez votre programme ici: */
      /* ---------------------------- */

      gem_prg( );

      /* ================================ */

      close_vwork( );
      exit ( 0 );
   }
   else
   {
      fprintf(stderr, "Une erreur est survenue pendant l'initialisation!");
      exit ( -1 );
   }
}

/* -------------------------------------------------------------------- */
/*       Fin du squelette de programme GEM                              */
/* -------------------------------------------------------------------- */
