/************************************************************************/
/*                                                                      */
/*       PDGEMDB.C                                                      */
/*                                                                      */
/*       Un programme de dmonstration pour montrer le fonctionnement   */
/*         de l'outil de mise au point Pure Debugger.                   */
/*                                                                      */
/*       ATTENTION: CE PROGRAMME CONTIENT UNE ERREUR VOLONTAIRE!!!      */
/*                                                                      */
/*       Copyright (c) 1989 Borland International                       */
/*       Tous droits rservs.                                          */
/*                                                                      */
/************************************************************************/

/* -------------------------------------------------------------------- */
/*       include - Inclusion des fichiers de dclaration.               */
/* -------------------------------------------------------------------- */

#include <aes.h>

/* -------------------------------------------------------------------- */
/*       Dfinition de constante.                                       */
/* -------------------------------------------------------------------- */

#define ME_HIDE               0
#define ME_SHOW               1
#define ME_NORM               1

#define RSC_NAME              "PDTEST.RSC"

/* -------------------------------------------------------------------- */
/*       Dfinition de type.                                            */
/* -------------------------------------------------------------------- */

typedef enum
   {
      FALSE,
      TRUE
   }
      boolean;

/* -------------------------------------------------------------------- */
/*       Variables globales.                                            */
/* -------------------------------------------------------------------- */

static OBJECT  *M_tree;
static boolean *Done;

/* -------------------------------------------------------------------- */
/*       Prototypes des fonctions.                                      */
/* -------------------------------------------------------------------- */

void gem_prg( void );
void hndl_event( int * msgbuff );

/* -------------------------------------------------------------------- */
/*       void gem_prg( void );                                          */
/*                                                                      */
/*       Cette fonction est appele par le squelette PCFRAME.C et       */
/*       contient le programme proprement dit (Gestion de menus).       */
/*                                                                      */
/*       ->                      Rien.                                  */
/*                                                                      */
/*       <-                      Rien.                                  */
/* -------------------------------------------------------------------- */

void gem_prg( void )
{
   static boolean done = FALSE;           /* Drapeau d'attente          */
          int     msgbuff[8];             /* Tampon pour les messages   */

/* correction  apporter:

   Done=&done;

   au lieu de ...
*/

   *Done = done;                          /* Programme pas encore prt  */

   if ( rsrc_load( RSC_NAME ) > 0 )       /* Charge 1 fichier ressource */
   {
      rsrc_gaddr( 0, 0, &M_tree );        /* Adresse de la racine de    */
                                          /*   l'arborescence (menus)   */
      graf_mouse( M_OFF, 0 );             /* Dsactivation de la souris */
      menu_bar( M_tree, ME_SHOW );        /* Affichage du menu          */
      graf_mouse( M_ON, 0 );
      graf_mouse( ARROW, 0 );             /* Activation de la souris s  */

      do
      {
         evnt_mesag( msgbuff );           /* Attente d'un vnement     */

         hndl_event( msgbuff );           /* Traitement de l'vnement  */
      }
      while ( !done );                    /* Jusqu' la fin...!         */

      graf_mouse( M_OFF,0 );
      menu_bar( M_tree, ME_HIDE );        /* Disparition du menu        */
      graf_mouse( M_ON, 0 );
      rsrc_free( );                       /* Abandon de l'arborescence  */
   }                                      /*   du fichier ressource     */
   else
      form_alert( 1, "[3][Fichier ressource introuvable.][Abandon]" );
}

/* -------------------------------------------------------------------- */
/*       void hndl_event( int *msgbuff );                               */
/*                                                                      */
/*       Traitement des vnements.                                     */
/*                                                                      */
/*       -> msgbuff              Pointeur sur le tampon contenant       */
/*                                 l'vnement GEM                      */
/*                                                                      */
/*       <- Done                 (Variable globale)                     */
/*                               TRUE  - Abandon du programme           */
/*                               FALSE - sinon                          */
/* -------------------------------------------------------------------- */

void hndl_event( int *msgbuff )
{
   *Done = FALSE;

   if ( msgbuff[0] == MN_SELECTED )       /* Le menu est slectionn    */
   {
      if ( msgbuff[4] != 16 )             /* Diffrent de 16, sauf si   */
                                          /*   on clique 'Quit'         */
         form_alert( 1, "[0][  Dmo Pure Debugger | |(c) 1989 \
Borland Int.  |Tous droits rservs.][ Ok ]" );
      else
         *Done = TRUE;                    /* Arrt du programme demand */

      menu_tnormal( M_tree, msgbuff[3], ME_NORM );
   }                                      /* Affichage normal du menu   */
}

/* -------------------------------------------------------------------- */
/*       Fin de PDGEMDB.C                                               */
/* -------------------------------------------------------------------- */
