/************************************************************************/
/*                                                                      */
/*       WCOUNTB.C                                                      */
/*                                                                      */
/*       Un programme de dmonstration pour montrer le fonctionnement   */
/*         de l'outil de mise au point Pure Debugger.                   */
/*                                                                      */
/*       ATTENTION: CE PROGRAMME CONTIENT UNE ERREUR VOLONTAIRE!!!      */
/*                                                                      */
/*       Copyright (c) 1989 Borland International.                      */
/*       Tous droits rservs.                                          */
/*                                                                      */
/************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define MAXWORDLEN 16               /* Longueur maximale des mots       */
#define NUL   ((char)0)             /* Marque finale (octet nul)        */
#define SPACE ((char)0x20)          /* Sparateur entre les mots        */

char *nextword( char *lineptr );
int  wordlen( char *wordstart );

/* -------------------------------------------------------------------- */
/*       Programme principal                                            */
/* -------------------------------------------------------------------- */

void main( void )
{
   FILE       *infile;                  /* Fichier lu en entre         */
   char       linebuf[1024];            /* "Ligne temporaire"           */
   char       *lineptr;                 /* Pointeur sur le premier ou   */
                                        /*  le prochain mot de la ligne */
   int        i;                        /* Index de boucle              */
   static int wordlens[MAXWORDLEN + 1], /* Variables pour faire l'tude */
              longwords;                /*  statistique des longueurs   */
                                        /*  des mots rencontrs         */

   printf( "ATTENTION!\n\n");
   printf( "WCOUNTB est un programme d'entranement pour vous\n");
   printf( "familiariser avec le fonctionnement du Pure Dbugger.\n");
   printf( "Si vous n'avez pas lanc ce programme  partir du\n" );
   printf( "Pure Debugger, SVP, pressez tout de suite <Return>!\n\n" );
   printf( "Sinon, excutez le programme et dbugguez-le.\n\n" );
   printf( "Vous trouverez plus d'informations dans le manuel.\n\n" );

   printf( "Entrez le nom du fichier texte (ex: TEXT.DAT): " );

   gets( linebuf );                 /* nom saisie rang dans linebuf    */

   if ( !strlen( linebuf ))         /* seul RETURN a t entr ?        */
      exit( 1 );                    /* alors arrt du programme         */

   infile = fopen( linebuf, "r" );  /* ouverture du fichier             */
   if ( !infile )
   {
      printf( "Erreur lors de l'ouverture du fichier %s\n", linebuf );
      exit( 1 );
   }

                                    /* Lecture d'une ligne              */
   while ( fgets(linebuf, sizeof( linebuf ), infile ))
   {
      printf( "%s", linebuf );      /* Affichage                        */

                                    /* Parcourt du tampon et annulation */
                                    /*   des caractres  '\n'           */
      i = strlen( linebuf );        /* Longueur de la ligne             */
      if ( linebuf[i - 1] != '\n' ) /* Est-ce un saut de ligne ?        */
         printf( "Dbut d'une ligne beaucoup trop longue:\n\t%70s\n", linebuf );
      else
         linebuf[i - 1] = NUL;      /* Annulation du caractre '\n'     */

      lineptr = nextword( linebuf );/* Recherche du premier mot         */

      while ( *lineptr )
      {
         i = wordlen( lineptr );    /* Mesure de la longueur du mot     */
         if ( i > MAXWORDLEN )      /* Longueur du mot > MAXWORDLEN ?   */
            longwords++;            /* Oui, un mot "long" de plus!      */
         else
            wordlens[i]++;          /* Sinon, mise  jour du tableau    */

         lineptr += i;              /* On se positionne derrire le mot */

         lineptr=nextword(lineptr); /* Recherche du prochain mot        */
      }
   }

   printf( "  Taille Nombre\n" );   /* Affichage des statistiques       */
   for ( i = 1; i <= MAXWORDLEN; i++ )
      printf( "  %5d %5d\n", i, wordlens[i] );
   printf( "Mots ""trop longs"": %5d\n", longwords );

   fclose(infile);                  /* Fermeture du fichier             */
   exit( 0 );                       /* Terminaison du programme         */
}

/* -------------------------------------------------------------------- */
/*       char *nextword( char *lineptr );                               */
/*                                                                      */
/*       Cette fonction retourne un pointeur sur le dbut du            */
/*         prochain 'mot' de la ligne.                                  */
/* -------------------------------------------------------------------- */

char *nextword( char *lineptr )
{
   while ( *lineptr == SPACE )      /* On avance tant qu'il y a des     */
      lineptr++;                    /*   espaces devant le prochain mot */

   return( lineptr );               /* Retourne un pointeur sur le      */
}                                   /*   prochain mot (s'il existe)     */

/* -------------------------------------------------------------------- */
/*       int wordlen( char *wordstart );                                */
/*                                                                      */
/*       Cette fonction mesure la longueur d'un mot.                    */
/* -------------------------------------------------------------------- */

int wordlen( char *wordstart )
{
   char *charptr;                   /* Pointeur sur les caractres      */

   charptr = wordstart;             /* Positionnement du pointeur en    */
                                    /*   dbut de mot                   */

                                    /* On avance tant que la fin du mot */
                                    /*   n'est pas atteinte             */
/* correction  apporter:
      && au lieu de &
*/
   while ( *charptr & *charptr != SPACE )
      charptr++;                    /* On avance sur le prochain        */
                                    /*   caractre                      */

   return( charptr - wordstart );   /* Retourne la longueur du mot      */
}                                 

/* -------------------------------------------------------------------- */
/*       Fin de WCOUNTB.C                                               */
/* -------------------------------------------------------------------- */
