/* PPH2SCR: translate Pure Pascal Help file
   into Hyper text source file (.SCR)
*/

#include <stdio.h>
#include <tos.h>
#include <stdlib.h>
#include "pph2scr.h"

static unsigned char dta[44];

void translate(char *data,FILE *fd)
{
	unsigned int 	i,j;
	char 			*p;
	unsigned int 	*ptr;
	char			*d;
	char 			*s;
	char			*s2;
	char			c;
	unsigned int	n;
	char 			*dbuf;
	int				found;

	int 			nbscreen;
	int 			nbtitle;
	int				nbzone;
	
	char 			*titles;
	unsigned int	*scr_len;

	long			len;
	unsigned long 	totaldec;
	
	
	filemap	*head;
	
	head=(filemap *)data;
	
	nbtitle=head->nb_title4/4;
	nbscreen=head->nb_screen2/2;
	nbzone=head->nb_zone2/2;

	titles=head->map;
	titles+=head->nb_title4;
	scr_len=titles+head->title_size;
	s=scr_len;
	s+=head->nb_screen2;
	s+=head->nb_zone2;

	totaldec=0;
	for(i=0;i<nbscreen;i++)
		totaldec+=(unsigned long)scr_len[i];

	len=0;
	for(i=0;i<nbzone;i++)
		len+=(long)scr_len[nbscreen+i];
	
	dbuf=(char *)malloc((size_t)totaldec);

	if (dbuf)
	{
		d=dbuf;
	
		while(len>0)
		{
		 	c=*s;
		 	
		 	if (c==0x7f)
		 	{
		 		s++;
			 	len--;
			 	
		 		c=(*s++);
	 			*(d++)=c;
			 	len--;
		 	}
		 	else
		 	if (c<0)
		 	{
		 		n=NUMBER;
		 		s2=d+OFFSET;
		 		s+=2;
		 		len-=2;
		 		
		 		if (!n)
		 		{
		 			len--;
		 			n=(unsigned int)((unsigned char)*(s++));
		 			if (!n)
		 			{
		 				len-=2;
		 				n=(unsigned int)((unsigned char)*(s++));
		 				n+=256L*((unsigned int)((unsigned char)*(s++)));
		 			}
				}
				
				n+=2;
				for(i=0;i<n;i++)
				{
					c=*(s2++);
					*(d++)=c;
				}
		 	}
			else
			{
				c=*(s++);
	 			*(d++)=c;
			 	len--;
			}
		}

		d=dbuf;
		
		for(i=0;i<nbscreen;i++)
		{
			fprintf(fd,"screen(");
		
			found=0;
			for(j=0;j<nbtitle;j++)
			{
				if (((head->map[j].rank)&0x7fff)==i)
				{
					if (found)
						fprintf(fd,",\n\t\t");
					fprintf(fd,"capsensitive(\"%s\")",TITLE(j));
					found=1;
				}
			}			
			if (!found) fprintf(fd,"\"%d\"",i);
			
			fprintf(fd,")\n");
			
			len=scr_len[i];
			while(len>0)
			{
				c=*d;
				
			 	if (c==0x1d)
			 	{
			 		d++;
		 			n=*((int *)d);
		 			d+=2;
			 		len-=3;

					for(j=0;j<nbtitle;j++)
						if (((head->map[j].rank)&0x7fff)==n) break;

					if (j!=nbtitle)
				 		fprintf(fd,"\\link(\"%s\")",TITLE(j));
				 	else
				 	if (n==-1)
						fprintf(fd,"\\link(\"\%\%GLOBAL\%\%\")",n);
				 	else
						fprintf(fd,"\\link(\"%d\")",n);


		 			while(*d!=0x1d)
		 			{
	 					c=*(d++);
	 					
	 					if (c==0x7f)
	 					{
	 						fprintf(fd,"%c",*d);
	 						len--;
	 						d++;
	 					}
	 					else
	 					if (c==13)
	 					{
	 						fprintf(fd,"\n");
	 						len--;
	 						d++;
	 					}
	 					else
		 				if (c=='\\')
							fprintf(fd,"\\\\");
	 					else
	 						fprintf(fd,"%c",c);

		 				len--;
		 			}
	 			
	 				fprintf(fd,"\\#");
	 				
				 	d++;
				 	len--;
				}
				else
				{
					if (c==0x7f)
	 				{
	 					len--;
	 					d++;
	 					
	 					fprintf(fd,"%c",*d);
	 				}
					else
					if (c==13)
	 				{
	 					fprintf(fd,"\n");
	 					len--;
	 					d++;
	 				}
	 				else
	 				if (c=='\\')
						fprintf(fd,"\\\\");
	 				else
						fprintf(fd,"%c",c);

					d++;
					len--;
				}
			}
			
			fprintf(fd,"\\end\n\n");
		}
		
		free(dbuf);
	}
	else
		printf("not enough memory (%ld bytes needed)\n",totaldec);
}



int bexist(char *nom)
{
	int r;

	gemdos(0x1a,dta);
	r=(int)gemdos(0x4e,nom,0);
	if (!r) r=1; else r=0;
	return(r);
}

long bsize(char *nom)
{
	long s=0L;

	if (bexist(nom))
	s=dta[26]*256L*65536L+dta[27]*65536L+dta[28]*256L+(long)dta[29];
	return(s);
}

int bload(char *nom,void *adr,long offset,long len)
{
	int fd;

	fd=(int)gemdos(0x3d,nom,0);
	if (fd>0)
	{
		gemdos(0x42,offset,fd,1);
		gemdos(0x3f,fd,len,adr);
		gemdos(0x3e,fd);
		fd=0;
	}
	return(fd);
}

int bsave(char *nom,void *adr,long offset,long len)
{
	int fd;
	int r=0;

	fd=(int)gemdos(0x3d,nom,2);
	if (fd>0)
	{
		gemdos(0x42,offset,fd,1);
		r=(int)gemdos(0x40,fd,len,adr);
		if (r==-1) r=-13;
		gemdos(0x3e,fd);
		fd=0;
	}
	if (r<0) fd=r;
	return(fd);
}



int bmake(char *nom,void *adr,long len)
{
	int fd;
	int r=0;

	gemdos(0x1a,dta);
	r=(int)gemdos(0x4e,nom,0);
	if (r==-33) r=0;
	if (!r)
	{
		fd=(int)gemdos(0x3c,nom,0);
		if (fd>0)
		{
			gemdos(0x40,fd,len,adr);
			gemdos(0x3e,fd);
			fd=0;
		}
		else
		if (fd==-1) fd=-13;
	}
	else fd=r;
	return(fd);
}





int bopen(char *nom)
{
	int fd;

	fd=(int)gemdos(0x3d,nom,0);
	if (fd<=0) fd=-1;
	return(fd);
}


int bcreate(char *nom)
{
	int fd;

	fd=(int)gemdos(0x3c,nom,0);
	if (fd<=0) fd=-1;
	return(fd);
}



int bread(int fd,void *adr,long len)
{
	int r=0;

	r=(int)gemdos(0x3f,fd,len,adr);
	return(r);
}


int bwrite(int fd,void *adr,long len)
{
	int r=0;

	r=(int)gemdos(0x40,fd,len,adr);
	return(r);
}



int bclose(int fd)
{
	int r=0;

	r=(int)gemdos(0x3e,fd);
	return(r);
}





void buildname(char *helpfile,char *name)
{
	char *p;
	int i,n;

	strcpy(name,helpfile);

	n=strlen(name);

	p=name;
	p+=n;
	
	for(i=0;i<n;i++)
	{
		p--;
		if (*p=='.')
		{
			p[1]='s';
			p[2]='c';
			p[3]='r';
			p[4]=0;
			break;
		}
	}
}





void reserve(char *helpfile)
{
	FILE *fd;
	char *s;
	char *d;
	long size;
	char name[80];

	buildname(helpfile,name);

	size=bsize(helpfile);
	if (size)
	{
		s=(char *)malloc((size_t)size);
		if (s)
		{
			bload(helpfile,s,0,size);
			if (*(long *)s=='PPH1')
			{
				fd=fopen(name,"w");
				if (fd)
				{
					translate(s,fd);
					fclose(fd);
				}
				else
					printf("can't create %s\n",name);
			}
			else
				printf("not a Pure Pascal Help file\n");
			free(s);
		}
		else
			printf("not enough memory (%ld bytes needed)\n",size);
	}
	else
		printf("%s not found",helpfile);
}



main(int argc,char *argv[])
{
	printf("PPH2SCR\ntranslate\nPure Pascal Help file\n");
	printf("into\nHyper text source file (.SCR)\n\n");

	if (argc==2)
	{
		reserve(argv[1]);
		printf("done.\n");
	}
	else
		printf("nothing to translate\n");

	gemdos(7);
	
	exit(0);
}

