MODULE Terminal;

IMPORT S:=SYSTEM, GemApp, Evnt, Graf, Menus, Rsrc, TermWin,
       VC:=VDIControl;


CONST
    BOX        = 0; (* form/dialog *)
    OK         = 4; (* BUTTON in tree BOX *)
    INPUT1     = 5; (* BUTTON in tree BOX *)
    OUTPUT1    = 6; (* BUTTON in tree BOX *)

    MENU       = 1; (* menu *)
    DESK       = 3; (* TITLE in tree MENU *)
    FILE       = 4; (* TITLE in tree MENU *)
    WORK       = 5; (* TITLE in tree MENU *)
    INFO       = 8; (* STRING in tree MENU *)
    QUIT       = 17; (* STRING in tree MENU *)
    INPUT2     = 19; (* STRING in tree MENU *)
    OUTPUT2    = 20; (* STRING in tree MENU *)

    INPUTBOX   = 2; (* form/dialog *)
    CIRCLE     = 2; (* BUTTON in tree INPUTBOX *)
    RECT       = 3; (* BUTTON in tree INPUTBOX *)
    XPOS       = 4; (* FTEXT in tree INPUTBOX *)
    YPOS       = 5; (* FTEXT in tree INPUTBOX *)
    RADIUS     = 6; (* FTEXT in tree INPUTBOX *)
    WIDTH      = 7; (* FTEXT in tree INPUTBOX *)
    HEIGHT     = 8; (* FTEXT in tree INPUTBOX *)
    DRAW       = 9; (* BUTTON in tree INPUTBOX *)


TYPE
  MyApp     = POINTER TO MyAppDesc;
  MyAppDesc = RECORD(GemApp.ApplDesc)
              END;


VAR i : LONGINT;
    myApp : MyApp; (* type MyAppDesc cannot be used, because it won't
                      have a type descriptor *)
    number : INTEGER;


PROCEDURE Exit;
 BEGIN
  myApp.Exit;
 END Exit;


PROCEDURE OpenOutput;
  VAR terminal : TermWin.Viewer;
 BEGIN
  NEW(terminal); terminal.Init;
  terminal.WriteString("Hello world!"); terminal.WriteLn;
  terminal.WriteString("This is terminal window #");
  terminal.WriteInt(number); INC(number);
  terminal.WriteLn;
  terminal.CursorOn;
 END OpenOutput;


PROCEDURE HandleEvent(VAR events : GemApp.Events);
 BEGIN
  IF TermWin.STRING IN events.events THEN
    WITH events : TermWin.Events DO
      events.viewer.WriteString("Received a string: ");
      events.viewer.WriteString(events.string);
      events.viewer.WriteLn;
    END;
    EXCL(events.events, TermWin.STRING);
  END;
 END HandleEvent;


PROCEDURE(app: MyApp) Init;
  (* initializes the application by opening a window *)
  VAR menu : Menus.Menu;
 BEGIN
  app.Init^; (* must come first! *)
  Graf.ChangeMouse( Graf.ARROW);
  IF NOT Rsrc.Load("GEMDEMO.RSC") THEN
    app.Exit
  END;
  NEW( menu); menu.Init( Rsrc.GetAddr(MENU) );
  menu.Set( FILE, QUIT, Exit );
  menu.Set( WORK, OUTPUT2, OpenOutput );
  menu.Show;
  GemApp.StoreEventHandler(HandleEvent);
 END Init;


PROCEDURE(app: MyApp) Exit;
  (* closes the window. This is done automatically, but this is just
     an example. The memory is also deallocated automatically *)
 BEGIN
  app.Exit^; (* must come last! *)
 END Exit;


BEGIN
  NEW(myApp);
  myApp.Init; myApp.Run; myApp.Exit
END Terminal.
