MODULE Tutor4;

IMPORT S:=SYSTEM, GemApp, Menus, WinView, MVC, VC:=VDIControl, VO:=VDIOutput,
       VA:=VDIAttributes, Form, Graf, Rsrc;

CONST
    BOX        = 0; (* form/dialog *)
    OK         = 4; (* BUTTON in tree BOX *)
    INPUT1     = 5; (* BUTTON in tree BOX *)
    OUTPUT1    = 6; (* BUTTON in tree BOX *)

    MENU       = 1; (* menu *)
    DESK       = 3; (* TITLE in tree MENU *)
    FILE       = 4; (* TITLE in tree MENU *)
    WORK       = 5; (* TITLE in tree MENU *)
    INFO       = 8; (* STRING in tree MENU *)
    QUIT       = 17; (* STRING in tree MENU *)
    INPUT2     = 19; (* STRING in tree MENU *)
    OUTPUT2    = 20; (* STRING in tree MENU *)

    INPUTBOX   = 2; (* form/dialog *)
    CIRCLE     = 2; (* BUTTON in tree INPUTBOX *)
    RECT       = 3; (* BUTTON in tree INPUTBOX *)
    XPOS       = 4; (* FTEXT in tree INPUTBOX *)
    YPOS       = 5; (* FTEXT in tree INPUTBOX *)
    RADIUS     = 6; (* FTEXT in tree INPUTBOX *)
    WIDTH      = 7; (* FTEXT in tree INPUTBOX *)
    HEIGHT     = 8; (* FTEXT in tree INPUTBOX *)
    DRAW       = 9; (* BUTTON in tree INPUTBOX *)


TYPE
  Application = POINTER TO ApplDesc;
  ApplDesc    = RECORD(GemApp.ApplDesc)
                END;
  Viewer    = POINTER TO ViewDesc;
  ViewDesc  = RECORD(WinView.ViewDesc)
              END;
  MyModel   = POINTER TO ModelDesc;
  ModelDesc = RECORD(MVC.ModelDesc)
              END;


VAR
  myApp : Application;
  myModel : MyModel;
  Station : INTEGER;
  Workout : VC.workout;


PROCEDURE(v : Viewer) Redraw(x,y,w,h : INTEGER);
  VAR x2, y2 : INTEGER;
 BEGIN
  x2 := x+w-1; y2 := y+h-1;
  VC.VsClip( Station, TRUE, x, y, x2, y2);
  VO.VBar( Station, x, y, x2, y2 );
 END Redraw;


PROCEDURE OpenOutput;
  VAR outWin  : Viewer;
 BEGIN
  NEW( outWin); outWin.Init;
  outWin.model := myModel;
  outWin.SetTitle("Objektfenster");
  outWin.SetFullSize( 0, 19, Workout.MaxX - 1,
                      Workout.MaxY - 20);
  outWin.Open;
 END OpenOutput;


PROCEDURE ShowInfo;
  VAR d : INTEGER;
 BEGIN
  d := Form.Alert(1, "[1][Tutor4 by Stephan Junker][Ok]");
 END ShowInfo;


PROCEDURE Exit;
 BEGIN
  GemApp.exit := TRUE;
 END Exit;


PROCEDURE (app : Application) Init;
  VAR Workin : VC.workin;
      menu : Menus.Menu;
 BEGIN
  app.Init^;
  Graf.ChangeMouse( Graf.ARROW);
  IF NOT Rsrc.Load("GEMDEMO.RSC") THEN
    app.Exit
  END;
  NEW( menu); menu.Init( Rsrc.GetAddr(MENU) );
  menu.Set( FILE, QUIT, Exit );
  menu.Set( DESK, INFO, ShowInfo );
  menu.Set( WORK, OUTPUT2, OpenOutput );
  menu.Show;
  Station := 1;
  Workin.Id := 1; Workin.LineType := 1;
  Workin.LineColor := 1; Workin.MarkType := 1;
  Workin.MarkColor := 1; Workin.Font := 1;
  Workin.TextColor := 1; Workin.FillStyle := 0;
  Workin.FillPat := 0; Workin.FillColor := 1;
  Workin.KoorType := 2;
  VC.VOpnvwk(Workin,Station,Workout);
  VA.VswrMode(Station,VA.REPLACE);
  VA.VsfPerimeter(Station,FALSE);
  NEW( myModel); myModel.Init;
 END Init;

BEGIN
  NEW( myApp);
  myApp.Init; myApp.Run; myApp.Exit
END Tutor4.
