/****************************************************************
*																*
*	POP_UP.C : Fonctions de Gestion de Menus "Pop Up",			*
*			par Claude Attard (DEVGEM4).						*
*																*
*	Adaptation pour WINDFORM par Jacques Delavoix et Olivier	*
*	Booklage, les 25 et 26 Mai 1996.							*
*	Dtail des Modifs en fin de ce fichier.						*
*																*
*****************************************************************/


#include <stdlib.h>
#include <string.h>
/* #include <xgemfast.h> */
#include <aes.h>
#include <vdi.h>

#include "windform.h"

extern	int x_desk, y_desk, h_desk, w_desk, nb_planes;
MFDB image;

/* XSOZOBON : Mettre en service la dfinition suivante, ou la mettre
dans le fichier "XGEMFAST.H" :	*/
/* #define MAX_LEN	81	 */


/* prototypage */

int pop_up(WINDFORM_VAR *ptr_var, int objc, int index);

static int get_popup(OBJECT *adr_form, int button, int index);
static void set_popup(OBJECT *adr_form, int button, int option, int index);
static char *get_text(OBJECT *adr_form, int object);
static void set_text(OBJECT *adr_form, int object, char *string);
static void	get_bkgr(int of_x, int of_y, int of_w, int of_h);
static void	put_bkgr(int of_x, int of_y, int of_w, int of_h);
char *trim_cpy(char *dest, char *src);

/*  pop_up() : Gestion d'un formulaire pop-up	*/

int pop_up(WINDFORM_VAR *ptr_var, int objc, int index)
{
	OBJECT *adr_form;
	OBJECT *adr_pop;
	int x, y, w, h, etat;
	int event, old_opt = -1, option = 0; 	/* buffer[8], */
	int xm, ym, km, dummy, sortie = FALSE, old = 0;

	adr_form = ptr_var->adr_form;
	wind_update(BEG_MCTRL);				/* Bloquer menu */
	rsrc_gaddr(R_TREE, index, &adr_pop);/* Adresse formulaire pop-up */

	objc_offset(adr_form, objc, &x, &y);/* Position bouton cliqu */
	y += (adr_form[objc].ob_height);	/* Se placer juste dessous par dfaut */
	adr_pop->ob_x = x;					/* Positionner le */
	adr_pop->ob_y = y;					/* formulaire pop_up. */
	w = adr_pop->ob_width;				/* Prendre ses dimensions: */
	h = adr_pop->ob_height;

	old = get_popup(adr_form, objc, index);		/* Chercher correspondance */
	if (old) /* Si le texte du bouton correspond dj  une option du pop-up */
	{		 /* On fait concider les positions de l'option et du bouton */
		x = adr_pop->ob_x = x - adr_pop[old].ob_x;
		y = adr_pop->ob_y = y - adr_pop[old].ob_y - adr_form[objc].ob_height;
		adr_pop[old].ob_state |= CHECKED;	/* On "Checke" l'option */
	}

/* Si on sort du bureau, dcaler le pop-up avec une marge de 5 pixels */
	if (x + w > x_desk + w_desk - 5)
		x = adr_pop->ob_x = w_desk + x_desk - w - 5;
	if (x < x_desk + 5)
		x = adr_pop->ob_x = x_desk + 5;
	if (y + h > y_desk + h_desk - 5)
		y = adr_pop->ob_y = h_desk + y_desk - h - 5;
	if (y < y_desk + 5)
		y = adr_pop->ob_y = y_desk + 5;

	get_bkgr(x, y, w, h);	/* Sauver l'image de fond */

	/* Dessiner le pop-up : */
	objc_draw(adr_pop, ROOT, MAX_DEPTH, x - 3, y - 3, w + 6, h + 6);

	do		/* BOUCLE PRINCIPALE DE GESTION DU POP-UP */
	{
		event = evnt_multi(MU_BUTTON | MU_TIMER,
							1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/* buffer	*/				0L, 10, 0, &xm, &ym, &km, &dummy, &dummy, &dummy);
		if (event & MU_BUTTON)
		{
			while (km)	/* attend relchement bouton souris. */
				graf_mkstate(&dummy, &dummy, &km, &dummy);

			sortie = TRUE;	/* On peut sortir, puisqu'on a cliqu */
		}
		else if (event == MU_TIMER)
		{
			graf_mkstate(&xm, &ym, &dummy, &dummy);

/* Demander l'option de pop-up  cette position : */
			option = objc_find(adr_pop, ROOT, MAX_DEPTH, xm, ym);

			if (old_opt != option)	/* Si l'option a chang */
			{
				if (old_opt != -1 && (! (adr_pop[old_opt].ob_state & DISABLED)))
				{		/* On dslectionne l'ancienne */
					etat = adr_pop[old_opt].ob_state & ~SELECTED;
					objc_change(adr_pop, old_opt, 0, x, y, w, h, etat, TRUE);
				}
/* Si l'on est bien dans le Pop-up et l'option non DISABLED : */

				if (option > ROOT && (! (adr_pop[option].ob_state & DISABLED)))
				{
				/* On la slectionne  : */
					etat = adr_pop[option].ob_state | SELECTED;
					objc_change(adr_pop, option, 0, x, y, w, h, etat, TRUE);
				}
				old_opt = option; /* Actuallise l'option. */
			}
		}
	} while (sortie == FALSE);

	put_bkgr(x, y, w, h);				/* Restaurer le fond */
	adr_pop[old].ob_state &= ~CHECKED;	/* D-checker l'option de dpart */

/* Si l'objet est une option du Pop-up et n'est pas DISABLED : */

	if (option > 0 && (! (adr_pop[option].ob_state & DISABLED)))
	{
		etat = adr_pop[option].ob_state &= ~SELECTED;	/* La dslectionner */
		objc_change(adr_pop, option, 0, x, y, w, h, etat, FALSE);
		set_popup(adr_form, objc, option, index); /* Copier son texte dans le bouton */
	}
	wind_update(END_MCTRL);	 /* Dbloquer menu */
	return old_opt;
}

/*  get_popup() Cherche correspondance entre texte bouton et option pop-up: */

static int get_popup(OBJECT *adr_form, int button, int index)
{
	int i = 1;
	char bouton[MAX_LEN], option[MAX_LEN];
	OBJECT *adr_pop;

	if (! (adr_form[button].ob_state & SHADOWED))
		return FALSE;

	rsrc_gaddr(R_TREE, index, &adr_pop);	/* Adresse formulaire pop-up */

	trim_cpy(bouton, get_text(adr_form, button)); /* Lire le texte du bouton */

	do		/* Pour chaque objet du formulaire pop-up ... */
	{
		if (adr_pop[i].ob_type == G_STRING)		/* Si c'est une G_STRING */
		{
			trim_cpy(option, get_text(adr_pop, i));/* Lire texte de l'option */
			if (strcmp(bouton, option) == 0)	/* Si correspondance */
				return i;					/* retourne le n de l'option */
		}
	} while (! (adr_pop[i++].ob_flags & LASTOB));	/* ... jusqu'au dernier. */

	return FALSE;	/* pas trouv */
}


/*  set_popup() :Place le texte d' option pop_up dans le bouton d'appel: */

static void set_popup(OBJECT *adr_form, int button, int option, int index)
{
	char texte[MAX_LEN];
	OBJECT *adr_pop;

	if (! (adr_form[button].ob_state & SHADOWED))
		return;																		/* Ressortir */

	rsrc_gaddr(R_TREE, index, &adr_pop);		/* Adresse formulaire pop-up */

	if (adr_form[button].ob_type == G_BUTTON)
	{
		trim_cpy(texte, get_text(adr_pop, option));/* Lire texte de l'option */
		set_text(adr_form, button, texte); /* Copier le texte dans le bouton */
	}
}


/* get_text() Lire une G_STRING ou un G_TEXT:	*/

char *get_text(OBJECT *adr_form, int object)
{
	int type;
	char *retour = "";

	type = adr_form[object].ob_type;

	if (type == G_STRING || type == G_BUTTON)
		retour = (adr_form[object].ob_spec.free_string);

	else if (type == G_TEXT || type == G_BOXTEXT ||
			type == G_FTEXT || type == G_FBOXTEXT)
		retour = (adr_form[object].ob_spec.tedinfo->te_ptext);

	return retour;	/* Retourner pointeur sur la chane */
}

/* set_text() Ecrire une G_STRING ou un G_TEXT : */

static void set_text(OBJECT *adr_form, int object, char *string)
{
	int type;

	type = adr_form[object].ob_type;	/* Lire le type de l'objet */

	if (type == G_STRING || type == G_BUTTON)
		strcpy(adr_form[object].ob_spec.free_string, string);

	else if (type == G_TEXT || type == G_BOXTEXT ||
					 type == G_FTEXT || type == G_FBOXTEXT)
		strcpy(adr_form[object].ob_spec.tedinfo->te_ptext, string);
}

/* get_bkgr() Sauve le fond d'un formulaire : */

static void	get_bkgr(int of_x, int of_y, int of_w, int of_h)
{
	int pxy[8];
	size_t taille;
	MFDB *img;
	MFDB ecr = {0};		/* Ecran logique */

	img = &image;
	of_x -= 3;	/* Prvoir une marge de scurit autour */
	of_y -= 3;	/* de la zone, pour le cas o on aurait */
	of_w += 5;	/* besoin de sauvegarder le fond d'un */
	of_h += 5;	/* formulaire avec un attribut OUTLINED. */

									/* Taille tampon de copie fond */
	taille = ((((size_t)(of_w / 16) + 1) * 2 * (size_t)nb_planes)
				* (size_t)of_h) + 256;
	img->fd_addr = malloc(taille);			/* Rserver tampon */
	img->fd_w = of_w;
	img->fd_h = of_h;
	img->fd_wdwidth = (of_w / 16) + ((of_w % 16) != 0);
	img->fd_stand = 1;
	img->fd_nplanes = nb_planes;

	pxy[0] = of_x;		/* Remplir la tableau */
	pxy[1] = of_y;
	pxy[2] = pxy[0] + of_w;
	pxy[3] = pxy[1] + of_h;
	pxy[4] = 0;
	pxy[5] = 0;
	pxy[6] = of_w;
	pxy[7] = of_h;
	vs_clip(vdi_handle, FALSE, pxy);

	v_hide_c(vdi_handle);
	vro_cpyfm(vdi_handle, S_ONLY, pxy, &ecr, img);	/* Copier l'image */
	v_show_c(vdi_handle, TRUE);
}

/* put_bkgr() Restaure le fond d'un formulaire : */

static void	put_bkgr(int of_x, int of_y, int of_w, int of_h)
{
	int pxy[8];
	MFDB *img;
	MFDB ecr = {0};		/* Ecran logique */

	img = &image;
	of_x -= 3;	/* Prvoir une marge de scurit autour */
	of_y -= 3;	/* de la zone, pour le cas o on aurait */
	of_w += 5;	/* besoin de sauvegarder le fond d'un */
	of_h += 5;	/* formulaire avec un attribut OUTLINED. */

	pxy[0] = 0;		/* Remplir le tableau */
	pxy[1] = 0;
	pxy[2] = of_w;
	pxy[3] = of_h;
	pxy[4] = of_x;
	pxy[5] = of_y;
	pxy[6] = pxy[4] + pxy[2];
	pxy[7] = pxy[5] + pxy[3];
	v_hide_c(vdi_handle);
	vro_cpyfm(vdi_handle, S_ONLY, pxy, img, &ecr);	/* Copier l'image */
	v_show_c(vdi_handle, TRUE);
	free(img->fd_addr);		/* Librer la mmoire */
}


/*	trim_cpy() : Copie "src" dans "dest" en supprimant les espaces de dbut
	et de fin de la chaine.	*/

char *trim_cpy(char *dest, char *src)
{
	char *ptr_dest = dest;
	char *stop = src + strlen(src) - 1;

	while (src[0] == ' ')	/* Elimine espaces au dbut... */
		src++;
	while (stop[0] == ' ')	/* ...et  la fin. */
		stop--;
	while (src <= stop)		/* Copie la chaine. */
		*(ptr_dest)++ = *(src++);

	*ptr_dest = '\0';		/* Place le caractre de fin de chaine. */
	return dest;
}

/* ================= Dtail des Modifications ===================

- Le pointeur pass  la fonction "pop_up()" est maintenant un pointeur sur
structure WINDFORM_VAR, et cette fonction retourne maintenant l'Index de
l'option "pop_up" choisie (test  faire: si >  zro).

- La structure MFDB "image" est maintenant "globale".

- La fonction "trim()" a t remplace par la fonction "trim_cpy()", qui
ralise la copie de Chaine en supprimant les espaces de dbut et de fin.

- Certains noms de Variables ont t changs :

ANCIEN NOM		NOUVEAU NOM		COMMENTAIRES

obj				objc			Index du bouton du Formulaire Principal.
pu				index			Index du formulaire Pop_up.
old_ob			old_opt
ob				option
adr				adr_form		Adresse du Formulaire Principal.
adr_pu			adr_pop			Adresse du formulaire Pop_up.

================================================================== */

