/********************************************************
*						(Tab = 4)						*
*	USERDEFS.C	: Boutons Userdefs pour Windform.		*
*														*
*	Auteur  : Olivier Booklage							*
*	Version : V1.0										*
*	Date    : 25/04/1996								*
*														*
*	Amliorations :	Jacques Delavoix					*
*	Version : V1.1										*
*	Date	: 21/05/1996								*
*														*
*	Source pour XSozobon 2.02 et Pure C					*
*	 (inclusions en REM).								*
*********************************************************/


#include <string.h>
/* #include <xgemfast.h>		aes+vdi (Xsozobon) */
#include <aes.h>	/* Pure C */
#include <vdi.h>	/* Pure C */

#include "windform.h"
#include "userdefs.h"

/* #define	cdecl */ /* Adaptation pour le XSozobon. */


void set_user(OBJECT *addr_tree) /* RAJOUTER LES TEST DANS CETTE ROUTINE. */
{
	int index = 1;		/* L'objet Racine n'est pas trait. */
	OBJECT *addr_obj;
	do
	{
		addr_obj = &addr_tree[index];	/* pointe sur l'objet  traiter */
		if ((addr_obj->ob_type & 0xff) == G_BUTTON)
		{
			switch (addr_obj->ob_type >> 8)
			{
				case UNDER_B :
				case SMALL_B : /* Routine  appeler: "under_button()" : */
					set_objc(addr_obj, under_button);
					break;
				case ROUNDED_BUTTON :				/* Nouveau au 21/06/96 */
					set_objc(addr_obj, rounded_button);
					break;
				case SQUARE_BUTTON :				/* Nouveau au 21/06/96 */
					set_objc(addr_obj, square_button);
					break;
/* Mettre ici d'autres "case" pour d'autres "buttons" en USERDEFS */

			}
		}
		index ++; /* prpare l'objet suivant ... */
	/* ... sauf si l'objet actuel est le dernier : */
	} while((addr_obj->ob_flags & LASTOB) == 0);
}


/************************************************************************/
/*																		*/
/*	Routines USERDEFS  partir d'ici...									*/
/*																		*/
/************************************************************************/


int cdecl rounded_button(PARMBLK *parmblock)
{
int  x, y, w, h, rayon;
int xy_clip[4], attributs[10];
int char_height, cell_width, cell_height;
int tx, ty, under_pos;
char	*string;
char 	*key_short;
char chaine[60];

	xy_clip[0] = parmblock->pb_xc;
	xy_clip[1] = parmblock->pb_yc;
	xy_clip[2] = parmblock->pb_wc + xy_clip[0] - 1;
	xy_clip[3] = parmblock->pb_hc + xy_clip[1] - 1;
	vs_clip(vdi_handle, 1, xy_clip);

	vqt_attributes(vdi_handle, attributs);
	char_height = attributs[7];
	cell_width = attributs[8];
	cell_height = attributs[9];

	x = parmblock->pb_x;
	y = parmblock->pb_y;
	w = parmblock->pb_w;
	h = parmblock->pb_h;

	string = (char *) parmblock->pb_parm;
	/* CALCUL DU TEXTE */
	if ((key_short = strchr(string, '[')) != 0)
	{
		strpcpy(chaine, string, key_short);
		vqt_extent(vdi_handle, chaine, attributs);
		under_pos = attributs[2];	/* Position du soulign */
		key_short++;
		strcat(chaine, key_short);
	}
	else
		strcpy(chaine, string);

	tx = x + (cell_width * 2);
	ty = y + (char_height + (h - cell_height) / 2);

	vswr_mode(vdi_handle, MD_TRANS);
	vst_color(vdi_handle, BLACK);

	v_gtext(vdi_handle, tx, ty, chaine);
	if (key_short != 0)
	{
		vst_effects(vdi_handle, 8);	/* mode "Soulign"	*/
		v_gtext(vdi_handle, tx + under_pos, ty, " ");
		vst_effects(vdi_handle, 0);	/* mode "Normal"	*/
	}

	rayon = char_height / 2;
/* Calcul du centre du Cercle : */
	x = x + rayon;
	y = y + 1 + rayon;
	
	vswr_mode(vdi_handle, MD_REPLACE);
	vsf_color(vdi_handle, BLACK);		/* Couleur des cadres	*/
	vsf_interior(vdi_handle,0);
	v_circle(vdi_handle, x, y, rayon);
	
	if ((parmblock->pb_currstate & SELECTED) != 0)
	{
		vsf_interior(vdi_handle, 1);
		v_circle(vdi_handle, x, y, (rayon / 2) + 1);
		vsf_interior(vdi_handle, 0);
	}

	return (parmblock->pb_currstate & DISABLED);
}


int cdecl square_button(PARMBLK *parmblock)
{
int  x, y, w, h, x1, y1, x2, y2;
int xy_clip[4], pxyarray[8], attributs[10];
int char_height, cell_width, cell_height;
int tx, ty, under_pos;
char *string;
char *key_short;
char chaine[60];

	xy_clip[0] = parmblock->pb_xc;
	xy_clip[1] = parmblock->pb_yc;
	xy_clip[2] = parmblock->pb_wc + xy_clip[0] - 1;
	xy_clip[3] = parmblock->pb_hc + xy_clip[1] - 1;
	vs_clip(vdi_handle, 1, xy_clip);

	vqt_attributes(vdi_handle, attributs);
	char_height = attributs[7];
	cell_width = attributs[8];
	cell_height = attributs[9];

	x = parmblock->pb_x;
	y = parmblock->pb_y;
	w = parmblock->pb_w;
	h = parmblock->pb_h;

	string = (char *) parmblock->pb_parm;
	/* CALCUL DU TEXTE */
	if ((key_short = strchr(string, '[')) != 0)
	{
		strpcpy(chaine, string, key_short);
		vqt_extent(vdi_handle, chaine, attributs);
		under_pos = attributs[2];	/* Position du soulign */
		key_short++;
		strcat(chaine, key_short);
	}
	else
		strcpy(chaine, string);

	tx = x + (cell_width * 2);
	ty = y + (char_height + (h - cell_height) / 2);

	vswr_mode(vdi_handle, MD_TRANS);
	vst_color(vdi_handle, BLACK);
	vsf_interior(vdi_handle, 0);

	v_gtext(vdi_handle, tx, ty, chaine);
	if (key_short != 0)
	{
		vst_effects(vdi_handle, 8);	/* mode "Soulign"	*/
		v_gtext(vdi_handle, tx + under_pos, ty, " ");
		vst_effects(vdi_handle, 0);	/* mode "Normal"	*/
	}

	x1 = parmblock->pb_x;
	y1 = parmblock->pb_y;
	x2 = parmblock->pb_x + char_height;
	y2 = parmblock->pb_y + char_height;
	
/*  vsl_type (vdi_handle, FIS_SOLID); */
/*  vsl_ends (vdi_handle, SQUARED, SQUARED); */
/*  vsl_width (vdi_handle, 1); */
	vswr_mode(vdi_handle, MD_REPLACE);
	vsf_color(vdi_handle, BLACK);		/* Couleur des cadres	*/
	vsf_interior(vdi_handle, 0);

	pxyarray[0]=x1;
	pxyarray[1]=y1;
	pxyarray[2]=x2;
	pxyarray[3]=y2;

	v_bar(vdi_handle, pxyarray);
	
	if ((parmblock->pb_currstate & SELECTED) != 0)
	{
		pxyarray[0]=x1;
		pxyarray[1]=y1;
		pxyarray[2]=x2;
		pxyarray[3]=y2;

		pxyarray[4]=x1;
		pxyarray[5]=y2;
		pxyarray[6]=x2;
		pxyarray[7]=y1;

		vsl_color(vdi_handle, BLACK);
		v_pline (vdi_handle, 4, pxyarray );
	}

	return (parmblock->pb_currstate & DISABLED);
}


/* ---          EOF                 --- */
