/*
wingraph.c : entres/sorties simplifies pour Windows
Auteur : Guillaume LAMONOCA (E-mail:gl@gen4.pressimage.fr)

Wingraph.h devra se trouver dans l'un des repertoires
"include" spcifis dans Options->Rpertoires.

Exemple fourni : exsimple.c (utilisez Borland ou Turbo C++)

Remarque : la fonction main() devra changer de nom, elle
devra s'appeler principal() (contrainte du C++).

Note technique : interface drive des modules GLCB (DP)
*/

		   
#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#include <wingraph.h>

/*#define ONLY_ONCE*/
		   /* un seul exemplaire du programme   */
		   /* en cours d'execution              */

/*#define NO_CURSOR*/
		   /* pas de curseur :                  */
		   /* necessite dans le projet, l'ajout */
		   /* d'une ressource (.rc) definissant */
		   /* un curseur transparent dont l'ID  */
		   /* est le nombre 100                 */

#ifndef NOM_CLASSE
#define NOM_CLASSE "OutputWClass" /* nom du 'moule' de la       */
#endif                            /* fenetre Windows principale */

/********************************************************************/
/* variables globales */

/* facteur de grossissement maximum autorise */

int	 RATIO=1;

static int emulmono=0; /* pour faire du monochrome tram */
		       /* 0 : non   1 : oui              */
		       /* utile pour impression N&B      */

static unsigned int oldpal[16]=
{
	0x8fff,0x1008,0x3080,0x5088,
	0x2800,0x3808,0x4880,0x5ccc,
	0x3888,0x400f,0x50f0,0x60ff,
	0x4f00,0x5f0f,0x7ff0,0x0000
};

static int ungetched=0;

static int couleur_fond=BLANC;

static int cur_y=0;
static int cur_x=0;

static int ecran_travail=0;
static int ecran_actif=1;
static HANDLE hInst;
static HWND window;
static HDC hdcm,hdc;
static HBITMAP holdbitmap;
static HBITMAP hecran[2];
static HPEN hpen,holdpen;
static HBRUSH hbrush,holdbrush,hhollowbrush;
static PAINTSTRUCT ps;
static int nbscreen=2;
static COLORREF color=RGB(0,0,0);
static nocolor=15;


static int mousex,mousey,mousek,vblclock;
static int msex,msey,msek,mclk;

static int nbrbuffer=0;
static int lstbufptr=0;
static int msebufptr=0;
static int msebuffer[128];

char keymap[256]={0};
char keystate[256]={0};

static int keybuffer[256];
static int keybufptr=0;
static int keybufend=0;
static int keybufnbr=0;

					   
static int 	wgfontwidth,wgfontheight;
static HFONT	hfont,hfontold;
#ifndef COURIER_FONT
static int	iPtSize = -16;
static PSTR	pszFace = "Fixedsys";
#define TEXTWIDTH  8
#define TEXTHEIGHT 15
#else
static int	iPtSize = 12;
static PSTR	pszFace = "Courier";
#define TEXTWIDTH  8
#define TEXTHEIGHT 13
#endif




/*******************************************************************************/
/* Memoire virtuelle disponible */

unsigned long freevirtualram(void)
{
	return GetFreeSpace(0);
}



/*******************************************************************************/
/* initialisation du systeme */

static void wginitwindow(void)
{
	LOGBRUSH logbrush;

	logbrush.lbStyle=BS_HOLLOW;
	logbrush.lbColor=NULL;
	logbrush.lbHatch=NULL;

	hdc=GetDC(window);
	hdcm=CreateCompatibleDC(hdc);
	hecran[0]=CreateCompatibleBitmap(hdc,WIDTH*RATIO,HEIGHT*RATIO);
	hecran[1]=CreateCompatibleBitmap(hdc,WIDTH*RATIO,HEIGHT*RATIO);
	ReleaseDC(window,hdc);
	holdbitmap=SelectObject(hdcm,hecran[ecran_actif]);

	hpen=CreatePen(PS_NULL,1,NULL);
	hbrush=CreateSolidBrush(RGB(255,255,255));
	holdbrush=SelectObject(hdcm,hbrush);
	holdpen=SelectObject(hdcm,hpen);
	Rectangle(hdcm,0,0,WIDTH*RATIO+1,HEIGHT*RATIO+1);
	SelectObject(hdcm,hecran[ecran_travail]);
	Rectangle(hdcm,0,0,WIDTH*RATIO+1,HEIGHT*RATIO+1);
	SelectObject(hdcm,holdbrush);
	SelectObject(hdcm,holdbrush);
	SelectObject(hdcm,holdpen);
	DeleteObject(hbrush);
	DeleteObject(hpen);

	hpen=CreatePen(PS_NULL,1,NULL);
	holdpen=SelectObject(hdcm,hpen);
	hbrush=CreateSolidBrush(color);
	hhollowbrush=CreateBrushIndirect(&logbrush);
	holdbrush=SelectObject(hdcm,hbrush);

	SetTextColor(hdcm,RGB(0,0,0));

	hfont=CreateFont(iPtSize,0,0,0,0,
		0,0,0,0,0,0,0,0,pszFace);

	hfontold=SelectObject(hdcm,hfont);

#ifndef WIN32
	wgfontwidth=(WORD)GetTextExtent(hdcm,"I",1);
	wgfontheight=(WORD)(GetTextExtent(hdcm,"I",1)>>16);
#else             
	wgfontwidth=TEXTWIDTH;
	wgfontheight=TEXTHEIGHT;
#endif
}



static int wginitwingraph(void)
{
	wgsimplescreen();

	return 1;
}


static void wgkillwingraph(void)
{
	MSG msg;

	SelectObject(hdcm,hfontold);
	DeleteObject(hfont);


	SelectObject(hdcm,holdbrush);
	SelectObject(hdcm,holdpen);
	DeleteObject(hhollowbrush);
	DeleteObject(hbrush);
	DeleteObject(hpen);

	SelectObject(hdcm,holdbitmap);
	DeleteObject(hecran[0]);
	DeleteObject(hecran[1]);
	DeleteDC(hdcm);
	PostQuitMessage(0);

	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

    exit(0);
}




static long FAR PASCAL WndProc (HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	window=hWnd;

	switch (Message)
	{
		case WM_CREATE:
			break;

		case WM_PAINT:
			hdc=BeginPaint(window,&ps);
			SelectObject(hdcm,hecran[ecran_actif]);
			BitBlt(hdc,0,0,WIDTH*RATIO,HEIGHT*RATIO,hdcm,0,0,SRCCOPY);
			SelectObject(hdcm,hecran[ecran_travail]);
			EndPaint(window,&ps);
			break;

		case WM_DESTROY:
			wgkillwingraph();
			break;

		default:
			return (DefWindowProc(hWnd, Message, wParam, lParam));
	}
	return (NULL);
}




static int InitApplication(HANDLE hInstance)
{
	WNDCLASS  wc;

	wc.style = CS_BYTEALIGNCLIENT;
	wc.lpfnWndProc = WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
#ifdef NO_CURSOR
	wc.hCursor = LoadCursor(hInstance,MAKEINTRESOURCE(100));
#else
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
#endif
	wc.hbrBackground = GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = "OutputWClass";

	return (RegisterClass(&wc));
}



static int InitInstance(HANDLE hInstance, int nCmdShow)
{
	HWND	hWnd;
	int	rx,ry,screenH,screenW,windowW,windowH;

	screenH=GetSystemMetrics(SM_CYSCREEN);
	screenW=GetSystemMetrics(SM_CXSCREEN);

	rx=screenW/WIDTH;
	ry=screenH/HEIGHT;
	if (ry<rx) rx=ry;
	if (rx<RATIO) RATIO=rx;

	windowW=WIDTH*RATIO+2*GetSystemMetrics(SM_CXBORDER);
	windowH=HEIGHT*RATIO+GetSystemMetrics(SM_CYCAPTION)+GetSystemMetrics(SM_CYBORDER);
	if (!RATIO) return 0;

	hInst = hInstance;

	hWnd = CreateWindow(
		NOM_CLASSE,
		NOM_FENETRE,
		WS_SYSMENU,
		(screenW-windowW)/2,
		(screenH-windowH)/2,
		windowW,
		windowH,
		NULL,
		NULL,
		hInstance,
		NULL
	);

	if (!hWnd)
		return (FALSE);

	window=hWnd;

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	return (TRUE);

}






#pragma argsused
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	int resultat;

#ifdef ONLY_ONCE
	if (hPrevInstance)
	{
		BringWindowToTop(FindWindow(NOM_CLASSE,NOM_FENETRE));
		return 0;
	} 
#endif
	      
	if (!hPrevInstance)
	if (!InitApplication(hInstance))
		return (FALSE);

	if (!InitInstance(hInstance, nCmdShow))
		return (FALSE);

	wginitwindow();

	wginitwingraph();

	principal();
	resultat=0;

	wgkillwingraph();

	return resultat;
}






			

/***************************************************************/
/* simulation du mode texte */

int largeur_caractere(void)
{
	return wgfontwidth;
}

int hauteur_caractere(void)
{
	return wgfontheight;
}


void outtextxy(int x, int y, char *chaine)
{
	int i,len;
	char *null_string="<NULL>";

	if (!chaine)
		chaine=null_string;

	cur_x=x;
        cur_y=y;

        len=strlen(chaine);

	for(i=0;i<len;i++)
	{
		switch(chaine[i])
		{
			case 27:
                        case '\b':
				break;
			case '\n':
			case '\r':
				cur_x=0;
				cur_y+=wgfontheight;
				break;

			case '\t':
				TextOut(hdcm,cur_x,cur_y," ",1);
				cur_x+=TABNBR*wgfontheight;
				cur_x=(cur_x/(TABNBR*wgfontheight))*TABNBR*wgfontheight;
				break;

                	default:
				TextOut(hdcm,cur_x,cur_y,&chaine[i],1);
				cur_x+=wgfontwidth;
		}

		if (cur_x+wgfontwidth>WIDTH)
		{
			cur_x=0;
                        cur_y+=wgfontheight;
		}

                if (cur_y+wgfontheight>HEIGHT)
		{
			cur_y=0;
			getch();
			clrscr();
                }
	}
}


int wherex(void)
{
	return (cur_x/wgfontwidth)+1;
}

int wherey(void)
{
	return (cur_y/wgfontheight)+1;
}


void clrscr(void)
{
	wgcls();
	cur_x=0;
        cur_y=0;
}

void gotoxy(int x, int y)
{
	cur_x=(x-1)*wgfontwidth;
	cur_y=(y-1)*wgfontheight;
}

void clreol(void)
{
	int x,y;

	x=wherex();
	y=wherey();

	while(y==wherey())
		printf(" ");

	gotoxy(x,y);
}

int sputs(char *s)
{
	outtextxy(cur_x,cur_y,s);

        return 1;
}

int puts(const char *s)
{
	outtextxy(cur_x,cur_y,(char *)s);
	outtextxy(cur_x,cur_y,(char *)"\n");

        return 1;
}

char *gets(char *s)
{
	int n=0;
	int x,y;
	char touche;

	if (cur_y>HEIGHT-wgfontheight)
		clrscr();	

	s[0]=0;

	x=cur_x;
        y=cur_y;

        outtextxy(x,y,"_");
	wgrefresh();

	do
	{
		touche=(char)getch();

		if (touche=='\b')
                {
			if (n)
			{
				s[n]=' ';
				s[n+1]=0;
				outtextxy(x,y,s);
				n--;
                        }
                }
		else
                	if (touche!='\r')
				s[n++]=touche;

		s[n]='_';
		s[n+1]=' ';
                s[n+2]=' ';
		s[n+3]=0;

		outtextxy(x,y,s);
		wgrefresh();
	}
	while (touche!='\r');

	s[n]=' ';
	s[n+1]=' ';
	outtextxy(x,y,s);
	s[n]=0;

	outtextxy(cur_x,cur_y,"\n");

	return s;
}

int scanf(const char *format, ...)
{
	int r;
	char s[250];

	va_list ap;

	va_start(ap,format);

        gets(s);

	r=vsscanf(s,format,ap);

	va_end(ap);

        return r;
}
     
int vscanf(const char *format, va_list arglist)
{
	int r;     
	char s[250];

        gets(s);

	r=vsscanf(s,format,arglist);

        return r;
}

int printf(const char *format, ...)
{
	int r;     
	char s[250];

	va_list ap;

	va_start(ap,format);
	r=vsprintf(s,format,ap);

        sputs(s);

	va_end(ap);

        return r;
}

int vprintf(const char *format, va_list arglist)
{
	int r;     
	char s[250];

	r=vsprintf(s,format,arglist);

	sputs(s);

	return r;
}



/***************************************************************/
/* gestion des couleurs */


static COLORREF wgcouleur(int n)
{
	unsigned int r,v,b;

        n&=255;

	if (!emulmono)
	{
		r=16*((oldpal[n]>>8)&15);
		v=16*((oldpal[n]>>4)&15);
		b=16*(oldpal[n]&15);

		if (r>=240) r=255;
		if (v>=240) v=255;
		if (b>=240) b=255;
	}
	else
	{
		switch((oldpal[n]>>12)&15)
		{
			case 0: r=0; break;
			case 1: r=1; break;
			case 2: r=1; break;
			case 3: r=2; break;
			case 4: r=4; break;
			case 5: r=6; break;
			case 6: r=7; break;
			case 7: r=7; break;
			case 8: r=8; break;
		}
		r*=16;
		return RGB(r,r,r);
	}

	return RGB(r,v,b);
}

void wgsetcolor(int c)
{
	static int couleur_courante=NOIR;
	static int couleur_precedente=NOIR;

	if (c==COULEUR_PRECEDENTE)
	{
		c=couleur_precedente;
		couleur_precedente=couleur_courante;
		couleur_courante=c;
	}
	else
	{
		if (c!= -1)
                {
			couleur_precedente=couleur_courante;
                        couleur_courante=c;
                }
	}

	wgsettextcolor(c);

	if (nocolor!=c)
	{
		color=wgcouleur(c);
		nocolor=c;

		SelectObject(hdcm,holdbrush);
		DeleteObject(hbrush);
		hbrush=CreateSolidBrush(color);
		SelectObject(hdcm,hbrush);
	}
}


void wgsettextcolor(int c)
{                            
	if (c!= -1)
	{
		SetTextColor(hdcm,wgcouleur(c));
		if (c&XOR_MODE)
                	SetROP2(hdcm,R2_XORPEN);
                else
                	SetROP2(hdcm,R2_COPYPEN);
	}
}


void wgsetbkcolor(int c)
{                                  
	static int couleur_fond_courante=BLANC;
	static int couleur_fond_precedente=BLANC;

	if (c==COULEUR_PRECEDENTE)
	{
		c=couleur_fond_precedente;
		couleur_fond_precedente=couleur_fond_courante;
		couleur_fond_courante=c;
	}
	else
	{
		if (c!= -1)
                {
			couleur_fond_precedente=couleur_fond_courante;
                        couleur_fond_courante=c;
		}
	}

	if (c!= -1)
	{
		SetBkColor(hdcm,wgcouleur(c));
                couleur_fond=c;
	}
}


void wggetpalette(unsigned int *pal)
{
	int i;

	for(i=0;i<16;i++) pal[i]=oldpal[i];
}



void wgsetpalette(unsigned int *pal)
{
	int i;

	for(i=0;i<16;i++) oldpal[i]=pal[i];
}

















/************************************************************/
/* instructions de gestion des ecrans graphiques */



void wgsimplescreen(void)
{
	if (nbscreen==2)
	{
		ecran_travail=ecran_actif;
		nbscreen=1;
		SelectObject(hdcm,hecran[ecran_travail]);
	}
}


void wgdoublescreen(void)
{
	if (nbscreen==1)
	{
		ecran_travail=1-ecran_actif;
		nbscreen=2;
		SelectObject(hdcm,hecran[ecran_travail]);
	}
}


void wgcls(void)
{
	int t;

	t=nocolor;
	wgpbox(0,0,WIDTH,HEIGHT,couleur_fond);
	wgsetcolor(t);
}




void wgrefresh(void)
{
	vblclock++;
	RedrawWindow(window,NULL,NULL,RDW_INVALIDATE);
	wgbuthit();
}



void wgswap(void)
{
	vblclock++;
	if (nbscreen==2)
	{
		ecran_travail=1-ecran_travail;
		ecran_actif=1-ecran_actif;
	}
	RedrawWindow(window,NULL,NULL,RDW_INVALIDATE);
	SelectObject(hdcm,hecran[ecran_travail]);
	wgbuthit();

}













/******************************************************************/
/* instructions graphiques de base */

#define SGN(x) ((x==0)?(0):((x<0)?(-1):(1)))
#define ABS(x) ((x<0)?(-(x)):(x))

void wgpellipse(int x,int y,int lx,int ly,int c)
{
	if (c>=0) wgsetcolor(c);

	Ellipse(hdcm,x*RATIO,y*RATIO,(x+lx)*RATIO+1,(y+ly)*RATIO+1);
}


void wgellipse(int x,int y,int lx,int ly,int c)
{
	HPEN hp;

	if (c>=0) wgsetcolor(c);
				    
	hp=CreatePen(PS_SOLID,1,color);
	SelectObject(hdcm,hp);
	SelectObject(hdcm,hhollowbrush);
	Ellipse(hdcm,x*RATIO,y*RATIO,(x+lx)*RATIO+1,(y+ly)*RATIO+1);
	SelectObject(hdcm,hbrush);
	SelectObject(hdcm,hpen);
	DeleteObject(hp);
}



void wgpbox(int x,int y,int lx,int ly,int c)
{
	if (c>=0) wgsetcolor(c);

	Rectangle(hdcm,x*RATIO,y*RATIO,(x+lx)*RATIO+1,(y+ly)*RATIO+1);
}


void wgplot(int x,int y,int c)
{
	if (c>=0) wgsetcolor(c);

	Rectangle(hdcm,x*RATIO,y*RATIO,(x+1)*RATIO+1,(y+1)*RATIO+1);
}

void wgline(int x,int y,int x2,int y2,int c)
{
	HPEN hp;
	if (c>=0) wgsetcolor(c);
#ifdef WIN32
	LineTo(hdcm,x*RATIO,y*RATIO);
#endif
	hp=CreatePen(PS_SOLID,1,color);
	SelectObject(hdcm,hp);
#ifndef WIN32
	MoveTo(hdcm,x*RATIO,y*RATIO);
#endif
	LineTo(hdcm,x2*RATIO,y2*RATIO);
	SelectObject(hdcm,hpen);
	DeleteObject(hp);
}






void wgdbox(int x,int y,int lx,int ly,int c)
{
	if (c>=0) wgsetcolor(c);
	wgpbox(x,y,lx,1,-1);
	wgpbox(x,y+ly-1,lx,1,-1);
	wgpbox(x,y,1,ly,-1);
	wgpbox(x+lx-1,y,1,ly,-1);
}


void wgpolyline(int n,int *tp,int c)
{
	int i;

	if (c>=0) wgsetcolor(c);
	for(i=0;i<n-1;i++)
		wgline(tp[i*2],tp[i*2+1],tp[i*2+2],tp[i*2+3],-1);

}



void wgpolyfill(int n,int *tp,int c)
{
	POINT points[256];
	int i;

	if (c>=0) wgsetcolor(c);
	for(i=0;i<n;i++)
	{
		points[i].x=RATIO*tp[i*2];
		points[i].y=RATIO*tp[i*2+1];
	}
	Polygon(hdcm,points,n);
}











/**************************************************************/
/* gestion de la souris et du clavier */

int souris(int *x, int *y, int *b)
{
	int r;

	r=wggetmouse();

	if (r)
	{
        	if (x)
			*x=msex;
                if (y)
			*y=msey;
                if (b)
			*b=msek;
	}
	else
	{		
        	if (x)
			*x=mousex;
                if (y)
			*y=mousey;
                if (b)
			*b=mousek;
	}

        return r;
}

static void wgaddchar(int c)
{
	if (keybufnbr<256)
	{
		keybuffer[keybufptr++]=c;
		keybufnbr++;
		keybufptr&=255;
	}
}



static void wgaddbut(int k,int x,int y,int c)
{
	int ptr;

	if (nbrbuffer<32)
	{
		ptr=(msebufptr>>1);
		msebuffer[ptr]=k;
		msebuffer[ptr+1]=x;
		msebuffer[ptr+2]=y;
		msebuffer[ptr+3]=c;
		msebufptr+=8;
		msebufptr&=255;
		nbrbuffer++;
	}
}


static void wgmsemoved(int x,int y,unsigned int k)
{
	mousex=x;
	mousey=y;
	if (mousex<0) mousex=0;
	if (mousey<0) mousey=0;
	if (mousex>(WIDTH-1)) mousex=(WIDTH-1);
	if (mousey>(HEIGHT-1)) mousey=(HEIGHT-1);
	mousek=0;
	if (k&MK_LBUTTON) mousek|=1;
	if (k&MK_RBUTTON) mousek|=2;
}


static unsigned int wgscancode(unsigned int k)
{
	switch(k)
	{
		case 0xDB: k=')'; break;
		case 0xBB: k='='; break;
		case 0xDD: k='^'; break;
		case 0xBA: k='$'; break;
		case 0xC0: k='%'; break;
		case 0xDC: k='*'; break;
		case 0xBC: k=','; break;
		case 0xBE: k=';'; break;
		case 0xBF: k=':'; break;
		case 0xDF: k='!'; break;
		case 111: k='/'; break;
		case 106: k='*'; break;
		case 109: k='-'; break;
		case 107: k='+'; break;
		case 110: k='.'; break;
		case 96: k='0'; break;
		case 97: k='1'; break;
		case 98: k='2'; break;
		case 99: k='3'; break;
		case 100: k='4'; break;
		case 101: k='5'; break;
		case 102: k='6'; break;
		case 103: k='7'; break;
		case 104: k='8'; break;
		case 105: k='9'; break;
		case 0x26: k='^'; break;
		case 0x28: k='v'; break;
		case 0x25: k='<'; break;
		case 0x27: k='>'; break;
		case 226: k='<'; break;
    }

	if ((k>='A')&&(k<='Z')) k+=32;

	if (k>127) k=0;
	if ((k<32)&&(k!=27)&&(k!=13)&&(k!=8)) k=0;

	return k;
}


static int wglookevent(MSG *msg)
{
	int x,y,r;
        unsigned int k,k2;
        long c;

	k=((unsigned int)msg->wParam)&255;
	x=((int)LOWORD(msg->lParam))/RATIO;
	y=((int)HIWORD(msg->lParam))/RATIO;
	r=1;

	switch (msg->message)
	{
	case WM_MOUSEMOVE:
		wgmsemoved(x,y,k);
		break;

	case WM_LBUTTONDOWN:
		wgmsemoved(x,y,k);

		if ((x<WIDTH)&&(y<HEIGHT)&&(x>=0)&&(y>=0))
			wgaddbut(1,x,y,(int)(msg->time&65535L));

		break;

	case WM_LBUTTONUP:
		wgmsemoved(x,y,k);

		if ((x<WIDTH)&&(y<HEIGHT)&&(x>=0)&&(y>=0))
			wgaddbut(5,x,y,(int)(msg->time&65535L));

		break;

	case WM_RBUTTONDOWN:
		wgmsemoved(x,y,k);

		if ((x<WIDTH)&&(y<HEIGHT)&&(x>=0)&&(y>=0))
			wgaddbut(2,x,y,(int)(msg->time&65535L));

		break;

	case WM_RBUTTONUP:
		wgmsemoved(x,y,k);

		if ((x<WIDTH)&&(y<HEIGHT)&&(x>=0)&&(y>=0))
			wgaddbut(6,x,y,(int)(msg->time&65535L));

		break;


	case WM_KEYUP:  
		keystate[k]=0;
		k=wgscancode(k);
		if (k) keymap[k]= 0;
		break;

	case WM_KEYDOWN:	  
		keystate[k]=128;
		if (ToAscii((UINT)msg->wParam,(UINT)((msg->lParam>>16)&255),(BYTE FAR*)keystate,(DWORD FAR*)&c,0))
		{
			c&=255;

			if (keystate[0x10]) c|=0x4000;
			if (keystate[0x11]) c|=0x2000;
			if (keystate[0x12]) c|=0x1000;


			wgaddchar((int)c);
		}
		else
		{
			if ((k<0x10)||(k>0x12))
			{
				k2=k;
				if (k==0x14)
					keystate[0x10]^=128;
				if (keystate[0x10]) k2|=0x4000;
				if (keystate[0x11]) k2|=0x2000;
				if (keystate[0x12]) k2|=0x1000;

				wgaddchar(k2|0x8000);
			}
                }

		k=wgscancode(k);
		if ((k)&&(!(msg->lParam>>30)))
			keymap[k]= 1;

		break;

	default:
		r=0;
        break;
	}

    return r;
}





int wggetmouse(void)
{
	int ptr;

	wgbuthit();

	if (nbrbuffer)
	{
		ptr=(lstbufptr>>1);
		msek=msebuffer[ptr];
		msex=msebuffer[ptr+1];
		msey=msebuffer[ptr+2];
		mclk=msebuffer[ptr+3];
		lstbufptr+=8;
		lstbufptr&=255;
		nbrbuffer-=1;

		/* msek: bit 0:bouton gauche  bit 1:bouton droit  bit 2:0:presse 1:relache */

		return msek;
	}

	return 0;
}







int wgbuthit(void)
{
	MSG msg;

	while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		if (!wglookevent(&msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}

	return(nbrbuffer);
}





void wgempty(void)
{
	kbhit();
	wgbuthit();

	keybufnbr=keybufptr=keybufend=0;
	nbrbuffer=lstbufptr=msebufptr=0;
}


int ungetch(int c)
{
	if (ungetched)
		return EOF;
	else
		ungetched=c;
	return c;
}

int putch(int c)
{
	printf("%c",c);
	return c;
}

int getch(void)
{
	int c=0;
	MSG msg;

	wgrefresh();

	if (ungetched)
	{
        	c=ungetched;
		ungetched=0;
		return c;
        }

	while(!kbhit())
	{
		if (GetMessage(&msg, NULL, 0, 0))
        		if (!wglookevent(&msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
	}

	if (keybufnbr)
	{
		c=keybuffer[keybufend++];
		keybufend&=255;
		keybufnbr--;
	}



	if ((c&0x8000)||
	    (((c&255)==0x5e)&&(!keystate[VK_SPACE])) ||
	    (((c&255)==0xa8)&&(!keystate[VK_SPACE]))
	   )
		c=getch();

	return(c&255);
}


int sgetch(void)
{

	int c=0;
	MSG msg;

	
	if (ungetched)
	{
        	c=ungetched;
		ungetched=0;
		return c;
	}


	while(!kbhit())
	{
		if (GetMessage(&msg, NULL, 0, 0))
        		if (!wglookevent(&msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
	}

	if (keybufnbr)
	{
		c=keybuffer[keybufend++];
		keybufend&=255;
		keybufnbr--;
	}
				
	if (
	    (((c&255)==0x5e)&&(!keystate[VK_SPACE])) ||
	    (((c&255)==0xa8)&&(!keystate[VK_SPACE]))
	   )
		c=sgetch();

	return c;
}


int getche(void)
{
	int c=0;
	MSG msg;

	wgrefresh();
		      
	if (ungetched)
	{
        	c=ungetched;
		ungetched=0;
                printf("%c",c&255);
		return c;
	}

	while(!kbhit())
	{
		if (GetMessage(&msg, NULL, 0, 0))
        		if (!wglookevent(&msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
	}

	if (keybufnbr)
	{
		c=keybuffer[keybufend++];
		keybufend&=255;
		keybufnbr--;
	}



	if ((c&0x8000)||
	    (((c&255)==0x5e)&&(!keystate[VK_SPACE])) ||
	    (((c&255)==0xa8)&&(!keystate[VK_SPACE]))
	   )
		c=getch();

        printf("%c",c&255);

	return(c&255);
}


int sgetche(void)
{

	int c=0;
	MSG msg;
			
	if (ungetched)
	{
        	c=ungetched;
		ungetched=0;
                printf("%c",c&255);
		return c;
	}


	while(!kbhit())
	{
		if (GetMessage(&msg, NULL, 0, 0))
        		if (!wglookevent(&msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
	}

	if (keybufnbr)
	{
		c=keybuffer[keybufend++];
		keybufend&=255;
		keybufnbr--;
	}
				
	if (
	    (((c&255)==0x5e)&&(!keystate[VK_SPACE])) ||
	    (((c&255)==0xa8)&&(!keystate[VK_SPACE]))
	   )
		c=sgetch();

        if (!(c&0x8000))
		printf("%c",c&255);

	return c;
}


int kbhit(void)
{
	MSG msg;

	while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		if (!wglookevent(&msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}

        if (ungetched)
		return(keybufnbr+1);
	else
		return(keybufnbr);
}


int wgkeyhit(void)
{
	int r;

	r=wgbuthit();
	if (!r) r=kbhit();
	return(r);
}



void wgconfirm(void)
{
	MSG msg;

	wgempty();
	while(!wgbuthit())
	{
		if (GetMessage(&msg, NULL, 0, 0))
			if (!wglookevent(&msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
	}
}

