/*
wingraph.h : entres/sorties simplifies pour Windows
Auteur : Guillaume LAMONOCA (E-mail:gl@gen4.pressimage.fr)

Wingraph.h devra se trouver dans l'un des repertoires
"include" spcifis dans Options->Rpertoires.

Exemple fourni : exsimple.c (utilisez Borland ou Turbo C++)

Remarque : la fonction main() devra changer de nom, elle
devra s'appeler principal() (contrainte du C++).

Note technique : interface drive des modules GLCB (DP)
*/

#ifndef WINGRAPH_H
#define WINGRAPH_H

#include <stdarg.h>

#ifndef NOM_FENETRE
#define NOM_FENETRE ""
#endif

/* dimensions de la fenetre */

#ifndef WIDTH
#define WIDTH	600
#endif

#ifndef HEIGHT
#define HEIGHT	400
#endif

#define LARGEUR WIDTH
#define HAUTEUR HEIGHT




/*******************************************************************************/
/* Memoire virtuelle disponible */

unsigned long freevirtualram(void);


/************************************************************/
/* Codes de touches speciales pour */ 
/* la fonction sgetch()            */

#define T_CTRL			0x2000
#define T_ALTGR			0x3000
#define T_SHIFT			0x4000
#define T_ALT			0x1000

#define T_EFFACE		0x0008
#define T_TAB			0x0009
#define T_ENTREE		0x000d
#define T_ECHAP			0x801b

#define T_INSER			0x802d
#define T_DEBUT			0x8024
#define T_PAGE_HAUT		0x8021
#define T_SUPPR			0x802e
#define T_FIN       		0x8023
#define T_PAGE_BAS		0x8022

#define T_HAUT			0x8026
#define T_BAS			0x8028
#define T_GAUCHE		0x8025
#define T_DROITE		0x8027
#define T_CENTRE		0x800c

#define T_VERR_NUM		0x8090
#define T_CAPSLOCK		0x8014
#define T_PAUSE			0x8013
#define T_ARRET_DEFIL		0x8091 

#define T_F1			0x8070
#define T_F2			0x8071
#define T_F3			0x8072
#define T_F4			0x8073
#define T_F5			0x8074
#define T_F6			0x8075
#define T_F7			0x8076
#define T_F8			0x8077
#define T_F9			0x8078
#define T_F10			0x8079
#define T_F11			0x807a
#define T_F12			0x807b
			



/************************************************************/
/* simulation du mode texte */

#ifndef TABNBR
#define TABNBR 8
#endif

int largeur_caractere(void);
int hauteur_caractere(void);

void gotoxy(int x, int y);
int wherex(void);
int wherey(void);
void clrscr(void);
void clreol(void);


			       
void outtextxy(int,int,char *);


int scanf(const char *format, ...);
int printf(const char *format, ...);
int vscanf(const char *format, va_list arglist);
int vprintf(const char *format, va_list arglist);
			  


/***************************************************************/
/* gestion des 16 couleurs */

#define couleur(c) wgsetcolor(c)
#define couleur_fond(c) wgsetbkcolor(c)

void wgsetcolor(int c);
void wgsettextcolor(int c);
void wgsetbkcolor(int c);
void wggetpalette(unsigned int *pal);
void wgsetpalette(unsigned int *pal);

#define XOR_MODE		0x4000

#define COULEUR_PRECEDENTE	0x40

#define BLANC        0
#define BLEU         1
#define VERT         2
#define CYAN         3
#define MARRON       4
#define VIOLET       5
#define KAKI         6
#define GRIS_CLAIR   7
#define GRIS         8
#define MAGENTA      9
#define VERT_CLAIR   10
#define CYAN_CLAIR   11
#define ROUGE        12
#define VIOLET_CLAIR 13
#define JAUNE        14
#define NOIR         15

/************************************************************/
/* instructions de gestion des ecrans graphiques */

void wgsimplescreen(void);
void wgdoublescreen(void);
void wgcls(void);
void wgrefresh(void);
#define rafraichir() wgrefresh()
void wgswap(void);


/******************************************************************/
/* instructions graphiques de base */

void wgpellipse(int x,int y,int lx,int ly,int c);
void wgellipse(int x,int y,int lx,int ly,int c);
void wgpbox(int x,int y,int lx,int ly,int c);
void wgplot(int x,int y,int c);
void wgline(int x1,int y1,int x2,int y2,int c);
void wgdbox(int x,int y,int lx,int ly,int c);
void wgpolyline(int n,int *tp,int c);
void wgpolyfill(int n,int *tp,int c);

#define cercle(x,y,r) wgellipse(x,y,r,r,-1)
#define cercle_plein(x,y,r) wgpellipse(x,y,r,r,-1)
#define ellipse(x,y,rx,ry) wgellipse(x,y,rx,ry,-1)
#define ellipse_pleine(x,y,rx,ry) wgpellipse(x,y,rx,ry,-1)
#define rectangle(x,y,lx,ly) wgdbox(x,y,lx,ly,-1)
#define rectangle_plein(x,y,lx,ly) wgpbox(x,y,lx,ly,-1)
#define pixel(x,y) wgplot(x,y,-1)
#define droite(x1,y1,x2,y2) wgline(x1,y1,x2,y2,-1)
			 
	   

/**************************************************************/
/* gestion de la souris et du clavier */

int wggetmouse(void);
int wgbuthit(void);

int getch(void);
char *gets(char *s);
int sgetch(void);
int putch(int c);
int getche(void);            
int sgetche(void);
int kbhit(void);
int puts(const char *s);
int sputs(char *s);
int ungetch(int);


int wgkeyhit(void);
void wgconfirm(void);
void wgempty(void);

#undef putchar
#undef getchar

#define putchar putch
#define getchar getch


int souris(int *x, int *y, int *b);

#define BOUTON_GAUCHE_ENFONCE 1
#define BOUTON_DROIT_ENFONCE  2
#define BOUTON_GAUCHE_RELACHE 5
#define BOUTON_DROIT_RELACHE  6




/* principal() sera dfini par l'utilisateur (remplace main) */
void principal(void);



#endif WINGRAPH_H

