/*************************************************************************/
/*																		                                   */
/*	by Christophe BOYANIQUE																               */
/*	for EGlib																					                   */
/*																									                     */
/*************************************************************************/

#if  !defined( __AES__ )
#define __AES__

/****** Gestion de l'Application *****************************************/
int	appl_init		(void);
int	appl_read		(int ap_rid,int ap_rlength,void *ap_rpbuff);
int	appl_write		(int ap_wid,int ap_wlength,void *ap_wpbuff);
int	appl_find		(const char *ap_fpname);
int	appl_tplay		(void *ap_tpmem,int ap_tpnum,int ap_tpscale);
int	appl_trecord	(void *ap_trmem,int ap_trcount);
int	appl_exit		(void);
int	appl_getinfo	(int ap_gtype,int *ap_gout1,int *ap_gout2,int *ap_gout3,int *ap_gout4);
int	appl_search		(int ap_smode,char *ap_sname,int *ap_stype,int *ap_sid);

/****** Gestion des Evenements *******************************************/
int	evnt_keybd	(void);
int	evnt_button	(int ev_bclicks,int ev_bmask,int ev_bstate,
						int *ev_bmx,int *ev_bmy,int *ev_bbutton,int *ev_bkstate);
int	evnt_mouse	(int ev_moflags,int ev_mox,int ev_moy,
						int ev_mowidth,int ev_moheight,int *ev_momx,
						int *ev_momy,int *ev_mobutton,int *ev_mokstate);
int	evnt_mesag	(int *ev_mgpbuff);
int	evnt_timer	(int ev_tlocount,int ev_thicount);
int	evnt_multi	(int ev_mflags,int ev_mbclicks,int ev_mbmask,int ev_mbstate,
						int ev_mm1flags,int ev_mm1x,int ev_mm1y,int ev_mm1width,int ev_mm1height,
						int ev_mm2flags,int ev_mm2x,int ev_mm2y,int ev_mm2width,int ev_mm2height,
						int *ev_mmgpbuff,int ev_mtlocount,int ev_mthicount,
						int *ev_mmox,int *ev_mmoy,int *ev_mmbutton,int *ev_mmokstate,
						int *ev_mkreturn,int *ev_mbreturn);
int	evnt_dclick	(int ev_dnew,int ev_dgetset);

/****** Gestion du Menu **************************************************/
int	menu_bar			(OBJECT *me_btree,int me_bshow);
int	menu_icheck		(OBJECT *me_ctree,int me_citem,int me_ccheck);
int	menu_ienable	(OBJECT *me_etree,int me_eitem,int me_eenable);
int	menu_tnormal	(OBJECT *me_ntree,int me_ntitle,int me_nnormal);
int	menu_text		(OBJECT *me_ttree,int me_titem,const char *me_ttext);
int	menu_register	(int me_rapid,const char *me_rpstring);


/****** Gestion des PopUp menus ******************************************/
int	menu_popup		(MENU *me_menu,int me_xpos,int me_ypos,MENU *me_mdata);
int	menu_attach		(int me_flag,OBJECT *me_tree,int me_item,MENU *me_mdata);
int	menu_istart		(int me_flag,OBJECT *me_tree,int me_imenu,int me_item);
int	menu_settings	(int me_flag,MN_SET *me_values);


/****** Gestion des Objets ***********************************************/
#define	OB_NEXT		(tree,id)	tree [id].ob_next
#define	OB_HEAD		(tree,id)	tree [id].ob_head
#define	OB_TAIL		(tree,id)	tree [id].ob_tail
#define	OB_TYPE		(tree,id)	(tree [id].ob_type & 0xff)
#define	OB_EXTYPE	(tree,id)	(tree [id].ob_type >> 8)
#define	OB_FLAGS	(tree,id)	tree [id].ob_flags
#define	OB_EXFLAGS	(tree,id)	(tree [id].ob_flags >> 8)
#define	OB_STATE	(tree,id)	tree [id].ob_state
#define	OB_EXSTATE	(tree,id)	(tree [id].ob_state >> 8)
#define	OB_SPEC		(tree,id)	tree [id].ob_spec
#define	OB_X			(tree,id)	tree [id].ob_x
#define	OB_Y			(tree,id)	tree [id].ob_y
#define	OB_WIDTH	(tree,id)	tree [id].ob_width
#define	OB_HEIGHT	(tree,id)	tree [id].ob_height

int	objc_add		(OBJECT *ob_atree,int ob_aparent,int ob_achild);
int	objc_delete	(OBJECT *ob_dltree,int ob_dlobject);
int	objc_draw	(OBJECT *ob_drtree,int ob_drstartob,int ob_drdepth,
						int ob_drxclip,int ob_dryclip,int ob_drwclip,int ob_drhclip);
int	objc_find	(OBJECT *ob_ftree,int ob_fstartob,int ob_fdepth,int ob_fmx,int ob_fmy);
int	objc_offset	(OBJECT *ob_oftree,int ob_ofobject,int *ob_ofxoff,int *ob_ofyoff);
int	objc_order	(OBJECT *ob_ortree,int ob_orobject,int ob_ornewpos);

/* modification de objc_edit pour sozobonX */
/*int	objc_edit	(OBJECT *ob_edtree,int ob_edobject,int ob_edchar,int *ob_edidx,int ob_edkind);*/
int	objc_edit	(OBJECT *ob_edtree,int ob_edobject,int ob_edchar,int ob_edidx,int ob_edkind, int *ob_edidx);

int	objc_change	(OBJECT *ob_ctree,int ob_cobject,int ob_cresvd,int ob_cxclip,int ob_cyclip,
						int ob_cwclip,int ob_chclip,int ob_cnewstate,int ob_credraw);
/* Nouvel entete */
int objc_sysvar(int ob_smode,int ob_swhich,int ob_sival1,int ob_sival2,int *ob_soval1,int *ob_soval2);

/****** Gestion des Formulaires ******************************************/
int	form_do		(OBJECT *fo_dotree,int fo_dostartob);
int	form_dial	(int fo_diflag,int fo_dilittlx,int fo_dilittly,int fo_dilittlw,
						int fo_dilittlh,int fo_dibigx,int fo_dibigy,int fo_dibigw,int fo_dibigh );
int	form_alert	(int fo_adefbttn,const char *fo_astring);
int	form_error	(int fo_enum);
int	form_center	(OBJECT *fo_ctree,int *fo_cx,int *fo_cy,int *fo_cw,int *fo_ch);
int	form_keybd	(OBJECT *fo_ktree,int fo_kobject,int fo_kobnext,int fo_kchar,
						int *fo_knxtobject,int *fo_knxtchar);
int	form_button	(OBJECT *fo_btree,int fo_bobject,int fo_bclicks,int *fo_bnxtobj);

/****** Gestion Graphique ************************************************/
int	graf_rubberbox	(int gr_rx,int gr_ry,int gr_minwidth,int gr_minheight,
							int *gr_rlastwidth,int *gr_rlastheight);
int	graf_rubbox		(int gr_rx,int gr_ry,int gr_minwidth,int gr_minheight,
							int *gr_rlastwidth,int *gr_rlastheight);
int	graf_dragbox	(int gr_dwidth,int gr_dheight,int gr_dstartx,int gr_dstarty,
							int gr_dboundx, int gr_dboundy,int gr_dboundw,int gr_dboundh,
							int *gr_dfinishx,int *gr_dfinishy);
int	graf_movebox	(int gr_mwidth,int gr_mheight,int gr_msourcex,int gr_msourcey,
							int gr_mdestx,int gr_mdesty);
int	graf_mbox		(int gr_mwidth,int gr_mheight,int gr_msourcex,int gr_msourcey,
							int gr_mdestx,int gr_mdesty);
int	graf_growbox	(int gr_gstx,int gr_gsty,int gr_gstwidth,int gr_gstheight,
							int gr_gfinx,int gr_gfiny,int gr_gfinwidth,int gr_gfinheight);
int	graf_shrinkbox	(int gr_sfinx,int gr_sfiny,int gr_sfinwidth,int gr_sfinheight,
							int gr_sstx,int gr_ssty,int gr_sstwidth,int gr_sstheight);
int	graf_watchbox	(OBJECT *gr_wptree,int gr_wobject,int gr_winstate,int gr_woutstate);
int	graf_slidebox	(OBJECT *gr_slptree,int gr_slparent,int gr_slobject,int gr_slvh);
int	graf_handle		(int *gr_hwchar,int *gr_hhchar,int *gr_hwbox,int *gr_hhbox);
int	graf_mouse		(int gr_monumber,MFORM *gr_mofaddr);
int	graf_mkstate	(int *gr_mkmx,int *gr_mkmy,int *gr_mkmstate,int *gr_mkkstate);


/****** Gestion du ClipBoard *********************************************/
int	scrp_read	(char *sc_rpscrap);
int	scrp_write	(char *sc_wpscrap);


/****** Gestion du slecteur de fichier **********************************/
int	fsel_input		(char *fs_iinpath,char *fs_iinsel,int *fs_iexbutton);
int	fsel_exinput	(char *fs_einpath,char *fs_einsel,int *fs_eexbutton,
							char *fs_elabel );

/****** Gestion des Fentres *********************************************/
int	wind_create	(int wi_crkind,int wi_crwx,int wi_crwy,int wi_crww,int wi_crwh);
int	wind_open	(int wi_ohandle,int wi_owx,int wi_owy,int wi_oww,int wi_owh);
int	wind_close	(int wi_clhandle);
int	wind_delete	(int wi_dhandle);
int	wind_get		(int wi_ghandle,int wi_gfield,...);
int	wind_set		(int wi_shandle,int wi_sfield,...);
int	wind_find	(int wi_fmx,int wi_fmy);
int	wind_update	(int wi_ubegend);
int	wind_calc	(int wi_ctype,int wi_ckind,int wi_cinx,int wi_ciny,int wi_cinw,
						int wi_cinh,int *coutx,int *couty,int *coutw,int *couth);
void	wind_new		(void);

/****** Gestion du Resource **********************************************/
int	rsrc_load	(const char *re_lpfname);
int	rsrc_free	(void);
int	rsrc_gaddr	(int re_gtype,int re_gindex,void *gaddr);
int	rsrc_saddr	(int re_stype,int re_sindex,void *saddr);
int	rsrc_obfix	(OBJECT *re_otree,int re_oobject);
int	rsrc_rcfix	(RSHDR *rc_header);

/****** Gestion de Communication *****************************************/
int	shel_read	(char *sh_rpcmd,char *sh_rptail);
/*int	shel_write	(int sh_wdoex,int sh_wisgr,int sh_wiscr,char *sh_wpcmd,
						char *sh_wptail);*/
int	shel_get		(char *sh_gaddr,int sh_glen);
int	shel_put		(char *sh_paddr,int sh_plen);
int	shel_find	(char *sh_fpbuff);
int	shel_envrn	(char **sh_epvalue,char *sh_eparm);

#endif
/*************************************************************************/
