#ifndef __AUDIO__
#define __AUDIO__

typedef struct
{
#define AVR_MAGIC	0x32424954
	long avr_magic;					// '2BIT'
	char avr_name[8];				// sample name
#define AVR_MONO	0
#define AVR_STEREO	-1
	short avr_mode;					// mono/stereo
#define AVR_UNSIGNED	0
#define AVR_SIGNED	-1
	short avr_resolution;			// sample resolution
	short avr_signed;				// signed/unsigned sample
#define AVR_NON_LOOPING	0
#define AVR_LOOPING	-1
	short avr_looping;				// looping sample control
#define AVR_NOTE_NONE	-1
	short avr_midinote;				// assigned midi note
	unsigned long avr_frequency;	// sample frequency
	unsigned long avr_length;		// sample length
	unsigned long avr_loop_first;	// offset of first loop
	unsigned long avr_loop_end;		// offset of end loop
	char avr_reserved[6];			// reserved
	char avr_xname[20];				// sample name extension area
	char avr_user[64];				// user commitable area
} avr_t;

/*
 * This is the sample list definition. It consists of a doubly linked
 * list of entries containing the samples which are available in the
 * current sample directory.
 */
typedef struct samp_list
{
	struct samp_list *suiv;		/* Sample suivant dans la liste ou NULL   */
	char name[128];						/* Chemin + Nom du fichier sample         */
	int entete;								/* Taille de l'entete                     */
	int type;									/* Type du sample                         */
	long length;							/* Taille du sample                       */
	short rate;								/* Frquence du Sample                    */
	short mode;								/* Mono = 0, Stereo = -1                  */
	char smp_name[29];				/* Nom du sample : 28 caractres          */
	char alias[9];						/* Alias = nom utilisateur du sample      */
} SAMPLE;

#define SMP_AVR 1						/* Pour l'instant, un seul type 					*/

int AudioInit (void);
void AudioExit (void);
void AjouteSample (int type, char *nom, char *alias);
void EnleveSample (char *alias);
int PlaySample (char *alias);

#define SND_LOCK -1
#define SND_OK  0

#endif
