Exemple d'utilisation du D&D (viewer)



			case AP_DRAGDROP:
				{
					char file[128], name[ 128], *buff;
					int dd_hdl, dd_msg; /* pipe-handle */
					LONG size;
					char ext[32];
					
					/* on accepte le drag&drop */
					dd_hdl = ddopen( evnt.buff[7], DD_OK);
					if( dd_hdl<0)	break;	/* erreur, pipe non ouvert */
					
					/*	On envoit notre liste de prefs:
					 *	L'metteur du D&D attend un buffer
					 *	de 32 octets ( en faite 8 fois 4 octets)
					 *	Chaque serie de 4 octets represente une
					 *	prfrance (une extension de fichier -
					 *	e.g. '.TXT' ou ARGS ou PATH)
					 *	Notre liste de prefs se borne au type ARGS
					 *	qui a une signification spciale: on attends
					 *	une liste de nom de fichiers dans le pipe
					 */
					strnset( ext, '\0', 32);
					strcpy( ext, "ARGS");
					dd_msg = ddsexts( dd_hdl, ext);
					if( dd_msg<0)	break;	/* erreur lecture du pipe */
					
					/* Lectures des infos reus */	
					dd_msg = ddrtry( dd_hdl, name, file, ext, &size);
					if( !strncmp( ext, "ARGS", 4))
					{
						/* on accepte les donnes */
						ddreply(dd_hdl, DD_OK);
						/* Dans le cas ou l'on a une liste
						   complexe de prferance, il faut
						   boucler sur:
						   	dd_msg = ddrtry( dd_hdl, name, file, ext, &size);
						   	jusqu'a qu'on trouve sur une extension qui nous
						   	aille.
						   	ddreply(dd_hdl, DD_EXT);   permet de demander l'extension
						   				   suivante */
						
						/* On lit les "size" octets des donnes dans le pipe */
						buff = (char*)malloc(sizeof(char)*size);
						if( Fread( dd_hdl, size, buff) == size)
							OpenList( buff);
						else
							/* erreur lecture pipe */
							;
						free( buff);
						ddclose( dd_hdl);	/* fin du protocole */
					}	
					else
						ddreply(dd_hdl, DD_NAK); 
					
					ddclose( dd_hdl);	/* fin du protocole */
					 
				}
				break;