/*******************************************************************
 * Fonctions de gestion de fichiers de paramtres (.inf)           *
 *                                                                 *
 * Fichier d'entte (.h)                                           *
 *                                                                 *
 * (C) 1996 - Philippe Castella                                    *
 *                                                                 *
 *******************************************************************/

#ifndef __INIPROTO__
#define __INIPROTO__

/* Dfinitions utiles                                              */
#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/* Une ligne du fichier (autre qu'un entte de section) ==>
   NomVariable=valeur                                              */
typedef struct _var
{
	char *VarName;								/* Nom de la variable              */
	char *VarVal;									/* Valeur de la variable           */
	struct _var *NextVar;					/* Variable suivante               */
} InfVar;

/* Liste des sections ==> [Nom de la section]                      */
typedef struct _sect
{
	char *SectionName;						/* Nom de la Section               */
	InfVar *FirstVar;							/* Premier lment de la section   */
	struct _sect *NextSection;		/* Section suivante                */
} InfSection;

/* Structure d'un fichier .inf                                     */
typedef struct _inf
{
	char *FileName;
	InfSection *FirstSection;
} InitFile;

/*-----------------------------------------------------------------*
 * Dclaration des fonctions de la librairie                       *
 *-----------------------------------------------------------------*/

/* Fonction d'initialisation (cration/ouverture d'un fichier .inf */
InitFile *InfCreate (char *nomFic);

/* Fonctions d'criture des variables d'un fichier .inf            */
void InfWriteBool    (InitFile **strIni, char *section, char *var, short val);
void InfWriteInteger (InitFile **strIni, char *section, char *var, long  val);
void InfWriteString  (InitFile **strIni, char *section, char *var, char *val);

/* Fonctions de lecture des variables d'un fichier .inf            */
void InfReadBool    (InitFile *strIni, char *section, char *var, short def, short *val);
void InfReadInteger (InitFile *strIni, char *section, char *var, long  def, long  *val);
void InfReadString  (InitFile *strIni, char *section, char *var, char *def, char  *val);

/* Fonction de suppression de variables et de sections             */
void InfDeleteVar     (InitFile **strIni, char *section, char *var);
void InfDeleteSection (InitFile **strIni, char *section);

/* Fonction de libration ET de mise  jour !!                     */
void InfFree (InitFile *strIni);

#endif
/*******************************************************************/