/*************************************************************************
 * Test_Inf - (c) 1996 Philippe Castella                                 *
 * Programme de test de la librarie InitFile                             *
 *************************************************************************/

/*************************************************************************
 * Fichiers  inclure                                                    *
 *************************************************************************/
#include <stdio.h>
#include <InitFile.h>

/*-----------------------------------------------------------------------*
 * Ce programme n'est absolument pas optimis (ca se voit d'ailleur !)   *
 * Il permet de tester mes fonctions de gestion de fichiers paramtres.  *
 *-----------------------------------------------------------------------*/
void main (void)
{
	InitFile *fic_ini;
	InfSection *sect;
	InfVar *var;
	short b;
	long entier;
	char chaine[128], buf[8];
	
	/* Cration d'un fichier .inf */
	printf ("> Cration / ouverture du fichier .inf\n> Ca dpend s'il existe dj ou non !...\n");
	fic_ini = InfCreate ("test_inf.inf");
	printf ("> Nom fichier : <%s>\n", fic_ini->FileName);

	printf ("Afficher contenu du fichier Inf (rien s'il n'existe pas)\n");
	sect = fic_ini->FirstSection;
	while (sect != (InfSection *)0)
	{
		printf ("Section = %s\n", sect->SectionName);
		var = sect->FirstVar;
		while (var != (InfVar *)0)
		{
			printf ("  Var = %s, Val = %s\n", var->VarName, var->VarVal);
			var = var->NextVar;
		}
		sect = sect->NextSection;
	}
	getchar();
	
	/* Lecture du contenu du fichier */
	puts ("> Si le fichier existe dj et que les variables existent aussi");
	puts ("> les fonctions de lectures retourneront les valeurs inscrites");
	puts ("> dans le fichier .inf");
	puts ("> Sinon, elles retourneront les valeurs par dfaut !");
	
	/* Lire variable Boolenne */
	puts ("> Lire variable boolenne");
	InfReadBool (fic_ini, "Section Gnrale", "Variable Boolenne", FALSE, &b);
	printf ("Boolen = <%d>\n", b);

	/* Lire variable Entire */
	puts ("> Lire variable entire");
	InfReadInteger(fic_ini, "Section Gnrale", "Variable Entire", 2000L, &entier);
	ltoa(entier, buf, 10);
	printf ("Entier = <%s>\n", buf);

	/* Lire variable Chaine */
	puts ("> Lire variable chaine de caractres");
	InfReadString(fic_ini, "Message", "Un Message", "Coucou !", chaine);
	printf ("Chaine = <%s>\n", chaine);
	getchar ();

	/* Ecriture des variables */
	puts ("> Ecriture du contenu des variables = ");
	puts ("> 1 - Cration si elles n'existent pas");
	puts ("> 2 - Mise  jour si elles existent");

  /* Une variable boolenne */
	printf ("> Ajouter variable boolenne...\n");
	InfWriteBool (&fic_ini, "Section Gnrale", "Variable Boolenne", TRUE);
	InfWriteBool (&fic_ini, "Section Gnrale", "Variable Boolenne 2", TRUE);
	InfWriteBool (&fic_ini, "Section Spciale", "Variable Boolenne 3", TRUE);
	
	/* Une variable entire */
	printf ("> Ajouter variable entire...\n");
	InfWriteInteger (&fic_ini, "Section Gnrale", "Variable Entire", 1996);
		
	/* Une variable chaine de caractres */
	printf ("> Ajouter variable chaine de caractres...\n");
	InfWriteString  (&fic_ini, "Message", "Un Message", "Joyeux Noel et Bonne Anne 1997");
	getchar();
	
	printf ("Afficher contenu du fichier Inf\n");
	sect = fic_ini->FirstSection;
	while (sect != (InfSection *)0)
	{
		printf ("Section = %s\n", sect->SectionName);
		var = sect->FirstVar;
		while (var != (InfVar *)0)
		{
			printf ("  Var = %s, Val = %s\n", var->VarName, var->VarVal);
			var = var->NextVar;
		}
		sect = sect->NextSection;
	}
	getchar();

	/* Test des fonctions de suppression */
	puts ("Suppression d'une variable et d'une section...");
	InfDeleteVar (&fic_ini, "Section Gnrale", "Variable Boolenne 2");
	InfDeleteSection (&fic_ini, "Section Spciale");
	getchar();

	printf ("Afficher contenu du fichier Inf\n");
	sect = fic_ini->FirstSection;
	while (sect != (InfSection *)0)
	{
		printf ("Section = %s\n", sect->SectionName);
		var = sect->FirstVar;
		while (var != (InfVar *)0)
		{
			printf ("  Var = %s, Val = %s\n", var->VarName, var->VarVal);
			var = var->NextVar;
		}
		sect = sect->NextSection;
	}
	getchar();

	/* Lire variable Boolenne */
	puts ("> Relire variable boolenne");
	InfReadBool (fic_ini, "Section Gnrale", "Variable Boolenne", FALSE, &b);
	printf ("Boolen = <%d>\n", b);

	/* Lire variable Entire */
	puts ("> Relire variable entire");
	InfReadInteger(fic_ini, "Section Gnrale", "Variable Entire", 2000L, &entier);
	ltoa(entier, buf, 10);
	printf ("Entier = <%s>\n", buf);

	/* Lire variable Chaine */
	puts ("> Relire variable chaine de caractres");
	InfReadString(fic_ini, "Message", "Un Message", "Coucou !", chaine);
	printf ("Chaine = <%s>\n", chaine);
	getchar ();

	/* Ecrire fichier + libration mmoire */
	printf ("> Mise  jour du fichier %s\n", fic_ini->FileName);
	InfFree (fic_ini);

	/* Lire variable Boolenne */
	puts ("\n> Relire variable boolenne aprs fermeture");
	InfReadBool (fic_ini, "Section Gnrale", "Variable Boolenne", FALSE, &b);
	printf ("Boolen = <%d> = valeur par dfaut\n", b);

	/* Lire variable Entire */
	puts ("> Relire variable entire aprs fermeture");
	InfReadInteger(fic_ini, "Section Gnrale", "Variable Entire", 2000L, &entier);
	ltoa(entier, buf, 10);
	printf ("Entier = <%s> = valeur par dfaut\n", buf);

	/* Lire variable Chaine */
	puts ("> Relire variable chaine de caractres aprs fermeture");
	InfReadString(fic_ini, "Message", "Un Message", "Coucou !", chaine);
	printf ("Chaine = <%s> = valeur par dfaut\n", chaine);
	getchar ();

	printf ("> Appuyez sur une touche...");
	getchar();

	exit(0);
}
