/*************************************************************************
 * Test - (c) 1996 Philippe Castella                                     *
 * Programme de test de la librarie WindGem                              *
 *************************************************************************/

/*************************************************************************
 * Fichiers  inclure                                                    *
 *************************************************************************/
#include <WindGem.h>		/* Formulaires en fentre */
#include "audio.h"
#include <falcon30.h>

#ifndef _LOWRES_
#include "test.h"				/* Dfinition des objets  */
#else
#include "testst.h"
#endif

/*************************************************************************
 * Prototypes des fonctions du programme                                 *
 *************************************************************************/
void gereToolBar(Wg_Evnt *evnt);
void gerePopup (Wg_Evnt *evnt);
void gereMenu (Wg_Evnt *evnt);
void informe (Wg_Evnt *evnt);
void form (Wg_Evnt *evnt);
void systeme(Wg_Evnt *evnt);
void user (Wg_Evnt *evnt);
void userSouris (Wg_Evnt *evnt);
void userTimer (Wg_Evnt *evnt);
MFDB *LoadDoodle (char *nom_fic);
MFDB *LoadPi3 (char *nom_fic);

void main(void);
void init_prog(void);

/*************************************************************************
 * Paramtres de l'application                                           *
 *************************************************************************/
int finProg = FALSE;
int ouvert = FALSE;

Wnd bureau;
Wnd info;
Wnd formulaire;
Wnd texte, texte1;
Wnd sysWnd;
Wnd userWnd;
Wnd imgWnd;
MFDB image;
int timUser;

char **txt = (char **)NULL;
char txtUser[50][30];
char **ptrUser = (char **)NULL;

/*struct samp_list *p;
struct samp_list *root;	*/		  		/* root of list                        */
int snd = TRUE;

static int UserImg[] =
{
  0xffff,0xffff,0x8000,0x0001,0xbfff,0xfffd,0xa000,0x0005,
  0xa000,0x0005,0xa000,0x0005,0xa000,0x0005,0xa000,0x0005,
  0xa000,0x0005,0xa000,0x0005,0xa813,0xf3e5,0xa814,0x0a15,
  0xa814,0x0215,0xa814,0x0215,0xa812,0x0215,0xa811,0x0225,
  0xa810,0xc2c5,0xa810,0x2285,0xa810,0x1245,0xa810,0x0a25,
  0xa814,0x0a15,0xa7e3,0xf215,0xa000,0x0005,0xafff,0xfff5,
  0xa000,0x0005,0xa000,0x0005,0xa000,0x0005,0xa000,0x0005,
  0xa000,0x0005,0xbfff,0xfffd,0x8000,0x0001,0xffff,0xffff,
};

static BITBLK user_icn = {(short *)&UserImg[0],4,32,0,0,1};


void gereMenuWind (Wg_Evnt *evnt)
{
	if (evnt->wnd == texte)
	{
		form_alert(1,"[1][Suppression du menu dynamiquement][Ok]");
		Wg_ResetMenu (texte);
 	}
}

void gereToolBar(Wg_Evnt *evnt)
{
	form_alert(1,"[1][|Gestion d'une ToolBar en fentre !!|][Ok]");	
	Wg_ObjSelect (evnt->wnd, ObjTBar, evnt->obj, FALSE);
}


void gerePopup (Wg_Evnt *evnt)
{
	switch (evnt->obj)
	{
	case POP1 :
	case POP2 :
	case POP3 :
	case POP4 :
		form_alert(1,"[1][|Gestion d'un popup Menu par appui|sur la touche droite de la souris !!|][Ok]");
		break;
	}
}

void gereMenu (Wg_Evnt *evnt)
{
	char chemin[128], fname[13] = {0};
	int nbl, nbc, i, ret;
	char message[128];
	static int icn = 0;

	switch (evnt->obj)
	{
	case MSYST :
		WindOpen(sysWnd, WndNORM);
		break;

	case MFORM :
		WindOpen(formulaire, WndNORM);
		break;

	case MTEXTE :
		strcpy(chemin,"\\");
		if (selector (chemin, "*.*", fname, "Choisir un fichier texte"))
		{
			if (strcmp(fname,"") != 0)
			{
				if (txt)
					free (txt);
				strcat(chemin, fname);
				Wg_Loadtext (chemin, &nbl, &nbc, &txt);
				Wg_SetTitle (texte, fname);
				WindOpen(texte, WndNORM);
				Wg_SetText (texte, nbl, nbc, 0, 0, txt);
			}
		}
		break;

	case MTEXTE1 :
		WindOpen(texte1, WndNORM);
		break;
		
	case MUSER :
		WindOpen(userWnd, WndNORM);
		break;

	case MSLIDER :
		Wg_ObjSlider(SLIDINI, 100, 0, "Essai du Slider");

		for (i=0;i < 100;i++)
			Wg_ObjSlider(SLIDAFF, 0, i, "");
			
		Wg_ObjSlider(SLIDEND, 0, 0, "");

		break;
		
	case MINFO :
		WindOpen(info, WndMODAL);
		break;

	case MALERTE :
#ifndef _LOWRES_
		strcpy (message, "Bote d'alerte - |");
		strcat (message, "On a maintenant droit  6 lignes de texte (dont titre)|");
		strcat (message, "d'une longueur maximale de 60 caractres.|");
		strcat (message, "Et de quatre boutons d'au maximum 20 caractres|");
		strcat (message, "Avec 14 icnes dfinis et ventuellement la...|");
		strcat (message, "...possibilit de fournir son propre icne.");
		ret = Wg_Alerte (ICN_USER, /*(BITBLK *)NULL*/ &user_icn, message, "Bouton 1|Bouton 2|Bouton 3|Bouton 4", 1);
#else
		strcpy (message, "Bote d'alerte - |");
		strcat (message, "* 6 lig. de texte (dont titre)|");
		strcat (message, "* longueur maximale de 60 car.|");
		strcat (message, "* 4 boutons d'au max. 20 car.|");
		strcat (message, "* 14 icnes dfinis + ...|");
		strcat (message, "* ...icnes utilisateur.");
		ret = Wg_Alerte (ICN_USER, /*(BITBLK *)NULL*/ &user_icn, message, "Bouton 1|Bouton 2|Bouton 3", 1);
#endif
    break;
    
	case MIMAGE :
		WindOpen(imgWnd, WndNORM);
		break;

	case MQUITTER :
		finProg = TRUE;
		break;
	}
}

/*-----------------------------------------------------------------------*/
void main(void)
/*-----------------------------------------------------------------------*
 * Fonction principale                                                   *
 * - Initialisation,                                                     *
 * - Gestion des vnements,                                             *
 * - Fin du programme.                                                   *
 *-----------------------------------------------------------------------*/
{
	init_prog();

	if (Ordi->Machine == FALCON30 && AudioInit() != SND_OK)
	{
		form_alert(1, "[1][Systme Audio dj verouill !!][Ok]");
		snd = FALSE;
	}

/*	AjouteSample(SMP_AVR, "COUCOU.AVR", "COUCOU");*/
	AjouteSample(SMP_AVR, "H:\\MUSIQUE\\GENERICS\\LODEND.AVR", "COUCOU");

	do
	{
		EventMulti();
	} while (NOT finProg);

	if (snd && Ordi->Machine == FALCON30)
		AudioExit();

	free (image.fd_addr);
	AppExit();

	exit(0);
}

void init_prog(void)
{
	GRECT pos;
	register int i;
	Wg_Coord coord;
	MFDB *img;

#ifndef _LOWRES_	
	AppInit("Test.rsc", FALSE);
#else
	AppInit("Testst.rsc", FALSE);
#endif
	bureau = AppSetDesk (DESK, (void *)NULL, MENU, gereMenu);
	Wg_SetPopup	(bureau, POPUPM);
	Wg_SetEvent (bureau, EvntPopup, gerePopup);

	info = NewWind (WndForm);
	Wg_SetDialog (info, PROGINFO, 0);
	Wg_SetTitle (info, "Informations");
	Wg_SetEvent (info, EvntButton, informe);
	Wg_AttachHelp (info, ObjForm, INFORET, "Bouton retour|Fermeture de la fentre");

	formulaire = NewWind (WndForm);
	Wg_SetDialog (formulaire, FORM, STIT);
	Wg_SetTitle (formulaire, "Saisie...");
	Wg_SetEvent (formulaire, EvntButton, form);
	Wg_AttachPopup (formulaire, ObjForm, SCAT, POPUP);
	Wg_SetMenu (formulaire, WMENU);
	Wg_SetToolbar	(formulaire, TOOLBAR);
	Wg_AttachPopup (formulaire, ObjTBar, TBPOPUP, POPUP);
	Wg_SetEvent (formulaire, EvntToolbar, gereToolBar);
	Wg_SetEvent (formulaire, EvntMenu, gereMenuWind);
	Wg_SetEvent (formulaire, EvntMessage, form);
	Wg_AttachHelp (formulaire, ObjForm, SSAUV, "Bouton menu...|Permet d'ajouter ou d'enlever|dynamiquement un menu...");
	Wg_AttachHelp (formulaire, ObjForm, SANNU, "Bouton d'annulation|Ferme la fiche sans sauvegarde|de son contenu...");
	Wg_AttachHelp (formulaire, ObjForm, SCAT, "Bouton de popup|Permet de slectionner la catgorie|du livre...");
	Wg_AttachHelp (formulaire, ObjForm, SAIDE, "Bouton HELP|Permet de faire appel  l'aide en ligne|Si St-Guide est en mmoire...");
	Wg_AttachHelp (formulaire, ObjTBar, TBOPT1, "Bouton|Option numro 1 du Toolbar");
	Wg_AttachHelp (formulaire, ObjTBar, TBOPT2, "Bouton|Option numro 2 du Toolbar");

	texte = NewWind (WndText);
	Wg_SetMenu (texte, WMENU);
	Wg_SetEvent (texte, EvntMenu, gereMenuWind);


	ptrUser = (char **)malloc(50 * sizeof(char **));

	for (i = 0; i < 50; i++)
	{
		sprintf (txtUser[i], "Ligne de texte n%2d", i + 1);
		ptrUser[i] = txtUser[i];
	}

	texte1 = NewWind (WndText);
	Wg_SetToolbar	(texte1, TOOLBAR);
	Wg_AttachPopup (texte1, ObjTBar, TBPOPUP, POPUP);
	Wg_SetEvent (texte1, EvntToolbar, gereToolBar);
	Wg_SetText (texte1, 50, 20, 0, 0, ptrUser);

	sysWnd = NewWind (WndForm);
	Wg_SetDialog (sysWnd, SYSTEME, 0);
	Wg_SetTitle (sysWnd, "Informations systme");
	Wg_SetEvent (sysWnd, EvntAll, systeme);

	userWnd = NewWind (WndUser);
	Wg_SetTitle (userWnd, "Fentre Utilisateur");
	Wg_SetToolbar	(userWnd, TOOLBAR1);
	Wg_AttachPopup (userWnd, ObjTBar, TBCOLOR, POPUPC);
	Wg_SetEvent (userWnd, EvntAll, user);
	Wg_SetEvent (userWnd, EvntButton, userSouris);
	Wg_SetEvent (userWnd, EvntToolbar, userSouris);
	Wg_SetAttrib(userWnd, (NAME|CLOSER|MOVER|SMALLER|INFO|UPARROW|DNARROW|VSLIDE|LFARROW|RTARROW|HSLIDE));
	Wg_SetSliders (userWnd, 200, 0, 4, 320, 0, 4);
	Wg_SetInfo (userWnd, "Clic gauche = point affich");

#ifndef _LOWRES_
	coord.x = 150;
	coord.y = 100;
#else
	coord.x = 0;
	coord.y = 0;
#endif
coord.w = 320;
coord.h = 200;	/* Compter hauteur du ToolBar + barre de titre */

	/* Limitation de la taille de la fentre */
	coord.minW = coord.maxW = BLANK;
	coord.minH = coord.maxH = BLANK;
	Wg_SetCoord (userWnd, &coord);
	Wg_ObjSetText (userWnd, ObjTBar, TBCOLOR, "Blanc");
/*
	timUser = Wg_SetTimer (userWnd, 20, TIMER_STOPPED);
	Wg_SetEvent (userWnd, EvntTimer, userTimer);
	Wg_ResumeTimer (userWnd, timUser);
*/

	image.fd_addr = malloc (8000 * Sys->Nplane);
	image.fd_w = 320;
	image.fd_h = 200;
	image.fd_wdwidth = image.fd_w / 16;
	image.fd_stand = 0;
	image.fd_nplanes = Sys->Nplane;
	image.fd_r1 = image.fd_r2 = image.fd_r3 = 0;

	imgWnd = NewWind (WndGrap);
	Wg_SetTitle (imgWnd, "Fentre image");
	img = LoadPi3 ("lune.pi3");
	if (img)
		Wg_SetImage (imgWnd, 400, 640, 0, 0, img);
}

/*-----------------------------------------------------------------------*
 * Routines de gestion des items menu                                    *
 *-----------------------------------------------------------------------*/
void informe(Wg_Evnt *evnt)
{
	if (evnt->evnt == EvntButton)
	{
		if (evnt->obj > 0)
		{			
			Wg_ObjSelect (evnt->wnd, ObjForm, evnt->obj, FALSE);
			if (snd && Ordi->Machine == FALCON30)
				if (Wg_Alerte (ICN_QUEST1, (BITBLK *)0, "Question...|Voulez-vous couter |un chantillon sonore ?", "Oui|Non", 1) == 1)
					PlaySample("COUCOU");
			WindClose(evnt->wnd);
		}
	}
}

void form(Wg_Evnt *evnt)
{
	static int flag = TRUE;

	if (evnt->evnt == EvntOpen)
		form_alert(1,"[1][Fonction appelee  |l'ouverture de la fenetre][Ok]");

	if (evnt->evnt == EvntClosed)
		form_alert(1,"[1][Fonction appelee  |la fermeture de la fenetre][Ok]");

	if (evnt->evnt == EvntDragDrop)
	{
			form_alert (1, "[1][Drag & Drop sur application !][Coucou]");
	}
	
	if (evnt->evnt == EvntButton)
	{
		if (evnt->obj == SSAUV)
		{
			if (! flag)
			{
				flag = TRUE;
				form_alert(1,"[1][Ajout d'un menu dynamiquement][Ok]");
				Wg_SetMenu (evnt->wnd, WMENU);
			}
			else
			{
				flag = FALSE;
				form_alert(1,"[1][Suppression d'un menu dynamiquement][Ok]");
				Wg_ResetMenu (evnt->wnd);
			}		
		}

		if (evnt->obj== SAIDE)
			StGuide ("WindGem.Hyp", "StGuide");

		if (evnt->obj == SANNU || evnt->obj == SSAUV || evnt->obj == SAIDE)
			Wg_ObjSelect (evnt->wnd, ObjForm, evnt->obj, FALSE);

		if (evnt->obj == SANNU)
			WindClose(evnt->wnd);
	}
}

void systeme(Wg_Evnt *evnt)
{
	char txt[30];
	
	if (evnt->evnt == EvntOpen)
	{
		switch (Ordi->Processor)
		{
			case M68000 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSPROC, "68000");
				break;
			case M68010 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSPROC, "68010");
				break;
			case M68020 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSPROC, "68020");
				break;
			case M68030 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSPROC, "68030");
				break;
		}
		if (Ordi->Machine == ST)
				Wg_ObjSetText (sysWnd, ObjForm, SYSMACH, "ST        ");
		else if (Ordi->Machine == STE)
				Wg_ObjSetText (sysWnd, ObjForm, SYSMACH, "STE       ");
		else if (Ordi->Machine == MSTE)
				Wg_ObjSetText (sysWnd, ObjForm, SYSMACH, "Mega STE  ");
		else if (Ordi->Machine == TT)
				Wg_ObjSetText (sysWnd, ObjForm, SYSMACH, "TT 030    ");
		else if (Ordi->Machine == FALCON30)
				Wg_ObjSetText (sysWnd, ObjForm, SYSMACH, "Falcon 030");
		else
				Wg_ObjSetText (sysWnd, ObjForm, SYSMACH, "Inconnue  ");

		switch (hibyte(hiword(Ordi->Fdc)))
		{
			case 0 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFDC, "DD");
				break;
			case 1 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFDC, "HD");
				break;
			case 2 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFDC, "ED");
				break;
		}

		switch (Ordi->Keyboard)
		{
			case KEYB_USA :
				Wg_ObjSetText (sysWnd, ObjForm, SYSCLAV, "USA     ");
				break;
			case KEYB_D :
				Wg_ObjSetText (sysWnd, ObjForm, SYSCLAV, "Allemand");
				break;				
			case KEYB_F :
				Wg_ObjSetText (sysWnd, ObjForm, SYSCLAV, "Franais");
				break;
			case KEYB_GB :
				Wg_ObjSetText (sysWnd, ObjForm, SYSCLAV, "Anglais ");
				break;
			case KEYB_SP :
				Wg_ObjSetText (sysWnd, ObjForm, SYSCLAV, "Espagnol");
				break;
			case KEYB_I :
				Wg_ObjSetText (sysWnd, ObjForm, SYSCLAV, "Italien ");
				break;
			case KEYB_CHD :
				Wg_ObjSetText (sysWnd, ObjForm, SYSCLAV, "Suisse D");
				break;
			case KEYB_CHF :
				Wg_ObjSetText (sysWnd, ObjForm, SYSCLAV, "Suisse F");
				break;
		}
		switch (Ordi->Language)
		{
			case LG_USA :
				Wg_ObjSetText (sysWnd, ObjForm, SYSLANG, "USA     ");
				break;
			case LG_D :
				Wg_ObjSetText (sysWnd, ObjForm, SYSLANG, "Allemand");
				break;				
			case LG_F :
				Wg_ObjSetText (sysWnd, ObjForm, SYSLANG, "Franais");
				break;
			case LG_GB :
				Wg_ObjSetText (sysWnd, ObjForm, SYSLANG, "Anglais ");
				break;
			case LG_SP :
				Wg_ObjSetText (sysWnd, ObjForm, SYSLANG, "Espagnol");
				break;
			case LG_I :
				Wg_ObjSetText (sysWnd, ObjForm, SYSLANG, "Italien ");
				break;
			case LG_CHD :
				Wg_ObjSetText (sysWnd, ObjForm, SYSLANG, "Suisse D");
				break;
			case LG_CHF :
				Wg_ObjSetText (sysWnd, ObjForm, SYSLANG, "Suisse F");
				break;
		}
		if (Ordi->Shifter == SHIFTER_ST)
			Wg_ObjSetText (sysWnd, ObjForm, SYSSHIF, "ST    ");
		else if (Ordi->Shifter == SHIFTER_STE)	
			Wg_ObjSetText (sysWnd, ObjForm, SYSSHIF, "STE   ");
		else if (Ordi->Shifter == SHIFTER_TT)
			Wg_ObjSetText (sysWnd, ObjForm, SYSSHIF, "TT    ");
		else if (Ordi->Shifter == VIDEL_FALCON)
			Wg_ObjSetText (sysWnd, ObjForm, SYSSHIF, "Falcon");
		else
			Wg_ObjSetText (sysWnd, ObjForm, SYSSHIF, "??????");

		strcpy(txt, "");
		if (Ordi->Sound & PSG)
			strcat(txt, "PSG ");
		if (Ordi->Sound & DSP)
			strcat(txt, "DSP ");
		if (Ordi->Sound & CODEC)
			strcat(txt, "CODEC ");
		if (Ordi->Sound & MATRICE)
			strcat(txt, "MATRICE ");

		strcomplete (txt, 24, ' ', INS_END);
		Wg_ObjSetText (sysWnd, ObjForm, SYSSND, txt);
		switch (Ordi->Fpu)
		{
			case NO_FPU :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFPU, "Aucun       ");
				break;
			case SFP004 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFPU, "SFP004      ");
				break;
			case C68881_2 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFPU, "C68881_2    ");
				break;
			case C68881_2_SFP :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFPU, "C68881_2_SFP");
				break;
			case C68881 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFPU, "C68881      ");
				break;
			case C68881_SFP :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFPU, "C68881_SFP  ");
				break;
			case C68882 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFPU, "C68882      ");
				break;
			case C68882_SFP :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFPU, "C68882_SFP  ");
				break;
			case C68040 :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFPU, "C68040      ");
				break;
			case C68040_SFP :
				Wg_ObjSetText (sysWnd, ObjForm, SYSFPU, "C68040_SFP  ");
				break;
		}
		switch (Ordi->Date)
		{
			case DATE_MJA :
				Wg_ObjSetText (sysWnd, ObjForm, SYSDATE, "MJA");
				break;
			case DATE_JMA :
				Wg_ObjSetText (sysWnd, ObjForm, SYSDATE, "JMA");
				break;
			case DATE_AMJ :
				Wg_ObjSetText (sysWnd, ObjForm, SYSDATE, "AMJ");
				break;
			case DATE_AJM :
				Wg_ObjSetText (sysWnd, ObjForm, SYSDATE, "AJM");
				break;
		}
		sprintf(txt, "%c",Ordi->Separator);
		Wg_ObjSetText (sysWnd, ObjForm, SYSSEP, txt);

		if (Ordi->Time == TIME_24)
			Wg_ObjSetText (sysWnd, ObjForm, SYSTIME, "24");
		else
			Wg_ObjSetText (sysWnd, ObjForm, SYSTIME, "12");

		sprintf (txt, "%X", Ordi->TosVersion);
		Wg_ObjSetText (sysWnd, ObjForm, SYSTOS, txt);

		sprintf (txt, "%X%X", lobyte(Ordi->GemdosVersion), hibyte(Ordi->GemdosVersion));
		Wg_ObjSetText (sysWnd, ObjForm, SYSGEMD, txt);
		sprintf (txt, "%X", Ordi->AesVersion);
		Wg_ObjSetText (sysWnd, ObjForm, SYSAES, txt);
		if (Ordi->MultiTosVersion == 0)
			Wg_ObjSetText (sysWnd, ObjForm, SYSMINT, "Non");
		else
		{
			sprintf (txt, "%X", Ordi->MultiTosVersion);
			Wg_ObjSetText (sysWnd, ObjForm, SYSMINT, txt);
		}
		if (Ordi->Magic)
			Wg_ObjSetText (sysWnd, ObjForm, SYSMAG, "Oui");
		else
			Wg_ObjSetText (sysWnd, ObjForm, SYSMAG, "Non");
	}
	
	if (evnt->evnt == EvntButton)
	{
		if (evnt->obj > 0)
		{
			Wg_ObjSelect (evnt->wnd, ObjForm, evnt->obj, FALSE);
			WindClose(evnt->wnd);
		}
	}
}

/*-----------------------------------*/
/* Gestion de la fentre utilisateur */
/*-----------------------------------*/
void userTimer (Wg_Evnt *evnt)
{
	if (evnt->obj == timUser)
	{
		form_alert (1, "[1][Coucou Timer...][Ok]");
	}
}

void user (Wg_Evnt *evnt)
{
	GRECT rd, coord, r;
	int h, xy[4], pxy[8];
	Wg_Coord pos;
	MFDB nul;
	
	nul.fd_addr = 0;
	
	h = Wg_GetHandle (evnt->wnd);
	Wg_GetWorkXYWH (evnt->wnd, &coord);

	if (evnt->evnt == EvntOpen)
	{
		if (ouvert == FALSE)
		{
			ouvert = TRUE;
			xy[0] = coord.g_x;
			xy[1] = coord.g_y;
			xy[2] = xy[0] + coord.g_w - 1;
			xy[3] = xy[1] + coord.g_h - 1;
			vsf_color(Sys->VdiHandle, BLACK);
			vr_recfl(Sys->VdiHandle, xy);

			/* Remplir en noir la zone tampon 320*200 */
			pxy[0] = coord.g_x;
			pxy[1] = coord.g_y;
			pxy[2] = pxy[0] + coord.g_w - 1;
			pxy[3] = pxy[1] + coord.g_h - 1;
			pxy[4] = 0;
			pxy[5] = 0;
			pxy[6] = coord.g_w - 1;
			pxy[7] = coord.g_h - 1;
			vro_cpyfm (Sys->VdiHandle, S_ONLY, pxy, &nul, &image);
			pxy[4] = 320 - coord.g_w;
			pxy[5] = 0;
			vro_cpyfm (Sys->VdiHandle, S_ONLY, pxy, &nul, &image);
			pxy[4] = 320 - coord.g_w;
			pxy[5] = 200 - coord.g_h;
			vro_cpyfm (Sys->VdiHandle, S_ONLY, pxy, &nul, &image);
			pxy[4] = 0;
			pxy[5] = 200 - coord.g_h;
			vro_cpyfm (Sys->VdiHandle, S_ONLY, pxy, &nul, &image);
		}
	}		

	if (evnt->evnt == EvntMessage)
	{
		int posH, posW;

		switch(evnt->mes[0])
		{
			case WM_REDRAW :
				Wg_GetSliderPos (evnt->wnd, &posH, &posW);
				rd.g_x = evnt->mes[4]; rd.g_y = evnt->mes[5];
				rd.g_w = evnt->mes[6]; rd.g_h = evnt->mes[7];		

				v_hide_c (Sys->VdiHandle);	/* Virer la souris */
				wind_update (BEG_UPDATE); 	/* Bloquer les fonctions de la souris */

				/* Demande les coord. et dimensions du 1 rectangle de la liste */
				wind_get (evnt->mes[3], WF_FIRSTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);

				while (r.g_w && r.g_h)			/* Tant qu'il y a largeur ou hauteur... */
				{
					set_clip (1, &r); 	/* Clipping ON */
					if (rc_intersect (&rd, &r)) /* Si intersection des 2 zones */
					{
						pxy[0] = posW;
						pxy[1] = posH;
						pxy[2] = pxy[0] + coord.g_w - 1;
						pxy[3] = pxy[1] + coord.g_h - 1;
						pxy[4] = coord.g_x;
						pxy[5] = coord.g_y;
						pxy[6] = pxy[4] + coord.g_w - 1;
						pxy[7] = pxy[5] + coord.g_h - 1;
						vro_cpyfm (Sys->VdiHandle, S_ONLY, pxy, &image, &nul);
					}
					/* Rectangle suivant */
					set_clip (0, &r); 	/* Clipping OFF */
					wind_get (evnt->mes[3], WF_NEXTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
				}
				wind_update(END_UPDATE);
				v_show_c (Sys->VdiHandle, 1); 			/* Rappeler la souris */
				break;
		}
	}	
}

void userSouris (Wg_Evnt *evnt)
{
	int xy[4], pxy[8];
	GRECT coord;
	static int couleur = WHITE;
	MFDB nul;
	int posH, posW;

	nul.fd_addr = 0;

	Wg_GetSliderPos (evnt->wnd, &posH, &posW);
	Wg_GetWorkXYWH (evnt->wnd, &coord);
	if (coord.g_x + coord.g_w > Sys->Xres)
		coord.g_w = Sys->Xres - coord.g_x;
	if (coord.g_y + coord.g_h > Sys->Yres)
		coord.g_h = Sys->Yres - coord.g_y;

	if (evnt->evnt == EvntButton)
	{
		v_hide_c (Sys->VdiHandle);

	  vsl_color (Sys->VdiHandle, couleur);
		set_clip (1, &coord); 	/* Clipping ON */
		/* Affichage d'un point sous le curseur de la souris */
		if (evnt->mk == 1)
		{
			xy[0] = evnt->mx;
			xy[1] = evnt->my;
			xy[2] = evnt->mx;
			xy[3] = evnt->my;
		  v_pline (Sys->VdiHandle, 2, xy);
		}
		set_clip (0, &coord); 	/* Clipping OFF */
		v_show_c (Sys->VdiHandle,1);
	}
	else
	{
		switch (evnt->obj)
		{
		case TBCOLOR :
			switch (evnt->objPop)
			{
			case CNOIR :
				couleur = BLACK;			
				break;
			case CBLANC :		
				couleur = WHITE;
				break;
			case CVERT :
			  couleur = GREEN;
				break;
			case CROUGE :
			  couleur = RED;
  			break;
	  	case CBLEU :
 			  couleur = BLUE;
				break;
			}
			break;
		case TBMEMO :
			/* Tenir compte des bords de l'cran sinon BOUM */
			v_hide_c (Sys->VdiHandle);
			pxy[0] = coord.g_x;
			pxy[1] = coord.g_y;
			pxy[2] = pxy[0] + coord.g_w - 1;
			pxy[3] = pxy[1] + coord.g_h - 1;
			pxy[4] = posW;
			pxy[5] = posH;
			pxy[6] = pxy[4] + coord.g_w - 1;
			pxy[7] = pxy[5] + coord.g_h - 1;
			vro_cpyfm (Sys->VdiHandle, S_ONLY, pxy, &nul, &image);
			v_show_c (Sys->VdiHandle,1);
			Wg_ObjSelect (evnt->wnd, ObjTBar, evnt->obj, FALSE);
			break;
		}
	}
}

MFDB *LoadDoodle (char *nom_fic)
{
	int fh;
	MFDB *img = (MFDB *)NULL;
	
	if (exist (nom_fic, ZERO))										/* Si le fichier est l */
	{
		fh = (int)Fopen (nom_fic, O_RDONLY);				/* Ouvrir le fichier */
		if (fh >= 0)															/* Si fichier bien ouvert */
		{
			img = (MFDB *)malloc (sizeof (MFDB));
			img->fd_addr = malloc (32000);	/* Rserver la mmoire pour l'image */
			if (img->fd_addr)								/* Si mmoire bien rserve */
			{
				Fread (fh, 32000, img->fd_addr);			/* Lire les 32000 octets d'image */
				Fclose (fh);													/* Fermer le fichier */
				img->fd_w = 640;											/* Largeur image en octets */
				img->fd_h = 400;											/* Hauteur image en octets */
				img->fd_wdwidth = img->fd_w / 16;			/* Largeur image en mots */
				img->fd_stand = 0;										/* Mode coordonnes */
				img->fd_nplanes = 1;									/* Nb plans de couleurs */
				img->fd_r1 = img->fd_r2 = img->fd_r3 = 0;	/* Elments rservs */
			}
		}
	}
	return img;
}

MFDB *LoadPi3 (char *nom_fic)
{
	int fh;
	int pal[16];
	MFDB *img = (MFDB *)NULL;
	
	if (exist (nom_fic, ZERO))										/* Si le fichier est l */
	{
		fh = (int)Fopen (nom_fic, O_RDONLY);				/* Ouvrir le fichier */
		if (fh >= 0)															/* Si fichier bien ouvert */
		{
			img = (MFDB *)malloc (sizeof (MFDB));
			img->fd_addr = malloc (32000);	/* Rserver la mmoire pour l'image */
			if (img->fd_addr)								/* Si mmoire bien rserve */
			{
				Fseek (2, fh, 0);
				Fread (fh, 32, pal);
				Fread (fh, 32000, img->fd_addr);			/* Lire les 32000 octets d'image */
				Fclose (fh);													/* Fermer le fichier */
				img->fd_w = 640;											/* Largeur image en octets */
				img->fd_h = 400;											/* Hauteur image en octets */
				img->fd_wdwidth = img->fd_w / 16;			/* Largeur image en mots */
				img->fd_stand = 0;										/* Mode coordonnes */
				img->fd_nplanes = 1;									/* Nb plans de couleurs */
				img->fd_r1 = img->fd_r2 = img->fd_r3 = 0;	/* Elments rservs */
			}
		}
	}
	return img;
}

/*----------------------------------------------------------------------*/
