/*************************************************************************
 * WgAlert.C                                                             *
 *                                                                       *
 * Module de gestion des boites d'alerte.                                *
 *                                                                       *
 * Cration : 8 mai 1997                                                 *
 *************************************************************************/
#include "WinProto.h"

/*-=< Inclusion des descriptions des objets UserDefs. >=-----------------*/
#include "user.h"

static int al_image[] = {
0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FF8, 0x1FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 0x7FFC, 0x3FFE, 
0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x7FFC, 0x3FFE, 0x7FF8, 0x1FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 
0x7FFC, 0x3FFE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000,

0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FF8, 0x1FFE, 0x7FE0, 0x07FE, 
0x7F80, 0x01FE, 0x7F00, 0x00FE, 0x7E00, 0x007E, 0x7E01, 0xC07E, 
0x7E03, 0xC07E, 0x7F07, 0x80FE, 0x7FFF, 0x01FE, 0x7FFE, 0x01FE, 
0x7FFC, 0x03FE, 0x7FF8, 0x07FE, 0x7FF8, 0x07FE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 0x7FFC, 0x3FFE, 
0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x7FFC, 0x3FFE, 0x7FF8, 0x1FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 
0x7FFC, 0x3FFE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000,

0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FFE, 0x7FFE, 0x7FFC, 0x7FFE, 
0x7FE4, 0x4FFE, 0x7FC4, 0x47FE, 0x7FC4, 0x47FE, 0x7FC4, 0x47FE, 
0x7FC4, 0x47FE, 0x7F44, 0x47FE, 0x7E44, 0x47FE, 0x7E44, 0x47FE, 
0x7E44, 0x467E, 0x7E44, 0x447E, 0x7E44, 0x447E, 0x7E40, 0x047E, 
0x7E40, 0x047E, 0x7E40, 0x047E, 0x7E00, 0x087E, 0x7E00, 0x107E, 
0x7E00, 0x407E, 0x7E00, 0x007E, 0x7E01, 0x00FE, 0x7F00, 0x00FE, 
0x7F00, 0x01FE, 0x7F80, 0x03FE, 0x7FC0, 0x0FFE, 0x7FFF, 0xFFFE, 
0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000,

0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FFC, 0x3FFE, 0x7FF8, 0x1FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 
0x7FFC, 0x3FFE, 0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x7FC0, 0x1FFE, 
0x7F80, 0x0FFE, 0x7F80, 0x0FFE, 0x7FC0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7F80, 0x01FE, 0x7F00, 0x00FE, 0x7F00, 0x00FE, 
0x7F80, 0x01FE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000,

0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
0x0000, 0x0000, 0x0000, 0xC790, 0x0000, 0xF844, 0x003D, 0xF830, 
0x01FF, 0xFCB2, 0x07FF, 0xFC00, 0x0FFF, 0xF848, 0x1F3F, 0xF800, 
0x1E67, 0xF800, 0x3FCF, 0xFC00, 0x3CFF, 0xFC00, 0x3C9F, 0xFC00, 
0x7F9F, 0xFE00, 0x7FFF, 0xFE00, 0x7FFF, 0xFE00, 0x7FFF, 0xFE00, 
0x3FFF, 0xFC00, 0x3FFF, 0xFC00, 0x3FFF, 0xFC00, 0x1FFF, 0xF800, 
0x1FFF, 0xF800, 0x0FFF, 0xF000, 0x07FF, 0xE000, 0x01FF, 0x8000, 
0x003C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0FFF, 0xFDE0, 
0x1F80, 0x07F0, 0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 
0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 0x1FC0, 0x0FF8, 
0x1FFF, 0xFFF8, 0x1FFF, 0xFFF8, 0x1FFF, 0xFFF8, 0x1C00, 0x0038, 
0x1C00, 0x0038, 0x1CF0, 0x0038, 0x1C00, 0x0038, 0x1CFF, 0x6038, 
0x1C00, 0x0038, 0x1CE4, 0x0038, 0x1C00, 0x0038, 0x1CFF, 0x9838, 
0x1C00, 0x0038, 0x14DF, 0x3038, 0x1400, 0x0038, 0x1C00, 0x0038, 
0x0FFF, 0xFFF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 
0x0000, 0xE000, 0x0001, 0xF000, 0x0003, 0xF800, 0x0005, 0xFC00, 
0x0008, 0xFE00, 0x0010, 0x7F00, 0x0020, 0x7F80, 0x0040, 0xFFC0, 
0x0087, 0xCF80, 0x010F, 0x8740, 0x010F, 0x82C0, 0x028F, 0x85C0, 
0x0347, 0x0BC0, 0x03A0, 0x17C0, 0x01D0, 0x2FC0, 0x0268, 0x5F80, 
0x0334, 0xBF00, 0x031B, 0x7E00, 0x018C, 0xFC00, 0x00CD, 0xF800, 
0x0065, 0xF000, 0x0039, 0xE000, 0x001D, 0xC000, 0x000D, 0x8000, 
0x0005, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

0x0000, 0x0000, 0x0000, 0x0000, 0x1FFF, 0xFFE0, 0x2C00, 0x00F0, 
0x3407, 0x80D8, 0x2C0F, 0xC0BC, 0x340C, 0xC0DC, 0x2C00, 0xC0BC, 
0x3401, 0x80DC, 0x2C03, 0x00BC, 0x3403, 0x00DC, 0x2C00, 0x00BC, 
0x3403, 0x00DC, 0x2C03, 0x00BC, 0x3400, 0x00DC, 0x2FFF, 0xFFBC, 
0x3555, 0x555C, 0x2AAA, 0xAABC, 0x35FF, 0xFD5C, 0x2B80, 0x06BC, 
0x3538, 0x035C, 0x2B38, 0x02BC, 0x3538, 0x035C, 0x2B38, 0x02BC, 
0x3538, 0x035C, 0x2B38, 0x02BC, 0x3500, 0x035C, 0x1FFF, 0xFFFC, 
0x0FFF, 0xFFFC, 0x07FF, 0xFFF8, 0x0000, 0x0000, 0x0000, 0x0000,

0x0000, 0x0000, 0x0001, 0x0000, 0x0003, 0x8000, 0x0007, 0xC000, 
0x0007, 0xE000, 0x000F, 0xF000, 0x000F, 0xF800, 0x002F, 0xFC00, 
0x006F, 0xFE00, 0x00DF, 0xFE00, 0x01BF, 0xFC00, 0x037F, 0xFC00, 
0x06FF, 0xF800, 0x037F, 0xFA00, 0x05BF, 0xFB00, 0x06DF, 0xF600, 
0x076F, 0xED00, 0x07B7, 0xDB00, 0x07DB, 0xB700, 0x07ED, 0x6F00, 
0x07F6, 0xDF00, 0x03FB, 0xBE00, 0x01FD, 0x7D80, 0x00FE, 0xFB80, 
0x007E, 0xFB80, 0x003E, 0xFB00, 0x001E, 0xF000, 0x000E, 0xE000, 
0x0006, 0xC000, 0x0002, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,

0x0001, 0x8000, 0x0002, 0x4000, 0x0004, 0x2000, 0x0009, 0x9000, 
0x0013, 0xC800, 0x0027, 0xE400, 0x004F, 0xF200, 0x009F, 0xF900, 
0x013C, 0x3C80, 0x027C, 0x3E40, 0x04FC, 0x3F20, 0x09FC, 0x3F90, 
0x13FC, 0x3FC8, 0x27FC, 0x3FE4, 0x4FFC, 0x3FF2, 0x9FFC, 0x3FF9, 
0x9FFC, 0x3FF9, 0x4FFC, 0x3FF2, 0x27FC, 0x3FE4, 0x13FC, 0x3FC8, 
0x09FF, 0xFF90, 0x04FF, 0xFF20, 0x027C, 0x3E40, 0x013C, 0x3C80, 
0x009F, 0xF900, 0x004F, 0xF200, 0x0027, 0xE400, 0x0013, 0xC800, 
0x0009, 0x9000, 0x0004, 0x2000, 0x0002, 0x4000, 0x0001, 0x8000,

0x7FFF, 0xFFFE, 0x8000, 0x0001, 0x9FFF, 0xFFF9, 0x4FE0, 0x0FF2, 
0x4FC0, 0x07F2, 0x2787, 0xC3E4, 0x27FF, 0xE3E4, 0x13FF, 0xE3C8, 
0x13FF, 0xC7C8, 0x09FF, 0x0F90, 0x09FE, 0x1F90, 0x04FC, 0x3F20, 
0x04FC, 0x3F20, 0x027C, 0x3E40, 0x027C, 0x3E40, 0x013C, 0x3C80, 
0x013F, 0xFC80, 0x009F, 0xF900, 0x009C, 0x3900, 0x004C, 0x3200, 
0x004F, 0xF200, 0x0027, 0xE400, 0x0027, 0xE400, 0x0013, 0xC800, 
0x0013, 0xC800, 0x0009, 0x9000, 0x0009, 0x9000, 0x0004, 0x2000, 
0x0004, 0x2000, 0x0002, 0x4000, 0x0002, 0x4000, 0x0001, 0x8000,

0x007F, 0xFE00, 0x00C0, 0x0300, 0x01BF, 0xFD80, 0x037F, 0xFEC0, 
0x06FF, 0xFF60, 0x0DFF, 0xFFB0, 0x1BFF, 0xFFD8, 0x37FF, 0xFFEC, 
0x6FFF, 0xFFF6, 0xDFFF, 0xFFFB, 0xB181, 0x860D, 0xA081, 0x0205, 
0xA4E7, 0x3265, 0xA7E7, 0x3265, 0xA3E7, 0x3265, 0xB1E7, 0x3205, 
0xB8E7, 0x320D, 0xBCE7, 0x327D, 0xA4E7, 0x327D, 0xA0E7, 0x027D, 
0xB1E7, 0x867D, 0xBFFF, 0xFFFD, 0xDFFF, 0xFFFB, 0x6FFF, 0xFFF6, 
0x37FF, 0xFFEC, 0x1BFF, 0xFFD8, 0x0DFF, 0xFFB0, 0x06FF, 0xFF60, 
0x037F, 0xFEC0, 0x01BF, 0xFD80, 0x00C0, 0x0300, 0x007F, 0xFE00,

0x0000, 0x0000, 0x0001, 0xC000, 0x0073, 0xE000, 0x00FB, 0xE700, 
0x00FB, 0xEF80, 0x1CFB, 0xEF80, 0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 
0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 
0x3EFB, 0xEF9C, 0x3EFB, 0xEFBC, 0x3EFB, 0xEFBC, 0x3FFF, 0xFF7C, 
0x3FFF, 0xFF7C, 0x3FFF, 0xFF7C, 0x3FFF, 0xFEFC, 0x3FFF, 0xF7F8, 
0x3FFF, 0xDFF8, 0x3FFF, 0x7FF0, 0x3FFF, 0xFFF0, 0x3FFD, 0xFFE0, 
0x1FFD, 0xFFC0, 0x0FFF, 0xFF80, 0x07FF, 0xFF00, 0x03FF, 0xFE00, 
0x03FF, 0xFE00, 0x03FF, 0xFE00, 0x03FF, 0xFE00, 0x0000, 0x0000,

0x0000, 0x0000, 0x003F, 0xFC00, 0x00FF, 0xFF00, 0x01FF, 0xFF80, 
0x03FF, 0xFFC0, 0x03F0, 0x0FC0, 0x03E0, 0x07C0, 0x03E0, 0x07C0, 
0x01C0, 0x07C0, 0x0000, 0x0F80, 0x0000, 0x1F80, 0x0000, 0x3F00, 
0x0000, 0x7E00, 0x0000, 0xFC00, 0x0001, 0xF800, 0x0003, 0xF000, 
0x0007, 0xE000, 0x0007, 0xC000, 0x000F, 0x8000, 0x000F, 0x8000, 
0x000F, 0x8000, 0x000F, 0x8000, 0x000F, 0x8000, 0x0007, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000F, 0x8000, 
0x001F, 0xC000, 0x001F, 0xC000, 0x000F, 0x8000, 0x0000, 0x0000
};

static BITBLK alert_icn = {(short *)&al_image[0],4,32,0,0,1};

/*-----------------------------------------------------------------------*
 * Affichage d'une boite d'alerte                                        *
 *-----------------------------------------------------------------------*/
void Rsc_Alerte(int index)
{
	char **alert;
	rsrc_gaddr(R_FRSTR, index, &alert);	 /* Adresse ptr sur ptr sur chaine */
	form_alert(1, *alert);
}

char *Rsc_String(int index)
{
	char **free_string;
	rsrc_gaddr(R_FRSTR, index, &free_string);
	return *free_string;
}

/*-----------------------------------------------------------------------*
 * Gestion des boites d'alerte interne  WindGem                         *
 *-----------------------------------------------------------------------*/
int Wg_Alerte (int icone, BITBLK *user_icn, char *text, char *button, int def)
{
	register int i = 0, j = 0, numtxt = 0, numbt = 0, maxlen = 0, butlen = 0, buttot = 0, sep = 0, pos = 0, obj;
	char txt[6][61], bout[4][21];
	int wx, wy, ww, wh, Coef;
	BITBLK *icn;
	MFDB alt_fond;

	if (Sys->Yres < 399)
		Coef = 2;
	else
		Coef = 1;

	/* Mise en place du texte du message */
	txt[0][0] = '\0'; txt[1][0] = '\0'; txt[2][0] = '\0';
	txt[3][0] = '\0'; txt[4][0] = '\0'; txt[5][0] = '\0';

	bout[0][0] = '\0'; bout[1][0] = '\0';
	bout[2][0] = '\0'; bout[3][0] = '\0';

	/* Rcupration du texte du message */
	while (text[i] && numtxt <= 5)
	{
		while (j < (60 / Coef) && text[i] && text[i] != '|')
			txt[numtxt][j++] = text[i++];
		while (text[i] && text[i] != '|') i++;

		txt[numtxt++][j] = '\0';
		if (j > maxlen)
			maxlen = j;
		j = 0;
		if (text[i])
			i++;
	}

	/* Rcupration du texte des boutons */
	i = 0; j = 0;
	while (button[i] && numbt <= 3)
	{
		while (j < (20 / Coef) && button[i] && button[i] != '|')
			bout[numbt][j++] = button[i++];
		while (button[i] && button[i] != '|') i++;
		bout[numbt++][j] = '\0';
		if (butlen < j)
			butlen = j;
		buttot += j + (4 / Coef);
		j = 0;
		if (button[i])
			i++;
	}
	if (maxlen < buttot)
		maxlen = buttot;
		
	/* Modification de la taille de la boite d'alerte et de ses objets */

	/* Formulaire + trait de sparation du titre */
	PrivSys->AdrAlerte->ob_width = 64 + (maxlen * 8);
	PrivSys->AdrAlerte->ob_height = (160 / Coef) - ((6 - numtxt) * (16 / Coef));

	if (strlen(txt[0]) == 0)
		PrivSys->AdrAlerte[ALTTRAIT].ob_width = 0;
	else
		PrivSys->AdrAlerte[ALTTRAIT].ob_width = maxlen * 8;
	PrivSys->AdrAlerte[ALTTRAIT].ob_height = 1; /* NEW */

	/* Modifier taille des objets texte */
	PrivSys->AdrAlerte[ALTTXT1].ob_width = 8 * strlen (txt[0]);
	PrivSys->AdrAlerte[ALTTXT2].ob_width = 8 * strlen (txt[1]);
	PrivSys->AdrAlerte[ALTTXT3].ob_width = 8 * strlen (txt[2]);
	PrivSys->AdrAlerte[ALTTXT4].ob_width = 8 * strlen (txt[3]);
	PrivSys->AdrAlerte[ALTTXT5].ob_width = 8 * strlen (txt[4]);
	PrivSys->AdrAlerte[ALTTXT6].ob_width = 8 * strlen (txt[5]);

	/* Positionnement du texte du message */
	set_text (PrivSys->AdrAlerte, ALTTXT1, txt[0]);
	set_text (PrivSys->AdrAlerte, ALTTXT2, txt[1]);
	set_text (PrivSys->AdrAlerte, ALTTXT3, txt[2]);
	set_text (PrivSys->AdrAlerte, ALTTXT4, txt[3]);
	set_text (PrivSys->AdrAlerte, ALTTXT5, txt[4]);
	set_text (PrivSys->AdrAlerte, ALTTXT6, txt[5]);

	/* Modifier taille et position des objets bouton */
	PrivSys->AdrAlerte[ALTBUT1].ob_width = 8 * butlen;
	PrivSys->AdrAlerte[ALTBUT1].ob_y = (128 / Coef) - ((6 - numtxt) * (16 / Coef));
	PrivSys->AdrAlerte[ALTBUT2].ob_width = 8 * butlen;
	PrivSys->AdrAlerte[ALTBUT2].ob_y = (128 / Coef) - ((6 - numtxt) * (16 / Coef));
	PrivSys->AdrAlerte[ALTBUT3].ob_width = 8 * butlen;
	PrivSys->AdrAlerte[ALTBUT3].ob_y = (128 / Coef) - ((6 - numtxt) * (16 / Coef));
	PrivSys->AdrAlerte[ALTBUT4].ob_width = 8 * butlen;
	PrivSys->AdrAlerte[ALTBUT4].ob_y = (128 / Coef) - ((6 - numtxt) * (16 / Coef));

	sep = (maxlen * 8) / numbt;
	pos = (sep - 8 * butlen) / 2;
	PrivSys->AdrAlerte[ALTBUT1].ob_x = 56 + pos;
	pos += sep;
	PrivSys->AdrAlerte[ALTBUT2].ob_x = 56 + pos;
	pos += sep;
	PrivSys->AdrAlerte[ALTBUT3].ob_x = 56 + pos;
	pos += sep;
	PrivSys->AdrAlerte[ALTBUT4].ob_x = 56 + pos;

	/* Positionnement du texte des boutons */
	if (numbt > 0)
		PrivSys->AdrAlerte[ALTBUT1].ob_flags &= ~HIDETREE;
	else
		PrivSys->AdrAlerte[ALTBUT1].ob_flags |= HIDETREE;
	set_text (PrivSys->AdrAlerte, ALTBUT1, bout[0]);

	if (numbt > 1)
		PrivSys->AdrAlerte[ALTBUT2].ob_flags &= ~HIDETREE;
	else
		PrivSys->AdrAlerte[ALTBUT2].ob_flags |= HIDETREE;
	set_text (PrivSys->AdrAlerte, ALTBUT2, bout[1]);

	if (numbt > 2)
		PrivSys->AdrAlerte[ALTBUT3].ob_flags &= ~HIDETREE;
	else
		PrivSys->AdrAlerte[ALTBUT3].ob_flags |= HIDETREE;
	set_text (PrivSys->AdrAlerte, ALTBUT3, bout[2]);

	if (numbt > 3)
		PrivSys->AdrAlerte[ALTBUT4].ob_flags &= ~HIDETREE;
	else
		PrivSys->AdrAlerte[ALTBUT4].ob_flags |= HIDETREE;
	set_text (PrivSys->AdrAlerte, ALTBUT4, bout[3]);

	/* Mise en place du bouton Dfaut */
	for (i=0;i<4;i++)
	{
		if (def == i + 1)
			PrivSys->AdrAlerte[ALTBUT1 + i].ob_flags |= DEFAULT;
		else
			PrivSys->AdrAlerte[ALTBUT1 + i].ob_flags &= ~DEFAULT;
	}			

	/* Choix de l'icone */
	if (icone > 13)
		icone = 13;
	if (icone < -1)
		icone = 0;
	if (icone != ICN_USER)
	{
		icn = &alert_icn;
		icn->bi_pdata = (void *) &al_image[icone << 6];
	}
	else
		icn = user_icn;
	PrivSys->AdrAlerte[ALTIMAGE].ob_spec.bitblk = icn;

	/* Affichage et gestion de la boite d'alerte */
	form_center(PrivSys->AdrAlerte, &wx, &wy, &ww, &wh);
	/* ATENTION : get_bkgr agrandit la zone de sauvegarde d'o les valeurs
	pour max et min */
	get_bkgr (max(3,wx), max(3,wy), min(Sys->Xres - 5,ww), min(Sys->Yres - 5,wh), &alt_fond);
	objc_draw(PrivSys->AdrAlerte, ROOT, MAX_DEPTH, wx, wy, ww, wh);
	obj = form_do (PrivSys->AdrAlerte, 0);
	evnt_timer (100,0);
	objc_change(PrivSys->AdrAlerte, obj, 0, PrivSys->AdrAlerte->ob_x, PrivSys->AdrAlerte->ob_y, PrivSys->AdrAlerte->ob_width, PrivSys->AdrAlerte->ob_height, 0, FALSE);
	put_bkgr (max(3,wx), max(3,wy), min(Sys->Xres - 5,ww), min(Sys->Yres - 5,wh), &alt_fond);
		
	return (obj - ALTBUT1) + 1;
}

/*--------------------------- Fin du module -----------------------------*/