/*************************************************************************
 * WgEvent.C                                                             *
 *                                                                       *
 * Module de gestion des vnements.                                     *
 *                                                                       *
 * Cration : 9 avril 1997                                               *
 *************************************************************************/
#include "WinProto.h"
#include "user.h"

/*-=< Dfinition des variables prives de WindGem >=---------------------*/

/*-=< Dclaration des fonctions prives du module >=---------------------*/
static int getPopup (OBJECT *adr, int button, OBJECT *popup);
static void setPopup (OBJECT *adr, int button, int option, OBJECT *popup);
static int menuBox (Wind *wind, int ob);
static void popupNext (Wind *wind, int typObj, OBJECT *obj, Wg_Evnt *evnt);
static OBJECT *isPopup (Wind *wind, int typObj, int numObj);
static void adjustSize (Wind *wind, Wg_Evnt *evnt);

static int coefX (OBJECT *form, int objet);
static int coefY (OBJECT *form, int objet);

static void EventTimer (Wg_Evnt *evnt);
static void EventMessage (Wind *wind, Wg_Evnt *evnt);
static void EventKeyboard (Wg_Evnt *evnt);
static int  do_keybd(OBJECT *tree, Wg_Evnt *evnt);
static void EvntSpe (Wg_Evnt *evnt);
static void EventKeySpec (Wind *wind, Wg_Evnt *evnt);
static void EventButton (Wg_Evnt *evnt);
static void EventPopup (Wind *wind, int typObj, OBJECT *obj, Wg_Evnt *evnt);
static void EventMenu (Wind *wind, Wg_Evnt *evnt);
static void EventHelp (Wind *wind, int typObj, int numObj);

/*************************************************************************
 * Dfinition des fonctions du module.                                   *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *************************************************************************/
void SendMessage(int appId, int type, int res, int handle, int par4, int par5, int par6, int par7)
{
	int mes[8];

	mes[0] = type;
	mes[1] = appId;
	mes[2] = res;
	mes[3] = handle;
	mes[4] = par4;
	mes[5] = par5;
	mes[6] = par6;
	mes[7] = par7;

	appl_write (appId, 16, mes);  					 /* Envoi du message */
}

/*-----------------------------------------------------------------------*
 * Fonction centrale de gestion des vnements systme ou non...         *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
static int Help_count = 0;
int EventMulti (void)
{
	Wind *wind;
	Wg_Evnt Evnt;											 /* Structure vnement de WindGem   */

	while (TRUE)
	{	/* Surveillance des vnements Clavier, Clic, Message et Timer       */
		Evnt.evnt = evnt_multi ((MU_MESAG|MU_BUTTON|MU_KEYBD|MU_TIMER),
										 258, 3, 0,	/* au lieu de 2,1,1 pour gerer les deux boutons */
										 ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO,
										 Evnt.mes, 10, 0,
										 &(Evnt.mx), &(Evnt.my), &(Evnt.mk),
										 &(Evnt.kbd), &(Evnt.key), &(Evnt.clik));

		Evnt.objPop = BLANK;

		if (Evnt.evnt & MU_KEYBD)	/* Clavier */
		{
			EventKeyboard (&Evnt);
			Help_count = 0;
		}
		else if (Evnt.evnt & MU_BUTTON) /* Clic Souris */
		{
			EventButton (&Evnt);
			Help_count = 0;
		}
		else if (Evnt.evnt & MU_MESAG)	/* Message */
		{
			Help_count = 0;
			if (Evnt.mes[0] == MN_SELECTED && WndMenu != BLANK)
			{
				int opt = Evnt.mes[3];		/* Ncessaire */

				Evnt.evnt = EvntMenu;
				Evnt.wnd = WndMenu;
				Evnt.obj = Evnt.mes[4];
				if (LstWnd[WndMenu].Wg_OnMenu)
					(*LstWnd[WndMenu].Wg_OnMenu)(&Evnt);
				Wg_MenuTNormal (LstWnd[WndMenu].numWnd, opt, 1);
			}
			else
			{
				/* Recupre fentre qui a recu le message */
				wind = TopListe(Evnt.mes[3]);
				if (wind)
				{	/* On ne traite l'vnement que si :
						1 - ce n'est pas un vnement TOPPED,
						2 - OU si on est en fonctionnement MODAL ET que c'est la fentre modale
						3 - OU si on est en fonctionnement MODAL ET que ce n'est pas la fentre modale ET que l'vnement n'est pas TOPPED
						=> On empche toutes les fentres non modales de passer en premier plan.
					*/
					if (Evnt.mes[0] != WM_TOPPED || (Evnt.mes[0] == WM_TOPPED && ((PrivSys->lastMode == WndMODAL && wind->mode == WndMODAL) || PrivSys->lastMode == WndNORM)))
					{
						Evnt.wnd = wind->numWnd;
						EventMessage (wind, &Evnt);
					}
				}
			}
		}
		else if (Evnt.evnt == MU_TIMER)	/* Timer */
		{
			Help_count++;
			EventTimer (&Evnt);
		}

		return Evnt.evnt;
	}
}

/*-----------------------------------------------------------------------*
 * Gestion des vnements Timer...                                       *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
static int xmouse = BLANK, ymouse = BLANK, Count = 0;

static void EventTimer (Wg_Evnt *evnt)
{
	int mx, my, top, obj, dummy;
	register int i;
	Wind *wind;
	Wg_Timer *ptr_timer;

	/* Incrmentation du compteur d'occurrence de l'vnement MU_TIMER */
	Count++;

	/* Traitement de l'affichage des bulles d'aide */
	graf_mkstate (&mx, &my, &dummy, &dummy);
	if ((Help_count % 50 == 0) && xmouse == mx && ymouse == my)
	{
		wind_get (ZERO, WF_TOP, &top, &dummy, &dummy, &dummy);
		wind = TopListe(top);
		if (wind && (! wind->iconified))
		{
			/* Si on se situe sur un formulaire */
			if (wind->adr_wdialog)
			{
				obj = objc_find (wind->adr_wdialog, ROOT, MAX_DEPTH, mx, my);
				EventHelp (wind, ObjForm, obj);
			}
			/* Si on se situe sur une ToolBar */
			if (wind->adr_wtoolbar)
			{
				obj = objc_find (wind->adr_wtoolbar, ROOT, MAX_DEPTH, mx, my);
				EventHelp (wind, ObjTBar, obj);
			}
		}
	}
	else
	{
		xmouse = mx;
		ymouse = my;
	}

	/* Dispatcher l'vnement  toutes les fentres qui le grent */
	i = 0;
	while (LstWnd[i].numWnd != BLANK)
	{
		if (LstWnd[i].timer && LstWnd[i].Wg_OnTimer)
		{
			ptr_timer = LstWnd[i].timer;
			if (ptr_timer->state == TIMER_RUNNING && Count % ptr_timer->freq == 0)
			{
				evnt->evnt = EvntTimer;
				evnt->obj = ptr_timer->timer;
				evnt->wnd = LstWnd[i].numWnd;
				(*(LstWnd[i].Wg_OnTimer))(evnt);
			}
		}
		i++;
	}
}

/*************************************************************************
 * Gestion des vnements Message...                                     *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *************************************************************************/
static void EventMessage (Wind *wind, Wg_Evnt *evnt)
{
	GRECT r, rd, coord;
	int wx, wy, ww, wh, nb, y_base, xy[4], pxy[8];
	int EnvoiUser = TRUE, init_field = FALSE;
	register int i;
	char chaine[256];
	MFDB nul;
	int color[2];
	Wg_FormWnd *ptr_dial;

	evnt->evnt = EvntMessage;
	evnt->wnd = wind->numWnd;
	switch(evnt->mes[0])
	{
		case AP_TERM :
			AppExit();
			break;

		case AP_DRAGDROP :
			evnt->evnt = EvntDragDrop;
			break;
			
		case WM_REDRAW :
			rd.g_x = evnt->mes[4];
			rd.g_y = evnt->mes[5];
			rd.g_w = evnt->mes[6];
			rd.g_h = evnt->mes[7];
			Wg_GetWorkXYWH (wind->numWnd, &coord);

			v_hide_c (Sys->VdiHandle);	/* Virer la souris */
			wind_update(BEG_UPDATE);
			if (wind->iconified == TRUE)
			{
				DrawIcone (wind->handle, &rd);
				EnvoiUser = FALSE;
			}
			else
			{
				if (wind->adr_wmenu || wind->adr_wtoolbar || wind->adr_wdialog || wind->text || wind->image)
				{
					if (wind->adr_wdialog)
					{
						ptr_dial = wind->dialog;
						if (ptr_dial->edit_objc)
						{	/* si champ ditable et...*/
							wind_get(0, WF_TOP, &wx, &wy, &ww, &wh);
							if (wind->handle == wx)
							{ /*...si fenetre au 1 plan -> redessin total */
								wind_get(wind->handle, WF_WORKXYWH, &rd.g_x, &rd.g_y, &rd.g_w, &rd.g_h);
								init_field = EDEND;
							}
						}
					}
					if (wind->text)
  					nb = coord.g_h / Sys->Hchar;
  				if (wind->image)
  				{
						nul.fd_addr = 0;
						color[0] = BLACK;			/* Couleur des points */
						color[1] = WHITE;
					}

					wind_get(wind->handle, WF_FIRSTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
					while (r.g_w && r.g_h)
					{
						if (rc_intersect(&rd, &r))
						{
							if (wind->adr_wmenu)
								objc_draw (wind->adr_wmenu, BARMENU, MAX_DEPTH, r.g_x, r.g_y, r.g_w, r.g_h);
							if (wind->adr_wtoolbar)
								objc_draw (wind->adr_wtoolbar, ROOT, MAX_DEPTH, r.g_x, r.g_y, r.g_w, r.g_h);
							if (wind->adr_wdialog)
								objc_draw(wind->adr_wdialog, 0, 8, r.g_x, r.g_y, r.g_w, r.g_h);
							set_clip (1, &r); 	/* Clipping ON */
							if (wind->image)
							{
								pxy[0] = wind->slider->posW + (r.g_x - coord.g_x);	/* Gauche */
								pxy[1] = wind->slider->posH + (r.g_y - coord.g_y);	/* Haut */
								pxy[2] = pxy[0] + r.g_w - 1;					/* Droite */
								pxy[3] = pxy[1] + r.g_h - 1;					/* Bas */
								/* Zone destination dans la fentre  l'cran */
								pxy[4] = r.g_x;												/* Gauche */
								pxy[5] = r.g_y;												/* Haut */
								pxy[6] = pxy[4] + r.g_w - 1;					/* Droite */
								pxy[7] = pxy[5] + r.g_h - 1;					/* Bas */
	
								if (wind->image->fd_nplanes == 1) /* noir et blanc -> copie transparente */
									vrt_cpyfm (Sys->VdiHandle, MD_REPLACE, pxy, wind->image, &nul, color);
								else												/* couleur -> copie opaque */
									vro_cpyfm (Sys->VdiHandle, S_ONLY, pxy, wind->image, &nul);
							}
							if (wind->text)
							{
 						    /* Prparer effacement fentre */
	 					    xy[0] = coord.g_x;
		      	  	xy[1] = coord.g_y;
     						xy[2] = coord.g_x + coord.g_w - 1;
		        		xy[3] = coord.g_y + coord.g_h - 1;

		     				vsf_color(Sys->VdiHandle, WHITE);
								vr_recfl(Sys->VdiHandle, xy);
								if (wind->text)
								{
									y_base = coord.g_y + Sys->baseline;
									vswr_mode(Sys->VdiHandle, MD_TRANS);
									i = wind->slider->posH;
									while (i < min(nb + wind->slider->posH + 1, wind->slider->scaleH))
									{
										strcopy(chaine, wind->text[i], wind->slider->posW, strlen(wind->text[i]));
										v_gtext(Sys->VdiHandle, coord.g_x + 1, y_base, chaine);
										y_base += Sys->Hchar;
										i++;
									}
									vswr_mode(Sys->VdiHandle, MD_REPLACE);
								}
							}
							set_clip (0, &r); 	/* Clipping OFF */
    				}
						wind_get(wind->handle, WF_NEXTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
					}
					if (wind->adr_wdialog)
					{
						if (ptr_dial->edit_objc && init_field)
							objc_edit(wind->adr_wdialog, ptr_dial->edit_objc, 0, ptr_dial->edit_pos, init_field, &(ptr_dial->edit_pos));
					}
				}
				
				if (wind->type == WndUser)
				{	/* Renvoi de la zone relle utilisable */
					rc_intersect (&rd, &coord);
					evnt->mes[5] = coord.g_y;
					evnt->mes[7] = coord.g_h;
				}
			}
			wind_update(END_UPDATE);
			v_show_c (Sys->VdiHandle, 1); 			/* Rappeler la souris */
			break;

		case WM_TOPPED :
			wind_set(wind->handle, WF_TOP);
			break;

		case WM_CLOSED :
			WindClose(wind->numWnd);
			EnvoiUser = FALSE;
			break;

		case WM_FULLED :
			if (wind->full)
			{
				wind->full = FALSE;
				wind_get (wind->handle, WF_PREVXYWH, &wx, &wy, &ww, &wh); 	 /* Coord. prcd. */
				wind_set (wind->handle, WF_CURRXYWH, wx, wy, ww, wh); 		 /* Nouvelles coord. */
			}
			else
			{
				int h = Sys->Desk.g_h, w = Sys->Desk.g_w;
				wind->full = TRUE;
				if (wind->pos->maxH != -1)
					h = min(Sys->Desk.g_h, wind->pos->maxH);
				if (wind->pos->maxW != -1)
					w = min (Sys->Desk.g_w, wind->pos->maxW);
				wind_set (wind->handle, WF_CURRXYWH, Sys->Desk.g_x, Sys->Desk.g_y, w, h);
			}
			wind_get (wind->handle, WF_CURRXYWH, &(wind->pos->x), &(wind->pos->y), &(wind->pos->w), &(wind->pos->h));
			Wg_Sliders (wind);

			RecaleWind(wind);
			break;

		case WM_MOVED :
			wind_set(wind->handle, WF_CURRXYWH, evnt->mes[4], evnt->mes[5], evnt->mes[6], evnt->mes[7]);
			if (wind->iconified == FALSE)
			{
				wind->pos->x = evnt->mes[4];
				wind->pos->y = evnt->mes[5];
				wind->full = FALSE;
				RecaleWind(wind);
			}
			break;

		case WM_SIZED :
			adjustSize (wind, evnt);
			wind_set(wind->handle, WF_CURRXYWH, evnt->mes[4], evnt->mes[5], evnt->mes[6], evnt->mes[7]);
			/* Annuler le flag de pleine ouverture */
			wind->full = FALSE;
			Wg_Sliders (wind);

			/* Enregistrer les coordonnes */
			wind_get(wind->handle, WF_CURRXYWH, &(wind->pos->x), &(wind->pos->y), &(wind->pos->w), &(wind->pos->h));
			wind_get(wind->handle, WF_WORKXYWH, &wx, &wy, &ww, &wh);
			if (wind->adr_wtoolbar)
				wind->adr_wtoolbar->ob_width = ww + 1;
			SendMessage (Sys->AppId, WM_REDRAW, 0, wind->handle, wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h);
			break;

		case WM_ICONIFY :
			graf_shrinkbox(evnt->mes[4], evnt->mes[5], evnt->mes[6], evnt->mes[7], wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h);
			wind_set(wind->handle, WF_ICONIFY, evnt->mes[4], evnt->mes[5], evnt->mes[6], evnt->mes[7]);
			wind->iconified = TRUE;
			break;

		case WM_UNICONIFY :
			graf_growbox(wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h, evnt->mes[4], evnt->mes[5], evnt->mes[6], evnt->mes[7]);
			wind_set(wind->handle, WF_UNICONIFY, evnt->mes[4], evnt->mes[5], evnt->mes[6], evnt->mes[7]);
			wind->iconified = FALSE;
			break;

		case WM_ARROWED :
			Wg_Arrow (wind, evnt);
     	break;
    	
		case WM_HSLID :
			Wg_HSlider (wind, evnt);
			break;
			
		case WM_VSLID :
			Wg_VSlider (wind, evnt);
			break;
	}
	if (wind->Wg_OnMessage && EnvoiUser)
		(*wind->Wg_OnMessage)(evnt);
}

static void adjustSize (Wind *wind, Wg_Evnt *evnt)
{
	Wg_Coord *pos = wind->pos;
	
	if (pos->minW != BLANK && evnt->mes[6] < pos->minW)
		evnt->mes[6] = pos->minW;
	if (pos->maxW != BLANK && evnt->mes[6] > pos->maxW)
		evnt->mes[6] = pos->maxW;
	if (pos->minH != BLANK && evnt->mes[7] < pos->minH)
		evnt->mes[7] = pos->minH;
	if (pos->maxH != BLANK && evnt->mes[7] > pos->maxH)
		evnt->mes[7] = pos->maxH;
}

/*************************************************************************
 * Gestion des vnements clavier...                                     *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *************************************************************************/
static int new_obj, new_pos;

static void EventKeyboard (Wg_Evnt *evnt)
{
	register int i;
	char option[50];
	int top, dummy;
	Wind *wind;
	Wg_FormWnd *ptr_dial;
	OBJECT *obj;
	int dialog = TRUE;

	evnt->evnt = EvntKeyboard;
	wind_get (ZERO, WF_TOP, &top, &dummy, &dummy, &dummy);
	wind = TopListe(top);
	if (wind && wind->numWnd != WndMenu && (! wind->iconified))
	{
		evnt->wnd = wind->numWnd;
		/* On regarde s'il ne s'agit pas d'un vnement spcial */
		EvntSpe (evnt);
		if (! wind->adr_wdialog)
		{
			if (evnt->evnt != EvntKeyboard)
			{
				EventKeySpec (wind, evnt);
				return;
			}
			if (wind->Wg_OnKeyboard)
				(*wind->Wg_OnKeyboard)(evnt);
			return;
		}
		ptr_dial	= wind->dialog;
		obj 			= wind->adr_wdialog;
		evnt->obj	= ptr_dial->edit_objc;
		new_obj		= evnt->obj;
		new_pos		= ptr_dial->edit_pos;
	}
	else
	{
		OBJECT *obj_menu = LstWnd[WndMenu].adr_wmenu;
		unsigned char touc;
		char ctr = ZERO;
		
		/* Recupre l'tat des touches spciales */
		evnt->kbd = (int)Kbshift (BLANK);
		/* Annuler bit CapsLock */
		evnt->kbd &= ~0x10;
		/* Car. reprsentant la touche spciale */
		if ((evnt->kbd == K_RSHIFT) || (evnt->kbd == K_LSHIFT))
			ctr = 0x01;
		else if (evnt->kbd == K_CTRL)
			ctr = 0x05E;
		else if (evnt->kbd == K_ALT)
			ctr = 0x07;

		/* Recherche code Ascii */
		stdkey (&touc, evnt->key);

		i = ZERO;

		do	/* Pour chaque objet du menu */
		{	/* Si c'est une option */
			if (obj_menu[i].ob_type == G_STRING)
			{
				/* la lire et virer les espaces */
				strcpy (option, obj_menu[i].ob_spec.free_string);
				trim (option);
				/* Si option correspondant et valide, gnre un evnt MN_SELECTED */
				if ((*(option + strlen (option) - 1) == touc) && (*(option + strlen (option) - 2) == ctr))
					if (NOT (obj_menu[i].ob_state & DISABLED))
						SendMessage (Sys->AppId, MN_SELECTED, 0, m_title(obj_menu, i), i, ZERO, ZERO, ZERO);
			}
		} while (NOT (obj_menu[i++].ob_flags & LASTOB));
		return;
	}

	if (evnt->key == RETURN || evnt->key == ENTER)
	{	/* Si <Return> ou <Enter>, chercher bouton DEFAULT s'il y en a */
		i = ZERO;
		do
		{
			if (obj[i].ob_flags & DEFAULT)
			{
				form_button(obj, i, 1, &new_obj);
				evnt_timer(100,0);
				evnt->obj = i;
				evnt->evnt = EvntButton;
				if (wind->Wg_OnButton)
					(*wind->Wg_OnButton)(evnt);
				return;
			}
		} while (NOT (obj[i++].ob_flags & LASTOB));
	}

	/* Interprte et traite l'vnement clavier */
	dialog = do_keybd(obj, evnt);
	if (evnt->key)
	{
		objc_edit(obj, evnt->obj, evnt->key, ptr_dial->edit_pos, EDCHAR, &ptr_dial->edit_pos);
		new_obj = evnt->obj;
		new_pos = ptr_dial->edit_pos;
		if (wind->Wg_OnObject)
		{
			evnt->evnt = EvntObjChanged;
			(*wind->Wg_OnObject)(evnt);
		}
	}

	/* Repositionner le curseur */
	if (dialog > 0)
	{
		if (new_obj > 0 && new_obj != evnt->obj || new_pos != ptr_dial->edit_pos)
		{
			objc_edit(obj, evnt->obj, 0, ptr_dial->edit_pos, EDEND, &ptr_dial->edit_pos);
			ptr_dial->edit_pos = new_pos;
			objc_edit(obj, new_obj, 0, ptr_dial->edit_pos, EDEND, &ptr_dial->edit_pos);
		}

		/* On sauve les paramtres dans l'objet Wg_FormWnd */
		ptr_dial->edit_objc = new_obj;
	}
	else if (dialog == -1)
	{	/* Traiter l'eventuel raccourcis clavier */
		evnt->evnt = EvntButton;	/* N objet dj mis  jour */
		(*wind->Wg_OnButton)(evnt);
		return;
	}
}

static int do_keybd(OBJECT *tree, Wg_Evnt *evnt)
{
	register int index, pos;
	register char *ed_text;
	register OBJECT *ptr_objc;
	int len, dialog, key_short;
	unsigned char dum;

	dialog = form_keybd(tree, evnt->obj, evnt->obj, evnt->key, &new_obj, &(evnt->key));
	if (dialog)
	{
		if (evnt->key == 0)
		{
			if (new_obj != 0)
			{
				ptr_objc = &tree[new_obj];
				new_pos = (int) strlen((ptr_objc->ob_spec.tedinfo)->te_ptext);
			}
			else
				new_pos = 0;
		}
		else
		{
			if (evnt->obj)
			{
				pos = new_pos;

				ptr_objc = &tree[evnt->obj];
				ed_text = (ptr_objc->ob_spec.tedinfo)->te_ptext;
				len = (int) strlen(ed_text);
				switch (evnt->key)
				{
					case 0x7300 :		/* Control <- : Curseur en debut de Champ */
						pos = 0;
						evnt->key = 0;
						break;
					case 0x7400 :		/* Control -> : Curseur en fin de Champ */
						pos = len;
						evnt->key = 0;
						break;
					case 0x4b34 :		/* SHIFT <- : Saute un mot	*/
						while (pos)
						{
							pos--;
							if (ed_text[pos] == ' ')
								break;
						}
						evnt->key = 0;
						break;
					case 0x4d36 :		/* SHIFT -> : Saute un mot	*/
						while (pos < len)
						{
							pos++;
							if (ed_text[pos] == ' ')
								break;
						}
						if (pos < len)
							pos++;
						evnt->key = 0;
						break;
				}
				new_pos = pos;
			}
			if (evnt->key != 0 && evnt->kbd == K_ALT)
			{	/* Raccourcis claviers	*/
				key_short = stdkey(&dum, evnt->key);
				index = 1;
				do
				{
					ptr_objc = &tree[index]; /* pointe sur l'objet a traiter */
					ed_text = 0;
					if (((ptr_objc->ob_state&DISABLED)==0) && ((ptr_objc->ob_type & 0x200) != 0))
					{ /* si l'objet n'est pas desactive	*/
						switch (ptr_objc->ob_type & 0xff)
						{
							case G_BUTTON :
								ed_text = ptr_objc->ob_spec.free_string;
								break;
							case G_USERDEF :
								ed_text = (char *)((ptr_objc->ob_spec.userblk)->ub_parm);
								break;
						}
						if (ed_text && (ed_text = strchr(ed_text, '[')) != 0)
						{
							if (key_short == toupper(ed_text[1]))
							{ /* Simuler un clic sur l'objet et retour : */
								evnt->key = 0;
								evnt->obj = index;
								form_button(tree, index, 1, &new_obj);
								evnt_timer(100,0);
								return -1;
							}
						}
					}
					index ++; /* Prepare l'objet suivant ... */
				/* ... sauf si l'objet actuel est le dernier : */
				} while((ptr_objc->ob_flags & LASTOB) == 0);
			}
		}
	}
	return dialog;
}

static void EvntSpe (Wg_Evnt *evnt)
{
	/* On definit s'il s'agit ou non d'un vnement special */
  if (evnt->key == HELP)
		evnt->evnt = EvntKeyHELP;
	else if (evnt->key == UNDO)
		evnt->evnt = EvntKeyUNDO;
	else if (evnt->key == ESC)
		evnt->evnt = EvntKeyESC;
	else if (evnt->key == HOME)
		evnt->evnt = EvntKeyHOME;
	else if (evnt->key == SHFT_HOME)
		evnt->evnt = EvntKeySHHOME;
	else if (evnt->key == CUR_UP)
		evnt->evnt = EvntKeyARUP;
	else if (evnt->key == CUR_DOWN)
		evnt->evnt = EvntKeyARDN;
	else if (evnt->key == CUR_LEFT)
		evnt->evnt = EvntKeyARLF;
	else if (evnt->key == CUR_RIGHT)
		evnt->evnt = EvntKeyARRT;
	else if (evnt->key == SHFT_CU)
		evnt->evnt = EvntKeySHARUP;
	else if (evnt->key == SHFT_CD)
		evnt->evnt = EvntKeySHARDN;
	else if (evnt->key == SHFT_CL)
		evnt->evnt = EvntKeySHARLF;
	else if (evnt->key == SHFT_CR)
		evnt->evnt = EvntKeySHARRT;
}

/*************************************************************************
 * Gestion des vnements Touches spciales.                             *
 *                                                                       *
 * Validation : . ... ....                                               *
 *************************************************************************/
static void EventKeySpec (Wind *wind, Wg_Evnt *evnt)
{
	int xw, yw, ww, hw;
	GRECT coord;
	Bool draw = FALSE;

	Wg_GetWorkXYWH (wind->numWnd, &coord);
	xw = coord.g_x;
	yw = coord.g_y;
	ww = coord.g_w;
	hw = coord.g_h;	

	if (wind->type == WndForm || wind->type == WndUser)
	{
		if (wind->Wg_OnKeySpec)
			(*wind->Wg_OnKeySpec)(evnt);
	}
	else
	{
		switch (evnt->evnt)
		{
			case EvntKeyHELP :	/* Help */
				if (wind->type == WndText)
					form_alert(1,"[1][(shft)/ : (pg)-lig haut/bas|(shft)/ : (pg)-lig droite/gauche|(shft) Home : (fin)-dbut texte|Esc : fermeture][Ok]");
				else
					form_alert(1,"[1][(shft)/ : (pg)-lig haut/bas|(shft)/ : (pg)-lig droite/gauche|(shft) Home : (fin)-dbut image|Esc : fermeture][Ok]");
				break;
			
			case EvntKeyESC :		/* Escape */
				SendMessage (Sys->AppId, WM_CLOSED, 0, wind->handle, ZERO, ZERO, ZERO, ZERO);
				break;

			case EvntKeyARLF :	/* gauche */
				evnt->mes[4] = WA_LFLINE;
				Wg_Arrow(wind, evnt);
				break;

			case EvntKeyARRT :	/* droite */
				evnt->mes[4] = WA_RTLINE;
				Wg_Arrow(wind, evnt);
				break;

			case EvntKeyARUP :	/* Haute  */
				evnt->mes[4] = WA_UPLINE;
				Wg_Arrow(wind, evnt);
				break;

			case EvntKeyARDN :	/* Basse  */
				evnt->mes[4] = WA_DNLINE;
				Wg_Arrow(wind, evnt);
				break;

			case EvntKeySHARLF :	/*  gauche */
				evnt->mes[4] = WA_LFPAGE;
				Wg_Arrow(wind, evnt);
				break;

			case EvntKeySHARRT :	/*  droite */
				evnt->mes[4] = WA_RTPAGE;
				Wg_Arrow(wind, evnt);
				break;

			case EvntKeySHARUP :	/*  Haute  */
				evnt->mes[4] = WA_UPPAGE;
				Wg_Arrow(wind, evnt);
				break;

			case EvntKeySHARDN :	/*  Basse  */
				evnt->mes[4] = WA_DNPAGE;
				Wg_Arrow(wind, evnt);
				break;

			case EvntKeyHOME :	/* HOME */
				if (wind->slider && wind->slider->posH > 0)
				{
					wind->slider->posH = 0;
					SendMessage (Sys->AppId, WM_REDRAW, 0, wind->handle, coord.g_x, coord.g_y, coord.g_w, coord.g_h);
					Wg_Sliders (wind); 				/* Actualiser les sliders */
				}
				break;
			
			case EvntKeySHHOME :	/*  HOME */
				if (wind->slider)
				{
					if (wind->text && wind->slider->posH < wind->slider->scaleH - (hw / Sys->Hchar))
					{
						wind->slider->posH = wind->slider->scaleH - (hw / Sys->Hchar);
						draw = TRUE;
					}
					else if (wind->slider->posH < wind->slider->scaleH - hw)
					{
						wind->slider->posH = wind->slider->scaleH - hw;
						draw = TRUE;
					}
				}
				if (draw)
				{
					SendMessage (Sys->AppId, WM_REDRAW, 0, wind->handle, coord.g_x, coord.g_y, coord.g_w, coord.g_h);
					Wg_Sliders (wind); 				/* Actualiser les sliders */
				}
				break;
		}
	}
}

/*************************************************************************
 * Gestion des vnements Clic souris...                                 *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *************************************************************************/
static void EventButton (Wg_Evnt *evnt)
{
	register int i, j;
	int top, wtop, dummy, type, obflags, obstate;
	Wind *wind;
	OBJECT *obj = (OBJECT *)NULL;
	Wg_FormWnd *ptr_dial = (Wg_FormWnd *)NULL;

	/* wind_find ... */
	wtop = wind_find (evnt->mx, evnt->my);
	wind_get (ZERO, WF_TOP, &top, &dummy, &dummy, &dummy);
	wind = TopListe(top);
	if (wind && (! wind->iconified))
	{
		evnt->evnt = EvntButton;
		evnt->wnd = wind->numWnd;
		/* Bouton droit == popup menu */
		if (evnt->mk == 2)
		{
			evnt->evnt = EvntPopup;
			if (wtop == top && wind->adr_wpopup)	/* Clic sur fentre 1 plan */
				EventPopup (wind, BLANK, wind->adr_wpopup, evnt);
			else if (wtop != top && WndMenu != BLANK && LstWnd[WndMenu].adr_wpopup)
				EventPopup (&LstWnd[WndMenu], BLANK, LstWnd[WndMenu].adr_wpopup, evnt);
			else if (wtop == top && wind->Wg_OnButton)
				(*wind->Wg_OnButton)(evnt);
			return;
		}
		else /* Traitement du bouton Gauche */
		{
			if (wind->numWnd != WndMenu && wind->adr_wmenu)
			{	/* A-t'on cliqu sur le menu */
				evnt->obj = objc_find (wind->adr_wmenu, BARTITLE, MAX_DEPTH, evnt->mx, evnt->my);
				/* Si clic sur un titre */
				if (evnt->obj > 0 && wind->adr_wmenu[evnt->obj].ob_type == G_TITLE)
				{
					EventMenu (wind, evnt);
					return;
				}
			}
			if (wind->adr_wtoolbar)
			{	/* a-t'on cliqu sur la ToolBar */
				evnt->obj = objc_find (wind->adr_wtoolbar, ROOT, MAX_DEPTH, evnt->mx, evnt->my);
				if (evnt->obj > 0)
				{
					obj = wind->adr_wtoolbar;
					type = ObjTBar;
					evnt->evnt = EvntToolbar;
				}
			}

			/* Si objet formulaire -> pointe sur l'OBJECT associ */
			if (! obj && wind->type == WndForm && wind->dialog)
			{
				obj = wind->adr_wdialog;
				type = ObjForm;
				ptr_dial = wind->dialog;
			}

			if (! obj)
			{
				if (wind->Wg_OnButton)
					(*wind->Wg_OnButton)(evnt);
			}
			else
			{	/* Traitement de l'vnement bouton sur un formulaire */
				evnt->obj = objc_find (obj, ROOT, MAX_DEPTH, evnt->mx, evnt->my);
				if (evnt->obj)
				{
					obflags = obj[evnt->obj].ob_flags;
					obstate = obj[evnt->obj].ob_state;

					/* Si objet non dsactiv */
					if (NOT (obstate & DISABLED))
					{
						OBJECT *popup;

						if (obflags & EDITABLE)
						{	/* Dsactiver curseur */
							objc_edit (obj, ptr_dial->edit_objc, 0, ptr_dial->edit_pos, EDEND, &(ptr_dial->edit_pos));
							/* Ractiver curseur */
							objc_edit (obj, evnt->obj, 0, ptr_dial->edit_pos, EDINIT, &(ptr_dial->edit_pos));
							ptr_dial->edit_objc	= evnt->obj;
						}

						if (popup = isPopup(wind, type, evnt->obj))
						{
							int Coef;
							if (Sys->Yres < 399)
								Coef = 2;
							else
								Coef = 1;
							Wg_ObjSelect (evnt->wnd, type, evnt->obj, TRUE);
							if (evnt->mx < obj[evnt->obj].ob_x + obj[ROOT].ob_x + obj[evnt->obj].ob_width - (16 / Coef))
								EventPopup (wind, type, popup, evnt);
							else
								popupNext (wind, type, popup, evnt);
						}
						else if (obflags & SELECTABLE)
						{
							if (! (obflags & RBUTTON))
							{	/* Si slectable simple, inverser l'etat de l'objet */
								obj[evnt->obj].ob_state ^= SELECTED;
								objc_draw (obj, evnt->obj, MAX_DEPTH,
										obj->ob_x, obj->ob_y, obj->ob_width, obj->ob_height);

								if (obflags & TOUCHEXIT)
								{
									/* Attendre relachement du bouton souris */
									while (evnt->mk)
										graf_mkstate (&dummy, &dummy, &(evnt->mk), &dummy);
								}
								else
									evnt_timer(100,0);
							}
							else if ((obflags & RBUTTON) && (! (obstate & SELECTED)))
							{	/* Si radio-bouton */
								j = evnt->obj;
								obj[evnt->obj].ob_state |= SELECTED;
      	
								objc_draw (obj, evnt->obj, MAX_DEPTH,
											obj->ob_x, obj->ob_y, obj->ob_width, obj->ob_height);
            	
								/* Chercher le pre */
								i = parent (obj, j);
								/* Aller du 1 enfant jusqu'au dernier */
								j = obj[i].ob_head;
								i = obj[i].ob_tail;
								do
								{
									if ((obj[j].ob_flags & RBUTTON) && (j != evnt->obj) && (obj[j].ob_state & SELECTED))
									{	/* Les mettre en normal si RBUTTON sauf l'objet cliqu */
										obj[j].ob_state &= ~SELECTED;

										objc_draw (obj, j, MAX_DEPTH,
													obj->ob_x, obj->ob_y, obj->ob_width, obj->ob_height);
									}
									j = obj[j].ob_next;
								} while ((j <= i) && (j > obj[i].ob_next));
							}
            }
						/* Appel  la fonction de gestion de la boite de dialogue */
						if (obflags & TOUCHEXIT || obflags & EXIT)
						{
							if (type == ObjForm && wind->Wg_OnButton)
								(*wind->Wg_OnButton)(evnt);
							else if (wind->Wg_OnToolbar)
								(*wind->Wg_OnToolbar)(evnt);
						}
					}
				}
			}
		}
	}
}

/*************************************************************************
 * Gestion du menu en fentre...                                         *
 *************************************************************************/
static int getPopup (OBJECT *adr, int button, OBJECT *popup)
/*-----------------------------------------------------------------------*
 * Chercher correspondance entre texte d'un bouton et formulaire pop-up  *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	register int i = 1;
	char bouton[MAX_LEN], option[MAX_LEN];

	/* Si pas pop-up, retrouner 0 */
	if (! ((adr[button].ob_type >> 8) & POPUP_B))
		return 0;

	/* Lire le texte du bouton */
	strcpy (bouton, get_text (adr, button));
	/* Virer les espaces au dbut et  la fin */
	trim (bouton);
	do	/* Dbut de boucle : pour chaque objet du formulaire pop-up */
	{
		/* Si c'est un  SELECTABLE */
		if (popup[i].ob_flags & SELECTABLE)
		{
			/* Lire le texte de l'option */
			strcpy (option, get_text (popup, i));
			/* Virer les espaces au dbut et  la fin */
			trim (option);
			/* Si correspondance, retourner le numro de l'option */
			if (strcmp (bouton, option) == 0)
				return i;
		}
	/* Jusqu'au dernier objet */
	} while (! (popup[i++].ob_flags & LASTOB));
	return 0;
}

static void setPopup (OBJECT *adr, int button, int option, OBJECT *popup)
/*-----------------------------------------------------------------------*
 * Faire correspondre le texte d'un bouton pop-up avec celui d'une option*
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	char texte[MAX_LEN];

	/* Si pas pop-up, on arrte tout traitement */
	if (! ((adr[button].ob_type >> 8) & POPUP_B))
		return;

	/* Si c'est bien un objet Popup */
	if ((adr[button].ob_type >> 8) & POPUP_B)
	{
		/* Lire le texte de l'option */
		strcpy (texte, get_text(popup, option));
		/* Virer les blancs */
		trim (texte);
		/* Copier le texte dans le bouton */
		set_text (adr, button, texte);
	}
}

static void EventPopup (Wind *wind, int typObj, OBJECT *obj, Wg_Evnt *evnt)
/*-----------------------------------------------------------------------*
 * Gestion d'un formulaire pop-up                                        *
 *                                                                       *
 * Si typObj = BLANK, obj est le popup appel par clic droit de la souris*
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	OBJECT *adr;
	int x, y, w, h, dummy, old_ob = -1, ob = 0, b[8], xm, ym, km, evt, sortie = FALSE, etat, old = 0;
	MFDB image;

	if (typObj != BLANK)
	{
		if (typObj == ObjForm)
			adr = wind->adr_wdialog;
		else
			adr = wind->adr_wtoolbar;
		
		/* Position bouton cliqu */
		objc_offset (adr, evnt->obj, &x, &y);
		/* Se placer juste dessous par dfaut */
		y += (adr[evnt->obj].ob_height);
	}
	else
	{
		x = evnt->mx;
		y = evnt->my;
	}

	/* Positionnement du formulaire popup */
	obj->ob_x = x;
	obj->ob_y = y;
	/* Rcuprer ses dimensions */
	w = obj->ob_width + 1;
	h = obj->ob_height + 1;

	/* Si texte du bouton correspond  une option du popup */
	if (typObj != BLANK)
		old = getPopup (adr, evnt->obj, obj);
	else
		old = 0;
	
	if (old)
	{	/* Faire concider les positions de l'option et du bouton */
		x = obj->ob_x = x - obj[old].ob_x;
		y = obj->ob_y = y - obj[old].ob_y - adr[evnt->obj].ob_height;
/*		obj[old].ob_state |= CHECKED;	 On "Checke" l'option */
	}

	/* Si dbordement du bureau, recaler le popup avec une marge de 5 pixels */
	if (x + w > Sys->Desk.g_x + Sys->Desk.g_w - 5)
		x = obj->ob_x = Sys->Desk.g_w + Sys->Desk.g_x - w - 5;
	if (x < Sys->Desk.g_x + 5)
		x = obj->ob_x = Sys->Desk.g_x + 5;
	if (y + h > Sys->Desk.g_y + Sys->Desk.g_h - 5)
		y = obj->ob_y = Sys->Desk.g_h + Sys->Desk.g_y - h - 5;
	if (y < Sys->Desk.g_y + 5)
		y = obj->ob_y = Sys->Desk.g_y + 5;

	/* Copier l'image de fond + dessiner le pop-up */
	get_bkgr (x, y, w, h, &image);
	objc_draw (obj, ROOT, MAX_DEPTH, x - 3, y - 3, w + 6, h + 6);

	/* Bloquer menu et vnements MU_MESSAG */
	wind_update(BEG_MCTRL);

	do	/* BOUCLE PRINCIPALE DE GESTION DU POP-UP */
	{
		/* Seuls les clic et le timer nous intressent */
		evt = evnt_multi (MU_BUTTON | MU_TIMER,
								 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
								 b, 10, 0, &xm, &ym, &km, &dummy, &dummy, &dummy);
		/* Si clic souris */
		if (evt & MU_BUTTON)
		{
			/* On attend que le bouton de la souris soit relach */
			while (km)
				graf_mkstate (&dummy, &dummy, &km, &dummy);
			/* On peut sortir, puisqu'on a cliqu */
			sortie = TRUE;
		}
		/* Si vnement Timer */
		else if (evt == MU_TIMER)
		{
			/* Demander coordonnes de la souris */
			graf_mkstate (&xm, &ym, &dummy, &dummy);

			/* Demander l'option de pop-up  cette position */
			ob = objc_find (obj, ROOT, MAX_DEPTH, xm, ym);

			if (old_ob != ob && (obj[ob].ob_flags & SELECTABLE))
			{	/* Si option diffrente de la prcdente */
				if ((old_ob != -1) && (! (obj[old_ob].ob_state & DISABLED)))
				{	/* On dslectionne l'ancienne */
					etat = obj[old_ob].ob_state & ~SELECTED;
					objc_change (obj, old_ob, 0, x, y, w, h, etat, TRUE);
				}
				if ((ob > ROOT) && (! (obj[ob].ob_state & DISABLED)) && (obj[ob].ob_flags & SELECTABLE))
				{	/* Si nouvelle option existe (non hors pop-up) et si valide */
					/* On la slectionne */
					etat = obj[ob].ob_state | SELECTED;
					objc_change (obj, ob, 0, x, y, w, h, etat, TRUE);
				}
				/* L'option courante devient l'ancienne option */
				old_ob = ob;
			}
		}
		/* Boucle tant qu'on n'a pas cliqu */
	} while (sortie == FALSE);

	/* Dbloquer menu et vnements MU_MESSAG */
	wind_update(END_MCTRL);

	/* Restaurer le fond de l'cran */
	put_bkgr (x, y, w, h, &image);
	/* D-checker l'option de dpart */
/*	obj[old].ob_state &= ~CHECKED;*/

	if ((ob > 0) && (! (obj[ob].ob_state & DISABLED)) && (obj[ob].ob_flags & SELECTABLE))
	{	/* Si option existe et si elle est valide, la dslectionner */
		etat = obj[ob].ob_state &= ~SELECTED;
		objc_change (obj, ob, 0, x, y, w, h, etat, FALSE);

		/* Copier texte dans le bouton, si travail avec un formulaire */
		if (typObj != BLANK)
		{	/* Rcuprer le numro de l'item slectionn */
			evnt->objPop = ob;
			setPopup (adr, evnt->obj, ob, obj);
		}
		else if (wind->Wg_OnPopup)
		{
			evnt->obj = ob;
			(*wind->Wg_OnPopup)(evnt);
		}
	}

	/* Si travail avec un formulaire, dselection et redessin du bouton */
	if (typObj != BLANK)
		Wg_ObjSelect (evnt->wnd, typObj, evnt->obj, FALSE);
}

static OBJECT *isPopup (Wind *wind, int typObj, int numObj)
/*-----------------------------------------------------------------------*
 * Rcupre l'OBJECT servant de popup  l'objet numObj de type typObj    *
 * d'une fentre...                                                      *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	Wg_Popup *popup;
	OBJECT *ret = (OBJECT *)NULL;

	popup = wind->popup;
	while (popup && (popup->typObj != typObj || popup->numObj != numObj))
		popup = popup->next;

	if (popup)
		ret = popup->obj;

	return ret;
}

static void popupNext (Wind *wind, int typObj, OBJECT *obj, Wg_Evnt *evnt)
/*-----------------------------------------------------------------------*
 * Chercher la valeur suivante dans un popup menu.                       *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	register int i = 1;
	int bon_obj, old_obj;
	OBJECT *adr;

	if (typObj == ObjForm)
		adr = wind->adr_wdialog;
	else
		adr = wind->adr_wtoolbar;

	/* Chercher correspondance */
	old_obj = getPopup (adr, evnt->obj, obj);
	if (old_obj > 0)
	{
		if (obj[old_obj].ob_flags & LASTOB)
			i = 1;
		else
			i = old_obj + 1;

		/* On cherche l'objet slectionnable suivant */
		do
		{
			if ((obj[i].ob_flags & SELECTABLE) && ! (obj[i].ob_state & DISABLED))
				break;
			i++;
		}	while (! (obj[i].ob_flags & LASTOB));

		if ((obj[i].ob_flags & SELECTABLE) && ! (obj[i].ob_state & DISABLED))
			bon_obj = i;
		else
			bon_obj = old_obj;
	}
	else /* si rien de dj slectionn */
	{
		i = 1;

		/* On recherche depuis le dbut */
		do
		{
			if ((obj[i].ob_flags & SELECTABLE) && ! (obj[i].ob_state & DISABLED))
				break;
			i++;
		}	while (! (obj[i].ob_flags & LASTOB));

		if ((obj[i].ob_flags & SELECTABLE) && ! (obj[i].ob_state & DISABLED))
			bon_obj = i;
		else
			bon_obj = -1;
	}
	if (bon_obj != -1)	/* Affiche l'option */
		setPopup (adr, evnt->obj, bon_obj, obj);
	evnt->objPop = bon_obj;
	evnt_timer (100,0);
	Wg_ObjSelect (evnt->wnd, typObj, evnt->obj, FALSE);
}

/*************************************************************************
 * Gestion du menu en fentre...                                         *
 *************************************************************************/
static int menuBox (Wind *wind, int ob)
/*-----------------------------------------------------------------------*
 * Bote correspondant  un titre.                                       *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	register int b, i;

	/* Fond des botes */
	b= (wind->adr_wmenu)->ob_tail;
	/* 1 bote */
	b= (wind->adr_wmenu)[b].ob_head;

	for (i = 3 ; i < ob ; i++)
		b = (wind->adr_wmenu)[b].ob_next;	/* Bote suivante */

  return b;
}

static void EventMenu (Wind *wind, Wg_Evnt *evnt)
/*-----------------------------------------------------------------------*
 * Gestion du menu en fentre.                                           *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	int xw, yw, ww, hw, etat;
	int x, y, w, h, dummy, bmenu, mx, my, mk;
	int obj, old_obj = -1, tit, mess[8], sortie = 0, ev;
	MFDB img;

	/* Bloquer menu principal + rcuprer dimensions zone de travail */
	wind_update (BEG_MCTRL);
	wind_get (wind->handle, WF_WORKXYWH, &xw, &yw, &ww, &hw);

	while (evnt->mk) /* Attente relacher bouton souris */
		graf_mkstate (&dummy, &dummy, &evnt->mk, &dummy);

	/* Slectionner titre */
	Wg_MenuTNormal (wind->numWnd, evnt->obj, FALSE);

	/* Chercher bote de menu correspondante */
	bmenu = menuBox (wind, evnt->obj);

	/* Largeur et hauteur de la bote */
	w = (wind->adr_wmenu)[bmenu].ob_width;
	h = (wind->adr_wmenu)[bmenu].ob_height;

	/* Replacer la bote sous le titre */
	(wind->adr_wmenu)[bmenu].ob_x = (wind->adr_wmenu)[evnt->obj].ob_x + 16;
	(wind->adr_wmenu)[bmenu].ob_y = 0;
	objc_offset (wind->adr_wmenu, bmenu, &x, &y);

	/* Corriger la position si on sort du bureau */
	if (x + w > Sys->Desk.g_x + Sys->Desk.g_w - 5)
	{
		(wind->adr_wmenu)[bmenu].ob_x -= ((x + w) - (Sys->Desk.g_x + Sys->Desk.g_w) + 5);
		objc_offset (wind->adr_wmenu, bmenu, &x, &y);
	}
	if (y + h > Sys->Desk.g_y + Sys->Desk.g_h - 5)
	{
		(wind->adr_wmenu)[bmenu].ob_y -= ((y + h) - (Sys->Desk.g_y + Sys->Desk.g_h) + 5);
		objc_offset (wind->adr_wmenu, bmenu, &x, &y);
	}

	/* Copier l'image du fond + dessin du sous-menu */
	get_bkgr (x, y, w, h, &img);
	objc_draw (wind->adr_wmenu, bmenu, MAX_DEPTH, x - 3, y - 3, w + 6, h + 6);
	tit = evnt->obj;

	do  /* BOUCLE D'ATTENTE */
	{
		ev = evnt_multi (MU_BUTTON | MU_TIMER,
							  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							  mess, 10, 0, &mx, &my, &mk, &dummy, &dummy, &dummy);

		/* Clic souris */
		if (ev & MU_BUTTON)
		{
			/* Virer le menu droul */
			put_bkgr (x, y, w, h, &img);

			/* Attend que le bouton de la souris soit relach */
			while (mk)
				graf_mkstate (&dummy, &dummy, &mk, &dummy);

			/* On peut sortir */
			sortie = 1;
		}
		/* Evnement TIMER */
		else if (ev == MU_TIMER)
		{
			/* Position actuelle de la souris */
			graf_mkstate (&mx, &my, &dummy, &dummy);

			/* Chercher objet point dans le menu */
			obj = objc_find (wind->adr_wmenu, bmenu, MAX_DEPTH, mx, my);
			if (obj == -1)	/* S'il n'y en a pas */
			{	/* Chercher titre point dans la barre */
				obj = objc_find (wind->adr_wmenu, BARTITLE, MAX_DEPTH, mx, my);
			}

			/* Si on est sur un titre et dans la fentre */
			if (((wind->adr_wmenu)[obj].ob_type == G_TITLE) && (mx < (xw + ww)))
			{
				if (old_obj != -1) /* Si on tait avant sur une option, la dselectionner */
				{
					etat = (wind->adr_wmenu)[old_obj].ob_state & ~SELECTED;
					objc_change (wind->adr_wmenu, old_obj, 0, x, y, w, h, etat, 1);
				}
				/* Si on a chang de titre */
				if (obj != tit)
				{
					/* Effacer l'ancien menu */
					put_bkgr (x, y, w, h, &img);
					/* Dslectionner l'ancien */
					Wg_MenuTNormal (wind->numWnd, tit, TRUE);
					/* Enregistrer nouveau titre courant, le slectionner */
					tit = obj;
					Wg_MenuTNormal (wind->numWnd, tit, FALSE);
					/* Sous-menu correspondant */
					bmenu = menuBox (wind, tit);
					/* Dimension du menu */
					w = (wind->adr_wmenu)[bmenu].ob_width;
					h = (wind->adr_wmenu)[bmenu].ob_height;
					/* Le positionner sous son titre */
					(wind->adr_wmenu)[bmenu].ob_x = (wind->adr_wmenu)[tit].ob_x + 16;
					(wind->adr_wmenu)[bmenu].ob_y = 0;

					objc_offset (wind->adr_wmenu, bmenu, &x, &y);
					/* Correction s'il sort du bureau */
					if (x + w > Sys->Desk.g_x + Sys->Desk.g_w - 5)
					{
						(wind->adr_wmenu)[bmenu].ob_x -= ((x + w) - (Sys->Desk.g_x + Sys->Desk.g_w) + 5);
						objc_offset (wind->adr_wmenu, bmenu, &x, &y);
					}
					if (y + h > Sys->Desk.g_y + Sys->Desk.g_h - 5)
					{
						(wind->adr_wmenu)[bmenu].ob_y -= ((y + h) - (Sys->Desk.g_y + Sys->Desk.g_h) + 5);
						objc_offset (wind->adr_wmenu, bmenu, &x, &y);
					}
					/* Recopier le fond de l'cran + dessin du menu */
					get_bkgr (x, y, w, h, &img);
					objc_draw (wind->adr_wmenu, bmenu, MAX_DEPTH, x - 3, y - 3, w + 6, h + 6);
				}
				/* Annuler objet courant */
				old_obj = -1;
			}
			/* Si on est sur une option */
			else if ((wind->adr_wmenu)[obj].ob_type == G_STRING)
			{
				/* Si objet diffrent de l'ancien */
				if (old_obj != obj)
				{
					if ((old_obj != -1) && (! ((wind->adr_wmenu)[old_obj].ob_state & DISABLED)))
					{	/* S'il y avait un objet courant non inactif, le dselectionner */
						etat = (wind->adr_wmenu)[old_obj].ob_state & ~SELECTED;
						objc_change (wind->adr_wmenu, old_obj, 0, x, y, w, h, etat, 1);
					}
					if ((obj > -1) && (! ((wind->adr_wmenu)[obj].ob_state & DISABLED)))
					{ /* Si le nouvel objet n'est pas inactif, le slectionner */
						etat = (wind->adr_wmenu)[obj].ob_state | SELECTED;
						objc_change (wind->adr_wmenu, obj, 0, x, y, w, h, etat, 1);
					}
					/* Enregistrer option courante */
					old_obj = obj;
				}
			}
		}
	} while (! sortie); /* Tourner jusqu' un clic */
  /* Dbloquer menu principal + vnement message */
  wind_update (END_MCTRL);

	Wg_MenuTNormal (wind->numWnd, tit, TRUE);
	if ((obj != -1) && (! ((wind->adr_wmenu)[obj].ob_state & DISABLED)))
	{
		evnt->obj = obj;
		(wind->adr_wmenu)[obj].ob_state &= ~SELECTED;
		if (wind->Wg_OnMenu)
			(*wind->Wg_OnMenu)(evnt);
	}
	else
	{
		/* si clic en dehors du menu */
		if (obj == -1)
			(wind->adr_wmenu)[old_obj].ob_state &= ~SELECTED;
	}
}

/*************************************************************************
 * Gestion des bulles d'aide...                                          *
 *************************************************************************/
static int coefX (OBJECT *form, int objet)
{
	register int pere;

	if (objet > 0)
	{
		pere = parent (form, objet);
		return form[objet].ob_x + coefX(form, pere);
	}
	else
		return form[ROOT].ob_x;
}

/* Calcul de la position en Y de l'objet */
static int coefY (OBJECT *form, int objet)
{
	register int pere;

	if (objet > 0)
	{
		pere = parent (form, objet);
		return form[objet].ob_y + coefY(form, pere);
	}
	else
		return form[ROOT].ob_y;
}

static void EventHelp (Wind *wind, int typObj, int numObj)
/*-----------------------------------------------------------------------*
 * Gestion des bulles d'aide.                                            *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	int x, y, w, h, xm, ym, km, dummy, xmouse, ymouse, i = 0, j = 0, num = 0, maxlen = 0;
	int Coef = 12;
	MFDB image;
	Wg_Help *help = (Wg_Help *)NULL;
	OBJECT *obj;
	char text[3][41];

	if (numObj > 0)
	{
		if (Sys->Yres < 399)
			Coef = 8;
		help = wind->help;

		while  (help && (help->typObj != typObj || help->numObj != numObj))
			help = help->next;

		if (! help)
			return;
			
		if (typObj == ObjTBar)
			obj = wind->adr_wtoolbar;
		else
			obj = wind->adr_wdialog;

		if (help)
		{	/* Rinitialiser les trois lignes de texte */
			text[0][0] = '\0';
			text[1][0] = '\0';
			text[2][0] = '\0';

			/* Rcuprer au maximum 3 lignes de texte */
			while (help->txt[i] != '\0' && num <= 2)
			{
				if (help->txt[i] == '|')
				{
					text[num++][j] = '\0';
					if (j > maxlen)
						maxlen = j;
					j = 0;
				}
				else
					text[num][j++] = help->txt[i];

				i++;
			}
			if (j > maxlen)
				maxlen = j;
			if (num <= 2)
				text[num][j++] = '\0';
			else
				num--;

			set_text (PrivSys->AdrHelp, HLPTXT1, text[0]);
			set_text (PrivSys->AdrHelp, HLPTXT2, text[1]);
			set_text (PrivSys->AdrHelp, HLPTXT3, text[2]);

			(PrivSys->AdrHelp)->ob_x = coefX(obj, numObj);
			(PrivSys->AdrHelp)->ob_y = coefY(obj, numObj);
			(PrivSys->AdrHelp)->ob_width = (maxlen + 1) * 6;
			(PrivSys->AdrHelp)->ob_height = (num + 1) * Coef;

			if ((PrivSys->AdrHelp)->ob_x + (PrivSys->AdrHelp)->ob_width > Sys->Desk.g_x + Sys->Desk.g_w - 5)
				(PrivSys->AdrHelp)->ob_x = Sys->Desk.g_w + Sys->Desk.g_x - (PrivSys->AdrHelp)->ob_width - 5;
			if ((PrivSys->AdrHelp)->ob_x < Sys->Desk.g_x + 5)
				(PrivSys->AdrHelp)->ob_x = Sys->Desk.g_x + 5;
			if ((PrivSys->AdrHelp)->ob_y + (PrivSys->AdrHelp)->ob_height > Sys->Desk.g_y + Sys->Desk.g_h - 5)
				(PrivSys->AdrHelp)->ob_y = Sys->Desk.g_h + Sys->Desk.g_y - (PrivSys->AdrHelp)->ob_height - 5;
			if ((PrivSys->AdrHelp)->ob_y < Sys->Desk.g_y + 5)
				(PrivSys->AdrHelp)->ob_y = Sys->Desk.g_y + 5;

			x = (PrivSys->AdrHelp)->ob_x;
			y = (PrivSys->AdrHelp)->ob_y;
			w = (PrivSys->AdrHelp)->ob_width;
			h = (PrivSys->AdrHelp)->ob_height;

			/* Copier l'image de fond + dessiner bulle d'aide */
			get_bkgr (x, y, w, h, &image);
			objc_draw (PrivSys->AdrHelp, ROOT, MAX_DEPTH, x, y, w, h);

			/* Virer la souris et sauver ses coordonnes */
			v_hide_c (Sys->VdiHandle);
			graf_mkstate (&xmouse, &ymouse, &dummy, &dummy);
			do	/* BOUCLE PRINCIPALE DE GESTION DE LA BULLE D'AIDE */
			{
				graf_mkstate (&xm, &ym, &km, &dummy);
			} while (xm == xmouse && ym == ymouse && ! km);
			/* Restaurer l'image de fond et raffiche la souris */
			put_bkgr (x, y, w, h, &image);
			v_show_c (Sys->VdiHandle, TRUE);
		}
	}
}

/**************************-=< Fin du module >=-**************************/
