/*************************************************************************
 * WgObject.C                                                            *
 *                                                                       *
 * Module de gestion des objets de type Wg_Object.                       *
 *                                                                       *
 * Cration : 16 avril 1997                                              *
 *************************************************************************/
#include "WinProto.h"

/*************************************************************************
 * Dfinition des fonctions du module.                                   *
 *************************************************************************/
void Wg_ObjSelect (Wnd numWnd, int typObj, int numObj, int state)
{
	Wind *wind;
	OBJECT **ptr_obj = (OBJECT **)NULL;

	wind = ObjListe (numWnd);
	if (wind)	
	{
		if (typObj == ObjTBar)
			ptr_obj = &(wind->adr_wtoolbar);
		else if (typObj == ObjForm)
			ptr_obj = &(wind->adr_wdialog);
		
		if (*ptr_obj)
		{
			if (state)
				(*ptr_obj)[numObj].ob_state |= SELECTED;
 			else
				(*ptr_obj)[numObj].ob_state &= ~SELECTED;
 
			objc_change(*ptr_obj, numObj, 0,(*ptr_obj)->ob_x, (*ptr_obj)->ob_y, (*ptr_obj)->ob_width, (*ptr_obj)->ob_height, state, FALSE);
			if (wind->handle > 0)
				objc_draw(*ptr_obj, numObj, MAX_DEPTH, (*ptr_obj)->ob_x, (*ptr_obj)->ob_y, (*ptr_obj)->ob_width, (*ptr_obj)->ob_height);
		}
	}
}

void Wg_ObjEnable (Wnd numWnd, int typObj, int numObj, int state)
{
	Wind *wind;
	OBJECT **ptr_obj = (OBJECT **)NULL;

	wind = ObjListe (numWnd);
	if (wind)	
	{
		if (typObj == ObjTBar)
			ptr_obj = &(wind->adr_wtoolbar);
		else if (typObj == ObjForm)
			ptr_obj = &(wind->adr_wdialog);
		else if (typObj == ObjPopup)
			ptr_obj = &(wind->adr_wpopup);
		
		if (*ptr_obj)
		{
			if (state)
				(*ptr_obj)[numObj].ob_state |= SELECTED;
 			else
				(*ptr_obj)[numObj].ob_state &= ~SELECTED;
 
			if (wind->handle > 0)
				objc_draw(*ptr_obj, numObj, MAX_DEPTH, (*ptr_obj)->ob_x, (*ptr_obj)->ob_y, (*ptr_obj)->ob_width, (*ptr_obj)->ob_height);
		}
	}
}

void Wg_ObjCheck (Wnd numWnd, int typObj, int numObj, int state)
{
	Wind *wind;
	OBJECT **ptr_obj = (OBJECT **)NULL;

	wind = ObjListe (numWnd);
	if (wind)	
	{
		if (typObj == ObjTBar)
			ptr_obj = &(wind->adr_wtoolbar);
		else if (typObj == ObjForm)
			ptr_obj = &(wind->adr_wdialog);
		else if (typObj == ObjPopup)
			ptr_obj = &(wind->adr_wpopup);
		
		if (*ptr_obj)
		{
			if (state)
				(*ptr_obj)[numObj].ob_state |= CHECKED;
			else
				(*ptr_obj)[numObj].ob_state &= ~CHECKED;

			if (wind->handle > 0)
				objc_draw(*ptr_obj, numObj, MAX_DEPTH, (*ptr_obj)->ob_x, (*ptr_obj)->ob_y, (*ptr_obj)->ob_width, (*ptr_obj)->ob_height);
		}
	}
}

void Wg_ObjSetCoord (Wnd numWnd, int typObj, int numObj, GRECT *coord)
{
	Wind *wind;
	OBJECT **ptr_obj = (OBJECT **)NULL;

	wind = ObjListe (numWnd);
	if (wind)	
	{
		if (typObj == ObjTBar)
			ptr_obj = &(wind->adr_wtoolbar);
		else if (typObj == ObjForm)
			ptr_obj = &(wind->adr_wdialog);
		
		if (*ptr_obj)
		{
			(*ptr_obj)[numObj].ob_x = coord->g_x;
			(*ptr_obj)[numObj].ob_y = coord->g_y;
			(*ptr_obj)[numObj].ob_width = coord->g_w;
			(*ptr_obj)[numObj].ob_height = coord->g_h;
			if (wind->handle > 0)
				objc_draw(*ptr_obj, numObj, MAX_DEPTH, (*ptr_obj)->ob_x, (*ptr_obj)->ob_y, (*ptr_obj)->ob_width, (*ptr_obj)->ob_height);
		}
	}
}

void Wg_ObjGetCoord (Wnd numWnd, int typObj, int numObj, GRECT *coord)
{
	Wind *wind;
	OBJECT *ptr_obj = (OBJECT *)NULL;

	wind = ObjListe (numWnd);
	if (wind)	
	{
		if (typObj == ObjTBar)
			ptr_obj = wind->adr_wtoolbar;
		else if (typObj == ObjForm)
			ptr_obj = wind->adr_wdialog;
		else if (typObj == ObjPopup)
			ptr_obj = wind->adr_wpopup;
		else if (typObj == ObjMenu)
			ptr_obj = wind->adr_wmenu;
		
		if (ptr_obj)
		{
			coord->g_x = ptr_obj[numObj].ob_x;
			coord->g_y = ptr_obj[numObj].ob_y;
			coord->g_w = ptr_obj[numObj].ob_width;
			coord->g_h = ptr_obj[numObj].ob_height;
		}
	}
}

void Wg_ObjDraw (Wnd numWnd, int typObj, int numObj, int depth)
{
	Wind *wind;
	GRECT r;
	int dummy, top;
	Wg_Coord *pos;
	OBJECT *ptr_obj;

	wind = ObjListe(numWnd);
	if (wind && wind->handle > 0)  /* la fenetre est ouverte */
	{
		pos = wind->pos;
		/* Si formulaire ... */
		if (typObj == ObjForm)
			ptr_obj = wind->adr_wdialog;
		/* ou Bote  outils */
		else if (typObj == ObjTBar)
			ptr_obj = wind->adr_wtoolbar;
		/* sinon on ne fait rien */
		else
			return;

		wind_update(BEG_UPDATE);
		wind_get(0, WF_TOP, &top, &dummy, &dummy, &dummy);
		if (wind->handle == top) /* si topped, on optimise... */
			objc_draw(ptr_obj, numObj, MAX_DEPTH, pos->x, pos->y, pos->w, pos->h);
		else
		{
			wind_get(wind->handle, WF_FIRSTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
			while (r.g_w && r.g_h)
			{
				objc_draw(ptr_obj, numObj, MAX_DEPTH, r.g_x, r.g_y, r.g_w, r.g_h);
				wind_get(wind->handle, WF_NEXTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
			}
		}
		wind_update(END_UPDATE);
	}
}

void Wg_ObjSetText (Wnd numWnd, int typObj, int numObj, char *text)
{
	Wind *wind;
	OBJECT *ptr_obj = (OBJECT *)NULL;

	wind = ObjListe (numWnd);
	if (wind)	
	{
		if (typObj == ObjTBar)
			ptr_obj = wind->adr_wtoolbar;
		else if (typObj == ObjForm)
			ptr_obj = wind->adr_wdialog;
		else if (typObj == ObjPopup)
			ptr_obj = wind->adr_wpopup;
		
		if (ptr_obj)
			set_text(ptr_obj, numObj, text);
	}
}

char *Wg_ObjGetText (Wnd numWnd, int typObj, int numObj)
{
	Wind *wind;
	OBJECT *ptr_obj = (OBJECT *)NULL;

	wind = ObjListe (numWnd);
	if (wind)	
	{
		if (typObj == ObjTBar)
			ptr_obj = wind->adr_wtoolbar;
		else if (typObj == ObjForm)
			ptr_obj = wind->adr_wdialog;
		else if (typObj == ObjPopup)
			ptr_obj = wind->adr_wpopup;
		
		if (ptr_obj)
			return get_text(ptr_obj, numObj);
	}
	return (char *)NULL;
}

void Wg_ObjClrText (Wnd numWnd, int typObj, int numObj)
{
	Wg_ObjSetText (numWnd, typObj, numObj, "");
}

void Wg_ObjClrAllText (Wnd numWnd, int typObj)
{
	register int i = ROOT;
	Wind *wind;
	OBJECT **ptr_obj = (OBJECT **)NULL;

	wind = ObjListe (numWnd);
	if (wind)	
	{
		if (typObj == ObjTBar)
			ptr_obj = &(wind->adr_wtoolbar);
		else if (typObj == ObjForm)
			ptr_obj = &(wind->adr_wdialog);
		
		if (*ptr_obj)
		{
			do
			{
				if ((*ptr_obj)[i].ob_flags & EDITABLE)
					set_text((*ptr_obj), i, "");
			}
			while (! (*ptr_obj)[i].ob_flags & LASTOB);
		}
	}
}

void Wg_MenuEnable (Wnd numWnd, int item, int flag)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind && wind->adr_wmenu)
		menu_ienable (wind->adr_wmenu, item, flag);
}

void Wg_MenuTNormal (Wnd numWnd, int item, int flag)
{
	int x, y;
	int xw, yw, ww, hw;
	Wind *wind;
	OBJECT *ptr_menu;

	wind = ObjListe (numWnd);
	if (wind && wind->adr_wmenu)
	{
		/* Pointe sur l'objet Menu */
		ptr_menu = wind->adr_wmenu;

		menu_tnormal (ptr_menu, item, flag);
		if (wind->type != WndDesk)
		{
			wind_get (wind->handle, WF_WORKXYWH, &xw, &yw, &ww, &hw);
			objc_offset (ptr_menu, item, &x, &y);

			objc_draw (ptr_menu, BARMENU, MAX_DEPTH, x, y,
						 min(ww - ptr_menu[item].ob_x - 16, ptr_menu[item].ob_width),
						 ptr_menu[item].ob_height);
		}
	}
}

void Wg_MenuCheck (Wnd numWnd, int item, int flag)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind && wind->adr_wmenu)
		menu_icheck (wind->adr_wmenu, item, flag);
}

void Wg_MenuText (Wnd numWnd, int item, char *text)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind && wind->adr_wmenu)
		menu_text (wind->adr_wmenu, item, text);
}

/**************************-=< Fin du module >=-**************************/
