/*************************************************************************
 * WgSlider.C                                                            *
 *                                                                       *
 * Module de gestion des objets de type Slider.                          *
 *                                                                       *
 * Cration : 8 mai 1997                                                 *
 *************************************************************************/
#include "WinProto.h"

/*-=< Inclusion des descriptions des objets UserDefs. >=-----------------*/
#include "user.h"

static MFDB fond;

void Wg_ObjSlider (int mode, int max, int pos, char *text)
/*-----------------------------------------------------------------------*
 * Fonction d'initialisation et de gestion d'un objet Slider             *
 * mode		  : SLIDINI - Initilisation et affichage initial               *
 *            SLIDAFF - Modification de l'affichage                      *
 *         	  SLIDEND - Dtruire l'objet Slider                          *
 * scale    : Valeur maximale du Slider                                  *
 * pos      : Position courante.                                         *
 *-----------------------------------------------------------------------*/
{
	static int x = 0, y = 0, w = 0, h = 0;
	static int scale = 0;
	char txt[5];

	v_hide_c (Sys->VdiHandle);											/* Virer la souris */
	switch (mode)
	{
		case SLIDINI :
			scale = max;
			form_center(PrivSys->AdrSlider, &x, &y, &w, &h);
			get_bkgr (x, y, w, h, &fond);
			(PrivSys->AdrSlider)[SLIDBAR].ob_width = 0;

			set_text (PrivSys->AdrSlider, SLIDTXT, text);
			sprintf(txt,"%d\%",0);
			set_text (PrivSys->AdrSlider, SLIDPOS, txt);
			objc_draw (PrivSys->AdrSlider, ROOT, MAX_DEPTH, x, y, w, h);
			break;

		case SLIDAFF :
			(PrivSys->AdrSlider)[SLIDBAR].ob_width = pos * (PrivSys->AdrSlider)[SLIDBOX].ob_width / scale;
			sprintf(txt,"%d\%",(int)(pos * 100 / scale));
			set_text (PrivSys->AdrSlider, SLIDPOS, txt);
			objc_draw (PrivSys->AdrSlider, SLIDBAR, MAX_DEPTH, x, y, w, h);
			objc_draw (PrivSys->AdrSlider, SLIDPOS, MAX_DEPTH, x, y, w, h);
			break;

		case SLIDEND :
			put_bkgr (x, y, w, h, &fond);
			break;
	}
	v_show_c (Sys->VdiHandle, TRUE);								/* Remet la souris */
				
}

/**************************-=< Fin du module >=-**************************/
