/*************************************************************************
 * WgSystem.C                                                            *
 *                                                                       *
 * Module de dfinition des fonctions d'initialisation et de terminaison *
 * d'une application.                                                    *
 *                                                                       *
 * Cration : 26 mars 1997                                               *
 *************************************************************************/
#include "WinProto.h"

/*-=< Dfinition des variables publiques de WindGem >=-------------------*/
System			*Sys;			  			/* Information Systme / application       */
MachineInfo *Ordi;						/* Information Ordinateur                  */
Wnd 				WndMenu;		  		/* Gestion du menu                         */

/*-=< Dfinition des variables prives de WindGem >=---------------------*/
Internal	*PrivSys;
DTA		dtabuffer;						/* Tampon DTA                              */

/*-=< Section de dclaration des fonctions prives >=--------------------*/
static void coord (void);
static void GetSysInfo (void);
static void MakeRsc (char *res, char *orig, Bool multiLang);

/*-=< Inclusion des descriptions des objets UserDefs. >=-----------------*/
#include "user.c"

/*-----------------------------------------------------------------------*/
/*-=< Dfinition des fonctions du module >=------------------------------*/
/*-----------------------------------------------------------------------*/

static void coord (void)
/*-----------------------------------------------------------------------*
 * Fonction qui fixe les coordonnes des objets USerDefs.                *
 *                                                                       *
 * Validation : 3 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	register int i, j;

	for (i = 0 ; i < rs_nb_tree ; i++) /* Pour chaque arbre du RSC intgr*/
	{
		j = 0;							    /* et chaque objet,                 */
		do
		{								  /* Tant qu'on n'est pas au dernier objet */
			rsrc_obfix (rs_trindex[i], j); 			  /* Adapter coordonnes */
		} while (! (rs_trindex[i][j++].ob_flags & LASTOB));
	}
	/* On conserve les pointeurs sur les diffrents objets */
	PrivSys->AdrUser		= rs_trindex[0];
	PrivSys->AdrIcone		= rs_trindex[1];
	PrivSys->AdrHelp		= rs_trindex[2];
	PrivSys->AdrSlider	= rs_trindex[3];
	PrivSys->AdrAlerte	= rs_trindex[4];

	/* Problme des modes 40 colonnes */
	if (Sys->Xres < 639)
		PrivSys->AdrSlider[SLIDBAR].ob_x = 1;
	/* Problme des modes avec moins de 399 lignes */
	if (Sys->Yres < 399)
	{
		PrivSys->AdrSlider[SLIDBAR].ob_height = 6;
		PrivSys->AdrHelp[HLPTXT1].ob_y = 1;
		PrivSys->AdrHelp[HLPTXT2].ob_y = 8;
		PrivSys->AdrHelp[HLPTXT3].ob_y = 15;
		PrivSys->AdrAlerte[ALTTRAIT].ob_y += 2;
	}
	/* Problme des rsolutions avec moins de 16 couleurs */
	if (Sys->Nplane < 4)
		PrivSys->AdrHelp[ROOT].ob_spec.obspec.fillpattern = 0;

}

void AppInit(char *fic_rsc, Bool multiLang)
/*-----------------------------------------------------------------------*
 * Fonction d'initialisation de l'application.                           *
 *                                                                       *
 * fic_rsc	: Fichier .Rsc de l'application avec ou sans extension       *
 *                                                                       *
 * Validation : 3 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	int i, attributes[12];
	char FicRsc[128];

	/* Allocation mmoire pour les structures de donnes systme */
	Sys			= (System *)			malloc (sizeof(System));
	PrivSys	= (Internal *)		malloc (sizeof(Internal));
	Ordi		= (MachineInfo *) malloc (sizeof(MachineInfo));

	/* Initialisation de l'application */
	Sys->AppId = appl_init();

	for (i = 1 ; i < 9 ; _GemParBlk.intin[i++] = 1);
	_GemParBlk.intin[0] = Getrez() + 2;	   		/* rsolution de l'cran */
	_GemParBlk.intin[9] = 0;							/* Couleur de Remplissage*/
	_GemParBlk.intin[10]= 2;						  	/* type de coordonnes   */

	/* Rcupration du handle VDI ...*/
	Sys->VdiHandle = graf_handle(&(Sys->Wchar), &(Sys->Hchar), &(Sys->Wcell), &(Sys->Hcell));
	Sys->Hchar++;			 /* +1 pour eviter que les lignes ne se touchent */
	/* Ligne de base des caractres + 1 pour viter que la premire ligne
	de texte ne touche le haut de la fentre. */
	vqt_attributes(Sys->VdiHandle, attributes);
	Sys->baseline = 1 + attributes[7];

	/* Ouverture station de travail virtuelle */
	v_opnvwk (_GemParBlk.intin, &(Sys->VdiHandle), _GemParBlk.intout);

	/* Etablissement des couleurs 3D */
	if (_GemParBlk.intout[13] < 16)
	{
		PrivSys->color_3d1 = WHITE;
		PrivSys->color_3d2 = BLACK;
	}
	else
	{
		PrivSys->color_3d1 = LWHITE;
		PrivSys->color_3d2 = LBLACK;
	}

	/* Coordonnes du bureau et rsolution de l'cran en pixel */
	wind_get (0, WF_WORKXYWH, &(Sys->Desk.g_x), &(Sys->Desk.g_y), &(Sys->Desk.g_w), &(Sys->Desk.g_h));
	Sys->Xres = _GemParBlk.intout[0];
	Sys->Yres = _GemParBlk.intout[1];

	/* Rcupration de quelques paramtres supplmentaires */
	vq_extnd (Sys->VdiHandle, TRUE, _GemParBlk.intout);
	/* Nombre de plans de couleurs */
	Sys->Nplane = _GemParBlk.intout[4];

	/* Lecture des informations systme */
	GetSysInfo();

	/* Crer le nom du fichier .rsc en fonction de la langue employe */
	MakeRsc (FicRsc, fic_rsc, multiLang);

	/* Si fichier .Rsc introuvable -> on arrte tout */
	if (NOT rsrc_load(FicRsc))
	{
		char mes[60];

		sprintf(mes,"[2][| Le Fichier Ressource |    %s    | n'a pu tre trouv.][Quitter]",FicRsc);
		form_alert(1,mes);
		/* Rendre le bureau et effacer l'cran */
		wind_set (0, WF_NEWDESK, 0, 0);
		v_clsvwk(Sys->VdiHandle);

		/* Forcer le redessin de l'cran */
		form_dial (FMD_FINISH, 0, 0, 0, 0, Sys->Desk.g_x, Sys->Desk.g_y, Sys->Desk.g_w, Sys->Desk.g_h);

		/* Libration de la mmoire */
		free (Sys);
		free (PrivSys);
		free (Ordi);

		/* Fin de l'application */
		appl_exit();
		exit(1);
	}

	/* Voir  supprimer par la suite */
	WndMenu = BLANK;

	/* Mode d'affichage des fentres */
	PrivSys->lastMode = WndNORM;
	/* Rcupration du chemin de l'application */
	getcwd(Sys->AppPath, 128);

	/* Fixer adresse tampon DTA -> voir  dplacer ou supprimer */
	Fsetdta (&dtabuffer);

	/* Mise en place des boutons UserDefs pour les objets du fichier .Rsc */
	coord();

	/* Dernier numro d'objet Timer */
	PrivSys->lastTimer = 1;

	/* Initilisation de la liste des objets */
	for (i=0; i<NBWIND; i++)
		LstWnd[i].numWnd = BLANK;

	graf_mouse(ARROW, 0);
}

Wnd AppSetDesk (int desk, void (*OnDesk)(Wg_Evnt evnt), int menu, void (*OnMenu)(Wg_Evnt evnt))
/*-----------------------------------------------------------------------*
 * Fonction d'initialisation du bureau et du menu de l'application.      *
 *                                                                       *
 * desk	  	: numero de l'objet pour bureau                              *
 * gereDesk : fonction de gestion du bureau                              *
 * menu	  	: numero de l'objet MENU                                     *
 * gereMenu	: fonction de gestion du menu                                *
 *                                                                       *
 * Retourne le numro de l'objet WindGem de gestion du bureau.           *
 *                                                                       *
 * Validation : 3 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	Wnd				numWnd;
	Wg_Coord	coord;

	/* Crer objet bureau */
	numWnd = NewWind (WndDesk);
	WndMenu = numWnd;

	/* Handle 0 */
	Wg_SetHandle (numWnd, 0);

	if (desk != BLANK)
	{
		/* Mise en place du "formulaire" de fond de bureau */
		Wg_SetDialog	(numWnd, desk, 0);

		/* Coordonnes du bureau */
		coord.x = Sys->Desk.g_x;
		coord.y = Sys->Desk.g_y;
		coord.w = Sys->Desk.g_w;
		coord.h = Sys->Desk.g_h;
		coord.minW = coord.maxW = Sys->Desk.g_w;
		coord.minH = coord.maxH = Sys->Desk.g_h;
		Wg_SetCoord	(numWnd, &coord);
		Wg_ObjSetCoord (numWnd, ObjForm, ROOT, &(Sys->Desk));

		/* Mise en place de la fonction de gestion des vnements bureau  */
		Wg_SetEvent	(numWnd, EvntAll, OnDesk);

		/* Affichage du bureau */
		wind_set (0, WF_NEWDESK, Wg_GetObject(numWnd, ObjForm), 0);
		form_dial (FMD_FINISH, 0, 0, 0, 0, Sys->Desk.g_x, Sys->Desk.g_y, Sys->Desk.g_w, Sys->Desk.g_h);
	}

	/* Mise en place du Menu *********************************************/
	if (menu != BLANK)
	{
		/* Mise en place et affichage du menu */
		Wg_SetMenu (numWnd, menu);

		/* Mise en place de la fonction de gestion du menu */
		Wg_SetEvent	(numWnd, EvntMenu, OnMenu);
	}

	return numWnd;
}

static void MakeRsc (char *res, char *orig, Bool multiLang)
/*-----------------------------------------------------------------------*
 * Cration du nom du fichier .Rsc de l'application.                     *
 *                                                                       *
 * res	: rsultat                                                       *
 * orig	: nom d'origine                                                  *
 *                                                                       *
 * Validation : 3 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	char extension[4];
	char pays[6];

	strcpy (pays, " .rsc");
	strcpy (res, orig);
	strright (extension, orig, 4);

	if (multiLang)
	{
		if (strcmp(strupr(extension), ".RSC") == 0)
			res[strlen(res) - 4] = '\0';

		switch (Ordi->Language)
		{
			case LG_F :
			case LG_CHF :
				pays[0] = 'F';
				break;
			case LG_USA :
			case LG_GB :
				pays[0] = 'E';
				break;
			case LG_I :
				pays[0] = 'I';
				break;
			case LG_SP :
				pays[0] = 'S';
				break;
			case LG_D :
			case LG_CHD :
				pays[0] = 'D';
				break;
			default :
				pays[0] = 'E';
		}
		strcat (res, pays);
	}
	else
	{
		if (strcmp(strupr(extension), ".RSC") != 0)
			strcat (res, ".RSC");
	}
}

void AppExit(void)
/*-----------------------------------------------------------------------*
 * Fermeture de l'application                                            *
 *                                                                       *
 * Validation : 3 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	register int i;

	v_clsvwk(Sys->VdiHandle);
	form_dial (FMD_FINISH, 0, 0, 0, 0, Sys->Desk.g_x, Sys->Desk.g_y, Sys->Desk.g_w, Sys->Desk.g_h);

	/* Destruction de toutes les fentres */
	for (i=0; i < NBWIND; i++)
		DeleteWind (LstWnd[i].numWnd);

	free (PrivSys);
	free (Ordi);
	free (Sys);

	/* Librer espace RSC + effacement de l'cran */
	rsrc_free();

	/* Fin de l'application */
	appl_exit();
	exit(0);
}

static void GetSysInfo (void)
/*-----------------------------------------------------------------------*
 * Rcupration des informations systme.                                *
 *                                                                       *
 * Validation : 3 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	long cookie;

  /*
	*	Par dfaut Atari ST Franais
	*/
  Ordi->Processor	= M68000;
  Ordi->Machine  	= ST;
  Ordi->Switch		= FALSE;
  Ordi->Fdc		  	= FALSE;
  Ordi->Keyboard	= KEYB_F;
  Ordi->Language	= LG_F;
  Ordi->Shifter  	= SHIFTER_ST;
  Ordi->Sound	  	= PSG;
  Ordi->Fpu		  	= NO_FPU;
  Ordi->Separator	= '/';
  Ordi->Time 	  	= TIME_12;
  Ordi->Date	  	= DATE_MJA;

  /*
	*	Rcupration des valeurs relles  l'aide du Cooky Jar
	*/
  if(Getcookie('_CPU',&cookie))
	 Ordi->Processor	= (int)(cookie & 0xFFFF);
  if(Getcookie('_MCH',&cookie))
	 Ordi->Machine		= cookie;
  if(Getcookie('_SWI',&cookie))
	 Ordi->Switch		= (int)(cookie & 0x00FF);
  if(Getcookie('_FDC',&cookie))
	 Ordi->Fdc				= cookie;
  if(Getcookie('_AKP',&cookie))
  {
	 Ordi->Keyboard = (int)(cookie & 0x00FF);
	 Ordi->Language = (int)((cookie & 0xFF00) >> 8);
  }
  if(Getcookie('_VDO',&cookie))
	 Ordi->Shifter	= cookie;
  if(Getcookie('_SND',&cookie))
	 Ordi->Sound		= loword(cookie);
  if(Getcookie('_FPU',&cookie))
	 Ordi->Fpu 		= hiword(cookie);
  if(Getcookie('_IDT',&cookie))
  {
	 Ordi->Separator	= (((unsigned char *)&(cookie))[3]);
	 Ordi->Date 			= (((unsigned char *)&(cookie))[2]) & 0xF;
	 Ordi->Time 			= (((unsigned char *)&(cookie))[2]) & 0xF0 >> 4;
  }
  Ordi->TosVersion		= _tos;
  Ordi->GemdosVersion = Sversion();
  Ordi->AesVersion		= gl_apversion;

  if(Getcookie('MiNT',&cookie))						 /* Mot faible = version */
	 Ordi->MultiTosVersion = loword(cookie);
  else														 /* Pas de multitos      */
	 Ordi->MultiTosVersion = FALSE;
	if (Getcookie('MagX', &cookie))					 /* Ordi sous Magic ??   */
	{
		if (cookie)
			Ordi->Magic = TRUE;
		else
			Ordi->Magic = FALSE;
	}
}

void Wg_GetDeskXYWH (int *Xdesk, int *Ydesk, int *Wdesk, int *Hdesk)
{
	*Xdesk = Sys->Desk.g_x;
	*Ydesk = Sys->Desk.g_y;
	*Wdesk = Sys->Desk.g_w;
	*Hdesk = Sys->Desk.g_h;
}


/**************************-=< Fin du module >=-**************************/
