/*************************************************************************
 * WgText.C                                                              *
 *                                                                       *
 * Module de gestion des fentres Texte.                                 *
 *                                                                       *
 * Cration : 6 mai 1997                                                 *
 *************************************************************************/
#include "WinProto.h"

void Wg_Loadtext (char *file, int *nblin, int *nbcol, char **text[])
{
	int fh, nlines = ZERO, maxi = ZERO;
	register int i;
	long taille;
	char *zone, *ptr;

	if (file)
	{
		taille = exist (file, ZERO);				/* Prendre la taille du fichier */
		if (taille)								 					/* S'il existe et memoire dispo */
		{
			zone = (char *)lalloc (taille);		/* Rserver mmoire */
			if (zone)													/* Si mmoire dispo */
			{
				fh = (int)Fopen (file, FO_READ);	/* Ouvrir fichier */
				Fread (fh, taille, zone);					/* Charger en mmoire */
				Fclose (fh);											/* Fermer fichier */
				ptr = zone;
				do
				{
					if (*ptr == '\r')								/* Remplacer fins de lignes par '\0' */
					{
						*ptr = '\0';
						nlines++;											/* Compter les lignes */
						ptr++;
					}
					ptr++;
				} while (ptr < zone + taille);
	
				/* Mmoire pointeurs sur les lignes */
				*text = (char **)malloc (nlines * sizeof (char **));
				ptr = zone;												/* Partir du dbut */
				for (i = ZERO ; i < nlines ; i++)	/* Pour chaque ligne */
				{
					(*text)[i] = ptr;	/* Pointer dessus */
					maxi = max (maxi, (int)strlen (ptr));	/* Ligne la plus longue */
					ptr += (strlen (ptr) + 2);			/* Ligne suivante */
				}
				*nblin = nlines;									/* Enregistrer nbre de lignes */
				*nbcol = maxi;										/* Enregistrer nbre colonnes  */
			}
		}
	}
}

void Wg_GetText (Wnd numWnd, int *nblin, int *nbcol, int *lin, int *col, char **text[])
{
	Wind *wind;
	
	wind = ObjListe(numWnd);
	if (wind && wind->text)
	{
		*text  = wind->text;
		*nblin = wind->slider->scaleH;
		*nbcol = wind->slider->scaleW;
		*lin 	 = wind->slider->posH;
		*col   = wind->slider->posW;
	}
}

void Wg_SetText (Wnd numWnd, int nblin, int nbcol, int lin, int col, char **text)
{
	Wind *wind;
	
	wind = ObjListe(numWnd);
	if (wind && wind->type == WndText)
	{
		wind->text    = text;
		Wg_SetSliders (numWnd, nblin, lin, 1, nbcol, col, 1);
		
		if (wind->handle > 0)
		{
			SendMessage (Sys->AppId, WM_REDRAW, 0, wind->handle, wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h);
			Wg_Sliders (wind);
		}
	}
}

void Wg_SetImage (Wnd numWnd, int nblin, int nbcol, int lin, int col, MFDB *img)
{
	Wind *wind;
	
	wind = ObjListe(numWnd);
	if (wind && wind->type == WndGrap)
	{
		wind->pos->maxW 		 = nbcol + 38;
		wind->pos->maxH 		 = nblin + 38;
		wind->image	  		 	 = img;
		Wg_SetSliders (numWnd, nblin, lin, 10, nbcol, col, 10);

		if (wind->handle > 0)
		{
			SendMessage (Sys->AppId, WM_REDRAW, 0, wind->handle, wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h);
			Wg_Sliders (wind);
		}
	}	
}

void Wg_GetImage (Wnd numWnd, int *nblin, int *nbcol, int *lin, int *col, MFDB **img)
{
	Wind *wind;
	
	wind = ObjListe(numWnd);
	if (wind && wind->text)
	{
		*img  = wind->image;
		*lin 	= wind->slider->posH;
		*col  = wind->slider->posW;
		*nblin= wind->slider->scaleH;
		*nbcol= wind->slider->scaleW;
	}
}

void Wg_Arrow (Wind *wind, Wg_Evnt *evnt)
{
	GRECT coord;
	int decal, pxy[8], hauteur_page, largeur_page;
	int lin, col, nblin, nbcol;
	Bool draw = FALSE;
	
	Wg_GetWorkXYWH (wind->numWnd, &coord);
	lin = wind->slider->posH;
	col = wind->slider->posW;
	nblin = wind->slider->scaleH;
	nbcol = wind->slider->scaleW;
	if (wind->text)
	{
		hauteur_page = coord.g_h / Sys->Hchar;
		largeur_page = coord.g_w / Sys->Wchar;
	}
	else
	{
		hauteur_page = coord.g_h;
		largeur_page = coord.g_w;
	}

	switch (evnt->mes[4])
	{
	case WA_UPPAGE :				/* Page vers le haut */
		if (lin > 0)
		{
			wind->slider->posH = max (lin - hauteur_page, 0);
			draw = TRUE;
		}
		break;
	case WA_DNPAGE :				/* Page vers le bas */
		if ((lin + hauteur_page) < nblin)
		{
			wind->slider->posH = min (lin + hauteur_page, nblin - hauteur_page);
			draw = TRUE;
		}
		break;
	case WA_UPLINE :				/* Ligne vers le haut */
		if (lin > 0)
		{
			wind->slider->posH -= wind->slider->offH;
			if (wind->slider->posH < 0)
				wind->slider->posH = 0;
			draw = TRUE;
		}
		break;
	case WA_DNLINE :				/* Ligne vers le bas */
		if ((lin + hauteur_page) < nblin)
		{
			wind->slider->posH += wind->slider->offH;
			if (wind->slider->posH + hauteur_page > wind->slider->scaleH)
				wind->slider->posH = wind->slider->scaleH - hauteur_page;
			draw = TRUE;
		}
		break;
	case WA_LFPAGE :				/* Page vers la gauche */
    if (col > 0)
		{
			wind->slider->posW = max (col - largeur_page, 0);
			draw = TRUE;
		}
		break;
		
	case WA_RTPAGE :				/* Page vers la droite */
 		if ((col + largeur_page) < nbcol)
		{
			wind->slider->posW = min (col + largeur_page, nbcol - largeur_page);
			draw = TRUE;
		}
		break;
		
	case WA_LFLINE :				/* Ligne vers la gauche */
		if (col > 0)
		{
			wind->slider->posW -= wind->slider->offW;
			if (wind->slider->posW < 0)
				wind->slider->posW = 0;
			draw = TRUE;
		}
		break;
		
	case WA_RTLINE :				/* Ligne vers la droite */
		if ((col + largeur_page) < nbcol)
		{
			wind->slider->posW += wind->slider->offW;
			if (wind->slider->posW + largeur_page > wind->slider->scaleW)
				wind->slider->posW = wind->slider->scaleW - largeur_page;
			draw = TRUE;
		}
		break;
	}
	if (draw)
	{
		SendMessage (Sys->AppId, WM_REDRAW, 0, wind->handle, coord.g_x, coord.g_y, coord.g_w, coord.g_h);
		Wg_Sliders (wind); 				/* Actualiser les sliders */
	}
}

void Wg_HSlider (Wind *wind, Wg_Evnt *evnt)
{
	GRECT coord;
	int slide, largeur_page;

	if (wind->slider)
	{
		slide = evnt->mes[4];
		Wg_GetWorkXYWH (wind->numWnd, &coord);

		if (wind->text)
			largeur_page = coord.g_w / Sys->Wchar;					/* Hauteur en lignes de texte */
  	else
			largeur_page = coord.g_w;					/* Hauteur en lignes de texte */

		wind->slider->posW = (int)((long)slide * (wind->slider->scaleW - largeur_page) / 1000);
		wind_set(wind->handle, WF_HSLIDE, slide);
		SendMessage (Sys->AppId, WM_REDRAW, 0, wind->handle, coord.g_x, coord.g_y, coord.g_w, coord.g_h);
	}
}

void Wg_VSlider (Wind *wind, Wg_Evnt *evnt)
{
	GRECT coord;
	int slide, hauteur_page;

	if (wind->slider)
	{
		slide = evnt->mes[4];
		Wg_GetWorkXYWH (wind->numWnd, &coord);

		if (wind->text)
			hauteur_page = coord.g_h / Sys->Hchar;					/* Hauteur en lignes de texte */
		else
			hauteur_page = coord.g_h;					/* Hauteur en lignes de texte */

		wind->slider->posH = (int)((long)slide * (wind->slider->scaleH - hauteur_page) / 1000);
		wind_set(wind->handle, WF_VSLIDE, slide);
		SendMessage (Sys->AppId, WM_REDRAW, 0, wind->handle, coord.g_x, coord.g_y, coord.g_w, coord.g_h);
	}
}

void Wg_Sliders (Wind *wind)
{
	GRECT coord;
	int hauteur_page, largeur_page;
	
	if (wind->slider)
	{
		Wg_GetWorkXYWH (wind->numWnd, &coord);

		if (wind->text)
		{
			hauteur_page = coord.g_h / Sys->Hchar;
			largeur_page = coord.g_w / Sys->Wchar;
		}
		else
		{
			hauteur_page = coord.g_h;
			largeur_page = coord.g_w;
		}

		/* Taille slider vertical */
		wind_set(wind->handle, WF_VSLSIZE, (int)((1000L * hauteur_page) / wind->slider->scaleH));
		wind->slider->posH = min(wind->slider->posH, wind->slider->scaleH - hauteur_page);
		if (wind->slider->posH < 0)
			wind->slider->posH = 0;

		/* Taille slider horizontal */
		wind_set(wind->handle, WF_HSLSIZE, (int)((1000L * largeur_page) / wind->slider->scaleW));
		wind->slider->posW = min(wind->slider->posW, wind->slider->scaleW - largeur_page);
		if (wind->slider->posW < 0)
			wind->slider->posW = 0;

		/* Position slider vertical */
		wind_set(wind->handle, WF_VSLIDE, (int)((1000L * wind->slider->posH)
				/ (wind->slider->scaleH - hauteur_page)));
			
		/* Position slider horizontal */
		wind_set(wind->handle, WF_HSLIDE, (int)((1000L * wind->slider->posW)
				/ (wind->slider->scaleW - largeur_page)));
	}
}

/**************************-=< Fin du module >=-**************************/
