/*************************************************************************
 * Fonctions de gestion des boutons UserDefs.                            *
 *                                                                       *
 * Dernire mise  jour : 25/04/1997                                     *
 *************************************************************************/
#include "winproto.h"
#include "user.h"

#ifndef ACTIVATOR
#define ACTIVATOR			0x600
#endif
#define USR_INDICATOR	0x800
#define USR_ACTIVATOR	0x1800

/*-=< Section dclaration >=---------------------------------------------*/
int cdecl under_button (PARMBLK *parmblock);
int cdecl check_button (PARMBLK *parmblock);
int cdecl popup_button (PARMBLK *parmblock);
int cdecl group_button (PARMBLK *parmblock);
static void set_objc(OBJECT *addr_obj, int cdecl (*code)(PARMBLK *parmblock));

/*-=< Gestion de l'affichage des boutons UserDefs >=---------------------*/

/*-----------------------------------------------------------------------*
 * Raccourcis clavier.                                                   *
 *-----------------------------------------------------------------------*/
int cdecl under_button(PARMBLK *parmblock)
{
	int flags, x, y, w, h, test = 0, under_pos, tx, ty;
	int back_color, lb_color, lh_color, txt_color = BLACK, xtype;
	int char_height, cell_height, dummy;
	register char *string, *key_short;
	int tab[4], xy_bar[8], attributs[10];
	char chaine[60];

	/* Dfinition et mise en place de la zone de clip */
	fill_tab (tab, 4,
							parmblock->pb_xc, parmblock->pb_yc,
							parmblock->pb_wc + parmblock->pb_xc - 1,
							parmblock->pb_hc + parmblock->pb_yc - 1);
	vs_clip (Sys->VdiHandle, TRUE, tab);

	/* Flag de l'objet */
	flags = parmblock->pb_tree[parmblock->pb_obj].ob_flags;
	/* Type tendu de l'objet */
	xtype = parmblock->pb_tree[parmblock->pb_obj].ob_type >> 8;
	/* Chane de caractres contenues */
	string = (char *) parmblock->pb_parm;

	/* Coordonnes de l'objet */
	x = parmblock->pb_x;
	y = parmblock->pb_y;
	w = parmblock->pb_w;
	h = parmblock->pb_h;

	/* Calcul de la taille du texte */
	vqt_attributes(Sys->VdiHandle, attributs);
	if (xtype == SMALL_B) /* Petite fonte systme. */
		char_height = 4;
	else
		char_height = attributs[7];
	vst_height(Sys->VdiHandle, char_height, &dummy, &char_height, &dummy, &cell_height);

	/* "CALCUL" DU TEXTE */
	if ((key_short = strchr(string, '[')) != 0)
	{
		strnpcpy(chaine, string,key_short);
		vqt_extent(Sys->VdiHandle, chaine, xy_bar);
		under_pos = xy_bar[2];	 /* Position du souligne */
		key_short++;
		strcat(chaine,key_short);
	}
	else
		strcpy(chaine, string);

	/* Position d'criture du texte */
	vqt_extent(Sys->VdiHandle, chaine, xy_bar);
	tx = x + (w - xy_bar[2])/2;
	ty = y + (char_height + (h - cell_height)/2);

	if (xtype != SMALL_B)
	{
		x -= 3; y -= 3; w += 5; h += 5;
	}
	else
		ty++;
	/* Prise en compte de la 3D */
	if ((flags & USR_ACTIVATOR) != 0)
	{
		x -= 2; y -= 2; w += 4; h += 4;
	}
	xy_bar[0] = x; xy_bar[1] = y;
	xy_bar[2] = x + w; xy_bar[3] = y + h;

	vswr_mode(Sys->VdiHandle, MD_REPLACE);
	/* Prise en compte du mode OUTLINED */
	if ((parmblock->pb_currstate & OUTLINED) != 0)
	{
		vsf_color(Sys->VdiHandle, WHITE);
		vsf_interior(Sys->VdiHandle, 1);
		/* Dessin du fond de l'objet */
		v_bar(Sys->VdiHandle, xy_bar);
	}
	else
	{
		/* Cadre pour "DEFAULT" */
		if (flags & DEFAULT)
			test++;
		/* Cadre pour "EXIT" */
		if (flags & EXIT)
			test++;
	}
	vsf_interior(Sys->VdiHandle ,0);
	vswr_mode(Sys->VdiHandle, MD_TRANS);

	/* Couleur des cadres */
	vsf_color(Sys->VdiHandle, BLACK);

	if ((parmblock->pb_currstate & OUTLINED) != 0 || test == 2)
	{
		/* Cadre Extrieur */
		v_bar(Sys->VdiHandle, xy_bar);
		test--;
	}
	xy_bar[0] ++; xy_bar[1] ++;
	xy_bar[2] --; xy_bar[3] --;

	/* Cadre Intermdiaire */
	if (test > 0)
		v_bar(Sys->VdiHandle, xy_bar);
	xy_bar[0] ++;	xy_bar[1] ++;
	xy_bar[2] --;	xy_bar[3] --;

	/* Cadre Intrieur */
	if ((parmblock->pb_currstate & OUTLINED) == 0)
		v_bar(Sys->VdiHandle, xy_bar);
	xy_bar[0] ++;	xy_bar[1] ++;
	xy_bar[2] --;	xy_bar[3] --;

	flags &= USR_ACTIVATOR;
	if (flags)
	{
		back_color = PrivSys->color_3d1;
		if ((parmblock->pb_currstate & SELECTED) == 0)
		{
			lh_color = WHITE;
			lb_color = PrivSys->color_3d2;
			if (flags == USR_ACTIVATOR)
			{	/* ACTIVATOR et NORMAL */
				tx--; ty--;
			}
		}
		else
		{
			lh_color = BLACK;
			lb_color = WHITE;
			if (flags == USR_INDICATOR)
			{	/* INDICATOR et SELECTED */
				back_color = PrivSys->color_3d2;
				txt_color = WHITE;
				lb_color = PrivSys->color_3d1;
			}
		}
	}
	else if ((parmblock->pb_currstate & SELECTED) != 0)
	{
		txt_color = WHITE;
		back_color = BLACK;
	}
	else
	{
		back_color = WHITE;
	}
	vsf_interior(Sys->VdiHandle, 1);
	vsf_color(Sys->VdiHandle, back_color);
	/* Remplissage intrieur du bouton */
	v_bar(Sys->VdiHandle, xy_bar);

	if (flags)
	{
		xy_bar[0]++;
		xy_bar[4] = xy_bar[2];
		xy_bar[5] = xy_bar[1] +1;
		xy_bar[1] = xy_bar[3];
		vsl_color(Sys->VdiHandle, lb_color);
		/* Ligne basse et droite */
		v_pline(Sys->VdiHandle, 3, xy_bar);
		xy_bar[0]--; xy_bar[5]--;
		xy_bar[2] = xy_bar[0];
		xy_bar[3] = xy_bar[5];
		xy_bar[1]--;xy_bar[4]--;
		vsl_color(Sys->VdiHandle, lh_color);
		/* Ligne gacueh et haute */
		v_pline(Sys->VdiHandle, 3, xy_bar);
	}
	vst_color(Sys->VdiHandle, txt_color);
	v_gtext(Sys->VdiHandle, tx, ty, chaine);
	if (key_short != 0)
	{
		/* Courleur de soulignement */
		vst_color(Sys->VdiHandle, RED);
		/* Mode "soulign" */
		vst_effects(Sys->VdiHandle, 8);
		v_gtext(Sys->VdiHandle, tx + under_pos, ty, " ");
		/* Mode "normal" */
		vst_effects(Sys->VdiHandle, 0);
	}

	vswr_mode(Sys->VdiHandle, MD_REPLACE);
	vst_color(Sys->VdiHandle, BLACK);
	vst_height(Sys->VdiHandle, attributs[7], &dummy, &dummy, &dummy, &dummy);

	/* Supprimer le clipping */
	vs_clip(Sys->VdiHandle, FALSE, tab);

	return (parmblock->pb_currstate & DISABLED);
}

/*-----------------------------------------------------------------------*
 * Radio-boutons et Check-box.                                           *
 *-----------------------------------------------------------------------*/
int cdecl check_button (PARMBLK *parmblock)
{
	int tab[4], pxy[8], pox, poy, sel, obj, color[2];
	register char *texte;
	int dummy, height, Coef;
	MFDB nul = {0}, pic, msk;

	vst_font (Sys->VdiHandle, 1);
	/* Dfinition et mise en place du clipping */
	fill_tab (tab, 4,
							parmblock->pb_xc, parmblock->pb_yc,
							parmblock->pb_wc + parmblock->pb_xc - 1,
							parmblock->pb_hc + parmblock->pb_yc - 1);
	vs_clip (Sys->VdiHandle, TRUE, tab);

	/* Choix du dessin en fonction de l'tat et du type tendu de l'objet */
	sel = parmblock->pb_currstate & SELECTED;
	if (Sys->Yres < 399)
	{
		if (parmblock->pb_tree[parmblock->pb_obj].ob_flags & RBUTTON)
			obj = sel ? RBLS : RBLN;
		else
			obj = sel ? BCLS : BCLN;
		height = 8;
		Coef = 2;
	}
	else
	{
		if (parmblock->pb_tree[parmblock->pb_obj].ob_flags & RBUTTON)
			obj = sel ? RBS : RBN;
		else
			obj = sel ? BCS : BCN;
		height = 16;
		Coef = 1;
	}
	/* Prparer copie de l'icne */
	pic.fd_addr = (void *) (PrivSys->AdrUser)[obj].ob_spec.iconblk->ib_pdata;
	msk.fd_addr = (void *) (PrivSys->AdrUser)[obj].ob_spec.iconblk->ib_pmask;
	pic.fd_w = msk.fd_w = 16;
	pic.fd_h = msk.fd_h = height;
	pic.fd_wdwidth = msk.fd_wdwidth = 1;
	pic.fd_nplanes = msk.fd_nplanes = 1;
	pic.fd_stand = msk.fd_stand = ZERO;

	fill_tab (pxy, 8,
						ZERO, ZERO, pic.fd_w - 1, pic.fd_h - 1,
						parmblock->pb_x, parmblock->pb_y,
						parmblock->pb_x + pic.fd_w - 1,
						parmblock->pb_y + pic.fd_h - 1);

	/* Copie de l'icne */
	color[0] = WHITE;
	color[1] = WHITE;
	vrt_cpyfm (Sys->VdiHandle, MD_TRANS, pxy, &msk, &nul, color);
	color[0] = BLACK;
	vrt_cpyfm (Sys->VdiHandle, MD_TRANS, pxy, &pic, &nul, color);

	/* Prparation du texte */
	texte = (char *)parmblock->pb_parm;
	vst_color (Sys->VdiHandle, BLACK);
	vst_alignment (Sys->VdiHandle, 0, 5, &dummy, &dummy);
	/* Mode transparent */
	vswr_mode (Sys->VdiHandle, MD_TRANS);
	/* Dsactiver tous les effets */
	vst_effects (Sys->VdiHandle, ZERO);
	/* Dfinir position en X et Y */
	pox = parmblock->pb_x + (2 / Coef) * Sys->Wchar + 2;
	poy = parmblock->pb_y + 1;

	/* Ecrire texte */
	v_gtext (Sys->VdiHandle, pox, poy, texte);
	/* Remettre le mode alignement par dfaut */
	vst_alignment (Sys->VdiHandle, 0, 0, &dummy, &dummy);

	/* Supprimer le clipping */
	vs_clip (Sys->VdiHandle, FALSE, tab);

	return (parmblock->pb_currstate & ~SELECTED);
}

/*-----------------------------------------------------------------------*
 * PopUp-boutons                                                         *
 *-----------------------------------------------------------------------*/
int cdecl popup_button (PARMBLK *parmblock)
{
	int flags, x, y, w, h, test = 0, tx, ty;
	int back_color, lb_color, lh_color, sel, obj;
	register char *texte;
	int tab[4], pxy[8], color[2], xy_bar[8], height, Coef;
	MFDB nul = {0}, pic, msk;

	/* Dfinir et mettre en place le clipping */
	vst_font (Sys->VdiHandle, 1);
	fill_tab (tab, 4,
							parmblock->pb_xc, parmblock->pb_yc,
							parmblock->pb_wc + parmblock->pb_xc - 1,
							parmblock->pb_hc + parmblock->pb_yc - 1);
	vs_clip (Sys->VdiHandle, TRUE, tab);

	/* Dessin de l'objet en fonction de son tat et de son type tendu */
	sel = parmblock->pb_currstate & SELECTED;
	if (Sys->Yres < 399)
	{
		obj = sel ? CYCLOFF : CYCLON;
		height = 8;
		Coef = 2;
	}
	else
	{
		obj = sel ? CYCOFF : CYCON;
		height = 16;
		Coef = 1;
	}

	/* Prparation affichage de l'icone */
	pic.fd_addr = (void *) (PrivSys->AdrUser)[obj].ob_spec.iconblk->ib_pdata;
	msk.fd_addr = (void *) (PrivSys->AdrUser)[obj].ob_spec.iconblk->ib_pmask;
	pic.fd_w = msk.fd_w = 16;
	pic.fd_h = msk.fd_h = height;
	pic.fd_wdwidth = msk.fd_wdwidth = 1;
	pic.fd_nplanes = msk.fd_nplanes = 1;
	pic.fd_stand = msk.fd_stand = ZERO;

	/* Rcupre les attributs et les coordonnes de l'objet */
	flags = parmblock->pb_tree[parmblock->pb_obj].ob_flags;
	x = parmblock->pb_x;
	w = parmblock->pb_w;
	y = parmblock->pb_y;
	h = parmblock->pb_h;

	if (Sys->Yres < 399)
	{
		y--;
		h+=2;
	}

	tx = x + 4;
	ty = y + Sys->Hchar - 3;

	/* Prise en compte de la 3D */
	if ((flags & USR_ACTIVATOR) != 0)
	{
		x -= 2; y -= 2; w += 4; h += 4;
	}
	xy_bar[0] = x; xy_bar[1] = y;
	xy_bar[2] = x + w - (16 / Coef) - 1; xy_bar[3] = y + h - 1;

	/* Cadre pour "EXIT" */
	if (flags & EXIT)
		test++;

	vsf_interior(Sys->VdiHandle ,0);
	/* Cadre transparent et noir */
	vswr_mode(Sys->VdiHandle, MD_TRANS);
	vsf_color(Sys->VdiHandle, BLACK);

	/* Dessin cadre intermdiaire */
	if (test > 0)
		v_bar(Sys->VdiHandle, xy_bar);
	xy_bar[0] ++;	xy_bar[1] ++;
	xy_bar[2] --;	xy_bar[3] --;
	xy_bar[0] ++;	xy_bar[1] ++;
	xy_bar[2] --;	xy_bar[3] --;

	flags &= USR_ACTIVATOR;
	if (flags)
	{
		back_color = PrivSys->color_3d1;
		if (! sel)
		{
			if (Sys->Nplane < 4)
				lh_color = BLACK;
			else
				lh_color = WHITE;
			lb_color = PrivSys->color_3d2;
			if (flags == USR_ACTIVATOR)
			{	/* ACTIVATOR et NORMAL */
				tx--; ty--;
			}
		}
		else
		{
			lh_color = BLACK;
			if (Sys->Nplane < 4)
				lb_color = BLACK;
			else
				lb_color = WHITE;
			if (flags == USR_INDICATOR)
			{	/* INDICATOR et SELECTED */
				back_color = PrivSys->color_3d2;
				lb_color = PrivSys->color_3d1;
			}
		}
	}
	else if (sel)
		back_color = BLACK;
	else
		back_color = WHITE;

	vsf_interior(Sys->VdiHandle, 1);
	vsf_color(Sys->VdiHandle, back_color);
	/* Remplissage intrieur du bouton */
	v_bar(Sys->VdiHandle, xy_bar);

	/* Dessin de l'objet : le cadre */
	if (flags)
	{
		xy_bar[0]++;
		xy_bar[4] = xy_bar[2];
		xy_bar[5] = xy_bar[1] +1;
		xy_bar[1] = xy_bar[3];
		vsl_color(Sys->VdiHandle, lb_color);
		/* Trace ligne basse et droite */
		v_pline(Sys->VdiHandle, 3, xy_bar);
		xy_bar[0]--; xy_bar[5]--;
		xy_bar[2] = xy_bar[0];
		xy_bar[3] = xy_bar[5];
		xy_bar[1]--;xy_bar[4]--;
		vsl_color(Sys->VdiHandle, lh_color);
		/* Trace ligne gauche et haute */
		v_pline(Sys->VdiHandle, 3, xy_bar);
	}

	/* Affichage de l'icone */
	fill_tab (pxy, 8,
						ZERO, ZERO, pic.fd_w - 1, pic.fd_h - 1,
						parmblock->pb_x + parmblock->pb_w - (16 / Coef), parmblock->pb_y,
						parmblock->pb_x + parmblock->pb_w - (16 / Coef) + pic.fd_w - 1,
						parmblock->pb_y + pic.fd_h - 1);

	color[0] = WHITE;
	color[1] = WHITE;
	vrt_cpyfm (Sys->VdiHandle, MD_TRANS, pxy, &msk, &nul, color);
	color[0] = BLACK;
	vrt_cpyfm (Sys->VdiHandle, MD_TRANS, pxy, &pic, &nul, color);

	/* Affichage du texte */
	texte = (char *) parmblock->pb_parm;
	vst_color (Sys->VdiHandle, BLACK);
	vst_effects (Sys->VdiHandle, ZERO);
	if (Sys->Yres < 399)
		ty += 2;
	v_gtext (Sys->VdiHandle, tx, ty, texte);
	vswr_mode(Sys->VdiHandle, MD_REPLACE);

	/* Supprimer le clipping */
	vs_clip (Sys->VdiHandle, FALSE, tab);

	return (parmblock->pb_currstate & ~SELECTED);
}

/*-----------------------------------------------------------------------*
 * Groupe...                                                             *
 *-----------------------------------------------------------------------*/
int cdecl group_button (PARMBLK *parmblock)
{
	int x, y, w, h, tx, ty;
	int back_color, lb_color, lh_color;
	register char *texte;
	int tab[4], xy_bar[8];

	vst_font (Sys->VdiHandle, 1);
	/* Dfinition et mise en place du clipping */
	fill_tab (tab, 4, parmblock->pb_xc, parmblock->pb_yc,
										parmblock->pb_wc + parmblock->pb_xc - 1,
										parmblock->pb_hc + parmblock->pb_yc - 1);
	vs_clip (Sys->VdiHandle, TRUE, tab);

	/* Rcupre les attributs et les coordonnes de l'objet */
	x = parmblock->pb_x;
	y = parmblock->pb_y;
	w = parmblock->pb_w;
	h = parmblock->pb_h;

	/* Position du texte */
	if (Sys->Xres <= 320)
		tx = x + 2;
	else
		tx = x + 4;
	if (Sys->Yres < 399)
		ty = y + 2;
	else
		ty = y + 4;

	xy_bar[0] = x; xy_bar[1] = y;
	xy_bar[2] = x + w - 1; xy_bar[3] = y + h - 1;

	vsf_interior(Sys->VdiHandle ,0);
	vswr_mode(Sys->VdiHandle, MD_TRANS);

	if (Sys->Nplane < 4)
		lh_color = BLACK;
	else
		lh_color = WHITE;
	back_color = PrivSys->color_3d1;
	lb_color = PrivSys->color_3d2;

	vsf_interior(Sys->VdiHandle, 1);
	vsf_color(Sys->VdiHandle, back_color);
	/* Remplir intrieur du bouton */
	v_bar(Sys->VdiHandle, xy_bar);

	xy_bar[0]++;
	xy_bar[4] = xy_bar[2];
	xy_bar[5] = xy_bar[1] +1;
	xy_bar[1] = xy_bar[3];
	vsl_color(Sys->VdiHandle, lh_color);
	/* Ligne basse et droite */
	v_pline(Sys->VdiHandle, 3, xy_bar);
	xy_bar[0]--; xy_bar[5]--;
	xy_bar[2] = xy_bar[0];
	xy_bar[3] = xy_bar[5];
	xy_bar[1]--;xy_bar[4]--;
	vsl_color(Sys->VdiHandle, lb_color);
	/* Ligne gauche et haute */
	v_pline(Sys->VdiHandle, 3, xy_bar);

	/* Pointe sur le texte */
	texte = (char *)parmblock->pb_parm;
	xy_bar[0] = x + 3; xy_bar[1] = y + 5 - Sys->Hchar;
	xy_bar[2] = xy_bar[0] + Sys->Wchar * strlen(texte) + 1; xy_bar[3] = xy_bar[1] + Sys->Hchar - 1;
	vsf_interior(Sys->VdiHandle, 1);
	vsf_color(Sys->VdiHandle, back_color);
	/* Remplir intrieur de l'objet */
	v_bar(Sys->VdiHandle, xy_bar);

	/* Ecriture du texte en relief */
	vst_color (Sys->VdiHandle, WHITE);
	v_gtext (Sys->VdiHandle, tx+1, ty+1, texte);
	vst_color (Sys->VdiHandle, BLACK);
	v_gtext (Sys->VdiHandle, tx, ty, texte);

	/* Supprimer le clipping */
	vs_clip (Sys->VdiHandle, FALSE, tab);

	return (parmblock->pb_currstate & ~SELECTED);
}

/*-=< Installation des boutons UserDefs >=-------------------------------*/

void set_user(OBJECT *addr_tree)
/*-----------------------------------------------------------------------*
 * Etablissement des boutons USERDEFS                                    *
 *-----------------------------------------------------------------------*/
{
	register int index = 1;								     /* Objet Racine + 1 */
	OBJECT *addr_obj;

	do
	{
		/* Pointe sur l'objet  traiter */
		addr_obj = &addr_tree[index];

		/* Si c'est un bouton */
		if ((addr_obj->ob_type & 0xff) == G_BUTTON)
		{
			switch (addr_obj->ob_type >> 8)
			{
				case POPUP_B :	/* Popup bouton */
					if (Sys->Yres < 399)
						addr_obj->ob_width += 8;
					else
						addr_obj->ob_width += 16;
					set_objc(addr_obj, popup_button);
					break;
				case RADIO_B :	/* Radio ou checkbox */
				case CHECK_B :
					if (Sys->Yres < 399)
						addr_obj->ob_width += 8;
					else
						addr_obj->ob_width += 16;
					set_objc(addr_obj, check_button);
					break;
				case UNDER_B :	/* petit texte ou raccourcis clavier */
				case SMALL_B :
					set_objc(addr_obj, under_button);
					break;
				case GROUP_B :	/* groupbox */
					set_objc(addr_obj, group_button);
					break;
			}
		}
		/* Initialiser les champs texte ditables */
		if (addr_obj->ob_flags & EDITABLE)
			strcpy((addr_obj->ob_spec.tedinfo)->te_ptext, "");

		/* Objet suivant */
		index ++;
	} while(! (addr_obj->ob_flags & LASTOB));
}

/*-----------------------------------------------------------------------*
 * Gestion des objets USERDEFS                                           *
 *-----------------------------------------------------------------------*/
static void set_objc(OBJECT *addr_obj, int cdecl (*code)(PARMBLK *parmblock))
{
	register int temp;
	register USERBLK *user;

	if ((user = (USERBLK *) malloc(sizeof(USERBLK))) != 0)
	{
		user->ub_code = code;
		addr_obj->ob_type = (addr_obj->ob_type & 0xff00) | G_USERDEF;
		user->ub_parm = (long) addr_obj->ob_spec.userblk;
		addr_obj->ob_spec.userblk = user;

/*-= Translation des flags 3D en ob_flags_11 et ob_flags_12. ===========-*/

		if ((temp = (addr_obj->ob_flags & ACTIVATOR)) != 0)
		{
			temp <<= 2;
			addr_obj->ob_flags = (addr_obj->ob_flags & ~ACTIVATOR) | temp;
		}
	}
}

/*-----------------------------------------------------------------------*/