/*************************************************************************
 * WgUtil.C                                                              *
 *                                                                       *
 * Module de dfinition des fonctions utilitaire de WindGem.             *
 *                                                                       *
 * Cration : 24 avril 1997                                              *
 *************************************************************************/
#include <time.h>
#include "WinProto.h"
#include "user.h"

/*-=< Dclaration des fonctions prives du module >=---------------------*/

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 * Gestion GEM.                                                          *
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
int obj_nb( register OBJECT *dial)
{
	register int racine = 0;

	while( !(dial[ racine].ob_flags & LASTOB))
		racine++;
	return( racine + 1);
}

OBJECT *ObjcDup( OBJECT *src)
{
	OBJECT *cpy;
	int obj_nb( OBJECT *);
	
	cpy = (OBJECT *)malloc(sizeof(OBJECT)*obj_nb( src));
	if( !cpy )
		return NULL;
	memcpy( cpy, src, sizeof(OBJECT)*obj_nb( src));
	return cpy;
}

/*************************************************************************
 * Duplication d'un arbre d'objets.                                      *
 *                                                                       *
 * Reprise d'EGEM220.                                                    *
 *************************************************************************/
OBJECT *copy_tree(OBJECT *tree)
{
	OBJECT *new;
	TEDINFO *nted;
	register OBJECT *obj=tree;
	register TEDINFO *ted;
	register char *d,*s;
	register long size=0,strsize=0;
	register	int i;

	for (;;)
	{
		size += sizeof(OBJECT);
		switch ((unsigned char) obj->ob_type)
		{
		case G_TEXT:
		case G_FTEXT:
		case G_BOXTEXT:
		case G_FBOXTEXT:
			ted = obj->ob_spec.tedinfo;
			strsize += sizeof(TEDINFO);
			strsize += ted->te_txtlen*2+ted->te_tmplen+3+1;
			strsize &= ~1;
			break;
		case G_STRING:
		case G_TITLE:
		case G_BUTTON:
			strsize += strlen(obj->ob_spec.free_string)+1+1;
			strsize &= ~1;
			break;
		}
		if (obj->ob_flags & LASTOB)
			break;
		obj++;
	}

	if ((new=(OBJECT *) calloc(1,size+strsize))!=NULL)
		for (memcpy(obj=new,tree,size),nted=(TEDINFO *) (((char *) new)+size);;)
		{
			switch ((unsigned char) obj->ob_type)
			{
			case G_TEXT:
			case G_FTEXT:
			case G_BOXTEXT:
			case G_FBOXTEXT:
				ted = obj->ob_spec.tedinfo;
				obj->ob_spec.tedinfo = nted;
				*nted = *ted;
				nted->te_ptext = d = (char *) &nted[1];
				for (s=ted->te_ptext,i=ted->te_txtlen;--i>=0;*d++=*s++);
				nted->te_ptmplt = d;
				for (s=ted->te_ptmplt,i=ted->te_tmplen;--i>=0;*d++=*s++);
				nted->te_pvalid = d;
				for (s=ted->te_pvalid,i=ted->te_txtlen;--i>=0;*d++=*s++);
				nted = (TEDINFO *) ((long) (d+1) & ~1);
				break;
			case G_STRING:
			case G_TITLE:
			case G_BUTTON:
				obj->ob_spec.free_string = d = strcpy((char *) nted,obj->ob_spec.free_string);
				nted = (TEDINFO *) ((long) (d+strlen(d)+1+1) & ~1);
				break;
			}
			if (obj->ob_flags & LASTOB)
				break;
			obj++;
		}
	return (new);
}

int parent (OBJECT *obj, int numObj)
/*-----------------------------------------------------------------------*
 * Recherche de l'objet pre d'un objet                                  *
 *-----------------------------------------------------------------------*/
{
	register int i;

	/* Partir de cet objet */
  i = numObj;
  do
  { /* Passer au suivant... */
	 i = obj[i].ob_next;
  } while (i > numObj); /* Jusqu'a revenir au pre. */

	/* Retourner le pre */
	return i;
}

int m_title (OBJECT *obj, int option)
/*-----------------------------------------------------------------------*
 * Rcuprer numero d'item menu                                          *
 *-----------------------------------------------------------------------*/
{
	register menu = 1, k = 2;
	int pere, titre;

	pere = parent (obj, option);
	/* Chercher 1 G_BOX */
	while (obj[(k++) + 1].ob_type != G_BOX) ;

	while (k != pere)
	{	/* Chercher menu correspondant */
		k = obj[k].ob_next;
		/* Les compter */
		menu++;
	}

	k = 3;
	do
	{	/* L'affecter */
		titre = k++;
	} while ((k - 3) != menu);

	return titre;
}

void set_clip (int clip_flag, GRECT *area)
/*-----------------------------------------------------------------------*
 * Fonction de mise en place d'un Clipping.                              *
 *-----------------------------------------------------------------------*/
{
	int pxy[4];

	pxy[0] = area->g_x;
	pxy[1] = area->g_y;
	pxy[2] = area->g_w + area->g_x - 1;
	pxy[3] = area->g_h + area->g_y - 1;
	vs_clip (Sys->VdiHandle, clip_flag, pxy);
}

int stdkey (unsigned char *k, int key)
/*-----------------------------------------------------------------------*
 * Gestion de la frappe d'une touche au clavier                          *
 *-----------------------------------------------------------------------*/
{
	KEYTAB *kt;

	kt = Keytbl((void *)-1, (void *)-1, (void *)-1);
	*k = toupper (kt->shift[(char)(key >> 8)]);

	return toupper (kt->shift[(char)(key >> 8)]);
}

char *get_text (OBJECT *adr, int object)
{
	int type;
	char *retour = "";

	type = adr[object].ob_type & 0xFF;	/* Lire le type de l'objet  */
																			/* en virant le type etendu */

	/* Si ob_spec d*signe le texte */
	if ((type == G_STRING) || (type == G_BUTTON))
		retour = (adr[object].ob_spec.free_string);
	/* Si ob_spec d*signe une structure TEDINFO */
	else if ((type == G_TEXT) || (type == G_BOXTEXT) || (type == G_FTEXT) || (type == G_FBOXTEXT))
		retour = (adr[object].ob_spec.tedinfo->te_ptext);
	else if (type == G_USERDEF)
		retour = ((char *)(adr[object].ob_spec.userblk->ub_parm));

	return retour;	/* Retourner pointeur sur la cha*ne */
}

void set_text (OBJECT *adr, int object, char *string)
{
	int type;

	type = adr[object].ob_type & 0xFF;	/* Lire le type de l'objet  */
																			/* en virant le type etendu */

	/* Si ob_spec d*signe le texte */
	if ((type == G_STRING) || (type == G_BUTTON))
		strcpy (adr[object].ob_spec.free_string, string);
	/* Si ob_spec d*signe une structure TEDINFO */
	else if ((type == G_TEXT) || (type == G_BOXTEXT) || (type == G_FTEXT) || (type == G_FBOXTEXT))
		strcpy (adr[object].ob_spec.tedinfo->te_ptext, string);
	else if (type == G_USERDEF)
		strcpy ((char *)(adr[object].ob_spec.userblk->ub_parm), string);
}

void get_bkgr (int of_x, int of_y, int of_w, int of_h, MFDB *img)
/*-----------------------------------------------------------------------*
 * Capture d'un fond.                                                    *
 *-----------------------------------------------------------------------*/
{
	int pxy[8];
	unsigned long taille;
	MFDB ecr={0};

	/* Prvoir une marge de scurit autour de l'objet */
	of_x -= 3;
	of_y -= 3;
	of_w += 5;
	of_h += 5;

	/* Taille tampon de copie fond */
	taille = ((((unsigned long)(of_w / 16L) + 1L) * 2L * (size_t)Sys->Nplane) * (size_t)of_h) + 256L;
	/* Rserver tampon */
	img->fd_addr = (FDADDR)lalloc (taille);
	/* Remplir la structure MFDB */
	img->fd_w = of_w;
	img->fd_h = of_h;
	img->fd_wdwidth = (of_w / 16) + ((of_w % 16) != 0);
	img->fd_stand = 1;
	img->fd_nplanes = Sys->Nplane;

	/* Remplir le tableau */
	pxy[0] = of_x;
	pxy[1] = of_y;
	pxy[2] = pxy[0] + of_w - 1;
	pxy[3] = pxy[1] + of_h - 1;
	pxy[4] = 0;
	pxy[5] = 0;
	pxy[6] = of_w - 1;
	pxy[7] = of_h - 1;
	/* Virer la souris */
	v_hide_c (Sys->VdiHandle);
	/* Copier l'image */
	vro_cpyfm (Sys->VdiHandle, S_ONLY, pxy, &ecr, img);
	/* Remet la souris */
	v_show_c (Sys->VdiHandle, TRUE);
}

void put_bkgr (int of_x, int of_y, int of_w, int of_h, MFDB *img)
/*-----------------------------------------------------------------------*
 * Reaffichage d'un fond.                                                *
 *-----------------------------------------------------------------------*/
{
	int pxy[8];
	MFDB ecr={0};

	/* Prvoir une marge de scurit autour de l'objet */
	of_x -= 3;
	of_y -= 3;
	of_w += 5;
	of_h += 5;

	/* Remplir le tableau */
	pxy[0] = 0;
	pxy[1] = 0;
	pxy[2] = of_w - 1;
	pxy[3] = of_h - 1;
	pxy[4] = of_x;
	pxy[5] = of_y;
	pxy[6] = pxy[4] + pxy[2] - 1;
	pxy[7] = pxy[5] + pxy[3] - 1;
	/* Cache la souris */
	v_hide_c (Sys->VdiHandle);
	/* Copier l'image  */
	vro_cpyfm (Sys->VdiHandle, S_ONLY, pxy, img, &ecr);
	/* Remet la souris */
	v_show_c (Sys->VdiHandle, TRUE);
	/* Libre la mmoire */
	free (img->fd_addr);
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 * Traitement des chaines de caractres.                                 *
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
char *trim (char *str)
/*-----------------------------------------------------------------------*
 * Suppression des espaces en debut et fin de chaine <str>               *
 *-----------------------------------------------------------------------*/
{
	register char *s;
	register int i = 0;
	char chaine[MAX_LEN];

  while (*(str + i) == ' ')
	 i++;
  strcpy (chaine, (str + i));

  s = chaine + strlen (chaine) - 1;
  for( ; (*s == ' ') && (s >= chaine) ; *s-- = 0);
  strcpy (str, chaine);

  return str;
}

char *strnpcpy(char *dest, char *start, char *stop)
/*-----------------------------------------------------------------------*
 * Fonction de bibliotheque : Copie dans "dest" la portion de chaine a   *
 * partir du pointeur "start", jusqu'au caractere place juste avant le   *
 * pointeur "stop". "start" et "stop" doivent obligatoirement pointer    *
 * dans la meme chaine. Dans tous les cas "dest" est terminee par le     *
 * caractere de fin de chaine '\0'.                                      *
 *-----------------------------------------------------------------------*/
{
	char *ptr_dest = dest;

	while (start < stop && (*(ptr_dest)++ = *(start++)) != 0);
	*ptr_dest = '\0';

	return dest;
}

char *strinsert (char *chaine, char *ch)
/* Ajoute <ch> avant <chaine> */
{
	char temp[256];

	strcpy(temp, chaine);
	strcpy(chaine, ch);
	strcat(chaine, temp);

	return chaine;
}

/*
Complete une chaine de caractere par des <car> avant ou apres
suivant <sens> (1 ou -1)
*/
char *strcomplete (char *chaine, int lng, char car, int where)
{
	int i;
	char ch[256];

	i = lng - strlen(chaine);

	if (i > 0)
	{
		ch[i] = '\0';
		while (i > 0)
			ch[--i] = car;

		switch (where)
		{
			case INS_BEG :
				strinsert(chaine, ch);
				break;
			case INS_END :
				strcat(chaine, ch);
				break;
		}
	}

	return chaine;
}

/*
Copy dans <res> de la sous-chaine commencant en position <deb>
et finissant par <fin> compris de la chaine <chaine>
*/
char *strcopy(char *res, char *chaine, int deb, int fin)
{
	int i = 0, l = strlen(chaine);

	if (deb < 0 || fin < 0 || fin < deb || deb > l || fin > l)
	{
		strcpy(res,"");
		return (char *)0;
	}

	while (deb <= fin && chaine[deb])
		res[i++] = chaine[deb++];

	res[i] = '\0';

	return res;
}

/*
Copy dans <res> de la sous-chaine commencant en position <deb>
et finissant par <fin> compris de la chaine <chaine>
Dans cette fonction <deb> et <fin> sont des entiers long.
*/
char *strlcopy(char *res, char *chaine, long deb, long fin)
{
	long i = 0L;
	long l = strlen(chaine);

	if (deb < 0L | fin < 0L || fin < deb || deb > l || fin > l)
	{
		strcpy(res,"");
		return (char *)0;
	}

	while (deb <= fin)
		res[i++] = chaine[deb++];

	res[i] = '\0';
	
	return res;	
}

char *strleft (char *res, char *chaine, int nb)
{
	return strcopy (res, chaine, 0, nb);
}

char *strright (char *res, char *chaine, int nb)
{
	register int taille = strlen(chaine);
  return strcopy (res, chaine, taille - nb, taille);
}

char *strmid (char *res, char *chaine, int deb, int nb)
{
	return strcopy (res, chaine, deb, deb + nb);
}

char *strchg(char *chaine, char old, char new)
/*-----------------------------------------------------------------------*
 * Remplacement de tous les caracteres <old> par <new> dans <chaine>     *
 * Concue le 7/6/1995                                                    *
 *-----------------------------------------------------------------------*/
/* change tous les caracteres <old> par <new> */
{
	int i = 0;
	
	while (chaine[i] != '\0')
	{
		if (chaine[i] == old)
			chaine[i] = new;
		i++;
	}
			
	return chaine;
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 * Gestions de fichiers.                                                 *
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
long exist (char *name, int att)
{
	int re;

	re = Fsfirst (name, att);
	/* Si rien n'est trouv, retourner FAUX */
	if ((re == -34) || (re == -33))
		return (FALSE);
	else
	{
		/* Si ce n'est pas un dossier, retourner la taille du fichier */
		if ((att & FA_SUBDIR) != FA_SUBDIR)
			return dtabuffer.d_length;
		else  /* Si existe, retourner VRAI */
			return (TRUE);
	}
}

/* path () Cherche et retourne le chemin de l'application :			*/
char *path (char *chemin)
{
	int drive;

	/* Lecteur courant */
	chemin[0] = 'A' + Dgetdrv ();
	chemin[1] = ':';
	/* Chemin lecteur courant */
	Dgetpath (&chemin[2], 0);
	strcat (chemin, "\\");
	return chemin;
}

int selector (char *path, char *ext, char *file, char *title)
{
	char ch[256], fi[13];
	int retour, i;

	strcpy (ch, path);
	/* Chemin et slection */
	strcat (ch, ext);
	strcpy (fi, file);
	/* Appel du slecteur */
	if ((Sversion () >> 8) <= 20)
		fsel_input (ch, fi, &retour);
	else
		fsel_exinput (ch, fi, &retour, title);
	/* Si pas ANNULER... */
	if (retour)
	{
		for (i = (int)strlen (ch) ; ch[i] != '\\' ; ch[i--] = '\0') ;
		strcpy (path, ch);
		strcpy (file, fi);
	}
	return retour;
}

/* extension () Ajuste extension :																*/
void extension (char *filename, char *ext)
{	/* L'EXTENSION DOIT ETRE TRANSMISE AVEC LE POINT */
	int t;

	/* Longueur du nom de fichier */
	t = (int)strlen (filename);
	/* Chercher le '.'  partir de la droite */
	while (filename[t] != '.' && t > ZERO)
		t--;

	/* Si trouv, ajouter l'extension  partir de l, sinon la concatner */
	if (t > ZERO)
	{
		memcpy (filename + t, ext, 4);
		filename[t + 4] = '\0';
	}
	else
		strcat (filename, ext);
}

void makeFileName(char *chemin, char *fic, char *fichier)
{
	char *pos;

	pos = strrchr(chemin,'\\');
	strnpcpy(fichier, chemin, pos + 1);
	strcat(fichier, fic);
}

char *getFileName(char *file, char *path)
/*-----------------------------------------------------------------------*
 * Recuperation du nom d'un fichier sans son extention ni son chemin     *
 *                                                                       *
 * entree : le nom complet chemin+nom+extension                          *
 * sortie : le nom du fichier                                            *
 *-----------------------------------------------------------------------*/
{
	int i = strlen(path);
	int j = 0;

	while (i>0 && path[i] != '.') i--;
	j = i;
	
	while (j>0 && path[i] != '\\') j--;
	if (j>0)
		j++;
		
	strcopy(file, path, j, i-1);
	
	return file;
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 * Autres fonctions.                                                     *
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

void DrawIcone (int handle, GRECT *zone)
/*-----------------------------------------------------------------------*
 * Affichage d'une icne dans une fentre iconifie                      *
 *-----------------------------------------------------------------------*/
{
	int xw, yw, ww, hw, pxy[4];
	GRECT r;

	/* Coordonnes zone de travail : */
	wind_get (handle, WF_WORKXYWH, &xw, &yw, &ww, &hw);
	/* Prparer effacement fentre */
	(PrivSys->AdrIcone)->ob_x = xw;
	(PrivSys->AdrIcone)->ob_y = yw;
	wind_get(handle, WF_FIRSTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
	while (r.g_w && r.g_h)
	{
		set_clip (1, &r); 	/* Clipping ON */

		if (rc_intersect(zone, &r))
		{
		  pxy[0] = r.g_x;
			pxy[1] = r.g_y;
	  	pxy[2] = r.g_x + r.g_w - 1;
			pxy[3] = r.g_y + r.g_h - 1;
			vsf_color(Sys->VdiHandle, WHITE);
			vr_recfl(Sys->VdiHandle, pxy);
			objc_draw(PrivSys->AdrIcone, ICONE, 1, r.g_x, r.g_y, r.g_w, r.g_h);
		}
		set_clip (0, &r); 	/* Clipping OFF */
		wind_get(handle, WF_NEXTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
	}
}


/* litdate () Lit la date systme ou fichier et conv. chane :		*/
void readDate (char *date, unsigned int fdate)
{
	int d, a, m, j;
	char ac[3], mc[3], jc[3];

	if (fdate == ZERO)
		d = Tgetdate ();
	else
		d = fdate;
	j = d & 0x1f;
	m = (d >> 5) & 0x0f;
	a = ((d >> 9) & 0x7f) + 80;

	itoa (j, jc, 10);
	if (strlen (jc) == 1)
	{
		jc[1] = jc[0];
		jc[0] = '0';
		jc[2] = '\0';
	}
	itoa (m, mc, 10);
	if (strlen (mc) == 1)
	{
		mc[1] = mc[0];
		mc[0] = '0';
		mc[2] = '\0';
	}
	itoa (a, ac, 10);
	if (strlen (ac) == 1)
	{
		ac[1] = ac[0];
		ac[0] = '0';
		ac[2] = '\0';
	}

	strcpy (date, jc);
	strcat (date, mc);
	strcat (date, ac);
}

/* convdate () Convertir date chane en valeur : 							*/
void convDate (char *date, unsigned int *fdate)
{
	int j, m, a, new_date = ZERO;
	char jc[3], mc[3], ac[3];

	jc[0] = date[0];
	jc[1] = date[1];
	jc[2] = '\0';

	mc[0] = date[2];
	mc[1] = date[3];
	mc[2] = '\0';

	ac[0] = date[4];
	ac[1] = date[5];
	ac[2] = '\0';

	j = atoi (jc);
	m = atoi (mc);
	a = atoi (ac) - 80;

	new_date |= j;
	new_date |= (m << 5);
	new_date |= (a << 9);

	*fdate = new_date;
}

char *getDate (char *time_string, int format, char sep)
/*-----------------------------------------------------------------------*
 * Recupere la date systeme et la renvoi sous un format predefini        *
 * format :	FRENCH_DATE 	JJMMAAAA                                       *
 *					ENGLISH_DATE  MMJJAAAA                                       *
 *          DOS_DATE      AAMMJJ                                         *
 *          US_DATE       AAAAMMJJ                                       *
 *          SYS_HEURE     hhmmss                                         *
 *-----------------------------------------------------------------------*/
{
	struct tm *date;
	char an[5], mois[3], jour[3];
	time_t temps;

	time(&temps);	

	date = localtime(&temps);

	if (format != DOS_DATE)
		itoa(1900 + date->tm_year,an,10);
	else
		itoa(date->tm_year,an,10);
	itoa(date->tm_mon + 1,mois,10);
	itoa(date->tm_mday,jour,10);

	switch(format)
	{
	case FRENCH_DATE :
		if (sep)
			sprintf(time_string,"%2s%c%2s%c%4s",jour,sep,mois,sep,an);
		else
			sprintf(time_string,"%2s%2s%4s",jour,mois,an);
		break;
	case ENGLISH_DATE :
		if (sep)
			sprintf(time_string,"%2s%c%2s%c%4s",mois,sep,jour,sep,an);
		else
			sprintf(time_string,"%2s%2s%4s",mois,jour,an);
		break;
	case US_DATE :
		if (sep)
			sprintf(time_string,"%4s%c%2s%c%2s",an,sep,mois,sep,jour);
		else
			sprintf(time_string,"%4s%2s%2s",an,mois,jour);
		break;
	case DOS_DATE :
		sprintf(time_string,"%2s%2s%2s",an,mois,jour);
		break;
	case SYS_TIME :
		if (sep)
			sprintf(time_string,"%2d%c%2d%c%2d",date->tm_hour,sep,date->tm_min,sep,date->tm_sec);
		else
			sprintf(time_string,"%2d:%2d:%2d",date->tm_hour,date->tm_min,date->tm_sec);
		break;
	}
	time_string = strchg(time_string,' ','0');
	
	return time_string;
}

long Atol16 (char *buf)
/*-----------------------------------------------------------------------*
 * Conversion d'une chaine de caractere en long signe                    *
 *                                                                       *
 * Entree : la chaine a covertir                                         *
 * Sortie : la valeur resultante                                         *
 *-----------------------------------------------------------------------*/
{
	int i = 0;
	long res = 0L;

	while (buf[i] && buf[i] == '0')
		i++;

	while (buf[i] && isxdigit(buf[i]))
	{
		if (buf[i] >= '0' && buf[i] <= '9')
			res = 16L * res + (buf[i] - '0');
		else
			res = 16L * res + (toupper(buf[i]) - 'A' + 10L);

		i++;
	}
	return res;		
}

UWORD Atoui16 (char *buf)
/*-----------------------------------------------------------------------*
 * Conversion d'une chaine de caractere en entier non signe              *
 *                                                                       *
 * Entree : la chaine a covertir                                         *
 * Sortie : la valeur resultante                                         *
 *-----------------------------------------------------------------------*/
{
	int i = 0;
	UWORD res = 0;

	while (buf[i] && buf[i] == '0')
		i++;
		
	while (buf[i] && isxdigit(buf[i]))
	{
		if (buf[i] >= '0' && buf[i] <= '9')
			res = 16 * res + (buf[i] - '0');
		else
			res = 16 * res + (toupper(buf[i]) - 'A' + 10);

		i++;
	}
	return res;		
}

unsigned long Atoul16 (char *buf)
/*-----------------------------------------------------------------------*
 * Conversion d'une chaine de caractere en long non signe                *
 *                                                                       *
 * Entree : la chaine a covertir                                         *
 * Sortie : la valeur resultante                                         *
 *-----------------------------------------------------------------------*/
{
	int i = 0;
	unsigned long res = 0L;

	while (buf[i] && buf[i] == '0')
		i++;

	while (buf[i] && isxdigit(buf[i]))
	{
		if (buf[i] >= '0' && buf[i] <= '9')
			res = 16L * res + (buf[i] - '0');
		else
			res = 16L * res + (toupper(buf[i]) - 'A' + 10L);

		i++;
	}
	return res;		
}

int is_digit(char *chaine)
{
	int i = 0, flag = TRUE;
	
	while (chaine[i] != '\0' && flag == TRUE)
	{
		if (! isdigit(chaine[i]))
			flag = FALSE;
		i++;
	}
	
	return flag;	
}

void fill_tab (int *pxy, int n, ...)
/*-----------------------------------------------------------------------*
 * Fonction de remplissage d'un tableau.                                 *
 *-----------------------------------------------------------------------*/
{
	int i, val;
	va_list pa;

	va_start (pa, n);
	for (i = ZERO ; i < n ; i++)
	{
		val = va_arg (pa, int);
		*(pxy + i) = val;
	}
	va_end (pa);
}

void StGuide(char *hypFile, char *node)
/*-----------------------------------------------------------------------*
 * StGuide - Fonction de gestion d'une aide en ligne au format ST-Guide  *
 *                                                                       *
 * Entre : Chemin + nom du fichier d'aide                               *
 *          Node St-Guide auquel il faut accder directement             *
 *-----------------------------------------------------------------------*/
{
	int msg[8], i;
	char HelpString[100];

	if ((i=appl_find("ST-GUIDE"))>=0)
	{
		/* Utilisation du protocole VA_START */
		msg[0] = VA_START;
		msg[1] = global[2];
		msg[2] = 0;
		sprintf(HelpString, "%s%s %s", Sys->AppPath, hypFile, node);
		*(char **)&msg[3] = HelpString;
		msg[5] = 0;
		msg[6] = 0;
		msg[7] = 0;
		appl_write(i, 16, msg);
	}
}

/**************************-=< Fin du module >=-**************************/