/*************************************************************************
 * WgWindow.C                                                            *
 *                                                                       *
 * Module de gestion des objets Wind.                                    *
 *                                                                       *
 * Cration : 26 mars 1997                                               *
 *************************************************************************/
#include "WinProto.h"

/*-=< Dfinition des variables prives de WindGem >=---------------------*/
Wind LstWnd[NBWIND];  				/* Liste des fentres (60 fentres max.)   */

/*************************************************************************
 * Dfinition des fonctions du module.                                   *
 *************************************************************************/

void RecaleWind (Wind *wind)
/*-----------------------------------------------------------------------*
 * Cette fonction permet de repositionner les objets Menu et Toolbar qui *
 * peuvent se trouver dans une fentre Wind ainsi que l'ventuel         *
 * formulaire qui peut s'y trouver.                                      *
 *-----------------------------------------------------------------------*/
{
	int wx, wy, ww, wh;
	Wg_FormWnd *ptr_dial;
	Wg_Coord *pos = wind->pos;

	/* Calcul des dimensions de la zone de travail de la fentre */
	wind_calc(WC_WORK, wind->attrib, pos->x, pos->y, pos->w, pos->h, &wx, &wy, &ww, &wh);

	/* Recaler l'ventuel formulaire qui se trouve dans la fentre */
	if (wind->adr_wdialog)
	{
		ptr_dial = wind->dialog;
		wind->adr_wdialog->ob_x = wx + ptr_dial->offset;
		wind->adr_wdialog->ob_y = wy + ptr_dial->offset;
	}

	/* Recaler le menu s'il y en a un */
	if (wind->adr_wmenu)
	{
		wind->adr_wmenu->ob_x = wx;
		wind->adr_wmenu->ob_y = wy;
		/* Recaler formulaire  cause du menu */
		if (wind->adr_wdialog)
		{
			wind->adr_wdialog->ob_y += wind->adr_wmenu[BARTITLE].ob_height + 2;
			wind->adr_wmenu->ob_y += ptr_dial->offset;
		}
	}
	/* Recaler la bote  outils s'il y en a une */
	if (wind->adr_wtoolbar)
	{
		/* Recaler le formulaire cause bote  outils */
		if (wind->adr_wdialog)
			wind->adr_wdialog->ob_y += wind->adr_wtoolbar->ob_height + 2;
		wind->adr_wtoolbar->ob_x = wx;
		wind->adr_wtoolbar->ob_y = wy;
		wind->adr_wtoolbar->ob_width = ww + 1;

		/* Recaler bote  outils et formulaire s'il y a un dj un menu */
		if (wind->adr_wmenu)
		{
			wind->adr_wtoolbar->ob_y += wind->adr_wmenu[BARTITLE].ob_height + 1;
			if (wind->adr_wdialog || global[1] == 1)
				wind->adr_wtoolbar->ob_y ++;
		}
		/* Sinon recaler formulaire */
		else if (wind->adr_wdialog)
			wind->adr_wdialog->ob_y -= 2;
	}
	/* Recadrage du formulaire en fonction de la composition de la fentre */
	if (wind->adr_wdialog && wind->adr_wmenu && wind->adr_wtoolbar)
		wind->adr_wdialog->ob_y -= 2;
	if (wind->adr_wdialog && wind->adr_wmenu && (! wind->adr_wtoolbar) && global[1] == 1)
		wind->adr_wdialog->ob_y++;
}

/*-----------------------------------------------------------------------*
 * Retourne l'objet Wind associ a l'objet <numObj>, NULL sinon          *
 *-----------------------------------------------------------------------*/
Wind *ObjListe(int numWnd)
{
	register int i = 0;

	if (numWnd != BLANK)
	{
		while (i < NBWIND)
		{
			if (LstWnd[i].numWnd == numWnd)
				return &LstWnd[i];
			i++;
		}
	}
	return WIND_NULL;
}

/*-----------------------------------------------------------------------*
 * Retourne l'objet de handle <handle> donne, NULL sinon                 *
 *-----------------------------------------------------------------------*/
Wind *TopListe(int handle)
{
	register int i = 0;

	while (i < NBWIND)
	{
		if (LstWnd[i].handle == handle)
			return &LstWnd[i];
		i++;
	}
	return WIND_NULL;
}

Wnd NewWind (int type)
/*-----------------------------------------------------------------------*
 * Cration d'un nouvel objet Wind de type <type>.                       *
 *                                                                       *
 * Retourne le numro de l'objet cr, BLANK sinon.                      *
 *-----------------------------------------------------------------------*/
{
	register int numWnd = 0;
	Wg_Coord *coord = (Wg_Coord *)malloc(sizeof(Wg_Coord));

	while (numWnd < NBWIND && LstWnd[numWnd].numWnd != BLANK) numWnd++;
	if (numWnd == NBWIND)
		return BLANK;

/*=-=-=-=-= Proprits de l'objet =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
	/* Numro et type de l'objet */
	LstWnd[numWnd].numWnd		= numWnd;
	LstWnd[numWnd].type			= type;

	/* Attributs de la fentre associe */
	if (type == WndForm)
		LstWnd[numWnd].attrib	= ATTRIB_FORM;
	else if (type != WndDesk)
		LstWnd[numWnd].attrib	= ATTRIB_ALL;
	else /* Pas d'attribut pour le bureau */
		LstWnd[numWnd].attrib	= BLANK;

	/* Handle de la fentre au dpart et flag plein cran */
	if (type == WndDesk)
	{
		LstWnd[numWnd].handle	= 0;
		LstWnd[numWnd].full		= TRUE;
	}
	else
	{
		LstWnd[numWnd].handle	= BLANK;
		LstWnd[numWnd].full		= FALSE;
	}

	/* Pas de titre au dpart */
	LstWnd[numWnd].title = (char *)NULL;
	/* Pas de barre d'info */
	LstWnd[numWnd].info = (char *)NULL;

	/* Pas iconifie au dpart */
	LstWnd[numWnd].iconified	= FALSE;

	/* Dimension de l'objet au dpart */
	coord->x					= 20;
	coord->y					= 20;
	coord->w					= 200;
	coord->h					= 100;
	coord->minW				= BLANK;
	coord->minH				= BLANK;
	coord->maxW				= BLANK;
	coord->maxH				= BLANK;
	LstWnd[numWnd].pos 	= coord;

	LstWnd[numWnd].slider = (Wg_Slider *)NULL;

	/* Contenu de la fentre */
	LstWnd[numWnd].dialog		= (Wg_FormWnd *)NULL;
	LstWnd[numWnd].text			= (char **)NULL;

	if (type == WndGrap)
		LstWnd[numWnd].image			 = (MFDB **)NULL;
  
	/* Autre objets de la fentre */
	LstWnd[numWnd].adr_wdialog	= (OBJECT *)NULL;
	LstWnd[numWnd].adr_wmenu 		= (OBJECT *)NULL;
	LstWnd[numWnd].adr_wtoolbar	= (OBJECT *)NULL;
	LstWnd[numWnd].adr_wpopup		= (OBJECT *)NULL;
	LstWnd[numWnd].var					= (void *)NULL;
	LstWnd[numWnd].help					= (Wg_Help *)NULL;
	LstWnd[numWnd].popup				= (Wg_Popup *)NULL;
	LstWnd[numWnd].timer				= (Wg_Timer *)NULL;

/*=-=-=-=-= Mthodes de l'objet =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
	LstWnd[numWnd].Wg_OnMessage		= (void *)NULL;
	LstWnd[numWnd].Wg_OnKeyboard	= (void *)NULL;
	LstWnd[numWnd].Wg_OnButton		= (void *)NULL;
	LstWnd[numWnd].Wg_OnKeySpec		= (void *)NULL;
	LstWnd[numWnd].Wg_OnTimer			= (void *)NULL;
	LstWnd[numWnd].Wg_OnObject		= (void *)NULL;
	LstWnd[numWnd].Wg_OnMenu			= (void *)NULL;
	LstWnd[numWnd].Wg_OnToolbar		= (void *)NULL;
	LstWnd[numWnd].Wg_OnPopup			= (void *)NULL;

	/* Fin de l'initialisation */
	return numWnd;
}

/*-----------------------------------------------------------------------*
 * Destruction d'un objet donn.                                         *
 *-----------------------------------------------------------------------*/
void DeleteWind (Wnd numWnd)
{
	Wind *wind;

	/* Rcupre la description de l'objet */
	wind = ObjListe (numWnd);
	/* Si introuvable, fin du traitement */
	if (! wind)
		return;

	/* Si fentre actuellement ouverte, on la ferme */
	if (wind->handle > 0)
		WindClose(numWnd);

	/* Cas de l'objet bureau */
	if (wind->type == WndDesk)
	{
		if (wind->adr_wmenu)
			menu_bar (wind->adr_wmenu, 0);
		WndMenu = BLANK;
	  wind_set (0, WF_NEWDESK, 0, 0);						/* Rendre le bureau        */
	}

	/* Dtruire le numro de l'objet et le titre */
	wind->numWnd = BLANK;
	free (wind->title);
	free (wind->info);
	/* Libration de la mmoire coordonnes */
	free (wind->pos);
	free (wind->slider);
	
	/* Suppression du contenu de la fentre */
	if (wind->type == WndForm)
		free (wind->dialog);
	else if (wind->type == WndGrap)
	{
		/* Librer la mmoire de l'image */
		if (wind->image)
		{
			free (wind->image->fd_addr);
			free (wind->image);
		}
	}
	else if (wind->type == WndText)
	{	/* Librer la mmoire du texte */
		free (wind->text);
	}

	/* Suppression des objets composant la fentre */
	free (wind->adr_wdialog);
	free (wind->adr_wmenu);
	free (wind->adr_wtoolbar);
	free (wind->adr_wpopup);
	free (wind->var);

	/* Virer message d'aide */
	if (wind->help)
	{
		register Wg_Help *help = wind->help, *tmp;

		while (help)
		{
			tmp = help;
			help = help->next;
			free (tmp->txt);
			free (tmp);
		}
	}
	/* Virer associations objet/popup */
	if (wind->popup)
	{
		register Wg_Popup *popup = wind->popup, *tmp;

		while (popup)
		{
			tmp = popup;
			popup = popup->next;
			free (tmp->obj);
			free (tmp);
		}
	}
	/* Virer Timer */
	if (wind->timer)
	{
		register Wg_Timer *timer = wind->timer, *tmp;

		while (timer)
		{
			tmp = timer;
			timer = timer->next;
			free (tmp);
		}
	}
}

/*-----------------------------------------------------------------------*
 * Ouverture d'une fentre donne avec le mode <mode> (WndMODAL/WndNORM).*
 *-----------------------------------------------------------------------*/
void WindOpen (Wnd numWnd, int mode)
{
	Wind *wind;
	OBJECT *ptr_objc;
	Wg_Evnt Evnt;

	if (PrivSys->lastMode == WndMODAL)
		return;
	
	/* Rcupre objet fentre */
	wind = ObjListe(numWnd);
	if (wind && wind->type != WndDesk)
	{
		/* Si fentre dj ouverte, on la passe au premier plan */
		if (wind->handle != BLANK)
			wind_set(wind->handle, WF_TOP);
		else
		{
			Wg_Coord pos;
			Wg_GetCoord (numWnd, &pos);

			wind->handle = wind_create (wind->attrib, pos.x, pos.y, pos.w, pos.h);
			if (wind->handle)
			{
				RecaleWind (wind);
				if (wind->title)
					wind_set (wind->handle, WF_NAME, wind->title);
				graf_growbox (0, 0, 0, 0, pos.x, pos.y, pos.w, pos.h);
				wind_open (wind->handle, pos.x, pos.y, pos.w, pos.h);
				if (wind->attrib & INFO)
					wind_set (wind->handle, WF_INFO, wind->info, 0, 0);

				switch(wind->type)
				{
					case WndForm :
						if (wind->dialog)
						{
							wind->dialog->edit_objc = wind->dialog->edit;
							ptr_objc = &(wind->adr_wdialog[wind->dialog->edit]);
							if ((ptr_objc->ob_flags & EDITABLE) != 0)
								wind->dialog->edit_pos = (int)strlen((ptr_objc->ob_spec.tedinfo)->te_ptext);
						}
						break;

					case WndGrap :
					case WndText :
					case WndUser :
						Wg_Sliders (wind);
						break;
				}
				/* Fentre modale -> on dsactive le menu et les vnements WM_TOPPED */
				if (mode == WndMODAL && WndMenu != BLANK)
				{
					register int index = 3;

					wind->mode = WndMODAL;
					PrivSys->lastMode = WndMODAL;
					/* Dsactiver tous les item menu */
					while (LstWnd[WndMenu].adr_wmenu[index++].ob_type == G_TITLE)
						LstWnd[WndMenu].adr_wmenu[index].ob_state |= DISABLED;
					while(LstWnd[WndMenu].adr_wmenu[index].ob_type != G_STRING)
						index++;
					LstWnd[WndMenu].adr_wmenu[index].ob_state |= DISABLED;

					/* Rafficher barre menu */
					menu_bar (LstWnd[WndMenu].adr_wmenu, 1);
				}
				else
					wind->mode == WndNORM;

				/* Envoi de l'vnement OPEN a la fentre */
				if (wind->Wg_OnMessage)
				{
					Evnt.evnt	= EvntOpen;
					Evnt.wnd	= numWnd;
					(*wind->Wg_OnMessage)(&Evnt);
				}
			}
			else
				form_alert(1, "[1][Plus de fentres disponibles !!][Ok]");
		}
	}
}

/*-----------------------------------------------------------------------*
 * Fermeture d'une fentre donne.                                       *
 *-----------------------------------------------------------------------*/
void WindClose (Wnd numWnd)
{
	Wind *wind;
	Wg_Coord pos;
	Wg_Evnt Evnt;

	Wg_GetCoord (numWnd, &pos);

	wind = ObjListe (numWnd);
	if (wind && wind->type != WndDesk)
	{
		/* ractive le menu et les vnements WM_TOPPED */
		if (wind->mode == WndMODAL && WndMenu != BLANK)
		{
			register int index = 3;

			PrivSys->lastMode = WndNORM;

			/* Ractivation de tous les item menu */
			while (LstWnd[WndMenu].adr_wmenu[index++].ob_type == G_TITLE)
				LstWnd[WndMenu].adr_wmenu[index].ob_state &= ~DISABLED;
			while(LstWnd[WndMenu].adr_wmenu[index].ob_type != G_STRING)
				index++;
			LstWnd[WndMenu].adr_wmenu[index].ob_state &= ~DISABLED;

			/* Raffichage du menu */
			menu_bar (LstWnd[WndMenu].adr_wmenu, 1);
		}
		/* Fermeture et destruction de la fentre */
		wind_close(wind->handle);
		wind_delete(wind->handle);
		graf_shrinkbox(0, 0, 0, 0, pos.x, pos.y, pos.w, pos.h);
		wind->handle = BLANK;
		if (wind->Wg_OnMessage)
		{
			Evnt.evnt = EvntClosed;
			Evnt.wnd  = numWnd;
			(*wind->Wg_OnMessage)(&Evnt);
		}
	}
}

/*-----------------------------------------------------------------------*
 * Rcupration des coordonnes d'une fentre dans <coord>.              *
 *-----------------------------------------------------------------------*/
void Wg_GetCoord (Wnd numWnd, Wg_Coord *coord)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind)
		memcpy (coord, wind->pos, sizeof(Wg_Coord));
}

/*-----------------------------------------------------------------------*
 * Modification des coordonnes d'une fentre avec <coord>.              *
 *-----------------------------------------------------------------------*/
void Wg_SetCoord (Wnd numWnd, Wg_Coord *coord)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind && wind->type != WndForm)
	{
/*		memcpy (wind->pos, coord, sizeof(Wg_Coord));*/
		wind->pos->x = coord->x;
		wind->pos->y = coord->y;
		if (wind->type != WndForm)
		{
			wind->pos->w = coord->w;
			wind->pos->h = coord->h;
			wind->pos->minW = coord->minW;
			wind->pos->minH = coord->minH;
		}
		if (wind->type != WndGrap)
		{
			wind->pos->maxH = coord->maxH;
			wind->pos->maxW = coord->maxW;
		}

		/* Recaler les composants de la fentre */
		RecaleWind (wind);
		/* Envoyer message de redimensionnement de la fentre */
		if (wind->handle > 0)
			SendMessage (Sys->AppId, WM_SIZED, 0, wind->handle, coord->x, coord->y, coord->w, coord->h);
	}
}

/*-----------------------------------------------------------------------*
 * Renvoie le handle d'une fentre, -1 si erreur                         *
 *-----------------------------------------------------------------------*/
int Wg_GetHandle (Wnd numWnd)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind)
		return wind->handle;
	return -2;
}

/*-----------------------------------------------------------------------*
 * Met  jour la barre d'info d'une fentre                              *
 *-----------------------------------------------------------------------*/
void Wg_SetInfo (Wnd numWnd, char *txt)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind && txt)
	{
		free (wind->info);
		wind->info = (char *)malloc (sizeof(char) * (strlen(txt) + 1));
		if (wind->info)
		{
			strcpy (wind->info, txt);
			if (wind->handle)
				wind_set (wind->handle, WF_INFO, txt, 0, 0);
		}
	}
}

/*-----------------------------------------------------------------------*
 * Rcupre le texte de la barre d'info d'une fentre                    *
 *-----------------------------------------------------------------------*/
void Wg_GetInfo (Wnd numWnd, char *txt)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind)
		strcpy (txt, wind->info);
}

/*-----------------------------------------------------------------------*
 * Met  jour le handle d'une fentre                                    *
 *-----------------------------------------------------------------------*/
void Wg_SetHandle (Wnd numWnd, int handle)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind)
		wind->handle = handle;
}

/*-----------------------------------------------------------------------*
 * Renvoie les attributs d'une fentre, -1 si erreur                     *
 *-----------------------------------------------------------------------*/
int Wg_GetAttrib (Wnd numWnd)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind)
		return wind->attrib;
	return BLANK;
}

/*-----------------------------------------------------------------------*
 * Met  jour les attributs d'une fentre.                               *
 *-----------------------------------------------------------------------*/
void Wg_SetAttrib (Wnd numWnd, int attrib)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind && wind->type == WndUser)
	{
		wind->attrib = attrib;
		if (wind->handle > 0)
			wind_set (WF_KIND, wind->attrib);
	}
}

/*-----------------------------------------------------------------------*
 * Rtourne VRAI si une fentre est iconifie, FAUX si non, -1 si erreur *
 *-----------------------------------------------------------------------*/
Bool Wg_IsIconified (Wnd numWnd)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind)
	{
		if (wind->iconified)
			return TRUE;
		else
			return FALSE;
	}
	return BLANK;
}

/*-----------------------------------------------------------------------*
 * Iconification force d'une fentre (non certifie,  tester).         *
 *-----------------------------------------------------------------------*/
/*
void Wg_SetIconified (Wnd numWnd)
{
	Wind *wind;

	if (numWnd > 0)
	{
		wind = ObjListe (numWnd);
		if (wind)
		{
			if (wind->handle > 0)
				SendMessage (Sys->AppId, WM_ICONIFY, 0, wind->handle, wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h);
		}
	}
}
*/
/*-----------------------------------------------------------------------*
 * Retourne un POINTEUR sur le titre d'une fentre, NULL si erreur.      *
 *-----------------------------------------------------------------------*/
char *Wg_GetTitle (Wnd numWnd)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind)
		return wind->title;

	return (char *)NULL;
}

/*-----------------------------------------------------------------------*
 * Associe un titre avec une fentre.                                    *
 *-----------------------------------------------------------------------*/
void Wg_SetTitle (Wnd numWnd, char *title)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind && title)
	{
		free (wind->title);
		wind->title = (char *)malloc ((strlen(title) + 1) * sizeof(char));
		strcpy (wind->title, title);
		if (wind->handle > 0)
			wind_set (wind->handle, WF_NAME, wind->title);
	}
}

/*-----------------------------------------------------------------------*
 * Paramtrage des ascenseurs d'une fentre utilisateur                  *
 *-----------------------------------------------------------------------*/
void Wg_SetSliders (Wnd numWnd, int scaleH, int posH, int offH, int scaleW, int posW, int offW)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind)
	{
		if (! wind->slider)
			wind->slider = (Wg_Slider *)malloc (sizeof(Wg_Slider));

		wind->slider->scaleH = scaleH;
		wind->slider->posH = posH;
		wind->slider->offH = offH;
		wind->slider->scaleW = scaleW;
		wind->slider->posW = posW;
		wind->slider->offW = offW;

		/* Met  jour l'affichage des ascenseurs si fentre ouverte */
		if (wind->handle > 0)
			Wg_Sliders (wind);
	}
}

void Wg_GetSliderPos (Wnd numWnd, int *posH, int *posW)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind && wind->slider)
	{
		*posH = wind->slider->posH;
		*posW = wind->slider->posW;
	}
}

void Wg_SetSliderPos (Wnd numWnd, int posH, int posW)
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind && wind->slider)
	{
		wind->slider->posH = posH;
		wind->slider->posW = posW;
		
		if (wind->handle > 0)
			Wg_Sliders (wind);
	}
}

/*-----------------------------------------------------------------------*
 * Rcupre dans <coord> les coordonnes XYWH de la zone de travail      *
 * d'une fentre, retourne NULL si erreur.                               *
 *-----------------------------------------------------------------------*/
void Wg_GetWorkXYWH (Wnd numWnd, GRECT *coord)
{
	Wind *wind;

	wind = ObjListe(numWnd);
	if (wind && wind->handle != BLANK)
	{
		wind_get(wind->handle, WF_WORKXYWH, &(coord->g_x), &(coord->g_y), &(coord->g_w), &(coord->g_h));
		if (wind->adr_wmenu)
		{
			coord->g_y += wind->adr_wmenu[BARTITLE].ob_height + 1;
			coord->g_h -= wind->adr_wmenu[BARTITLE].ob_height + 1;
		}
		if (wind->adr_wtoolbar)
		{
			coord->g_y += wind->adr_wtoolbar[ROOT].ob_height + 2;
			coord->g_h -= wind->adr_wtoolbar[ROOT].ob_height + 2;
		}
		if (wind->adr_wmenu && wind->adr_wtoolbar && global[1] == 1)
		{
			coord->g_y++;
			coord->g_h--;
		}
		else if (wind->adr_wtoolbar && global[1] > 1)
		{
			coord->g_y -= 2;
			coord->g_h += 2;
		}
	}
	else
		coord = (GRECT *)NULL;
}

/*-----------------------------------------------------------------------*
 * Renvoie un pointeur sur la structure "var" d'une fentre.             *
 *-----------------------------------------------------------------------*/
void *Wg_GetUserVar (Wnd numWnd)
{
	void *var;
	Wind *wind;

	wind = ObjListe(numWnd);
	if (wind)
		var = wind->var;
	else
		var = (void *)NULL;

	return var;
}

/*-----------------------------------------------------------------------*
 * Met  jour la structure "var" d'un objet.                             *
 *-----------------------------------------------------------------------*/
void Wg_SetUserVar (Wnd numWnd, void *var)
{
	Wind *wind;
	void **ptr_var;

	wind = ObjListe(numWnd);
	if (wind)
	{
		ptr_var = &(wind->var);
		*ptr_var = var;
	}
}

/*-----------------------------------------------------------------------*
 * Association des mthodes ...                                          *
 *-----------------------------------------------------------------------*/
void Wg_SetEvent (Wnd numWnd, int evnt, void (*Wg_OnEvnt)(Wg_Evnt *evnt))
{
	Wind *wind;

	wind = ObjListe (numWnd);
	if (wind)
	{
		switch (evnt)
		{
			case EvntAll :
				wind->Wg_OnKeyboard = Wg_OnEvnt;
				wind->Wg_OnKeySpec = Wg_OnEvnt;
				wind->Wg_OnButton = Wg_OnEvnt;
				wind->Wg_OnTimer = Wg_OnEvnt;
				wind->Wg_OnMessage = Wg_OnEvnt;
				wind->Wg_OnObject = Wg_OnEvnt;
				wind->Wg_OnMenu = Wg_OnEvnt;
				wind->Wg_OnToolbar = Wg_OnEvnt;
				wind->Wg_OnPopup = Wg_OnEvnt;
				break;
			case EvntKeyboard :
				wind->Wg_OnKeyboard = Wg_OnEvnt;
				break;
			case EvntKeySpec :
				wind->Wg_OnKeySpec = Wg_OnEvnt;
				break;
			case EvntButton :
				wind->Wg_OnButton = Wg_OnEvnt;
				break;
			case EvntTimer :
				wind->Wg_OnTimer = Wg_OnEvnt;
				break;
			case EvntMessage :
				wind->Wg_OnMessage = Wg_OnEvnt;
				break;
			case EvntObject :
				wind->Wg_OnObject = Wg_OnEvnt;
				break;
			case EvntMenu :
				wind->Wg_OnMenu = Wg_OnEvnt;
				break;
			case EvntToolbar :
				wind->Wg_OnToolbar = Wg_OnEvnt;
				break;
			case EvntPopup :
				wind->Wg_OnPopup = Wg_OnEvnt;
				break;
		}
	}
}

void Wg_ResetEvent (Wnd numWnd, int evnt)
{
	Wg_SetEvent (numWnd, evnt, (void *)NULL);
}

/**************************-=< Fin du module >=-**************************/
