/*************************************************************************ff
 * WgWndObj.C                                                            *
 *                                                                       *
 * Module de gestion des composants d'un objet Wind.                     *
 *                                                                       *
 * Cration : 16 avril 1997                                              *
 *************************************************************************/
#include "WinProto.h"

/*-=< Dfinition des variables prives de WindGem >=---------------------*/

/*-=< Dclaration des fonctions prives du module >=---------------------*/

/*************************************************************************
 * Dfinition des fonctions du module.                                   *
 *************************************************************************/

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Formulaire en fentre ...                                             */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
void Wg_SetDialog	(Wnd numWnd, int tree, int edit)
/* Associer un formulaire avec une fentre...                            */
{
	int wx, wy, ww, wh;
	Wg_FormWnd *ptr_dial;
	OBJECT *ptr_obj;
	Wind *wind;

	wind = ObjListe(numWnd);
	if (wind)
	{
		/* Allocation mmoire pour objet formulaire */
		ptr_dial = (Wg_FormWnd *)malloc(sizeof(Wg_FormWnd));

		/* Rcupration de l'adresse du formulaire */
		rsrc_gaddr(R_TREE, tree, &ptr_obj);

		/* Initialisation des variables associes  l'objet formulaire */
		if (ptr_obj->ob_state & OUTLINED)	/* dcalage invariable ! */
			ptr_dial->offset = 3;
		else
		{
			if (global[1] > 1) /* Si Multitache */
				ptr_dial->offset = 1; /* surtout pour Magic */
			else
				ptr_dial->offset = 0;
		}
		ptr_dial->edit	  	= edit;
		ptr_dial->edit_objc	= edit;
		ptr_dial->edit_pos 	= 0;

		/* Calcul des dimension de la fentre */
		form_center(ptr_obj, &wx, &wy, &ww, &wh);
		wind_calc(WC_BORDER, ATTRIB_FORM, wx, wy, ww, wh, &wx, &wy, &ww, &wh);

		wind->pos->x = wx;
		wind->pos->y = wy;
		wind->pos->w = ww;
		wind->pos->h = wh;
		wind->pos->minW = wind->pos->maxW = ww;
		wind->pos->minH = wind->pos->maxH = wh;

		/* Etablissement des boutons USERDEFS. */
		set_user(ptr_obj);

		/* Association de l'object GEM */
		wind->adr_wdialog = ptr_obj;

		/* Association de l'objet formulaire */
		wind->dialog = ptr_dial;
	}
}

OBJECT *Wg_GetObject (Wnd numWnd, int typObj)
{
	Wind *wind;
	OBJECT *obj = (OBJECT *)NULL;

	wind = ObjListe (numWnd);
	if (wind)
	{
		if (typObj == ObjForm)
			obj = wind->adr_wdialog;
		else if (typObj == ObjTBar)
			obj = wind->adr_wtoolbar;
		else if (typObj == ObjMenu)
			obj = wind->adr_wmenu;
		else if (typObj == ObjPopup)
			obj = wind->adr_wpopup;
	}	
	return obj;
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Menu ...                                                              */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
void Wg_SetMenu (Wnd numWnd, int tree)
/* Associer un menu avec une fentre...                                  */
{
	Wind *wind;
	OBJECT *win_menu;

/* Penser  traiter le cas du menu principal de l'application */

	wind = ObjListe(numWnd);
	if (wind && tree >= 0 && (! wind->adr_wmenu))
	{
		/* Rcupre l'adresse de l'objet menu */
		rsrc_gaddr (R_TREE, tree, &win_menu);

		/* Fonction de gestion du menu */
		if (wind->adr_wmenu = copy_tree(win_menu));
		{
			/* Pas de trame, cadre 1 pixel vers l'ext*rieur */
			wind->adr_wmenu[BARMENU].ob_spec.index = 0xFF1101L;

			if (wind->type == WndForm)
				wind->pos->h += wind->adr_wmenu[BARTITLE].ob_height;

			/* Recaler les composants de la fentre */
			if (wind->type != WndDesk)
				RecaleWind(wind);
			else /* activer menu principal */
				menu_bar (wind->adr_wmenu, 1);

			if (wind->handle > 0)
				wind_set(wind->handle, WF_CURRXYWH, wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h);
		}
	}
}

void Wg_ResetMenu (Wnd numWnd)
/* Supprimer le menu d'une fentre...                                    */
{
	Wind *wind;

	wind = ObjListe(numWnd);
	if (wind && wind->adr_wmenu)
	{
		if (wind->type == WndForm)
			wind->pos->h -= wind->adr_wmenu[BARTITLE].ob_height;

		free(wind->adr_wmenu);
		wind->adr_wmenu = (OBJECT *)NULL;

		/* Recaler les composants de la fentre */
		if (wind->type != WndDesk)
			RecaleWind (wind);
		else /* Virer menu principal */
			menu_bar (wind->adr_wmenu, 0);

		if (wind->handle > 0)
		{
			wind_set(wind->handle, WF_CURRXYWH, wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h);
			SendMessage (Sys->AppId, WM_REDRAW, 0, wind->handle, wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h);
		}
	}
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Bote  Outils ...                                                    */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
void Wg_SetToolbar (Wnd numWnd, int tree)
/* Associer une bote  outils avec une fentre...                       */
{
	Wind *wind;
	OBJECT *win_toolbar;

	wind = ObjListe(numWnd);
	if (wind && wind->type != WndDesk && tree >= 0 && (! wind->adr_wtoolbar))
	{
		/* Rcupre l'adresse de l'objet toolbar */
		rsrc_gaddr (R_TREE, tree, &win_toolbar);

		/* Fonction de gestion du menu */
		if (wind->adr_wtoolbar = copy_tree(win_toolbar));
		{	/* Modifier attributs racine ToolBar */
			set_user(wind->adr_wtoolbar);

			wind->adr_wtoolbar->ob_state &= ~OUTLINED;					/* Pas Outline */
			wind->adr_wtoolbar->ob_spec.obspec.framesize = 1;		/* Cadre : 1 vers l'extrieur */
			wind->adr_wtoolbar->ob_spec.obspec.textmode = 1;		/* Objet racine opaque */
			wind->pos->h += wind->adr_wtoolbar[ROOT].ob_height;

			/* Recaler les composants de la fentre */
			RecaleWind(wind);

			if (wind->handle > 0)
				wind_set(wind->handle, WF_CURRXYWH, wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h);
		}
	}
}

void Wg_ResetToolbar (Wnd numWnd)
/* Supprimer la bote  outils d'une fentre...                          */
{
	Wind *wind;

	wind = ObjListe(numWnd);
	if (wind && wind->adr_wtoolbar)
	{
		if (wind->type == WndForm)
			wind->pos->h -= wind->adr_wtoolbar[ROOT].ob_height;

		free(wind->adr_wtoolbar);
		wind->adr_wtoolbar = (OBJECT *)NULL;

		/* Recaler les composants de la fentre */
		RecaleWind (wind);

		if (wind->handle > 0)
		{
			wind_set(wind->handle, WF_CURRXYWH, wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h);
			SendMessage (Sys->AppId, WM_REDRAW, 0, wind->handle, wind->pos->x, wind->pos->y, wind->pos->w, wind->pos->h);
		}
	}
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Timer ...                                                             */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
int Wg_SetTimer (Wnd numWnd, int freq, int state)
/* Cration d'un nouveau Timer...                                        */
{
	int ret = BLANK;
	Wind *wind;
	Wg_Timer *ptr_timer, *tmp;

	wind = ObjListe(numWnd);
	if (wind)
	{
		ptr_timer = (Wg_Timer *)malloc(sizeof(Wg_Timer));
		ptr_timer->state = state;
		ptr_timer->timer = PrivSys->lastTimer++;
		ptr_timer->freq = freq;
		tmp = wind->timer;
		if (! tmp)
			wind->timer = ptr_timer;
		else
		{
			while (tmp->next)
				tmp = tmp->next;
			tmp->next = ptr_timer;
		}
		ret = ptr_timer->timer;
	}
	return ret;
}

void Wg_ResetTimer (Wnd numWnd, int timer)
/* Suppression d'un Timer existant...                                    */
{
	Wind *wind;
	Wg_Timer *ptr_timer, *tmp;

	wind = ObjListe(numWnd);
	if (wind)
	{
		tmp = ptr_timer = wind->timer;
		if (ptr_timer && ptr_timer->timer == timer)
		{
			wind->timer = wind->timer->next;
			free (tmp);
		}
		else
		{
			while (ptr_timer && ptr_timer->timer != timer)
			{
				tmp = ptr_timer;
				ptr_timer = ptr_timer->next;
			}
			if (ptr_timer)
			{
				tmp->next = ptr_timer->next;
				free (ptr_timer);
			}
		}
	}
}

void Wg_SuspendTimer (Wnd numWnd, int timer)
/* Dsactiver un Timer...                                                */
{
	Wind *wind;
	Wg_Timer *ptr_timer;

	wind = ObjListe(numWnd);
	if (wind)
	{
		ptr_timer = wind->timer;
		while (ptr_timer && ptr_timer->timer != timer)
			ptr_timer = ptr_timer->next;
		if (ptr_timer)
			ptr_timer->state = TIMER_STOPPED;
		wind->timer = ptr_timer;
	}
}

void Wg_ResumeTimer (Wnd numWnd, int timer)
/* Ractiver un Timer...                                                 */
{
	Wind *wind;
	Wg_Timer *ptr_timer;

	wind = ObjListe(numWnd);
	if (wind)
	{
		ptr_timer = wind->timer;
		while (ptr_timer && ptr_timer->timer != timer)
			ptr_timer = ptr_timer->next;
		if (ptr_timer)
			ptr_timer->state = TIMER_RUNNING;
		wind->timer = ptr_timer;
	}
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Popup menu ...                                                        */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
void Wg_SetPopup (Wnd numWnd, int tree)
/* Associer un popup menu  une fentre...                               */
{
	Wind *wind;
	OBJECT *win_popup;

	wind = ObjListe (numWnd);
	if (wind && (! wind->adr_wpopup))
	{
		/* Rcupre l'adresse de l'objet popup */
		rsrc_gaddr (R_TREE, tree, &win_popup);

		/* Fonction de gestion du popup */
		wind->adr_wpopup = copy_tree(win_popup);
	}
}

void Wg_ResetPopup (Wnd numWnd)
/* Supprimer le popup menu d'une fentre...                              */
{
	Wind *wind;

	wind = ObjListe(numWnd);
	if (wind && wind->adr_wpopup)
	{
		free (wind->adr_wpopup);
		wind->adr_wpopup = (OBJECT *)NULL;
		wind->Wg_OnPopup = (void *)NULL;
	}
}

void Wg_AttachPopup (Wnd numWnd, int typObj, int numObj, int popupTree)
/*-----------------------------------------------------------------------*
 * Fonction permettant d'associer un popup  un objet d'un formulaire.   *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	Wind *wind;
	Wg_Popup *popup, *NewPopup;
	OBJECT *obj;

	if (numWnd >= 0 && numObj > 0 && popupTree >= 0)
	{
		wind = ObjListe(numWnd);
		if (wind != WIND_NULL)
		{
			if (NewPopup = (Wg_Popup *)malloc(sizeof(Wg_Popup)));
			{
				NewPopup->typObj = typObj;
				NewPopup->numObj = numObj;
				/* Adresse formulaire pop-up */
				rsrc_gaddr (R_TREE, popupTree, &obj);
				NewPopup->obj = copy_tree (obj);
				NewPopup->next  = (Wg_Popup *)NULL;
			}

			popup = wind->popup;
			if (! popup)
				wind->popup = NewPopup;
			else
			{
				while (popup->next)
					popup = popup->next;
				popup->next = NewPopup;
			}
		}
	}
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Bulles d'aide...                                                      */
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
void Wg_AttachHelp (Wnd numWnd, int typObj, int numObj, char *txt)
/*-----------------------------------------------------------------------*
 * Association d'une bulle d'aide avec un objet.                         *
 *                                                                       *
 * Validation : 4 mai 1997                                               *
 *-----------------------------------------------------------------------*/
{
	Wind *wind;
	Wg_Help *help;
	register Wg_Help *pos;

	wind = ObjListe(numWnd);
	if (wind && *txt && (wind->type == ObjForm || wind->type == ObjTBar))
	{
		help = (Wg_Help *)malloc(sizeof(Wg_Help));
		if (help)
		{
			help->typObj = typObj;
			help->numObj = numObj;
			help->txt = (char *) malloc(strlen(txt)+1);
			if (help->txt)
			{
				strcpy (help->txt, txt);
				help->next = (Wg_Help *)NULL;
				pos = wind->help;
				if (! pos)
					wind->help = help;
				else
				{
					while (pos->next)
						pos = pos->next;

					pos->next = help;
				}
			}
			else
			  free(help);
		}
	}
}

/**************************-=< Fin du module >=-**************************/
