/*************************************************************************
 *                                                                       *
 *  WindGem.h : Dfinitions utilises par les procdures WindGem II.     *
 *                                                                       *
 *************************************************************************/

#ifndef __Windgem__
#define __Windgem__

/*-=- Inclusion des fichiers d'entte ncessaires =-=-=-=-=-=-=-=-=-=-=-=*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <xgemfast.h>
#include <tosbind.h>
#include <atari.h>  			/* pour KEYTAB */
#include <malloc.h>
#include <macros.h>

/*************************************************************************
 * Dfinitions utiles.                                                   *
 *************************************************************************/
typedef char	Bool;
typedef int		Wnd;

#ifndef TRUE
#define TRUE		1
#endif

#ifndef FALSE
#define FALSE		0
#endif

#define FAIL	  -1
#define MAX_LEN 256
#define NOT 		!
#define BLANK	  -1
#define ZERO 		0

/*************************************************************************
 * Valeur de dfinition des objets UserDefs.                             *
 *************************************************************************/
#define UNDER_B 18 				 /* Pour raccourcis clavier                    */
#define SMALL_B 22 				 /* Petite *criture                            */
#define POPUP_B 24 				 /* Boutons PopUp                              */
#define RADIO_B 26 				 /* Radio-Boutons                              */
#define CHECK_B 28 				 /* Check-Box                                  */
#define GROUP_B 30 				 /* Objet Groupe                               */

/*************************************************************************
 * Dfinition des structures utilises par WindGem.                      *
 *************************************************************************/
/*-=< Structure Info systmes >=-----------------------------------------*/
typedef struct		 						/* Paramtres systme                      */
{
	int		AppId;								/* Id application                          */
	int		VdiHandle;						/* Handle Vdi                              */
	char	AppPath[128];					/* Chemin de l'application                 */
	int		Wchar, Hchar;					/* Taille caractere                        */
	int		Wcell, Hcell;					/* Taille boite contenant caractre        */
	int		baseline; 						/* Premiere ligne de texte dans une fentre*/
	GRECT	Desk;									/* Coordonnes du bureau                   */
	int		Xres, Yres;						/* Rsolution de l'ecran                   */
	int		Nplane;		 						/* Nombre de plans du bureau               */
} System;

/*-=< Structure Ordinateur >=--------------------------------------------*/
typedef	struct
{
	int		Processor;						/* Type du microprocesseur                 */
	long	Machine;							/* Type d'ordinateur                       */
	int		Switch;								/* Switch Carte mre                       */
	long	Fdc;									/* Floppy Disk Controler                   */
	int		Keyboard;							/* Type du clavier                         */
	int		Language;							/* Langage                                 */
	long	Shifter;							/* Circuit vido                           */
	int		Sound;								/* Systme sonore                          */
	int		Fpu;									/* Unit arythmtique et logique (Co-pro)  */
	int		Separator;						/* Sparateur de Date                      */
	int		Date;									/* Format de la date                       */
	int		Time;									/* Format de l'heure                       */
	int		TosVersion;						/* TOS                                     */
	int		GemdosVersion;				/* Gemdos                                  */
	int		AesVersion;						/* Version AES                             */
	int		MultiTosVersion;			/* Version Mint / Multitos                 */
	int		Magic;								/* Magic prsent ?                         */
} MachineInfo;

typedef struct
{
	int		evnt;									/* Evnement                               */
	int 	mes[8];								/* structure event_multi                   */
	Wnd 	wnd;									/* Numro de l'objet actif                 */
	int 	obj;									/* Numro de l'ventuel objet concern     */
	int 	objPop;								/* Numro objet dans popup                 */
	int 	kbd;									/* Etat des touches spciales              */
	int 	key;									/* Touches du clavier                      */
	int 	mx;										/* Coordonnes X de la souris              */
	int 	my;										/* Coordonnes Y de la souris              */
	int 	mk;										/* Bouton(s) enfonc(s)                    */
	int 	clik;									/* Nombre de clics                         */
} Wg_Evnt;


/*-=< Structure Wg_Coord >=----------------------------------------------*/
typedef struct
{
	int	x, y, w, h;							/* Coordonnes XYWH de la fentre          */
	int	minW;	 				 					/* Largeur min. de la fentre              */
	int	maxW;	  								/* Largeur max. de la fentre              */
	int	minH;	  								/* Hauteur min. de la fentre              */
	int	maxH;	 									/* Hauteur max. de la fentre              */
} Wg_Coord;

/*************************************************************************
 * Dclaration des variables publiques.                                  *
 *************************************************************************/
extern System *Sys;						/* Information Systme / application       */
extern MachineInfo *Ordi;			/* Information Ordinateur                  */

/*************************************************************************
 * Prototypes des Fonctions publiques.                                   *
 *************************************************************************/
/*-=< Gestion de l'application >=----------------------------------------*/
void AppInit 		(char *fic_rsc, Bool multiLang);
Wnd AppSetDesk 	(int desk, void (*OnDesk)(Wg_Evnt evnt), int menu, void (*OnMenu)(Wg_Evnt evnt));
void AppExit 		(void);

/* Coeur de WindGem */
int EventMulti (void);

/* Envoi d'un message GEM */
void SendMessage (int appId, int type, int res, int handle, int par4, int par5, int par6, int par7);

/*-=< Gestion des Sliders >=---------------------------------------------*/
void Wg_ObjSlider (int mode, int max, int pos, char *text);
#define SLIDINI 0								 /* Initialisation du Slider             */
#define SLIDAFF 1								 /* Mise  jour                          */
#define SLIDEND 2								 /* Fermeture du Slider                  */

/*-=< Gestion des Boites d'alerte >=-------------------------------------*/
int Wg_Alerte (int icone, BITBLK *user_icn, char *text, char *button, int def);

/* Affichage d'un message d'alerte venant d'un fichier .RSC */
void Rsc_Alerte(int index);
/* Rcupration d'une chaine libre dans un formulaire */
char *Rsc_String(int index);

#define ICN_USER		-1
#define ICN_EXCLAM1	 0
#define ICN_QUEST1	 1
#define ICN_HAND1		 2
#define ICN_INFO		 3
#define ICN_BOMB		 4
#define ICN_DISK1		 5
#define ICN_HD			 6
#define ICN_DISK2		 7
#define ICN_PRINTER	 8
#define ICN_EXCLAM2	 9
#define ICN_QUEST2	10
#define ICN_STOP		11
#define ICN_HAND2		12
#define ICN_QUEST3	13

/*-=< Gestion de l'aide >=-----------------------------------------------*/
void Wg_AttachHelp	(Wnd numWnd, int typObj, int numObj, char *txt);
void StGuide (char *hypFile, char *node);

/*-=< Gestion des objets USERDEFS POPMENU l'aide >=----------------------*/
void Wg_AttachPopup (Wnd numWnd, int typObj, int numObj, int popupTree);

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 *-=< Objets Wg_Object >=------------------------------------------------*
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Si objet de type ObjForm ou ObjTBar*/
void Wg_ObjSelect (Wnd numWnd, int typObj, int numObj, int state);
void Wg_ObjEnable (Wnd numWnd, int typObj, int numObj, int state);
void Wg_ObjCheck  (Wnd numWnd, int typObj, int numObj, int state);
void Wg_ObjSetCoord (Wnd numWnd, int typObj, int numObj, GRECT *coord);
void Wg_ObjGetCoord (Wnd numWnd, int typObj, int numObj, GRECT *coord);

/* Redessin d'un objet d'un formulaire -> ATTENTION syntaxe diffrente */
void	Wg_ObjDraw	(Wnd numWnd,  int typObj, int numObj, int depth);

/* Champs textes */
void Wg_ObjSetText 	(Wnd numWnd, int typObj, int numObj, char *text);
char *Wg_ObjGetText 	(Wnd numWnd, int typObj, int numObj);
void Wg_ObjClrText 	(Wnd numWnd, int typObj, int numObj);
void Wg_ObjClrAllText (Wnd numWnd, int typObj);

/* Si objet de type ObjMenu */
void	Wg_MenuEnable	(Wnd numWnd, int item, int flag);
void	Wg_MenuTNormal(Wnd numWnd, int item, int flag);
void	Wg_MenuCheck	(Wnd numWnd, int item, int flag);
void	Wg_MenuText		(Wnd numWnd, int item, char *text);

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 *-=< Objets Wind >=-----------------------------------------------------*
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Cration d'un objet fentre */
Wnd NewWind (int type);

/* Suppression d'un objet fentre */
void DeleteWind (Wnd numWnd);

/* Ouverture et fermeture d'une fentre */
void WindOpen	(Wnd numWnd, int mode);
void WindClose	(Wnd numWnd);

/*-=< Diverses autres fonction de GemForm.c >=---------------------------*/
/* Gestion des variables de l'objet */
void	Wg_GetCoord			(Wnd numWnd, Wg_Coord *coord);
void	Wg_SetCoord			(Wnd numWnd, Wg_Coord *coord);
int		Wg_GetHandle		(Wnd numWnd);
Bool	Wg_IsIconified	(Wnd numWnd);
char	*Wg_GetTitle		(Wnd numWnd);
void	Wg_SetTitle			(Wnd numWnd, char *title);
void	Wg_SetAttrib		(Wnd numWnd, int attrib);
int		Wg_GetAttrib		(Wnd numWnd);
void	Wg_SetInfo (Wnd numWnd, char *txt);
void	Wg_GetInfo (Wnd numWnd, char *txt);
void	Wg_SetSliders (Wnd numWnd, int scaleH, int posH, int offH, int scaleW, int posW, int offW);
void	Wg_GetSliderPos (Wnd numWnd, int *posH, int *posW);
void	Wg_SetSliderPos (Wnd numWnd, int posH, int posW);


/* Objets de la fentre */
/* Menu en fentre : Ajout / Suppression / Utilisation */
void	Wg_SetMenu		(Wnd numWnd, int tree);
void	Wg_ResetMenu	(Wnd numWnd);

/* ToolBar : Ajout / Suppression / Utilisation */
void	Wg_SetToolbar	(Wnd numWnd, int tree);
void	Wg_ResetToolbar(Wnd numWnd);

/* Traitement priodique : Ajout / Suppression */
int			Wg_SetTimer		(Wnd numWnd, int freq, int state);
void		Wg_ResetTimer	(Wnd numWnd, int timer);
void		Wg_SuspendTimer (Wnd numWnd, int timer);
void		Wg_ResumeTimer (Wnd numWnd, int timer);

/* Popup Menu associ : Ajout / Suppression / Utilisation */
void		Wg_SetPopup		(Wnd numWnd, int tree);
void		Wg_ResetPopup	(Wnd numWnd);

/* Formulaire : Ajout / Utilisation */
void		Wg_SetDialog	(Wnd numWnd, int tree, int edit);
OBJECT *Wg_GetObject (Wnd numWnd, int typObj);

/* Fentre image : Ajout / Utilisation */
void Wg_SetImage (Wnd numWnd, int nblin, int nbcol, int lin, int col, MFDB *img);
void Wg_GetImage (Wnd numWnd, int *nblin, int *nbcol, int *lin, int *col, MFDB **img);

/* Fentre Texte : Mise et place / rcupration du contenu */
void Wg_Loadtext (char *file, int *nblin, int *nbcol, char **text[]);
void Wg_SetText (Wnd numWnd, int nblin, int nbcol, int lin, int col, char **text);
void Wg_GetText (Wnd numWnd, int *nblin, int *nbcol, int *lin, int *col, char **text[]);

/* Installation des fonctions de gestion d'vnements */
void Wg_SetEvent		(Wnd numWnd, int evnt, void (*Wg_OnEvnt)(Wg_Evnt *evnt));
void Wg_ResetEvent	(Wnd numWnd, int evnt);

/* Rcupration des coordonnes de la fentre ou de la zone de travail   */
void	Wg_GetWorkXYWH	(Wnd numWnd, GRECT *coord);

/*-=< Gestion des donnes utilisateur d'un objet Wind >=-----------------*/
void *Wg_GetUserVar	(Wnd numWnd);
void Wg_SetUserVar	(Wnd numWnd, void *var);

/*************************************************************************/
/* Rcupration des coordonnes du bureau */
void Wg_GetDeskXYWH (int *Xdesk, int *Ydesk, int *Wdesk, int *Hdesk);

/*************************************************************************
 * Dfinition des constantes utilisateurs.                               *
 *************************************************************************/
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 *-=< Objets Wind >=-----------------------------------------------------*
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Pour NewWind (...) et les routines EventXXX internes ou non */
#define WndNone		-1		 			/* Pas de fentre                          */
#define WndDesk 	 0				 	/* Type spcial pour la gestion du bureau  */
#define WndForm 	 1				 	/* Fentre de type WindForm                */
#define WndGrap	 	 2			 		/* Fentre image                           */
#define WndText	 	 3			 		/* Fentre texte                           */
#define WndUser	 	 4				 	/* Fentre "User Defined"                  */
#define WIND_NULL	(Wind *)0

/* Pour Wg_SetAttrib (...) et Wg_GetAttrib (...) */
#define ATTRIB_DEFAULT	0 		 /* Utiliser les attributs par dfaut      */
															 /* Autre valeur = attributs  appliquer   */
															 /* Fentre USER uniquement, non pris en   */
															 /* compte sinon.                          */

/* Pour WindOpen (...) */
#define WndNORM		0 					/* Fentre normale                         */
#define WndMODAL	1 					/* Fentre modale                          */

/* Pour SetEvent (...) */
#define EvntAll				1000						 			 /* Tout type d'vnements   */
#define EvntKeyboard	1100
#define EvntKeySpec		1110
#define EvntKeyHELP 	(EvntKeySpec + 1)			 /* Touche Help              */
#define EvntKeyUNDO		(EvntKeySpec + 2)			 /* Touche Undo              */
#define EvntKeyARUP		(EvntKeySpec + 3)			 /* Fleche Haut              */
#define EvntKeyARDN		(EvntKeySpec + 4)			 /* Fleche Bas               */
#define EvntKeyARLF		(EvntKeySpec + 5)		 	 /* Fleche Gauche            */
#define EvntKeyARRT		(EvntKeySpec + 6)			 /* Fleche Droite            */
#define EvntKeySHARUP	(EvntKeySpec + 7)			 /* Fleche Haut              */
#define EvntKeySHARDN	(EvntKeySpec + 8)			 /* Fleche Bas               */
#define EvntKeySHARLF	(EvntKeySpec + 9)			 /* Fleche Gauche            */
#define EvntKeySHARRT	(EvntKeySpec + 10)		 /* Fleche Droite            */
#define EvntKeyHOME		(EvntKeySpec + 11)		 /* Touche Home              */
#define EvntKeySHHOME	(EvntKeySpec + 12)		 /* Touche Shift Home        */
#define EvntKeyESC		(EvntKeySpec + 13)		 /* Touche Escape            */
#define EvntButton 		1200               		 /* Gestion de la souris     */
#define EvntTimer	 		1300									 /* Traitement priodique    */
#define EvntMessage		1400                 	 /* Tout type de message     */
/* Nouveaux vnements message */
#define EvntOpen	 		(EvntMessage + 1)			 /* Ouverture d'une fentre  */
#define EvntClosed 		(EvntMessage + 2)			 /* Fermeture                */
#define EvntDragDrop	(EvntMessage + 3)			 /* Drag & Drop (Atari)      */
#define EvntDrag	 		(EvntMessage + 4)			 /* Dbut Drag & Drop (Drag) */
#define EvntDrop	 		(EvntMessage + 5)			 /* Fin Drag & Drop (Drop)   */

#define EvntObject			1500								 /* Tout type d'vnement    */
/* Evnements spciaux que peuvent recevoir les objets d'un formulaire   */
#define EvntObjChanged	(EvntObject + 1)		 /* Changement contenu champ */

/* Autres vnements */
#define EvntMenu			1600									 /* Menu en fentre ou non   */
#define EvntToolbar		1700									 /* Toolbar                  */
#define EvntPopup			1800									 /* Popup menu               */

/* Pour variable <state> de la structure Wg_Timer */
#define TIMER_STOPPED	0
#define TIMER_RUNNING	1

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 *-=< Objets Wg_Object >=------------------------------------------------*
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* Pour proprit obj_type et Wg_AttachHelp (...) et Wg_AttachPopup (...)*/
#define ObjForm		1
#define ObjTBar		2
#define ObjMenu   3					 			 /* Non dispo pour Wg_Attachxxxx (...) */
#define ObjPopup	4                /* Idem                               */

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 *-=< Objets MachineInfo >=----------------------------------------------*
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
#define	M68000		0x0000 			/* Processeurs */
#define	M68010		0x000A
#define	M68020		0x0014
#define	M68030		0x001E

#define	ST				0x00000L			/* Machines */
#define	STE				0x10000L
#define	MSTE			0x10010L
#define	TT				0x20000L
#define	FALCON30	0x30000L

#define	KEYB_USA	0x0				/* Clavier */
#define	KEYB_D		0x1
#define	KEYB_F		0x2
#define	KEYB_GB		0x3
#define	KEYB_SP		0x4
#define	KEYB_I		0x5
#define	KEYB_CHD	0x7
#define	KEYB_CHF	0x8

#define	LG_USA		0x0				/* Langue */
#define	LG_D			0x1
#define	LG_F			0x2
#define	LG_GB			0x3
#define	LG_SP			0x4
#define	LG_I			0x5
#define	LG_CHD		0x7
#define	LG_CHF		0x8

#define	SHIFTER_ST		0x00000L		/* Circuit Video */
#define	SHIFTER_STE		0x10000L
#define	SHIFTER_TT		0x20000L
#define	VIDEL_FALCON	0x30000L

#define	MATRICE	0x08				/* Systeme sonore */
#define	DSP			0x04
#define	CODEC		0x02
#define	PSG			0x01

#define	NO_FPU				0				/* Copro. Math. */
#define	SFP004				1
#define	C68881_2			2
#define	C68881_2_SFP	3
#define	C68881				4
#define	C68881_SFP		5
#define	C68882				6
#define	C68882_SFP		7
#define	C68040				8
#define	C68040_SFP		9

#define	DATE_MJA			0				/* Format date */
#define	DATE_JMA			1
#define	DATE_AMJ			2
#define	DATE_AJM			3

#define	TIME_12			0				/* Format horaire */
#define	TIME_24			1

/*-=< Fonctions Utilitaires : WgUtil.c >=--------------------------------*/
extern OBJECT *ObjcDup( OBJECT *src);
extern OBJECT *copy_tree(OBJECT *tree);
extern void get_bkgr (int of_x, int of_y, int of_w, int of_h, MFDB *img);
extern void put_bkgr (int of_x, int of_y, int of_w, int of_h, MFDB *img);
extern void set_clip (int clip_flag, GRECT *area);
extern char *get_text (OBJECT *adr, int object);
extern void set_text (OBJECT *adr, int object, char *string);

extern char *trim (char *str);
extern char *strnpcpy(char *dest, char *start, char *stop);
extern char *strinsert (char *chaine, char *ch);
extern char *strcomplete (char *chaine, int lng, char car, int where);
#define INS_BEG   -1
#define INS_END    1
extern char *strcopy(char *res, char *chaine, int deb, int fin);
extern char *strlcopy(char *res, char *chaine, long deb, long fin);
extern char *strleft (char *res, char *chaine, int nb);
extern char *strright (char *res, char *chaine, int nb);
extern char *strmid (char *res, char *chaine, int deb, int nb);
extern char *strchg(char *chaine, char old, char new);

extern long exist (char *name, int att);
extern char *path (char *chemin);
extern int selector (char *path, char *ext, char *file, char *title);
extern void extension (char *filename, char *ext);
extern void makeFileName(char *chemin, char *fic, char *fichier);
extern char *getFileName(char *file, char *path);

extern void readDate (char *date, unsigned int fdate);
extern void convDate (char *date, unsigned int *fdate);
extern char *getDate (char *time_string, int format, char sep);
#define FRENCH_DATE  0	/* definitions pour fonction GetDate */
#define ENGLISH_DATE 1  /* ... formats de date possibles     */
#define US_DATE      2
#define DOS_DATE     3
#define SYS_TIME     4
extern long Atol16 (char *buf);
extern UWORD Atoui16 (char *buf);
extern unsigned long Atoul16 (char *buf);
extern int is_digit(char *chaine);

extern void DrawIcone (int handle, GRECT *zone);
extern void fill_tab (int *pxy, int n, ...);

#endif
/*************************************************************************
 * Fin du module de dclaration.                                         *
 *************************************************************************/