/*************************************************************************
 *                                                                       *
 *  WinProto.h : Dfinitions utilises par les procdures WindGem II.    *
 *                                                                       *
 *************************************************************************/

/*-=- Inclusion des fichiers d'entte ncessaires =-=-=-=-=-=-=-=-=-=-=-=*/
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <types.h>
#include <xgemfast.h>
#include <tosbind.h>
#include <atari.h>  			/* pour KEYTAB */
#include <malloc.h>
#include <macros.h>
#include <scancode.h>
#include <vaproto.h>
#include <unistd.h>

#include "windgem.h"

#ifndef __Wg_Proto__
#define __Wg_Proto__

/*************************************************************************
 * Dfinitions utiles.                                                   *
 *************************************************************************/
/* Attributs par dfaut des fentres si l'utilisateur n'en donne pas     */
#define ATTRIB_FORM	(NAME|CLOSER|MOVER|SMALLER)	/* Formulaires        */
#define ATTRIB_ALL  (NAME|CLOSER|FULLER|MOVER|SMALLER|SIZER|UPARROW|DNARROW|VSLIDE|LFARROW|RTARROW|HSLIDE)

/* Pour objets menu en fentre */
#define BARMENU  1
#define BARTITLE 2

/*************************************************************************
 * Dfinition des structures utilises par WindGem en interne.           *
 *************************************************************************/
typedef struct
{
	int color_3d1, color_3d2;	/* Couleur pour la 3D                      */
	OBJECT *AdrUser;	 				/* Objet contenant les objets Userdefs     */
	OBJECT *AdrIcone;	  			/* Objet contenant l'icones pour iconify   */
	OBJECT *AdrHelp;	  			/* Adresse objet aide en ligne             */
	OBJECT *AdrSlider;  			/* Adresse objet Slider                    */
	OBJECT *AdrAlerte;  			/* Adresse objet Alerte                    */
	int lastMode;							/* Mode d'affichage actuel (MODAL ?)    )  */
	int lastTimer;						/* Dernier numro de Timer                 */
} Internal;

/*-=< Objet Aide en ligne >=---------------------------------------------*/
typedef struct _help					/* Structure de l'aide pour les Boutons    */
{
	int		typObj;								/* Type de l'objet ObjForm ou ObjTBar      */
	int		numObj;								/* Numro de l'objet pour l'aide           */
	char	*txt;									/* Texte de l'aide                         */
	struct _help *next;					/* Aide suivante                           */
} Wg_Help;

/*-=< Objets Wg_Timer >=-------------------------------------------------*/
typedef struct _timer
{
	int		timer;
	int 	freq;
	int 	state;
	struct _timer *next;
} Wg_Timer;

/*-=< Objet Userdef POPMENU >=-------------------------------------------*/
typedef struct _popup					/* Structure pour objets popup             */
{
	int 		typObj;							/* Type de l'objet : ObjForm ou ObjTBar    */
	int 		numObj;							/* Objet auquel on associe le popup        */
	OBJECT 	*obj;	 							/* arbre d'objet du Popup menu             */
	struct _popup *next;				/* Popup suivant                           */
} Wg_Popup;

/*-=< Composantes principales d'une fentre >=---------------------------*/
typedef struct								/* Fentre formulaire                      */
{
	int	offset;									/* Dcalage x et y pour boite "OUTLINED".	 */
	int	edit;	 									/* 1er champ ditable ou BLANK.            */
	int	edit_objc;							/* Objet ditable courant.                 */
	int	edit_pos;								/* Position courante du curseur d'dition. */
} Wg_FormWnd;

typedef struct
{
	int scaleH;									/* Echelle pour ascenseur horizontal       */
	int posH;										/* Position ascenseur horizontal           */
	int offH;										/* Coefficient de dplacement vertical     */
	int scaleW;									/* Echelle pour ascenseur vertical         */
	int posW;										/* Position ascenseur vertical             */
	int offW;										/* Coefficient de dplacement horizontal   */
} Wg_Slider;

/*-=< Objets Wind >=-----------------------------------------------------*/
typedef struct								/* Objet Fentre (Wind)                    */
{
/*=-=-=-=-= Proprits de l'objet =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
	Wnd   		numWnd; 					/* Numero de la fentre                    */
	int  			handle;						/* handle de la fentre si ouverte         */
	int 			type;							/* type de la fentre                      */
	int  			attrib;	 					/* Attributs de la fentre                 */
	int				mode;							/* Mode d'ouverture de la fentre          */
	char			*title;						/* pointeur sur une chaine titre           */
	char			*info;						/* Barre d'information de la fentre       */
	Bool 			iconified;				/* Flag iconification                      */
	Bool			full;							/* Flag fentre en taille maximale         */
	Wg_Coord 	*pos;							/* Coordonnes et dimensions de l'objet    */
	Wg_Slider	*slider;					/* paramtrage des ascenseurs d'une fentre*/

	/* Composantes principales de la fentre */
	Wg_FormWnd	 *dialog;	 			/* Type boite de dialogue                  */
	MFDB				 *image; 				/* Type fentre image                      */
	char	 			 **text;				/* Type fentre texte                      */

	/* Autres composantes de la fentre */
	OBJECT		*adr_wdialog;			/* Objet formulaire de la fentre ou NULL  */
	OBJECT		*adr_wmenu;				/* Objet menu de la fentre ou NULL        */
	OBJECT		*adr_wtoolbar;		/* Objet ToolBar de la fentre ou NULL     */
	OBJECT		*adr_wpopup;			/* Objet Popup Menu de la fentre ou NULL  */
	void			*var;							/* Permet  l'utilisateur de  stocker les  */
															/* var. dont il aurait besoin (structure). */
	Wg_Help		*help;						/* Liste des messages d'aide               */
	Wg_Popup	*popup;						/* Liste des objets popup                  */
	Wg_Timer	*timer;						/* Liste des objets Timer                  */

/*=-=-=-=-= Mthodes de l'objet =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
	void	(*Wg_OnMessage)(Wg_Evnt *evnt);								/* MU_MESAG        */
	void	(*Wg_OnKeyboard)(Wg_Evnt *evnt);							/* MU_KEYBD        */
	void	(*Wg_OnButton)(Wg_Evnt *evnt);	 							/* MU_BUTTON       */
	void	(*Wg_OnKeySpec)(Wg_Evnt *evnt); 							/* Touche spciale */
	void	(*Wg_OnTimer)(Wg_Evnt *evnt);	 								/* MU_TIMER        */
	void	(*Wg_OnObject)(Wg_Evnt *evnt);								/* Evnment Objet */
	void	(*Wg_OnMenu)(Wg_Evnt *evnt);	 								/* Menu en fentre */
	void	(*Wg_OnToolbar)(Wg_Evnt *evnt);								/* ToolBar         */
	void	(*Wg_OnPopup)(Wg_Evnt *evnt);									/* Popup menu      */
} Wind;

/*=-=-=-=-=-= Variables prives =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
extern Internal *PrivSys;
#define NBWIND	60					/* Nombre maximum de fentres              */
extern Wind LstWnd[NBWIND];	/* Liste des fenetres (60 fenetres max.)   */
extern Wnd WndMenu;			 		/* Numro de l'objet "menu"                */
extern DTA dtabuffer;		 		/* Tampon DTA                              */

/*************************************************************************
 * Prototypes des Fonctions Internes  WindGem.                          *
 *************************************************************************/

extern void Wg_SetHandle (Wnd numWnd, int handle);

/*-=< Routines UserDefs >=-----------------------------------------------*/
extern void set_user(OBJECT *addr_tree);

extern void	RecaleWind(Wind *wind);
extern Wind *ObjListe(int numWnd);
extern Wind *TopListe(int handle);

extern void Wg_VSlider (Wind *wind, Wg_Evnt *evnt);
extern void Wg_HSlider (Wind *wind, Wg_Evnt *evnt);
extern void Wg_Arrow   (Wind *wind, Wg_Evnt *evnt);
extern void Wg_Sliders (Wind *wind);

/* Fonctions utilitaires */
extern int stdkey (unsigned char *k, int key);
extern int parent (OBJECT *adr, int object);
extern int m_title (OBJECT *adresse, int option);

#endif
/*************************************************************************/