# uucp poll with O and Hermes 1.10
# Bourne-Style shell script
# wr 30.7.93

A=$*

PATH=d:/bin,d:/usr/bin,e:/o,$PATH
O_INF=e:/o/o.inf
export PATH O_INF

# clean up temp space
rm -f m:/tmp/*.txt

# remove Hermes history file
rm -f h:/news/history

# uuwork creates a file in the root of the current drive, so
# make sure we are not on U:
cd c:/

# run with parameter "poll" to supress export
if [ "$A" != "poll" ]
then
  # inform user about free disk space to help him decide whether to
  # abort oexpire (delete this line if you are not using the
  # Okami shell)
  echo Free space on H: `df -f h` bytes

  # O cleanup
  echo cut logs
  cutlog.ttp -W -s 5000 -l 500 -a 5 $ETC/log/*

  # O expire
  # -Yu = Usenet only
  # -W = wait for ESC-termination
  # -R = reorg if 50% or more unused
  echo oexpire
  oexpire -Yu -W -R 50%

  # O export
  echo oexport
  oexport

  # uucp export
  rsmtp
  rmail
  rnews
  batch tornado
  batchmai tornado
fi

# now do the uucp poll (use TEMP from config.sys)
SAVETEMP=$TEMP
unset TEMP
uuwork -n tornado

# switch cursor back on (delete this line if you are not
# using the Okami shell)
cursor +v

# uucp import
rmail
rnews

# restore TEMP
TEMP=$SAVETEMP
export TEMP
unset SAVETEMP

# O import
# -I = delete files immediately after import (saves disk space)
echo oimport
oimport -I

# check mail
omchk -l wr root
echo ^007UU-Poll beendet.
