;	This is an example UUCP.CTL file for the UUCP-ST package
;	Date:  21 May 1996
;
;	All command lines begin with a keyword which must be followed
;	at least one space.  TAB characters are not allowed!
;	Unknown words that begin on the left margin, or any line
;	that does not begin with a letter on the left margin,
;	will be ignored.
;	
;	Coomands indicated with *** are required.  All others are
;	optional except as noted.
;
;***	The Sysop line is required; use the BBS username of the
;	sysop, or the sysop name in your message editor setup if
;	you are not running a BBS.
Sysop           Rich Tietjens
;
;	"Key" is the registration key that you will receive after
;	registering the pacakge.  If the key is incorrect, or simply
;	omitted, all your messages will be marked as "unregistered"
;	and some of the less-used features will not work.
Key 	(a 64-character ASCII key will go here)
;
;***	The "mailbox" is what appears to the left of the "@" symbol
;	in your email address.  This is case sensitive!
Mailbox         starship
;
;	If your ISP assigns a hostname to your system (this would
;	appear after the @ and before the domain name, e.g., if your
;	address is something like dsmith@hostname.demon.co.uk), indicate
;	the hostname here.
Hostname        hostname
;
;***	The MailQueue is the folder where outbound mail and news
;	will be written and held for NOS to send into the Internet.
MailQueue       i:\oasis\spool\mqueue\
;
;***	The NetMail base is the path of your netmail messagebase,
;	without the .MSG/.HDR extension
NetMail         f:\sysop\netmail
;
;	Userdata is the file where your user database is maintained.
;	Optional; "gateway.dat" will be used by default, in the 
;	same directory with the UUCP-ST programs.  It is a good idea
;	to specify this file in case you run a program from a shell
;	that doesn't properly change the current working directory.
Userdata        i:\uucp-st\gateway.dat
;
;***	Where shall the logs be written?  Full path.
LogFile         e:\logs\uucp_st.log
;
;	Loglevel controls the amount of data written to the log;
;	Loglevel 0 doesn't write a log at all.
;	Loglevel 1 writes only start, end, and critical errors;
;	Loglevel 2 also indicates general statistics (speed,
;	total number of messages processed each run, etcetera);
;	Loglevel 3 logs the Internet Message-Id for each message
;	processed;	
;	Loglevel 4 logs individual addressee names for each message;
;	Loglevel 5 logs the entire message body for each message.
;	If this line is left out, Loglevel defaults to 0.
LogLevel        3
;
;	Debug On|off
;	If Debug is On, exhaustive levels of information will be written to
;	log; UUCP-ST operation will be very slow also.  Unless there is
;	a problem requiring detailed analysis, this should be left off,
;	If the line is omitted, Debug defaults to off.
Debug           On
;
;	SigFile is the signature that is appended to outbound news articles;
;	if it is omitted, a product ID will be appended instead.  Netiquette
;	dictates that a .sig file consist of no more than 4 lines of plain
;	text.  This most often observed in the breach, however.
SigFile         e:\jetmail\jetmail\usenet.jm
;
;	MailSig is simply a signature file that is appended to email.
;	You can use the same file for both, if you wish, or even omit
;	one of them and only use the other (or simply omit both of
;	them if you have nothing special you want to say in every message).
MailSig         e:\jetmail\jetmail\gateway.jm
;
;	The directory where new email is written by NOS; the filename
;	will be the same as your mailbox name plus ".TXT" - thus new
;	inbound email for all users at STarship will be found in a
;	file named starship.txt in this directory:
NewEmail        i:\oasis\spool\mail\
;
;	Immediate Import controls the behavior of EmailOut when writing
;	mail back to users who send function requests and to new account
;	holders.  If it is set to ON, then Email_In will be called by
;	EmailOut as soon as a message exists in the New Email folder.
;	This slows EmailOut somewhat and requires more memory but may
;	be preferred while setting up and testing UUCP-ST (or if you
;	have a need for immediate replies, such as realtime response
;	during a BBS session).  Option, default is OFF.
ImmediateImport On
;	
;	Reimport On will allow all of your outbound news articles to be
;	picked up by NOS and reimported to your message base.  This is
;	useful for debugging (or if you're just curious to see what your
;	articles look like), but wastes time in the NOS cycle.  Set this
;	to Off to have each message ID added to the History file, thus
;	preventing NOS from downloading your outbound messages:
ReimportNews    Off
;
;	MaxSize is something I'll have to research, I forgot what it does...
MaxSize         32767
;
;***	AttachDir is where email messages that are too large for a single
;	Fido-style message will be written.  This does not apply to News;
;	large news articles will be split among as many fido messages as
;	required.
AttachDir       f:\attached
;
;	The PlayPrg will be called when new email is found.  This can
;	be amusing or annoying, depending on your personal desires.
;	Any sound player that accepts a command line and exits after
;	playing can be used; if you have tight RAM, you may prefer to
;	omit this and save the memory.  Several optional programs are
;	listed - pick the one that works for your hardware.
;
;	WavePly2 works on the STe only:
PlayPrg         e:\waveplay\wavplay2.gtp
;
;	Play.Ttp should work on any ST:
;	PlayPrg		PLAY.TTP
;
;	PlayFile is the entire command line required by your sound
;	player program.  Optional (ignored if PlayPrg is omitted):
PlayFile        e:\octopus\sounds\mailz_in.wav
;
;***	HomeAddr is your .ftn address (without domain name):
HomeAddr        51:205/311.0
;
;***	HomeSite is your ISP's domain name:
HomeSite        3rdplanet.com
;
;	Organization (or Organisation, if you're in the UK; spelling
;	either way is optional) is the name of your BBS or network:
Organization    STarship and Quark's Holosuites
;
;***	TZ or TimeZone (either keyword is OK) is your Time Zone in
;	any standard format:  the 3-letter abbreviation, time 
;	difference from GMT (e.g., -0700), or both if you wish.
TZ              PDT
;
;***	AreasBBS is the full pathname of your AREAS.BBS file.
;	Required for news, optional for email:
AreasBBS        e:\jetmail\areas.bbs
;
;	The next 2 parameters are for use with PURGE; you may omit
;	them if you aren't going to use the program.
;
;	If you wish to use the Purge data in your Jetmail config,
;	use the full path to the config.jm file:
Jetmail         e:\jetmail\jetmail\config.jm
;
;	If you prefer a seperate Purge list, put the filename (or
;	full path if it's not in the UUCP-ST folder) here:
PurgeList       purge.txt
;
;	Is there someone who posts to the newsgroups but never
;	has anything useful or interesting to say?  Does he annoy
;	you like no one else ever has?  Want to trash all his
;	news articles automatically?  KillFrom will do just that -
;	after you have registered UUCP-ST.
;	The info on this line must match perfectly with info in the
;	From: line of incoming news articles, although it need not
;	be the only thing on the line.  In the given example, any
;	message with "PETER SINCLAIR-DAY" as part of the From: address
;	will be automatically trashed.
KillFrom	PETER SINCLAIR-DAY
;
;	What about email?  Does someone have you on their junk email
;	list, or do you just never want to hear from a given individual
;	at all?  Email should be treated as postal mail in this respect;
;	if you get mail you don't want, it should be returned to the sender.
;	BounceFrom will do exactly that.  The address must match EXACTLY,
;	so if you get email from (for example) sinclap2945@cobra.uni.edu,
;	if will bounce, but mail from SinClap2945@cobra.uni.edu will not;
;	mail from sinclap2954@cobra.uni.edu (PETER SINCLAIR-DAY) will.
;	Be sure to specifiy enough information so you don't accidentally
;	bounce mail you want to keep!  A line that said (for example)
;	BounceFrom aol.com
;	will bounce ALL mail originating on AOL!  You really should
;	specify as complete an address as possible if you use this feature.
;	Try to keep the number of lines here as low as possible; 
;	checking for Bounce addresses takes time and memory.
;
;	This feature is reserved for registered sysops.
BounceFrom	sinclap2945@cobra.uni.edu
BounceFrom	root@uni.edu
;
;***	The BatchText file is the full path of your incoming
;	news articles.  Required for News.
BatchText       i:\oasis\spool\articles\batch.txt
;
;***	Path to your NOS Spool folder:
Spool           i:\oasis\spool\
;
;	If you wish new users to be automatically activated, set
;	ActiveFlag to On; if you prefer to manually activate each
;	user, set this command to Off; default is ON:
ActiveFlag      On
;
;	If SendReceipt is set to ON, then each email sent will be acknowlged
;	in a return email ot the sender; if set to Off, mail will be
;	sent without notifiying the sender.  Default is Off:
SendReceipt     OFF
;
;	If you want a text file with the daily statistical report;
;	put the full pathname here:
StatsRep        e:\logs\stats.log
;	
;	If you want the statistics sent out in a message to ALL;
;	indicate the message base location (without .MSG/.HDR
;	extension) here:  NOTE:  Either StatsRep or StatsBase
;	is required; you may do either or both, but do not
;	leave both out of the control file!
StatsBase       f:\sysop\gatenews
;
;	If you wish to have outbound email copied to an archive
;	file, set KeepSysopMail to ON.  Defaults to OFF; setting 
;	this on will slow EmailOut considerably.
KeepSysOpMail   OFF
;
;	If you want Reminder.Txt sent to each user automatically
;	on a given day of each month, set the date here.  You may
;	also send a function request to UUCP-ST (see the docs for
;	EmailOut) or run EmailOut with a command line of "Reminder"
;	to manually accomplish the same thing.
SendRemindDate  15
;
;	History is the list of messages that New_In has already
;	seen; this will keep NOS from downloading them again.
History         i:\oasis\spool\news\history
;
;	HistorySize is the maximum number of message IDs to keep
;	in the history list.  The more you have in the list, the
;	longer it will take NOS to collect new messages; however, 
;	if you don't keep at least one average day's message IDs,
;	NOS will repeatedly download the same messages.  A minimum
;	size of 3000 messages has worked well at STarship:
HistorySize     3000
;
;	Since UUCP-ST runs in a GEM Window, it is possible to resize
;	that window.  However, rather than adding speed-gobbling code
;	to the programs to determine if you have resized the window,
;	and to save the new size if you have, instead you can set the
;	size in the CTL file.  UUCP-ST defaults to a full-screen window
;	regardless of your resolution.  You may set the X and Y coordinates
;	here and the size of the border area, that is, how far to the right
;	and how far down should the window open, and how much space
;	behind the window should be visible.
Window          16,8,64,128
;
;	The Link and File lines may be included here; if a LINK.CTL file
;	is found in the UUCP-ST folder, it will be used instead, but the
;	format is the same.  Each line starts with either Link or File;
;	then one or more spaces (NO TABS!), followed by the internet
;	newsgroup name (case sensitive!) and again, one or more spaces.
;	If it is a Link, end the line with the .ftn areaname as listed
;	in your AREAS.BBS file.
;	If instead you wish each news article written to a disk file,
;	indicate the path to the folder where the articles will be stored.
;	Filenames will be generated based on the current system time;
;	a maximum of 27 articles per second can be handled.  At any higher
;	speed, the software must pause until the system clock catches up
;	to prevent overwriting existing articles.  For reference, assuming
;	an average article size of 32768 bytes (which is fairly common for
;	the Binaries heirarchy), that equates to 864 kilobytes per second.
;	You will probably not see this kind of speed unless you have an
;	'040 CPU running at better than 40 MHz.
;	Keep in mind that newsgroups linked to Files in this way will
;	NOT be available for areafixing by your downlinks.
;	The trash area (where empty and unlinked articles will be written)
;	is a special case; it should have the newsgroup name listed as either
;	"badmsgs" or "trasharea" and the message base will be the same as your
;	Jetmail/IOS trasharea.  This link is not required but it is highly
;	recommended; if it doesn't exist the results are unpredictable.
Link badmsgs                                    BADMSGS
Link alt.ascii-art                              U.ALT.ASCII-ART
Link alt.atari-jaguar.discussion                U.ALT.ATARI-JAGUAR.DISCUSSION
Link alt.atari.2600                             U.ALT.ATARI.2600
;
File alt.binaries.pictures.black.erotic.females I:\UFILE\BLACK\
File alt.binaries.sounds.erotica                I:\UFILE\AUD_EROS\
;
Link alt.games.lynx                             U.ALT.GAMES.LYNX
Link alt.internet.services                      U.ALT.INTERNET.SERVICES
Link alt.sports.baseball.la-Dodgers             U.ALT.SPORTS.BASEBALL.LA-DODGERS
Link alt.tv.babylon-5                           U.ALT.TV.BABYLON-5
Link alt.tv.red-dwarf                           U.ALT.TV.RED-DWARF
Link comp.binaries.atari.st                     U.COMP.BINARIES.ATARI.ST
Link comp.os.linux.m68k                         U.COMP.OS.LINUX.M68K
Link comp.sys.atari.8bit                        U.COMP.SYS.ATARI.8BIT
Link comp.sys.atari.st                          U.COMP.SYS.ATARI.ST
Link comp.sys.atari.st.advocacy                 U.COMP.SYS.ATARI.ST.ADVOCACY
Link comp.sys.atari.st.announce                 U.COMP.SYS.ATARI.ST.ANNOUNCE
Link comp.sys.atari.st.programmer               U.COMP.SYS.ATARI.ST.PROGRAMMER
Link comp.sys.atari.st.tech                     U.COMP.SYS.ATARI.ST.TECH
Link demon.ip.support.atari                     U.DEMON.IP.SUPPORT.ATARI
Link news.announce.newgroups                    U.NEWS.ANNOUNCE.NEWGROUPS
;
