;	This is the example control file for Wormhole.
;	If you wish to use a combined file for both Wormhole and
;	UUCP-ST, you may incorporate all the information into the
;	UUCP.CTL file; I like to keep wormhole's data seperate.
;	This allows a different sample to be played when Wormhole
;	encounters a new email file, so I can tell from across the
;	room which program is running.
;
;	If you haven't already looked at EXAMPLE.CTL (and edited it
;	to create your UUCP.CTL file), do that first.
;	The first several lines here are explained in EXAMPLE.CTL and
;	will not be commented here.
;
Sysop           Rich Tietjens
Mailbox         starship
MailQueue       i:\oasis\spool\mqueue\
NewEmail        i:\oasis\spool\mail\
Spool           i:\oasis\spool\
LogFile         e:\logs\wormhole.log
LogLevel        3
PlayPrg         e:\waveplay\wavplay2.gtp
PlayFile        e:\octopus\sounds\working.wav
Debug           Off
AttachDir       F:\attached
HomeAddr        51:205/311.0
HomeSite        3rdplanet.com
Organisation    STarship and Quark's Holosuites
TZ              PDT
;       Window          16,8,64,128
;	
;	Wormhole plays the NewMailSample when it finds a new inbound
;	email file in the NewEmail folder.
NewMailSample   e:\octopus\sounds\chanopen.wav
;
;	Plays the SendMailSample when it begins the outbound mail run.
;	This sample plays even if there's no outbound mail to process.
SendMailSample  e:\octopus\sounds\unclear.wav
;
;	If SecureMail is set to ON, Wormhole will toss inbound packets
;	into your protected inbound folder; if it is off, or if this
;	line is omitted, they will go into the regular inbound folder.
SecureMail      Off
;
;	Wormhole needs a temporary folder to store UUencoded packets
;	when calling the UUdecoder program:
Temp            f:\temp
;	
;	The buffer size is the maximum amount of data that Wormhole will
;	"grab" from the new email file at one time.  I suggest making this
;	about 1/2 the size of your free RAM; Wormhole will run faster with
;	more memory, and at the moment, cannot handle mail packets larger
;	than the buffer size.  This last will be fixed in a future release.
BufferSize      212144
;
;	ftn packet directories:
;	First, inbound and protected, where Wormhole will toss inbound
;	packets:
;
Inbound         f:\inbound
Protect         f:\protect
;
;	Where to look for outbound packets:
;
Outbound        f:\atarinet.033
Outbound        f:\nest.05a
;
;	ftn file names and addresses; Wormhole looks for the packet filename
;	(with various extensions, use ONLY the 8-charcter filename) and sends
;	them to the indicated address:
;
Send            02I00000        dbrewood@cix.compulink.co.uk
Send            080G00UR        WORMHOLE <starship@3rdplanet.com>
Send            02U03W00        AUTONET@mettav.demon.co.uk
;
;       UUencoder path and command line:
;	%s is the file to be uuencoded;
;	%f is the filename for the encoded file to be written to
;
Encode          c:\archiver\esscd63\esscode.prg -uue %s %f
;
;	UUdecoder path and command line:
;	%s is the inbound uucoded file;
;	%f is the decoded filename
;
Decode          c:\archiver\esscd63\esscode.prg -uud %s %f
;
