;*************************************;
; WASM Buffered File I/O, Token Input ;
; By Eric Tauck                       ;
;                                     ;
; Defines:                            ;
;                                     ;
;   GetTok  input a token             ;
;                                     ;
; Requires:                           ;
;                                     ;
;   BUFFER2.ASM                       ;
;*************************************;

        jmps    _buffer4_end

;========================================
; Read a token delimited by spaces or
; control-characters.
;
; In: AX= storage area; CX= max length;
;     BX= buffer record.
;
; Out: AX= length of token (zero if
;      none); CY= set if error (AX=0 if
;      token too long, AX= error code if
;      read error); EOF returns a zero
;      length token but no error.

GetTok  PROC    NEAR
        push    di
        mov     di, ax

        push    di              ;save to length calculation

;--- skip delimiters

_gttok1 push    cx
        call    GetByt          ;read a character
        pop     cx
        jc      _gttok5         ;jump if error
        cmp     al, 32          ;lower range of valid characters
        jbe     _gttok1         ;loop if delimiter

;--- read non-delimiters

        jmps    _gttok3         ;enter loop

_gttok2 cld
        stosb                   ;store byte
        push    cx
        call    GetByt          ;read character
        pop     cx
        jc      _gttok5
        cmp     al, 32          ;lower range of valid characters
        jbe     _gttok6         ;exit loop if delimiter

_gttok3 loop    _gttok2         ;loop back if more bytes

;--- token too long or read error

        sub     ax, ax          ;return zero if token too long

_gttok4 pop     cx              ;fix stack
        pop     di
        stc
        ret

;--- end of token

_gttok5 or      al, al          ;check if error
        jnz     _gttok4         ;exit if so

_gttok6 sub     al, al          ;NUL
        cld
        stosb                   ;store it

        pop     ax              ;restore start address
        sub     ax, di          ;get difference
        neg     ax              ;adjust
        dec     ax              ;don't count NUL

        pop     di
        clc
        ret
        ENDP

_buffer4_end
