;**************************************;
; WASM Video Module, Fix Cursor Type   ;
; By Eric Tauck                        ;
;                                      ;
; Defines:                             ;
;                                      ;
;   CurFix  force standard cursor type ;
;                                      ;
; Requires:                            ;
;                                      ;
;   VIDEO1.ASM                         ;
;   VIDEO2.ASM                         ;
;   VIDEO4.ASM                         ;
;**************************************;

        jmps    _video9_end

;--- scan line settings for 80x25 mode

_vid_scan LABEL BYTE
        DW      0B0CH   ;MDA
        DW      0607H   ;CGAMON
        DW      0607H   ;CGACOL
        DW      0607H   ;EGAMON         ;not sure if correct
        DW      0607H   ;EGACOL         ;works okay on test system
        DW      0D0EH   ;VGAMON         ;probably works, 0607 might be better
        DW      0D0EH   ;VGACOL         ;works, 0607 also works
        DW      0D0EH   ;MCGAMON        ;not sure if correct
        DW      0D0EH   ;MCGACOL        ;not sure if correct

;========================================
; Set the cursor type according to the
; adapter.  ONLY VALID FOR 80x25 TEXT
; MODE.
;
; Out: CY= set if error.

CurFix  PROC    NEAR
        call    VidTyp                  ;get adapter type
        jc      _crfix2                 ;exit if error
        sub     ah, ah
        dec     ax
        mov     bx, ax
        shl     bx                      ;BX times two
        mov     ax, [_vid_scan + bx]    ;load scan pattern
        mov     _vid_con, ax            ;save it
        call    CurGet                  ;get cursor flag
        or      al, al                  ;check flag
        jz      _crfix1                 ;exit if off
        sub     al, al
        call    CurSet                  ;cursor off
        call    CurSet                  ;cursor on
_crfix1 clc
_crfix2 ret
        ENDP

_video9_end
