{************************************************************************}
{ CRC Generator                                                          }
{                                                                        }
{ This routine updates a CRC value by one byte.  The machine code (i.e.  }
{ the arguments for Inline) was created from the file CRC_TP.ASM.  To    }
{ use this routine, first compile this file and include a "USES CRC;" in }
{ the program using crc16.  A routine to generate an xmodem CRC value    }
{ for a string of characters could be written as:                        }
{                                                                        }
{    FUNCTION crc_of_block (block: String): Word;                        }
{    VAR                                                                 } 
{      crcval,i: Word;                                                   }
{    BEGIN                                                               }
{      crcval := 0;                                                      }
{      FOR i := 1 TO Length (block) DO                                   }
{        crc16 (crcval, Ord(block[i]));                                  }
{      crc16 (crcval, 0);                                                }
{      crc16 (crcval, 0);                                                }
{      crc_of_block := crcval;                                           }
{    END;                                                                }
{************************************************************************}

UNIT CRC;

INTERFACE

PROCEDURE crc16 (VAR crc: Word; data: Byte);

IMPLEMENTATION

{$F+}
PROCEDURE crc16 (VAR crc: Word; data: Byte);
BEGIN
  Inline (
    $1E/$8A/$46/$06/$C5/$5E/$08/$8B/$17/$B9/
    $08/$00/$D0/$E0/$D1/$D2/$73/$04/$81/$F2/
    $21/$10/$E2/$F4/$89/$17/$1F
  );
END;
{$F-}

END.
