;================================================
; CRC Generation Subroutine for Turbo Pascal
;
; This is a code fragment to update a 16 bit CRC
; value by one byte.  To use in Turbo Pascal,
; perform the following steps:
;
;   WASM crc_tp
;   CONVERT pascal < crc_tp.com > temp
;   DEL crc_tp.com
;
; Now the machine code is in text format in the
; file TEMP.  Use this code as follows:
;
;   {$F+}
;   PROCEDURE CRC16 (VAR crc: Word; data: Byte);
;   BEGIN
;     Inline (
;       { insert the contents of file TEMP here }
;     );
;   END.
;   {$F-}

CRCGEN  EQU     1021H   ;xmodem CRC bit pattern

        push    ds              ;DS must be saved
        mov     al, [bp+6]      ;load data byte
        lds     bx, [bp+8]      ;load address of CRC value
        mov     dx, [bx]        ;load current CRC value
        mov     cx, 8           ;bits to process
a1      shl     al              ;shift bit into carry
        rcl     dx              ;roll into checksum
        jnc     a2              ;skip xor if bit not shifted out
        xor     dx, CRCGEN      ;xor CRC value
a2      loop    a1              ;loop for each bit in byte
        mov     [bx], dx        ;save CRC value
        pop     ds              ;restore DS
