;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                    Header                     ;
; Output the list heading.                      ;
;===============================================;

Header Proc Near
 Or List_Stat, Head_Line ;set header in progress
 Mov Di,Head_Buff       ;output buffer

 Cmp List_Type,Nul_File ;check if implicit output to screen
 Je Headscr             ;jump if so
 Cmp List_Type,Con_File ;check if explicit output to screen
 Je Headscr             ;jump if so

;----- printer or file listing, start with formfeed

 Test List_Stat,First_Head ;check if first header
 Jnz Headstart          ;jump if so, no page on first
 Mov Al,Page_Mark       ;page marker (formfeed)
 Stosb
 Jmps Headstart

;----- console (screen) listing, start with blank lines

Headscr
 Mov Cx,Top_Lines       ;blank lines for readability
 Test List_Stat,First_Head ;check if first header
 Jz Hconloop            ;jump if not
 Mov Cx, 1              ;just one line on first page

Hconloop
 Push Cx
 Call Lst_Send          ;send to list file
 Pop Cx
 Mov Di,Head_Buff       ;empty buffer
 Loop Hconloop          ;loop for CX count

;----- title

Headstart
 And List_Stat,Not First_Head ;turn off first bit

 Mov Dl,Width           ;page width
 Mov Si,Title_Buff      ;title location
 Lodsb                  ;load length
 Mov Cl,Al

 Sub Dl,27              ;source and page
 Cmp Al,Dl              ;check if too big
 Jbe Htlenok            ;jump if OK

 Sub Al,Dl              ;extra bytes
 Sub Cl,Al              ;reduce string size

Htlenok Mov Bl,Cl
 Sub Ch,Ch
 Rep
 Movsb                  ;move into buffer

;----- top line spaces, can't use HEAD_FILL because of potential formfeed

 Mov Cl,Width           ;line size
 Sub Cl,27              ;source and page
 Sub Cl,Bl              ;title string
 Store_Spc              ;store

 Mov Al,' '             ;extra space
 Stosb                  ;store

;----- get source name

 Mov Si,Src_Name        ;source name
 Mov Ah,Bit2+Bit3       ;name and extension
 Push Di
 Call Store_Nam         ;get name
 Pop Di

;----- extra spaces due to fewer than 12 characters in the filename

 Mov Si,Name_Buff       ;name location
 Mov Cl,12              ;default spaces
 Sub Cl,[Si]            ;extra number of spaces
 Store_Spc              ;store

;----- translate page number

 Mov Ax,Page_Num        ;page number
 Mov Cx,10              ;number base
 Push Di
 Call Number_Con        ;translate number
 Pop Di

;----- extra spaces due to fewer than 5 digits in the page number

 Mov Si,Num_Buff        ;number location
 Mov Cl,5               ;default spaces
 Sub Cl,[Si]            ;extra number of spaces
 Store_Spc              ;store

;----- store name

 Mov Si,Name_Buff       ;name location
 Store_Str              ;move string

;----- store page text

 Mov Si,Offset Wasmmess ;location
 Store_Str              ;move string

;----- store page number

 Mov Si,Num_Buff        ;number location
 Store_Str              ;move string
 Call Lst_Send          ;send to list file

;----- create time/date string and have BL return the length

 Dos_Function 2ch       ;get time
 Push Cx
 Dos_Function 2ah       ;get date
 Pop Ax
 Call Store_Date        ;create time and date

 Mov Si,Date_Buff       ;string location
 Mov Bl,[Si]            ;length
 Inc Bl                 ;allow for single seperating space

;----- subtitle

 Mov Dl,Width           ;DL has available bytes for line
 Sub Dl,Bl              ;reduce for time/date

 Mov Di,Head_Buff       ;output buffer
 Mov Si,Subt_Buff       ;subtitle location
 Lodsb                  ;load length
 Mov Cl,Al

 Cmp Al,Dl              ;check if too big
 Jbe Hslenok            ;jump if OK

 Sub Al,Dl              ;extra bytes
 Sub Cl,Al              ;reduce string size

Hslenok Sub Ch,Ch
 Rep
 Movsb                  ;move subtitle into buffer

 Call Head_Fill         ;fill in center spaces

 Mov Al,' '             ;extra space
 Stosb                  ;store

;----- store date and time

 Mov Si,Date_Buff       ;string location
 Store_Str              ;move
 Call Lst_Send          ;send to list file

 Mov Di,Head_Buff       ;empty buffer
 Call Lst_Send          ;send blank line

;----- header, check type

 Mov Di,Head_Buff       ;output buffer
 Cmp Head_Type,Norm_Head ;check if normal header
 Jne Symhead            ;jump if not, sym dump header

;----- part one of header

 Mov Si,Offset Part1    ;location
 Store_Str              ;move string

;----- put 11 blanks

 Mov Cl,11              ;11 of them
 Store_Spc              ;store

;----- part two of header

 Mov Si,Offset Part2    ;location
 Store_Str              ;move string

 Mov Bl,9               ;9 bytes for Wasm X.XX
 Call Head_Fill         ;center spaces
 Mov Si,Offset Htitle   ;assembler message
 Store_Str              ;move string

 Call Lst_Send          ;send to list file

 Mov Di,Head_Buff       ;buffer location
 Call Lst_Send          ;send blank line
 And List_Stat, Not Head_Line ;clear header flag
 Ret

;----- symbol table dump header

Symhead Mov Al,Head_Type

 Mov Si,Offset Bramess  ;branch header location
 Dec Al
 Jz Symhput
 Mov Si,Offset Memmess  ;memory reference header location
 Dec Al
 Jz Symhput
 Mov Si,Offset Equmess  ;immediate data header location
 Dec Al
 Jz Symhput
 Mov Si,Offset Macmess  ;macro header location
 Dec Al
 Jz Symhput
 Mov Si,Offset Undmess  ;undefined symbol header location

Symhput Store_Str       ;move string
 Mov Bl,9               ;9 bytes for Wasm X.XX
 Call Head_Fill         ;center spaces
 Mov Si,Offset Htitle   ;assembler message
 Store_Str              ;move string

 Call Lst_Send          ;send to list

 Mov Di,Head_Buff       ;buffer location
 Call Lst_Send          ;send blank line
 And List_Stat, Not Head_Line ;clear header flag
 Ret

;----- header output data

Wasmmess Db 9,' -- Page '
Part1 Db 8,'Loc  Obj'
Part2 Db 13,'Line   Source'
Htitle Db 9,'Wasm ', Version_Hi\10+'0','.',Version_Lo/10+'0',Version_Lo\10+'0'
Bramess Db 16,'Branch Locations'
Memmess Db 17,'Memory References'
Equmess Db 14,'Equated Values'
Macmess Db 14,'Defined Macros'
Undmess Db 17,'Undefined Symbols'

;===============================================;
;                  Head_Fill                    ;
; Local routine of HEADER to add the proper     ;
; number of spaces between right and left       ;
; justified strings. The first string must      ;
; already be in HEAD_BUFF  and the length of    ;
; the second string must be in BL.              ;
;===============================================;

Head_Fill Proc Near
 Mov Ax,Di
 Sub Ax,Head_Buff       ;AX has file name size
 Add Al,Bl              ;add page, total non-spaces

 Mov Cl,Width           ;output width
 Sub Cl,Al              ;number of spaces
 Store_Spc              ;store
 Ret
 Endp                   ;Head_Fill

 Endp                   ;Header

;===============================================;
;                   Line_Out                    ;
; Output a list line to the list file,          ;
; including the location counter, object code,  ;
; line number, and the source code.             ;
;===============================================;

Line_Out Proc Near
 Mov Di,Lst_Buffer      ;output buffer

 Test Line_Stat,Loc_Flag ;check if display location
 Jz Nolinloc            ;jump if not

 Cmp Op_Number,Equate   ;check if EQU
 Jne Locout             ;jump if not, normal location

;----- equate, put indented value

 Mov Cl,2               ;2 spaces
 Store_Spc              ;store

 Mov Ax,Dtype           ;type
 Mov Bx,Dval            ;value
 Call Store_Hnum        ;store number

 Mov Cl,12              ;12 spaces (up to line #)
 Store_Spc              ;store
 Jmps Lnumout           ;jump to line number

;----- fill with spaces up to line number

Nolinloc Mov Cl,18      ;18 spaces (up to line #)
 Store_Spc              ;store
 Jmps Lnumout           ;jump to line number

;----- location counter

Locout Mov Ax,Immed     ;type
 Mov Bx,Lostor          ;the stored location counter
 Call Store_Hnum        ;store number

 Mov Al,' '
 Stosb

;----- procedure nest level

 Mov Al,Op_Number       ;present operation
 Cmp Al,Proc            ;check if PROC
 Jne Lopend
 Mov Dl,Stack_Top       ;nest level
 Jmps Lopcsk

Lopend Cmp Al,Endp      ;Check If Endp
 Jne Lopmac
 Mov Dl,Stack_Top
 Inc Dl                 ;previous nest level

Lopcsk Sub Dh,Dh        ;clear high part
 Mov Bx,Dx
 Dec Bx
 Shl Bx                 ;disp. from stack base
 Add Bx,Stack_Base      ;absolute location

 Mov Si,Offset Linoutar1 ;near arrow
 Test Word [Bx],Fart    ;test if far
 Jz Lioustpm            ;jump if not
 Mov Si,Offset Linoutar2 ;far arrow

Lioustpm Store_Str      ;store

 Mov Ax,Dx
 Jmps Lopnumfill

;----- macro nest level

Lopmac Test Line_Stat,Mac_Line ;check if macro line
 Jz Lopobj              ;jump if not

 Mov Si,Offset Linoutar3 ;macro arrow
 Store_Str              ;store

 Mov Ax,Nmac_Num        ;nest number

;----- put in number and fill out extra spaces on procedure or macro nest level

Lopnumfill Mov Cx,10    ;base 10
 Call Store_Num         ;store number

 Mov Cl,5               ;most digits
 Sub Cl,Dl              ;remove for digits (DL returned number)
 Add Cl,5               ;spaces up to line number
 Store_Spc              ;store
 Jmps Lnumout

;----- obj code

Lopobj Call Code_Out    ;put line of obj code
 Mov Al,' '
 Stosb

;----- line number

Lnumout Test Mac_Stat,Mac_Flag ;check if macro expansion
 Jz Nomaclinn           ;jump if not, non-macro line
 Cmp Nmac_Num,1         ;check if nested macros
 Ja Lomlinn             ;jump if above one, definitely a macro line
 Test Line_Stat,Mac_Line ;check if very start of macro (MACRO line)
 Jz Lomlinn             ;jump if not, definitely a macro line

Nomaclinn Mov Cx,10     ;base 10
 Mov Dx,0520h           ;length 5, buffer with ' '
 Test Line_Stat,Inc_Line ;check if include line
 Jnz Lorlinn            ;jump if so

;----- normal line number

 Mov Ax,Line_Num        ;line number
 Call Store_Fnum        ;formated number output
 Jmps Lolintyp

;----- include line number

Lorlinn Mov Bx,Inctor   ;include storage
 Mov Ax,[Bx+9]          ;line number
 Call Store_Fnum        ;formated number output
 Jmps Lolintyp

;----- macro line number (no number)

Lomlinn Mov Al,' '      ;space
 Mov Cx,5               ;fill number area
 Rep
 Stosb                  ;store spaces

;----- line type

Lolintyp Mov Al,' '     ;space
 Stosb                  ;store space after line number

 Mov Al,Mac_Char        ;macro character
 Test Mac_Stat,Mac_Flag ;check if macro expansion
 Jz Nomaclint           ;jump if not
 Cmp Nmac_Num,1         ;check if nested macros
 Ja Lomlint             ;jump if above one
 Test Line_Stat,Mac_Line ;check if initial macro line
 Jz Lomlint             ;jump if not

Nomaclint Mov Al,Inc_Char ;include character
 Test Input_Stat,Inc_Flag ;check if include
 Jz Noincint            ;jump if not
 Test Line_Stat,Inc_Line ;check if include line
 Jz Lomlint             ;jump if not

Noincint Mov Al,' '     ;normal character

Lomlint Stosb           ;store marker
 Mov Al,' '             ;space before source
 Stosb                  ;store

;----- source line

 Mov Cx,Src_Size        ;source line length
 Sub Ax,Ax
 Mov Al,Width           ;output width
 Sub Ax,26              ;AX gets max source length
 Cmp Cx,Ax              ;check size
 Jbe Oless              ;jump if short enough
 Mov Cx,Ax              ;set to max length
Oless Mov Si,Line       ;source
 Rep
 Movsb                  ;move to buffer

;----- send buffer

 Call Lst_Send          ;send output buffer

;----- check if extra object output

 Cmp Obj_Length,6       ;check if more than 6
 Jbe Noutmore           ;jump if not
 Call Extra_Code        ;output the extra
Noutmore Ret

;----- data

Linoutar1 Db 3,'-> '
Linoutar2 Db 3,'=> '
Linoutar3 Db 3,'*> '

;===============================================;
;                   Code_Out                    ;
; Local routine of LINE_OUT to write the        ;
; original line of object code to the list      ;
; line (DI).                                    ;
;===============================================;

Code_Out Proc Near

;----- output code

 Mov Ax,Obj_Length      ;object code length
 Cmp Ax,6               ;can't ouput more than 6
 Jbe Leco               ;jump if short enough
 Mov Ax,6               ;output only 6 bytes of code

Leco Mov Si,Obj_Buffer  ;source
 Mov Cx,Ax              ;set number of bytes to write
 Push Ax
 Call Obj_Move          ;translate and write to buffer
 Pop Ax

;----- fill in extra spaces

 Mov Cl,6               ;max 6
 Sub Cl,Al              ;amount to fill
 Shl Cl                 ;two spaces for each byte
 Store_Spc              ;store spaces
 Ret
 Endp                   ;Code_Out

;===============================================;
;                  Extra_Code                   ;
; Local routine of LINE_OUT to output any       ;
; extra lines of object code.                   ;
;===============================================;

Extra_Code Proc Near
 Mov Si,Obj_Buffer      ;source
 Add Si,6               ;skip the first six

 Mov Ax,Obj_Length      ;number of bytes
 Sub Ax,6               ;skip the first six

;----- loop for each row of output

Ecodeloop Mov Di,Lst_Buffer ;output buffer
 Mov Cl,5               ;five of them
 Push Ax
 Store_Spc              ;store
 Pop Ax

;----- set number of bytes to output

 Push Ax
 Cmp Al,6               ;check if less than six
 Jb Codless             ;all bytes if less than six
 Mov Ax,6               ;put in six

Codless Mov Cx,Ax       ;number to output
 Call Obj_Move          ;translate and write to buffer

 Push Si
 Call Lst_Send          ;send output buffer
 Pop Si
 Pop Ax

 Cmp Ax,6               ;how many left?
 Jbe Coddone            ;jump if done
 Sub Ax,6               ;bytes remaining
 Jmps Ecodeloop         ;loop for remaining bytes

Coddone Ret
 Endp                   ;Extra_Code

;===============================================;
;                   Obj_Move                    ;
; Local routine of LINE_OUT to move CX bytes    ;
; of object code from from SI to DI,            ;
; translating into ASCII.                       ;
;===============================================;

Obj_Move Proc Near
 Or Cx,Cx
 Jz Nobj                ;jump if no output

;----- loop for each byte to output

Objloop Push Cx
 Lodsb                  ;load number
 Sub Ah,Ah
 Mov Cx,16              ;base 16
 Mov Dx,0230h           ;length 2, buffer with '0' (30H)
 Call Store_Fnum        ;store number
 Pop Cx
 Loop Objloop

Nobj Ret
 Endp                   ;Obj_Move

 Endp                   ;Line_Out

;===============================================;
;                   Sym_Dump                    ;
; Dumps symbol table in alphabetical order,     ;
; divided into pages by type, to the list file. ;
;===============================================;

Sym_Dump Proc Near

;----- near and far labels

 Mov Head_Type,Bra_Head ;branch locations
 Mov Ax,1               ;display values
 Mov Dx,Neart+Fart      ;types
 Call Sym_Tdump         ;dump

;----- direct addresses

 Mov Head_Type,Mem_Head ;memory references
 Mov Ax,1               ;display values
 Mov Dx,Addr            ;types
 Call Sym_Tdump         ;dump

;----- immediate data

 Mov Head_Type,Equ_Head ;immediate data
 Mov Ax,1               ;display values
 Mov Dx,Immed           ;types
 Call Sym_Tdump         ;dump

;----- macros

 Mov Head_Type,Mac_Head ;macros
 Sub Ax,Ax              ;do not display values
 Mov Dx,Macrot          ;types
 Call Sym_Tdump         ;dump

;----- undefined symbols

 Mov Head_Type,Und_Head ;branch locations
 Sub Ax,Ax              ;no values
 Mov Dx,Undef           ;type
 Call Sym_Tdump         ;dump
 Ret
 Endp                   ;Sym_Dump

;===============================================;
;                   Sym_Tdump                   ;
; Start a new page and dump all the symbols     ;
; matching the type in DX. If the first bit in  ;
; AX is set the value is also displayed.        ;
;===============================================;

Sym_Tdump Proc Near
 Push Ax
 Push Dx
 Call Page              ;new page

;----- calculate the number of symbols that will fit across

 Mov Cl,Max_Sdispl      ;symbol size
 Add Cl,4               ;add for: divide (4)
 Mov Bp,Sp
 Test Word [Bp+2],1     ;test if display value
 Jz Nosytval            ;jump if not
 Add Cl,5               ;add for: spc (1) + val (4)
Nosytval Call Num_Across ;number across

;----- dump all matching symbols

 Sub Ch,Ch              ;CH counts number across
 Mov Di,Lst_Buffer      ;output buffer

;----- loop until no symbols are found

Sytloop Push Ds
 Mov Ds,Sym_Seg         ;set data segment

 Mov Bp,Sp
 Mov Dx,[Bp+2]          ;get type
 Push Cx
 Push Di
 Call Sym_Low           ;lowest symbol
 Pop Di
 Pop Cx
 Jnc Sytdone            ;jump if finished

 Cmp Ch,Cl              ;compare to number across
 Je Sytsend             ;jump when enough symbols on a line

;----- add symbol to line

Sytcont Inc Ch          ;one more in buffer
 Push Cx

 Lodsb                  ;symbol length
 Sub Ah,Ah
 Mov Bx,Si
 Add Bx,Ax              ;skip symbol, BX points to symbol data

 Cmp Al,Max_Sdispl      ;check if too long
 Jbe Smlok              ;jump if OK

 Mov Al,Max_Sdispl      ;max length

Smlok Push Si
 Mov Cl,Al
 Sub Ch,Ch              ;CX gets bytes to display
 Rep
 Movsb                  ;move symbol to output buffer
 Pop Si
 Mov Byte [Si],0        ;remove symbol from search

 Mov Dx,[Bx+4]          ;type
 Mov Bx,[Bx]            ;value
 Pop Cx
 Pop Ds
 Push Cx

;----- spaces after symbol

 Push Dx
 Push Bx
 Mov Cl,Max_Sdispl      ;ten bytes total length
 Sub Cl,Al              ;reduce for symbol length
 Inc Cl                 ;space to seperate symbol and value
 Sub Ch,Ch              ;CX has bytes to buffer
 Store_Spc              ;store spaces
 Pop Bx
 Pop Ax

;----- display value

 Test Word [Bp+4],1     ;test if display value
 Jz Sytsep              ;jump if not
 Call Store_Hnum        ;store

;----- seperation blanks

Sytsep Mov Cl,4         ;four of them
 Store_Spc              ;store
 Pop Cx
 Jmps Sytloop           ;loop for next symbol

;----- send a line of symbols before putting in next symbol

Sytsend Pop Ds

 Push Cx
 Push Si
 Call Lst_Send          ;send buffer
 Pop Si
 Pop Cx

 Sub Ch,Ch              ;reset count
 Mov Di,Lst_Buffer      ;beginning of output buffer
 Push Ds
 Mov Ds,Sym_Seg         ;set segment
 Jmps Sytcont           ;back to display symbol

;----- finished

Sytdone Pop Ds
 Add Sp,4               ;throw away type and status word
 And Opt_Stat,Not Page_Flag ;no more paging
 Or Ch,Ch               ;check if symbols still in buffer
 Jz Allsdd              ;jump if all sent
 Call Lst_Send          ;send buffer, symbols still in it
Allsdd Ret
 Endp                   ;Sym_Tdump

;===============================================;
;                  Num_Across                   ;
; Calculate the number of entries that will     ;
; fit across the page. The width of a single    ;
; entry must be in CL. The number that will     ;
; fit across is returned in CL.                 ;
;===============================================;

Num_Across Proc Near
 Mov Al,Width           ;width
 Sub Ah,Ah              ;clear high part
 Div Al,Cl              ;AL gets number across
 Mov Cl,Al
 Ret
 Endp                   ;Num_Across

;===============================================;
;                    Sym_Low                    ;
; Returns the alphabetically lowest symbol      ;
; matching the bit pattern in DX. DS must be    ;
; pointing to the symbol segment. Carry is set  ;
; if one is found.                              ;
;===============================================;

Sym_Low Proc Near
 Push Es
 Mov Ax,Ds
 Mov Es,Ax              ;symbol segment
 Sub Si,Si              ;beginning of symbol table

;----- find first eligible symbol

 Call Next_Sym          ;next symbol
 Jnc Slnone             ;jump if none found
 Mov Di,Si              ;DI holds symbol to display
 Push Ax

;----- loop through all other possible symbols

Slloop Pop Si
 Call Next_Sym          ;next symbol
 Jnc Sldone             ;jump if none found

 Push Ax                ;save next symbol location on the stack
 Call Comp_Astr         ;compare strings at DI and SI
 Jbe Slloop             ;loop back if DI<=SI, no switch
 Mov Di,Si              ;new low symbol
 Jmps Slloop            ;loop back for next symbol

;----- finished

Sldone Mov Si,Di
 Pop Es
 Stc
 Ret

;----- no symbols available

Slnone Pop Es
 Clc
 Ret
 Endp                   ;Sym_Low

;===============================================;
;                   Next_Sym                    ;
; Find the next symbol in the symbol table      ;
; whose first byte isn't zero and whose type    ;
; matches the bit pattern in DX. The search is  ;
; started at DS:SI (where DS contains the       ;
; symbol table segment and SI is the pointer    ;
; within it). Carry set if found and AX         ;
; returns pointing to the next symbol.          ;   
;===============================================;

Next_Sym Proc Near
 Seg Cs
 Cmp Si,Sym_Point       ;all checked?
 Je Nextsymf            ;jump if not

;----- get length and point to next symbol

Nextsyml Mov Al,[Si]    ;load length
 Sub Ah,Ah
 Mov Bx,Ax
 Add Ax,7               ;add for data and symbol length
 Add Ax,Si              ;point to next symbol

;----- check if valid symbol

 Cmp Byte [Si+1],0      ;check if first byte is zero
 Je Nextsymd            ;jump if so
 Test [Si+Bx+5],Dx      ;test type
 Jz Nextsymd            ;jump if no match
 Test Word [Si+Bx+5],Mlabel+Cfalse_Sym ;test for special sym
 Jnz Nextsymd           ;jump if so
 Test Word [Si+Bx+5],Undef ;test if undefined
 Jnz Nextundef          ;jump if so

;----- successful

Nextsucc Stc
 Ret

;----- undefined symbol

Nextundef Test Dx,Undef ;see if specifically looking for undefined
 Jnz Nextsucc           ;jump if so

;----- not found, try again or fail

Nextsymd Mov Si,Ax      ;source to next symbol
 Seg Cs
 Cmp Ax,Sym_Point       ;all checked?
 Jne Nextsyml           ;jump if not

;----- fail

Nextsymf Clc
 Ret
 Endp                   ;Next_Sym

