;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                   New_Line                    ;
; New display line. Print a CR and LF to the    ;
; screen.                                       ;
;===============================================;

New_Line Proc Near
 Mov Si, Offset Newlindat ;data
 Call Print_Str         ;send to display
 Ret

Newlindat Db 2, 13, 10
 Endp                   ;New_Line

;===============================================;
;                   Print_Str                   ;
; Print the string at SI to the screen. First   ;
; byte must be length.                          ;
;===============================================;

Print_Str Proc Near
 Mov Bx,Std_Device      ;standard output
 Mov Cl,[Si]
 Sub Ch,Ch              ;CX has length
 Mov Dx,Si              ;buffer location
 Inc Dx
 Dos_Function 40h       ;print character
 Ret
 Endp                   ;Print_Str

;===============================================;
;                  Print_Char                   ;
; Print the character in AL to the screen.      ;
;===============================================;

Print_Char Proc Near
 Mov Dl,Al              ;character
 Dos_Function 2         ;display
 Ret
 Endp                   ;Print_Char

;===============================================;
;                    Opener                     ;
; Opens source, list and object files.          ;
;===============================================;

Opener Proc Near

;----- open source

 Mov Dx,Src_Name        ;source name
 Call Open_File         ;open sourec file
 Jc Srcerror            ;jump if error
 Mov Src_Handle,Ax      ;save handle
 Or Io_Stat,Src_Open    ;set i/o bit

;----- open object

 Mov Dx,Obj_Name        ;object file name
 Call Make_File         ;create object file
 Jc Objerror            ;jump if error
 Mov Obj_Handle,Ax      ;save handle
 Or Io_Stat,Obj_Open    ;set i/o bit

;----- open list

 Cmp List_Type,Nul_File ;check if no list
 Je Nooplis
 Cmp List_Type,Con_File ;check if console
 Je Nooplis
 Cmp List_Type,Prn_File ;check if printer
 Je Nooplis

 Mov Dx,Lst_Name        ;list file name
 Call Make_File         ;create list file
 Jc Lsterror            ;jump if error
 Mov Lst_Handle,Ax      ;save handle
 Or Io_Stat,Lst_Open    ;set i/o bit
Nooplis Ret

;----- source open error

Srcerror Mov Ax,9002h   ;error 2
 Call Error             ;critical error

;----- object open error

Objerror Mov Ax,9004h   ;error 4
 Call Error             ;critical error

;----- list open error

Lsterror Mov Ax,9005h   ;error 5
 Call Error             ;critical error
 Endp                   ;Opener

;===============================================;
;                   Open_File                   ;
; Opens the file using the name at DX. The      ;
; carry flag is set if there are problems,      ;
; cleared otherwise. AX returns file handle.    ;
;===============================================;

Open_File Proc Near
 Dos_Function 3dh, 0    ;open file for read
 Ret
 Endp                   ;Open_File

;===============================================;
;                 Begin_File                    ;
; Sets source file read pointer to beginning    ;
; of file.                                      ;
;===============================================;

Begin_File Proc Near
 Test Input_Stat,Src_Whole ;check if entire file read
 Jnz Begfwhol           ;jump if so

 Mov Bx,Src_Handle      ;file handle
 Sub Cx,Cx
 Mov Dx,Cx              ;address 0000:0000
 Dos_Function 42h, 0    ;move file pointer, absolute
Begfwhol Ret
 Endp                   ;Begin_File

;===============================================;
;                     Read                      ;
; Reads as much of a buffer full from the       ;
; source file as it can. Sets all source        ;
; pointers and flags.                           ;
;===============================================;

Read Proc Near
 Test Input_Stat,Src_Whole ;check if entire file read
 Jnz Readwhol           ;jump if so
 Or Input_Stat,Src_Flag ;set source flag true

;----- read from file

 Push Ds
 Mov Bx,Src_Handle      ;source handle
 Mov Cx,Read_Size       ;amount to read
 Sub Dx,Dx              ;start of buffer
 Mov Ds,Src_Seg         ;segment
 Dos_Function 3fh       ;read from file
 Pop Ds

;----- check if end of file

 Cmp Ax,Cx              ;check if all bytes read
 Je Readok              ;jump if so
 And Input_Stat,Not Src_Flag ;clear file flag if not filled

;----- set source pointers

Readok Mov Src_Point,Dx ;set source pointer to beginning
 Add Dx,Ax              ;compute buffer end
 Mov Src_End,Dx         ;save it
 Test Input_Stat,Src_First ;check if first buffer
 Jnz Readcfb            ;jump if so
 Ret

;---- first file read, set whole file flag if entire file read

Readcfb And Input_Stat,Not Src_First ;not first buffer anymore
 Test Input_Stat,Src_Flag ;see if eof
 Jnz Readcfbn           ;jump if not
 Or Input_Stat,Src_Whole ;set whole file flag
Readcfbn Ret

;----- entire file in buffer, just reset read pointer

Readwhol Sub Ax,Ax      ;start of buffer
 Mov Src_Point,Ax       ;set source pointer to beginning
 And Input_Stat, Not Src_Flag ;set eof flag
 Ret
 Endp                   ;Read

;===============================================;
;                  Lst_Send                     ;
; Stores bytes in LST_BUFFER up to DI in        ;
; LST_OUTBUF for output by interfacing with     ;
; STORE. Adds a CR and LF to end.               ;
;===============================================;

Lst_Send Proc Near
 Or Io_Stat,Lst_Data    ;buffer in use

;----- check for optional first line

 Test List_Stat,Opt_Line6 ;check if optional line
 Jz Chklscr             ;jump if not

 And List_Stat,Not Opt_Line6 ;clear optional line flag
 Test List_Stat, Last_Line ;check if last line
 Jnz Chklscr            ;jump if so
 Test Opt_Stat, Page_Flag ;check if paging
 Jz Chklscr             ;jump if not

 Mov Al, Page_Line      ;previous page line number
 Cmp Al, Page_Size      ;check if will start new page
 Jnae Chklscr           ;jump if not
 Ret

;----- add line marker

Chklscr
 Test List_Stat,Last_Line ;check if partial line (last line -- ^Z)
 Jnz Nolslm             ;jump if so, no CR + LF

 Mov Ax,Line_Mark       ;carrige return and line feed
 Stosw                  ;store them

;----- increment line number and check if new page

 Mov Al,Page_Line       ;present page line
 Cmp Al, 255            ;check if out of range
 Je Pagnpi              ;jump if so, leave it there
 Inc Al                 ;another output line
 Mov Page_Line,Al       ;save

Pagnpi
 Test Opt_Stat,Page_Flag ;check if no paging
 Jz Nolslm              ;jump if so

 Test List_Stat, Head_Line ;check if in header
 Jnz Nolslm             ;jump if so
 Cmp Al,Page_Size       ;check if new page
 Jbe Nolslm             ;jump if not

;----- new page

 Mov Page_Line,0        ;reset page line number
 Inc Page_Num           ;next page
 Push Di
 Call Header            ;header (indirectly recursive)
 Pop Di

;----- send line

Nolslm
 Mov Si,Lst_Buffer      ;list file buffer location
 Test List_Stat, Head_Line ;check if in header
 Jz Paghlin             ;jump if so
 Mov Si,Head_Buff       ;head list file buffer location

Paghlin
 Push Es
 Mov Cx,Di              ;pointer in buffer
 Sub Cx,Si              ;bytes to store
 Mov Bx,Lst_Handle      ;list file handle
 Mov Di,Lst_Outlen      ;bytes in output buffer
 Mov Dx,Lst_Name        ;list name
 Mov Es,Lst_Seg         ;segment
 Call Store             ;store buffer
 Pop Es
 Mov Lst_Outlen,Di      ;new number of bytes in output buffer
 Ret
 Endp                   ;Lst_Send

;===============================================;
;                  Obj_Send                     ;
; Stores OBJ_LENGTH bytes of object code in     ;
; OBJ_BUFFER for output by interfacing with     ;
; STORE.                                        ;
;===============================================;

Obj_Send Proc Near
 Or Io_Stat,Obj_Data    ;buffer in use
 Mov Cx,Obj_Length      ;bytes in object buffer
 Or Cx,Cx               ;check if zero
 Jz Empbuff             ;jump if zero
 Push Es
 Mov Bx,Obj_Handle      ;object file handle
 Mov Di,Obj_Outlen      ;bytes in object output buffer
 Mov Dx,Obj_Name        ;object name
 Mov Es,Obj_Seg         ;buffer segment
 Mov Si,Obj_Buffer      ;object buffer locatiom
 Call Store             ;store buffer
 Pop Es
 Mov Obj_Outlen,Di      ;new number of bytes in output buffer
Empbuff Ret
 Endp                   ;Obj_Send

;===============================================;
;                    Store                      ;
; Stores the number of bytes in CX from SI to   ;
; ES:DI buffer location (ES:0000 is the start   ;
; of the buffer). WRITE_SIZE is the max buffer  ;
; size. DI returns the new number of bytes in   ;
; the buffer. If the buffer is filled then it   ;
; is written to the file specified by the       ;
; handle in BX. DX must point to the file name  ;
; in case of an error.                          ;
;===============================================;

Store Proc Near
 Mov Ax,Write_Size      ;buffer size
 Cmp Di,Ax              ;compare to buffer size
 Je Storeful            ;write before store

 Sub Ax,Di              ;AX gets available bytes to fill
 Cmp Cx,Ax              ;check if too many
 Ja Storesom            ;jump if so

;----- store bytes to buffer, do not need write

 Rep
 Movsb                  ;store bytes
 Ret

;----- buffer full, write before store

Storeful
 Push Cx
 Push Dx
 Mov Cx,Write_Size      ;bytes to write
 Sub Dx,Dx              ;location, ES:DX = ES:0000
 Call Write             ;write buffer
 Pop Dx
 Pop Cx
 Jc Storerr             ;jump if error

 Sub Di,Di              ;reset pointer
 Rep
 Movsb                  ;store bytes
 Ret

;----- all bytes will not fit, must store some and then write

Storesom
 Push Ax
 Push Cx
 Push Dx

 Mov Cx,Ax              ;available bytes
 Rep
 Movsb                  ;store bytes

 Mov Cx,Write_Size      ;bytes to write
 Sub Dx,Dx              ;location, ES:DX = ES:0000
 Call Write             ;write buffer
 Pop Dx
 Pop Cx
 Pop Ax
 Jc Storerr             ;jump if error

 Sub Cx,Ax              ;reduce for bytes written
 Sub Di,Di              ;reset pointer
 Rep
 Movsb                  ;store extra bytes
 Ret

;----- some kind of error in WRITE, critical error

Storerr
 Or Io_Stat, Disk_Full  ;set disk full
 Mov Ax,9000h           ;error 0
 Call Error             ;error routine
 Endp                   ;Store

;===============================================;
;                   Flusher                     ;
; Flushes list and object files.                ;
;===============================================;

Flusher Proc Near
 Push Es
 Test Io_Stat, Disk_Full ;check if disk full
 Jnz Noflusho

;----- list

 Test Io_Stat,Lst_Data  ;check if bytes written
 Jz Noflushl            ;jump if not

 Mov Ax, Lst_Name       ;name
 Mov Bx, Lst_Handle     ;handle
 Mov Cx, Lst_Outlen     ;bytes
 Sub Dx, Dx             ;start of buffsr
 Mov Es, Lst_Seg        ;segement
 Call Flush
 And Io_Stat, Not Lst_Data ;clear flag

;----- object

Noflushl
 Test Io_Stat,Obj_Data  ;check if bytes written
 Jz Noflusho            ;jump if not

 Mov Ax, Lst_Name       ;name
 Mov Bx, Obj_Handle     ;handle
 Mov Cx, Obj_Outlen     ;bytes
 Sub Dx, Dx             ;start of buffsr
 Mov Es, Obj_Seg        ;segement
 Call Flush
 And Io_Stat, Not Obj_Data ;clear flag

Noflusho
 Pop Es
 Ret
 Endp                   ;Flusher

;===============================================;
;                   Flush                       ; 
; Writes the final buffer at ES:DX. The handle  ;
; is in BX and the bytes to write are in CX.    ;
; AX must point to the file name in case of     ;
; error.                                        ;
;===============================================;

Flush Proc Near
 Or Cx,Cx               ;check if any
 Jz Noflu               ;exit if nothing to write

 Push Ax
 Call Write             ;write buffer
 Pop Dx
 Jc Fluserr             ;jump if error
Noflu Ret

;----- some kind of error in WRITE, critical error

Fluserr
 Or Io_Stat, Disk_Full  ;set disk full
 Mov Ax,9000h           ;error 0
 Call Error             ;error routine
 Endp                   ;Flush

;===============================================;
;                    Write                      ;
; Write the buffer at ES:DX using the handle    ;
; in BX. The bytes to write are in CX.  The     ;
; carry is set if there is an error.            ;
;===============================================;

Write Proc Near
 Push Ds
 Mov Ax,Es
 Mov Ds,Ax              ;set data segment
 Dos_Function 40h       ;write to file
 Pop Ds
 Jc Writeer             ;jump if error
 Cmp Cx, Ax             ;check bytes written
 Jne Writeer            ;jump if error
 Clc
 Ret

;----- write error

Writeer
 Stc
 Ret
 Endp                   ;Write

;===============================================;
;                  Make_File                    ;
; Creates a file using the name at DX. The      ;
; carry flag is set if there are problems,      ;
; cleared otherwise. AX returns file handle.    ;
;===============================================;

Make_File Proc Near
 Sub Cx,Cx              ;normal attribute
 Dos_Function 3ch       ;create file
 Ret
 Endp                   ;Make_File

;===============================================;
;                   Closer                      ;
; Close the list, source, and object files.     ;
;===============================================;

Closer Proc Near

;----- include (only open if premature termination)

Closeiloop
 Test Input_Stat,Inc_Flag ;test if include
 Jz Noclosei            ;jump if not
 Call Pop_Source        ;pop source input level
 Jmps Closeiloop        ;try again

;----- source

Noclosei
 Test Io_Stat,Src_Open  ;check if opened
 Jz Nocloses            ;jump if not

 Mov Bx,Src_Handle      ;source handle
 Call Close_File        ;close file
 And Io_Stat,Not Src_Open ;clear bit

;----- object

Nocloses
 Test Io_Stat,Obj_Open  ;check if opened
 Jz Nocloseo            ;jump if not

 Mov Bx,Obj_Handle      ;object handle
 Call Close_File        ;close file
 And Io_Stat,Not Obj_Open ;clear bit

;----- list

Nocloseo
 Test Io_Stat,Lst_Open  ;check if opened
 Jz Noclosel            ;jump if not

 Mov Bx,Lst_Handle      ;list handle
 Call Close_File        ;close file
 And Io_Stat,Not Lst_Open ;clear bit

Noclosel Ret
 Endp                   ;Closer

;===============================================;
;                Close_File                     ;
; Given file handle in BX, will close the       ;
; file.                                         ;
;===============================================;

Close_File Proc Near
 Dos_Function 3eh       ;close file
 Ret
 Endp                   ;Close_File

