# bmk-make.mk
# This file is part of the FreeBASIC test suite
#
# make file for building mutile-module tests
# and testing run-time assertions
#
# expected usage
# make -f bmk-make.mk [clean] { BMK=? | FILE=? } TEST_MODE=? [ALLOW_CUNIT=0|1]
#   clean
#       clean files
#   BMK=/path/filename.bmk
#       make file for multi-module test (a make include file)
#   FILE=/path.filename.bas
#       single module filename to test
#   TEST_MODE:
#       COMPILE_AND_RUN_OK
#       COMPILE_AND_RUN_FAIL
#       MULTI_MODULE_OK
#       MULTI_MODULE_FAIL
#

include common.mk

ifeq ($(HOST),dos)
SHELL = /bin/sh
else
SHELL := $(SHELL)
endif
ECHO := echo

ifndef FBC
FBC := fbc$(EXEEXT)
endif

ifeq ($(TEST_MODE),COMPILE_AND_RUN_OK)
RUN_TEST := run_test_ok
else
ifeq ($(TEST_MODE),COMPILE_AND_RUN_FAIL)
RUN_TEST := run_test_fail
else
ifeq ($(TEST_MODE),MULTI_MODULE_OK)
RUN_TEST := run_test_ok
else
ifeq ($(TEST_MODE),MULTI_MODULE_FAIL)
RUN_TEST := run_test_fail
else
$(error TEST_MODE $(TEST_MODE) not supported)
endif
endif
endif
endif

FBC_CFLAGS :=
FBC_LFLAGS :=

ifneq ($(FB_LANG),)
FBC_CFLAGS += -lang $(FB_LANG)
endif

ifneq ($(FPU),)
FBC_CFLAGS += -fpu $(FPU)
endif

MAINX :=
SRCSX :=

ifneq ($(BMK),)

include $(BMK)
SRCDIR := $(dir $(BMK))
MAINX := $(addprefix $(SRCDIR),$(MAIN))
SRCSX := $(MAINX) $(addprefix $(SRCDIR),$(SRCS))

else

SRCDIR :=
MAINX := $(FILE)
SRCSX := $(FILE)

endif

MAIN_MODULE := $(basename $(MAINX))
APP := $(MAIN_MODULE)$(EXEEXT)

ifeq ($(MAIN_MODULE),)
$(error main module not specified)
endif

FBC_CFLAGS += -g -w 0 
FBC_LFLAGS += -g

ifeq ($(ALLOW_CUNIT),1)
FBC_CFLAGS += -i fbcu/fake
endif

OBJS := $(addsuffix .o,$(basename $(SRCSX)))

all : $(RUN_TEST)

$(OBJS) : %.o : %.bas
	$(FBC) $(FBC_CFLAGS) -m $(MAIN_MODULE) -c $< -o $@

$(APP) : $(OBJS)
	$(FBC) $(FBC_LFLAGS) $(OBJS) -x $(APP)

run_test_ok : $(APP)
	@if $(APP) ; then true ; else false ; fi

run_test_fail : $(APP)
	@if $(APP) ; then false ; else true ; fi

.PHONY : clean
clean:
	@$(ECHO) Cleaning $(SRCDIR)$(MAIN_MODULE) files ...
	@$(RM) $(OBJS) $(APP)
