''
''
'' d3d9types -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __win_d3d9types_bi__
#define __win_d3d9types_bi__

#ifndef DIRECT3D_VERSION
#define DIRECT3D_VERSION &h0900
#endif

#define D3DCLEAR_TARGET &h01
#define D3DCLEAR_ZBUFFER &h02
#define D3DCLEAR_STENCIL &h04
#define D3DCLIPPLANE0 &h01
#define D3DCLIPPLANE1 &h02
#define D3DCLIPPLANE2 &h04
#define D3DCLIPPLANE3 &h08
#define D3DCLIPPLANE4 &h10
#define D3DCLIPPLANE5 &h20
#define D3DCOLOR_ARGB(a,r,g,b) (cast(D3DCOLOR,(((a) and &hff) shl 24) or (((r) and &hff) shl 16) or (((g) and &hff) shl 8) or ((b) and &hff)))
#define D3DCOLOR_COLORVALUE(r,g,b,a) D3DCOLOR_RGBA(cuint((r)*255),cuint((g)*255),cuint((b)*255),cuint((a)*255))
#define D3DCOLOR_RGBA(r,g,b,a) D3DCOLOR_ARGB(a,r,g,b)
#define D3DCOLOR_XRGB(r,g,b) D3DCOLOR_ARGB(&hff,r,g,b)
#define D3DCOLOR_XYUV(y,u,v) D3DCOLOR_ARGB(&hff,y,u,v)
#define D3DCOLOR_AYUV(a,y,u,v) D3DCOLOR_ARGB(a,y,u,v)
#define D3DCOLORWRITEENABLE_RED &h01
#define D3DCOLORWRITEENABLE_GREEN &h02
#define D3DCOLORWRITEENABLE_BLUE &h04
#define D3DCOLORWRITEENABLE_ALPHA &h08
#define D3DCS_LEFT &h01
#define D3DCS_RIGHT &h02
#define D3DCS_TOP &h04
#define D3DCS_BOTTOM &h08
#define D3DCS_FRONT &h10
#define D3DCS_BACK &h20
#define D3DCS_PLANE0 &h40
#define D3DCS_PLANE1 &h80
#define D3DCS_PLANE2 &h100
#define D3DCS_PLANE3 &h200
#define D3DCS_PLANE4 &h400
#define D3DCS_PLANE5 &h800
#define D3DCS_ALL (&h01 or &h02 or &h04 or &h08 or &h10 or &h20 or &h40 or &h80 or &h100 or &h200 or &h400 or &h800)
#define D3DDECL_END() {&hff,0,D3DDECLTYPE_UNUSED,0,0,0}
#define D3DDP_MAXTEXCOORD 8
#define D3DPV_DONOTCOPYDATA &h01
#define D3DTA_SELECTMASK &h0f
#define D3DTA_DIFFUSE &h00
#define D3DTA_CURRENT &h01
#define D3DTA_TEXTURE &h02
#define D3DTA_TFACTOR &h03
#define D3DTA_SPECULAR &h04
#define D3DTA_TEMP &h05
#define D3DTA_CONSTANT &h06
#define D3DTA_COMPLEMENT &h10
#define D3DTA_ALPHAREPLICATE &h20
#define D3DFVF_RESERVED0 &h01
#define D3DFVF_POSITION_MASK &h4000E
#define D3DFVF_XYZ &h02
#define D3DFVF_XYZRHW &h04
#define D3DFVF_XYZB1 &h06
#define D3DFVF_XYZB2 &h08
#define D3DFVF_XYZB3 &h0a
#define D3DFVF_XYZB4 &h0c
#define D3DFVF_XYZB5 &h0e
#define D3DFVF_XYZW &h4002
#define D3DFVF_NORMAL &h10
#define D3DFVF_PSIZE &h20
#define D3DFVF_DIFFUSE &h40
#define D3DFVF_SPECULAR &h80
#define D3DFVF_TEXCOUNT_MASK &hf00
#define D3DFVF_TEXCOUNT_SHIFT 8
#define D3DFVF_TEX0 &h0000
#define D3DFVF_TEX1 &h0100
#define D3DFVF_TEX2 &h0200
#define D3DFVF_TEX3 &h0300
#define D3DFVF_TEX4 &h0400
#define D3DFVF_TEX5 &h0500
#define D3DFVF_TEX6 &h0600
#define D3DFVF_TEX7 &h0700
#define D3DFVF_TEX8 &h0800
#define D3DFVF_TEXCOORDSIZE1(i) (D3DFVF_TEXTUREFORMAT1 shl (i * 2 + 16))
#define D3DFVF_TEXCOORDSIZE2(i) (D3DFVF_TEXTUREFORMAT2)
#define D3DFVF_TEXCOORDSIZE3(i) (D3DFVF_TEXTUREFORMAT3 shl (i * 2 + 16))
#define D3DFVF_TEXCOORDSIZE4(i) (D3DFVF_TEXTUREFORMAT4 shl (i * 2 + 16))
#define D3DFVF_TEXTUREFORMAT1 3
#define D3DFVF_TEXTUREFORMAT2 0
#define D3DFVF_TEXTUREFORMAT3 1
#define D3DFVF_TEXTUREFORMAT4 2
#define D3DFVF_LASTBETA_UBYTE4 &h1000
#define D3DFVF_LASTBETA_D3DCOLOR &h8000
#define D3DFVF_RESERVED2 &h6000
#define D3DDMAPSAMPLER 256
#define D3DVERTEXTEXTURESAMPLER0 (256+1)
#define D3DVERTEXTEXTURESAMPLER1 (256+2)
#define D3DVERTEXTEXTURESAMPLER2 (256+3)
#define D3DVERTEXTEXTURESAMPLER3 (256+4)
#define D3DVS_ADDRESSMODE_SHIFT 13
#define D3DVS_ADDRESSMODE_MASK (1 shl 13)
#define D3DVS_SWIZZLE_SHIFT 16
#define D3DVS_SWIZZLE_MASK &h00FF0000
#define D3DVS_X_X (0 shl 16)
#define D3DVS_X_Y (1 shl 16)
#define D3DVS_X_Z (2 shl 16)
#define D3DVS_X_W (3 shl 16)
#define D3DVS_Y_X (0 shl (16+2))
#define D3DVS_Y_Y (1 shl (16+2))
#define D3DVS_Y_Z (2 shl (16+2))
#define D3DVS_Y_W (3 shl (16+2))
#define D3DVS_Z_X (0 shl (16+4))
#define D3DVS_Z_Y (1 shl (16+4))
#define D3DVS_Z_Z (2 shl (16+4))
#define D3DVS_Z_W (3 shl (16+4))
#define D3DVS_W_X (0 shl (16+6))
#define D3DVS_W_Y (1 shl (16+6))
#define D3DVS_W_Z (2 shl (16+6))
#define D3DVS_W_W (3 shl (16+6))
#define D3DVS_NOSWIZZLE ((0 shl 16) or (1 shl (16+2)) or (2 shl (16+4)) or (3 shl (16+6)))
#define D3DPRESENT_RATE_DEFAULT 0
#define D3DRENDERSTATE_WRAPBIAS 128UL
#define D3DSHADER_ADDRESSMODE_SHIFT 13
#define D3DSHADER_ADDRESSMODE_MASK (1 shl 13)
#define D3DSHADER_COMPARISON_SHIFT	D3DSP_OPCODESPECIFICCONTROL_SHIFT
#define D3DSHADER_COMPARISON_MASK	(&h07 shl D3DSHADER_COMPARISON_SHIFT)
#define D3DSHADER_INSTRUCTION_PREDICATED &h10000000
#define D3DSI_COISSUE &h40000000
#define D3DSI_COMMENTSIZE_SHIFT 16
#define D3DSI_COMMENTSIZE_MASK &h7fff0000
#define D3DSI_OPCODE_MASK &hffff
#define D3DSI_INSTLENGTH_MASK &hf000000
#define D3DSI_INSTLENGTH_SHIFT 24
#define D3DSI_TEXLD_PROJECT	(&h01 shl D3DSP_OPCODESPECIFICCONTROL_SHIFT)
#define D3DSI_TEXLD_BIAS (&h02 shl D3DSP_OPCODESPECIFICCONTROL_SHIFT)
#define D3DSINCOSCONST1	-1.5500992e-006, -2.1701389e-005, 0.0026041667, 0.00026041668
#define D3DSINCOSCONST2	-0.020833334, -0.12500000, 1.0, 0.50000000
#define D3DSP_OPCODESPECIFICCONTROL_MASK &hff0000
#define D3DSP_OPCODESPECIFICCONTROL_SHIFT 16
#define D3DSP_DCL_USAGE_SHIFT 0
#define D3DSP_DCL_USAGE_MASK &h0000000f
#define D3DSP_DCL_USAGEINDEX_SHIFT 16
#define D3DSP_DCL_USAGEINDEX_MASK &h000f0000
#define D3DSP_TEXTURETYPE_SHIFT 27
#define D3DSP_TEXTURETYPE_MASK &h78000000
#define D3DSP_REGNUM_MASK &h7ff
#define D3DSP_WRITEMASK_0 &h10000
#define D3DSP_WRITEMASK_1 &h20000
#define D3DSP_WRITEMASK_2 &h40000
#define D3DSP_WRITEMASK_3 &h80000
#define D3DSP_WRITEMASK_ALL &hf0000
#define D3DSP_DSTMOD_SHIFT 20
#define D3DSP_DSTMOD_MASK &hf00000
#define D3DSPDM_NONE 0
#define D3DSPDM_SATURATE (1 shl 20)
#define D3DSPDM_PARTIALPRECISION (2 shl 20)
#define D3DSPDM_MSAMPCENTROID (4 shl 20)
#define D3DSP_DSTSHIFT_SHIFT 24
#define D3DSP_DSTSHIFT_MASK &hf000000
#define D3DSP_NOSWIZZLE	((0 shl (D3DSP_SWIZZLE_SHIFT + 0)) or (1 shl (D3DSP_SWIZZLE_SHIFT + 2)) or (2 shl (D3DSP_SWIZZLE_SHIFT + 4)) or (3 shl (D3DSP_SWIZZLE_SHIFT + 6)))
#define D3DSP_REPLICATERED	0
#define D3DSP_REPLICATEGREEN ((1 shl (D3DSP_SWIZZLE_SHIFT + 0)) or (1 shl (D3DSP_SWIZZLE_SHIFT + 2)) or (1 shl (D3DSP_SWIZZLE_SHIFT + 4)) or (1 shl (D3DSP_SWIZZLE_SHIFT + 6)))
#define D3DSP_REPLICATEBLUE	((2 shl (D3DSP_SWIZZLE_SHIFT + 0)) or (2 shl (D3DSP_SWIZZLE_SHIFT + 2)) or (2 shl (D3DSP_SWIZZLE_SHIFT + 4)) or (2 shl (D3DSP_SWIZZLE_SHIFT + 6)))
#define D3DSP_REPLICATEALPHA ((3 shl (D3DSP_SWIZZLE_SHIFT + 0)) or (3 shl (D3DSP_SWIZZLE_SHIFT + 2)) or (3 shl (D3DSP_SWIZZLE_SHIFT + 4)) or (3 shl (D3DSP_SWIZZLE_SHIFT + 6)))
#define D3DSP_REGTYPE_SHIFT 28
#define D3DSP_REGTYPE_SHIFT2 8
#define D3DSP_REGTYPE_MASK &h70000000
#define D3DSP_REGTYPE_MASK2 &h1800
#define D3DSP_SRCMOD_SHIFT 24
#define D3DSP_SRCMOD_MASK &hf000000
#define D3DSP_SWIZZLE_SHIFT 16
#define D3DSP_SWIZZLE_MASK &hff0000
#define D3DTS_WORLDMATRIX(index)	cast(D3DTRANSFORMSTATETYPE,index + 256)
#define D3DTS_WORLD	D3DTS_WORLDMATRIX(0)
#define D3DTS_WORLD1 D3DTS_WORLDMATRIX(1)
#define D3DTS_WORLD2 D3DTS_WORLDMATRIX(2)
#define D3DTS_WORLD3 D3DTS_WORLDMATRIX(3)
#define D3DTSS_TCI_PASSTHRU &h00
#define D3DTSS_TCI_CAMERASPACENORMAL &h10000
#define D3DTSS_TCI_CAMERASPACEPOSITION &h20000
#define D3DTSS_TCI_CAMERASPACEREFLECTIONVECTOR &h30000
#define D3DTSS_TCI_SPHEREMAP &h40000
#define D3DUSAGE_RENDERTARGET &h01
#define D3DUSAGE_DEPTHSTENCIL &h02
#define D3DUSAGE_WRITEONLY &h08
#define D3DUSAGE_SOFTWAREPROCESSING &h10
#define D3DUSAGE_DONOTCLIP &h20
#define D3DUSAGE_POINTS &h40
#define D3DUSAGE_RTPATCHES &h80
#define D3DUSAGE_NPATCHES &h100
#define D3DUSAGE_DYNAMIC &h200
#define D3DUSAGE_AUTOGENMIPMAP &h400
#define D3DUSAGE_DMAP &h4000
#define D3DUSAGE_QUERY_LEGACYBUMPMAP &h8000
#define D3DUSAGE_QUERY_SRGBREAD &h10000
#define D3DUSAGE_QUERY_FILTER &h20000
#define D3DUSAGE_QUERY_SRGBWRITE &h40000
#define D3DUSAGE_QUERY_POSTPIXELSHADER_BLENDING &h80000
#define D3DUSAGE_QUERY_VERTEXTEXTURE &h100000
#define D3DWRAP_U &h01
#define D3DWRAP_V &h02
#define D3DWRAP_W &h04
#define D3DWRAPCOORD_0 &h01
#define D3DWRAPCOORD_1 &h02
#define D3DWRAPCOORD_2 &h04
#define D3DWRAPCOORD_3 &h08
#define MAX_DEVICE_IDENTIFIER_STRING 512
#define MAXD3DDECLLENGTH 64
#define MAXD3DDECLUSAGEINDEX 15
#define D3DMAXUSERCLIPPLANES 32
#define D3D_MAX_SIMULTANEOUS_RENDERTARGETS 4
#define D3DPS_VERSION(major,minor) (&hffff0000 or ((major) shl 8) or (minor))
#define D3DVS_VERSION(major,minor) (&hfffe0000 or ((major) shl 8) or (minor))
#define D3DSHADER_VERSION_MAJOR(version) (((version) shr 8) & &hff)
#define D3DSHADER_VERSION_MINOR(version) (((version) shr 0) & &hff)
#define D3DSHADER_COMMENT(s) ((((s) shl D3DSI_COMMENTSIZE_SHIFT) & D3DSI_COMMENTSIZE_MASK) or D3DSIO_COMMENT)
#define D3DPS_END()	&hffff
#define D3DVS_END()	&hffff
#define D3DPRESENTFLAG_LOCKABLE_BACKBUFFER &h01
#define D3DPRESENTFLAG_DISCARD_DEPTHSTENCIL &h02
#define D3DPRESENTFLAG_DEVICECLIP &h04
#define D3DPRESENTFLAG_VIDEO &h10
#define D3DLOCK_READONLY &h10
#define D3DLOCK_NOSYSLOCK &h800
#define D3DLOCK_NOOVERWRITE &h1000
#define D3DLOCK_DISCARD &h2000
#define D3DLOCK_DONOTWAIT &h4000
#define D3DLOCK_NO_DIRTY_UPDATE &h8000
#define D3DISSUE_END &h01
#define D3DISSUE_BEGIN &h02
#define D3DGETDATA_FLUSH &h01
#define D3DRTYPECOUNT	(D3DRTYPE_INDEXBUFFER+1)

#ifndef MAKEFOURCC
#define MAKEFOURCC(ch0, ch1, ch2, ch3) (cuint(cubyte(ch0)) or (cuint(cubyte(ch1)) shl 8) or   _
                					   (cuint(cubyte(ch2)) shl 16) or (cuint(cubyte(ch3)) shl 24 ))
#endif

type D3DCOLOR as DWORD

enum D3DBACKBUFFER_TYPE
	D3DBACKBUFFER_TYPE_MONO = 0
	D3DBACKBUFFER_TYPE_LEFT = 1
	D3DBACKBUFFER_TYPE_RIGHT = 2
	D3DBACKBUFFER_TYPE_FORCE_DWORD = &hffffffff
end enum

enum D3DBASISTYPE
	D3DBASIS_BEZIER = 0
	D3DBASIS_BSPLINE = 1
	D3DBASIS_INTERPOLATE = 2
	D3DBASIS_FORCE_DWORD = &hffffffff
end enum

enum D3DBLEND
	D3DBLEND_ZERO = 1
	D3DBLEND_ONE = 2
	D3DBLEND_SRCCOLOR = 3
	D3DBLEND_INVSRCCOLOR = 4
	D3DBLEND_SRCALPHA = 5
	D3DBLEND_INVSRCALPHA = 6
	D3DBLEND_DESTALPHA = 7
	D3DBLEND_INVDESTALPHA = 8
	D3DBLEND_DESTCOLOR = 9
	D3DBLEND_INVDESTCOLOR = 10
	D3DBLEND_SRCALPHASAT = 11
	D3DBLEND_BOTHSRCALPHA = 12
	D3DBLEND_BOTHINVSRCALPHA = 13
	D3DBLEND_BLENDFACTOR = 14
	D3DBLEND_INVBLENDFACTOR = 15
	D3DBLEND_FORCE_DWORD = &hffffffff
end enum

enum D3DBLENDOP
	D3DBLENDOP_ADD = 1
	D3DBLENDOP_SUBTRACT = 2
	D3DBLENDOP_REVSUBTRACT = 3
	D3DBLENDOP_MIN = 4
	D3DBLENDOP_MAX = 5
	D3DBLENDOP_FORCE_DWORD = &h7fffffff
end enum

enum D3DCMPFUNC
	D3DCMP_NEVER = 1
	D3DCMP_LESS = 2
	D3DCMP_EQUAL = 3
	D3DCMP_LESSEQUAL = 4
	D3DCMP_GREATER = 5
	D3DCMP_NOTEQUAL = 6
	D3DCMP_GREATEREQUAL = 7
	D3DCMP_ALWAYS = 8
	D3DCMP_FORCE_DWORD = &hffffffff
end enum

enum D3DCUBEMAP_FACES
	D3DCUBEMAP_FACE_POSITIVE_X = 0
	D3DCUBEMAP_FACE_NEGATIVE_X = 1
	D3DCUBEMAP_FACE_POSITIVE_Y = 2
	D3DCUBEMAP_FACE_NEGATIVE_Y = 3
	D3DCUBEMAP_FACE_POSITIVE_Z = 4
	D3DCUBEMAP_FACE_NEGATIVE_Z = 5
	D3DCUBEMAP_FACE_FORCE_DWORD = &hffffffff
end enum

enum D3DCULL
	D3DCULL_NONE = 1
	D3DCULL_CW = 2
	D3DCULL_CCW = 3
	D3DCULL_FORCE_DWORD = &hffffffff
end enum

enum D3DDEBUGMONITORTOKENS
	D3DDMT_ENABLE = 0
	D3DDMT_DISABLE = 1
	D3DDMT_FORCE_DWORD = &hffffffff
end enum

enum D3DDECLMETHOD
	D3DDECLMETHOD_DEFAULT = 0
	D3DDECLMETHOD_PARTIALU = 1
	D3DDECLMETHOD_PARTIALV = 2
	D3DDECLMETHOD_CROSSUV = 3
	D3DDECLMETHOD_UV = 4
	D3DDECLMETHOD_LOOKUP = 5
	D3DDECLMETHOD_LOOKUPPRESAMPLED = 6
end enum

enum D3DDECLTYPE
	D3DDECLTYPE_FLOAT1 = 0
	D3DDECLTYPE_FLOAT2 = 1
	D3DDECLTYPE_FLOAT3 = 2
	D3DDECLTYPE_FLOAT4 = 3
	D3DDECLTYPE_D3DCOLOR = 4
	D3DDECLTYPE_UBYTE4 = 5
	D3DDECLTYPE_SHORT2 = 6
	D3DDECLTYPE_SHORT4 = 7
	D3DDECLTYPE_UBYTE4N = 8
	D3DDECLTYPE_SHORT2N = 9
	D3DDECLTYPE_SHORT4N = 10
	D3DDECLTYPE_USHORT2N = 11
	D3DDECLTYPE_USHORT4N = 12
	D3DDECLTYPE_UDEC3 = 13
	D3DDECLTYPE_DEC3N = 14
	D3DDECLTYPE_FLOAT16_2 = 15
	D3DDECLTYPE_FLOAT16_4 = 16
	D3DDECLTYPE_UNUSED = 17
end enum

enum D3DDECLUSAGE
	D3DDECLUSAGE_POSITION = 0
	D3DDECLUSAGE_BLENDWEIGHT = 1
	D3DDECLUSAGE_BLENDINDICES = 2
	D3DDECLUSAGE_NORMAL = 3
	D3DDECLUSAGE_PSIZE = 4
	D3DDECLUSAGE_TEXCOORD = 5
	D3DDECLUSAGE_TANGENT = 6
	D3DDECLUSAGE_BINORMAL = 7
	D3DDECLUSAGE_TESSFACTOR = 8
	D3DDECLUSAGE_POSITIONT = 9
	D3DDECLUSAGE_COLOR = 10
	D3DDECLUSAGE_FOG = 11
	D3DDECLUSAGE_DEPTH = 12
	D3DDECLUSAGE_SAMPLE = 13
end enum

enum D3DDEGREETYPE
	D3DDEGREE_LINEAR = 1
	D3DDEGREE_QUADRATIC = 2
	D3DDEGREE_CUBIC = 3
	D3DDEGREE_QUINTIC = 5
	D3DDEGREE_FORCE_DWORD = &hffffffff
end enum

enum D3DDEVTYPE
	D3DDEVTYPE_HAL = 1
	D3DDEVTYPE_REF = 2
	D3DDEVTYPE_SW = 3
	D3DDEVTYPE_FORCE_DWORD = &hffffffff
end enum

enum D3DFILLMODE
	D3DFILL_POINT = 1
	D3DFILL_WIREFRAME = 2
	D3DFILL_SOLID = 3
	D3DFILL_FORCE_DWORD = &hffffffff
end enum

enum D3DFOGMODE
	D3DFOG_NONE = 0
	D3DFOG_EXP = 1
	D3DFOG_EXP2 = 2
	D3DFOG_LINEAR = 3
	D3DFOG_FORCE_DWORD = &hffffffff
end enum

enum D3DFORMAT
	D3DFMT_UNKNOWN = 0
	D3DFMT_R8G8B8 = 20
	D3DFMT_A8R8G8B8 = 21
	D3DFMT_X8R8G8B8 = 22
	D3DFMT_R5G6B5 = 23
	D3DFMT_X1R5G5B5 = 24
	D3DFMT_A1R5G5B5 = 25
	D3DFMT_A4R4G4B4 = 26
	D3DFMT_R3G3B2 = 27
	D3DFMT_A8 = 28
	D3DFMT_A8R3G3B2 = 29
	D3DFMT_X4R4G4B4 = 30
	D3DFMT_A2B10G10R10 = 31
	D3DFMT_A8B8G8R8 = 32
	D3DFMT_X8B8G8R8 = 33
	D3DFMT_G16R16 = 34
	D3DFMT_A2R10G10B10 = 35
	D3DFMT_A16B16G16R16 = 36
	D3DFMT_A8P8 = 40
	D3DFMT_P8 = 41
	D3DFMT_L8 = 50
	D3DFMT_A8L8 = 51
	D3DFMT_A4L4 = 52
	D3DFMT_V8U8 = 60
	D3DFMT_L6V5U5 = 61
	D3DFMT_X8L8V8U8 = 62
	D3DFMT_Q8W8V8U8 = 63
	D3DFMT_V16U16 = 64
	D3DFMT_A2W10V10U10 = 67
	D3DFMT_UYVY = MAKEFOURCC(asc("U"),asc("Y"),asc("V"),asc("Y"))
	D3DFMT_R8G8_B8G8 = MAKEFOURCC(asc("R"),asc("G"),asc("B"),asc("G"))
	D3DFMT_YUY2 = MAKEFOURCC(asc("Y"),asc("U"),asc("Y"),asc("2"))
	D3DFMT_G8R8_G8B8 = MAKEFOURCC(asc("G"),asc("R"),asc("G"),asc("B"))
	D3DFMT_DXT1 = MAKEFOURCC(asc("D"),asc("X"),asc("T"),asc("1"))
	D3DFMT_DXT2 = MAKEFOURCC(asc("D"),asc("X"),asc("T"),asc("2"))
	D3DFMT_DXT3 = MAKEFOURCC(asc("D"),asc("X"),asc("T"),asc("3"))
	D3DFMT_DXT4 = MAKEFOURCC(asc("D"),asc("X"),asc("T"),asc("4"))
	D3DFMT_DXT5 = MAKEFOURCC(asc("D"),asc("X"),asc("T"),asc("5"))
	D3DFMT_D16_LOCKABLE = 70
	D3DFMT_D32 = 71
	D3DFMT_D15S1 = 73
	D3DFMT_D24S8 = 75
	D3DFMT_D24X8 = 77
	D3DFMT_D24X4S4 = 79
	D3DFMT_D16 = 80
	D3DFMT_L16 = 81
	D3DFMT_D32F_LOCKABLE = 82
	D3DFMT_D24FS8 = 83
	D3DFMT_VERTEXDATA = 100
	D3DFMT_INDEX16 = 101
	D3DFMT_INDEX32 = 102
	D3DFMT_Q16W16V16U16 = 110
	D3DFMT_MULTI2_ARGB8 = MAKEFOURCC(asc("M"),asc("E"),asc("T"),asc("1"))
	D3DFMT_R16F = 111
	D3DFMT_G16R16F = 112
	D3DFMT_A16B16G16R16F = 113
	D3DFMT_R32F = 114
	D3DFMT_G32R32F = 115
	D3DFMT_A32B32G32R32F = 116
	D3DFMT_CxV8U8 = 117
	D3DFMT_FORCE_DWORD = &hffffffff
end enum

enum D3DLIGHTTYPE
	D3DLIGHT_POINT = 1
	D3DLIGHT_SPOT = 2
	D3DLIGHT_DIRECTIONAL = 3
	D3DLIGHT_FORCE_DWORD = &hffffffff
end enum

enum D3DMATERIALCOLORSOURCE
	D3DMCS_MATERIAL = 0
	D3DMCS_COLOR1 = 1
	D3DMCS_COLOR2 = 2
	D3DMCS_FORCE_DWORD = &hffffffff
end enum

enum D3DMULTISAMPLE_TYPE
	D3DMULTISAMPLE_NONE = 0
	D3DMULTISAMPLE_NONMASKABLE = 1
	D3DMULTISAMPLE_2_SAMPLES = 2
	D3DMULTISAMPLE_3_SAMPLES = 3
	D3DMULTISAMPLE_4_SAMPLES = 4
	D3DMULTISAMPLE_5_SAMPLES = 5
	D3DMULTISAMPLE_6_SAMPLES = 6
	D3DMULTISAMPLE_7_SAMPLES = 7
	D3DMULTISAMPLE_8_SAMPLES = 8
	D3DMULTISAMPLE_9_SAMPLES = 9
	D3DMULTISAMPLE_10_SAMPLES = 10
	D3DMULTISAMPLE_11_SAMPLES = 11
	D3DMULTISAMPLE_12_SAMPLES = 12
	D3DMULTISAMPLE_13_SAMPLES = 13
	D3DMULTISAMPLE_14_SAMPLES = 14
	D3DMULTISAMPLE_15_SAMPLES = 15
	D3DMULTISAMPLE_16_SAMPLES = 16
	D3DMULTISAMPLE_FORCE_DWORD = &hffffffff
end enum

enum D3DORDERTYPE
	D3DORDER_LINEAR = 1
	D3DORDER_QUADRATIC = 2
	D3DORDER_CUBIC = 3
	D3DORDER_QUINTIC = 5
	D3DORDER_FORCE_DWORD = &hffffffff
end enum

enum D3DPATCHEDGESTYLE
	D3DPATCHEDGE_DISCRETE = 0
	D3DPATCHEDGE_CONTINUOUS = 1
	D3DPATCHEDGE_FORCE_DWORD = &hffffffff
end enum

enum D3DPOOL
	D3DPOOL_DEFAULT = 0
	D3DPOOL_MANAGED = 1
	D3DPOOL_SYSTEMMEM = 2
	D3DPOOL_SCRATCH = 3
	D3DPOOL_FORCE_DWORD = &hffffffff
end enum

enum D3DPRIMITIVETYPE
	D3DPT_POINTLIST = 1
	D3DPT_LINELIST = 2
	D3DPT_LINESTRIP = 3
	D3DPT_TRIANGLELIST = 4
	D3DPT_TRIANGLESTRIP = 5
	D3DPT_TRIANGLEFAN = 6
	D3DPT_FORCE_DWORD = &hffffffff
end enum

enum D3DQUERYTYPE
	D3DQUERYTYPE_VCACHE = 4
	D3DQUERYTYPE_RESOURCEMANAGER = 5
	D3DQUERYTYPE_VERTEXSTATS = 6
	D3DQUERYTYPE_EVENT = 8
	D3DQUERYTYPE_OCCLUSION = 9
end enum

enum D3DRENDERSTATETYPE
	D3DRS_ZENABLE = 7
	D3DRS_FILLMODE = 8
	D3DRS_SHADEMODE = 9
	D3DRS_ZWRITEENABLE = 14
	D3DRS_ALPHATESTENABLE = 15
	D3DRS_LASTPIXEL = 16
	D3DRS_SRCBLEND = 19
	D3DRS_DESTBLEND = 20
	D3DRS_CULLMODE = 22
	D3DRS_ZFUNC = 23
	D3DRS_ALPHAREF = 24
	D3DRS_ALPHAFUNC = 25
	D3DRS_DITHERENABLE = 26
	D3DRS_ALPHABLENDENABLE = 27
	D3DRS_FOGENABLE = 28
	D3DRS_SPECULARENABLE = 29
	D3DRS_FOGCOLOR = 34
	D3DRS_FOGTABLEMODE = 35
	D3DRS_FOGSTART = 36
	D3DRS_FOGEND = 37
	D3DRS_FOGDENSITY = 38
	D3DRS_RANGEFOGENABLE = 48
	D3DRS_STENCILENABLE = 52
	D3DRS_STENCILFAIL = 53
	D3DRS_STENCILZFAIL = 54
	D3DRS_STENCILPASS = 55
	D3DRS_STENCILFUNC = 56
	D3DRS_STENCILREF = 57
	D3DRS_STENCILMASK = 58
	D3DRS_STENCILWRITEMASK = 59
	D3DRS_TEXTUREFACTOR = 60
	D3DRS_WRAP0 = 128
	D3DRS_WRAP1 = 129
	D3DRS_WRAP2 = 130
	D3DRS_WRAP3 = 131
	D3DRS_WRAP4 = 132
	D3DRS_WRAP5 = 133
	D3DRS_WRAP6 = 134
	D3DRS_WRAP7 = 135
	D3DRS_CLIPPING = 136
	D3DRS_LIGHTING = 137
	D3DRS_AMBIENT = 139
	D3DRS_FOGVERTEXMODE = 140
	D3DRS_COLORVERTEX = 141
	D3DRS_LOCALVIEWER = 142
	D3DRS_NORMALIZENORMALS = 143
	D3DRS_DIFFUSEMATERIALSOURCE = 145
	D3DRS_SPECULARMATERIALSOURCE = 146
	D3DRS_AMBIENTMATERIALSOURCE = 147
	D3DRS_EMISSIVEMATERIALSOURCE = 148
	D3DRS_VERTEXBLEND = 151
	D3DRS_CLIPPLANEENABLE = 152
	D3DRS_POINTSIZE = 154
	D3DRS_POINTSIZE_MIN = 155
	D3DRS_POINTSPRITEENABLE = 156
	D3DRS_POINTSCALEENABLE = 157
	D3DRS_POINTSCALE_A = 158
	D3DRS_POINTSCALE_B = 159
	D3DRS_POINTSCALE_C = 160
	D3DRS_MULTISAMPLEANTIALIAS = 161
	D3DRS_MULTISAMPLEMASK = 162
	D3DRS_PATCHEDGESTYLE = 163
	D3DRS_DEBUGMONITORTOKEN = 165
	D3DRS_POINTSIZE_MAX = 166
	D3DRS_INDEXEDVERTEXBLENDENABLE = 167
	D3DRS_COLORWRITEENABLE = 168
	D3DRS_TWEENFACTOR = 170
	D3DRS_BLENDOP = 171
	D3DRS_POSITIONDEGREE = 172
	D3DRS_NORMALDEGREE = 173
	D3DRS_SCISSORTESTENABLE = 174
	D3DRS_SLOPESCALEDEPTHBIAS = 175
	D3DRS_ANTIALIASEDLINEENABLE = 176
	D3DRS_MINTESSELLATIONLEVEL = 178
	D3DRS_MAXTESSELLATIONLEVEL = 179
	D3DRS_ADAPTIVETESS_X = 180
	D3DRS_ADAPTIVETESS_Y = 181
	D3DRS_ADAPTIVETESS_Z = 182
	D3DRS_ADAPTIVETESS_W = 183
	D3DRS_ENABLEADAPTIVETESSELLATION = 184
	D3DRS_TWOSIDEDSTENCILMODE = 185
	D3DRS_CCW_STENCILFAIL = 186
	D3DRS_CCW_STENCILZFAIL = 187
	D3DRS_CCW_STENCILPASS = 188
	D3DRS_CCW_STENCILFUNC = 189
	D3DRS_COLORWRITEENABLE1 = 190
	D3DRS_COLORWRITEENABLE2 = 191
	D3DRS_COLORWRITEENABLE3 = 192
	D3DRS_BLENDFACTOR = 193
	D3DRS_SRGBWRITEENABLE = 194
	D3DRS_DEPTHBIAS = 195
	D3DRS_WRAP8 = 198
	D3DRS_WRAP9 = 199
	D3DRS_WRAP10 = 200
	D3DRS_WRAP11 = 201
	D3DRS_WRAP12 = 202
	D3DRS_WRAP13 = 203
	D3DRS_WRAP14 = 204
	D3DRS_WRAP15 = 205
	D3DRS_SEPARATEALPHABLENDENABLE = 206
	D3DRS_SRCBLENDALPHA = 207
	D3DRS_DESTBLENDALPHA = 208
	D3DRS_BLENDOPALPHA = 209
	D3DRS_FORCE_DWORD = &hffffffff
end enum

enum D3DRESOURCETYPE
	D3DRTYPE_SURFACE = 1
	D3DRTYPE_VOLUME = 2
	D3DRTYPE_TEXTURE = 3
	D3DRTYPE_VOLUMETEXTURE = 4
	D3DRTYPE_CUBETEXTURE = 5
	D3DRTYPE_VERTEXBUFFER = 6
	D3DRTYPE_INDEXBUFFER = 7
	D3DRTYPE_FORCE_DWORD = &hffffffff
end enum

enum D3DSAMPLER_TEXTURE_TYPE
	D3DSTT_UNKNOWN = 0 shl 27
	D3DSTT_2D = 2 shl 27
	D3DSTT_CUBE = 3 shl 27
	D3DSTT_VOLUME = 4 shl 27
	D3DSTT_FORCE_DWORD = &hffffffff
end enum

enum D3DSAMPLERSTATETYPE
	D3DSAMP_ADDRESSU = 1
	D3DSAMP_ADDRESSV = 2
	D3DSAMP_ADDRESSW = 3
	D3DSAMP_BORDERCOLOR = 4
	D3DSAMP_MAGFILTER = 5
	D3DSAMP_MINFILTER = 6
	D3DSAMP_MIPFILTER = 7
	D3DSAMP_MIPMAPLODBIAS = 8
	D3DSAMP_MAXMIPLEVEL = 9
	D3DSAMP_MAXANISOTROPY = 10
	D3DSAMP_SRGBTEXTURE = 11
	D3DSAMP_ELEMENTINDEX = 12
	D3DSAMP_DMAPOFFSET = 13
	D3DSAMP_FORCE_DWORD = &hffffffff
end enum

enum D3DSHADEMODE
	D3DSHADE_FLAT = 1
	D3DSHADE_GOURAUD = 2
	D3DSHADE_PHONG = 3
	D3DSHADE_FORCE_DWORD = &hffffffff
end enum

enum D3DSHADER_ADDRESSMODE_TYPE
	D3DSHADER_ADDRMODE_ABSOLUTE = (0 shl 13)
	D3DSHADER_ADDRMODE_RELATIVE = (1 shl 13)
	D3DSHADER_ADDRMODE_FORCE_DWORD = &hffffffff
end enum

enum D3DSHADER_COMPARISON
	D3DSPC_RESERVED0 = 0
	D3DSPC_GT = 1
	D3DSPC_EQ = 2
	D3DSPC_GE = 3
	D3DSPC_LT = 4
	D3DSPC_NE = 5
	D3DSPC_LE = 6
	D3DSPC_RESERVED1 = 7
end enum

enum D3DSHADER_INSTRUCTION_OPCODE_TYPE
	D3DSIO_NOP = 0
	D3DSIO_MOV = 1
	D3DSIO_ADD = 2
	D3DSIO_SUB = 3
	D3DSIO_MAD = 4
	D3DSIO_MUL = 5
	D3DSIO_RCP = 6
	D3DSIO_RSQ = 7
	D3DSIO_DP3 = 8
	D3DSIO_DP4 = 9
	D3DSIO_MIN = 10
	D3DSIO_MAX = 11
	D3DSIO_SLT = 12
	D3DSIO_SGE = 13
	D3DSIO_EXP = 14
	D3DSIO_LOG = 15
	D3DSIO_LIT = 16
	D3DSIO_DST = 17
	D3DSIO_LRP = 18
	D3DSIO_FRC = 19
	D3DSIO_M4x4 = 20
	D3DSIO_M4x3 = 21
	D3DSIO_M3x4 = 22
	D3DSIO_M3x3 = 23
	D3DSIO_M3x2 = 24
	D3DSIO_CALL = 25
	D3DSIO_CALLNZ = 26
	D3DSIO_LOOP = 27
	D3DSIO_RET = 28
	D3DSIO_ENDLOOP = 29
	D3DSIO_LABEL = 30
	D3DSIO_DCL = 31
	D3DSIO_POW = 32
	D3DSIO_CRS = 33
	D3DSIO_SGN = 34
	D3DSIO_ABS = 35
	D3DSIO_NRM = 36
	D3DSIO_SINCOS = 37
	D3DSIO_REP = 38
	D3DSIO_ENDREP = 39
	D3DSIO_IF = 40
	D3DSIO_IFC = 41
	D3DSIO_ELSE = 42
	D3DSIO_ENDIF = 43
	D3DSIO_BREAK = 44
	D3DSIO_BREAKC = 45
	D3DSIO_MOVA = 46
	D3DSIO_DEFB = 47
	D3DSIO_DEFI = 48
	D3DSIO_TEXCOORD = 64
	D3DSIO_TEXKILL = 65
	D3DSIO_TEX = 66
	D3DSIO_TEXBEM = 67
	D3DSIO_TEXBEML = 68
	D3DSIO_TEXREG2AR = 69
	D3DSIO_TEXREG2GB = 70
	D3DSIO_TEXM3x2PAD = 71
	D3DSIO_TEXM3x2TEX = 72
	D3DSIO_TEXM3x3PAD = 73
	D3DSIO_TEXM3x3TEX = 74
	D3DSIO_RESERVED0 = 75
	D3DSIO_TEXM3x3SPEC = 76
	D3DSIO_TEXM3x3VSPEC = 77
	D3DSIO_EXPP = 78
	D3DSIO_LOGP = 79
	D3DSIO_CND = 80
	D3DSIO_DEF = 81
	D3DSIO_TEXREG2RGB = 82
	D3DSIO_TEXDP3TEX = 83
	D3DSIO_TEXM3x2DEPTH = 84
	D3DSIO_TEXDP3 = 85
	D3DSIO_TEXM3x3 = 86
	D3DSIO_TEXDEPTH = 87
	D3DSIO_CMP = 88
	D3DSIO_BEM = 89
	D3DSIO_DP2ADD = 90
	D3DSIO_DSX = 91
	D3DSIO_DSY = 92
	D3DSIO_TEXLDD = 93
	D3DSIO_SETP = 94
	D3DSIO_TEXLDL = 95
	D3DSIO_BREAKP = 96
	D3DSIO_PHASE = &hfffd
	D3DSIO_COMMENT = &hfffe
	D3DSIO_END = &hffff
	D3DSIO_FORCE_DWORD = &hffffffff
end enum

enum D3DSHADER_MISCTYPE_OFFSETS
	D3DSMO_POSITION = 0
	D3DSMO_FACE = 1
end enum

enum D3DSHADER_PARAM_REGISTER_TYPE
	D3DSPR_TEMP = 0
	D3DSPR_INPUT = 1
	D3DSPR_CONST = 2
	D3DSPR_ADDR = 3
	D3DSPR_TEXTURE = 3
	D3DSPR_RASTOUT = 4
	D3DSPR_ATTROUT = 5
	D3DSPR_TEXCRDOUT = 6
	D3DSPR_OUTPUT = 6
	D3DSPR_CONSTINT = 7
	D3DSPR_COLOROUT = 8
	D3DSPR_DEPTHOUT = 9
	D3DSPR_SAMPLER = 10
	D3DSPR_CONST2 = 11
	D3DSPR_CONST3 = 12
	D3DSPR_CONST4 = 13
	D3DSPR_CONSTBOOL = 14
	D3DSPR_LOOP = 15
	D3DSPR_TEMPFLOAT16 = 16
	D3DSPR_MISCTYPE = 17
	D3DSPR_LABEL = 18
	D3DSPR_PREDICATE = 19
	D3DSPR_FORCE_DWORD = &hffffffff
end enum

enum D3DSHADER_PARAM_SRCMOD_TYPE
	D3DSPSM_NONE = 0 shl 24
	D3DSPSM_NEG = 1 shl 24
	D3DSPSM_BIAS = 2 shl 24
	D3DSPSM_BIASNEG = 3 shl 24
	D3DSPSM_SIGN = 4 shl 24
	D3DSPSM_SIGNNEG = 5 shl 24
	D3DSPSM_COMP = 6 shl 24
	D3DSPSM_X2 = 7 shl 24
	D3DSPSM_X2NEG = 8 shl 24
	D3DSPSM_DZ = 9 shl 24
	D3DSPSM_DW = 10 shl 24
	D3DSPSM_ABS = 11 shl 24
	D3DSPSM_ABSNEG = 12 shl 24
	D3DSPSM_NOT = 13 shl 24
	D3DSPSM_FORCE_DWORD = &hffffffff
end enum

enum D3DVS_ADDRESSMODE_TYPE
	D3DVS_ADDRMODE_ABSOLUTE = (0 shl 13)
	D3DVS_ADDRMODE_RELATIVE = (1 shl 13)
	D3DVS_ADDRMODE_FORCE_DWORD = &hffffffff
end enum

enum D3DVS_RASTOUT_OFFSETS
	D3DSRO_POSITION = 0
	D3DSRO_FOG = 1
	D3DSRO_POINT_SIZE = 2
	D3DSRO_FORCE_DWORD = &hffffffff
end enum

enum D3DSTENCILOP
	D3DSTENCILOP_KEEP = 1
	D3DSTENCILOP_ZERO = 2
	D3DSTENCILOP_REPLACE = 3
	D3DSTENCILOP_INCRSAT = 4
	D3DSTENCILOP_DECRSAT = 5
	D3DSTENCILOP_INVERT = 6
	D3DSTENCILOP_INCR = 7
	D3DSTENCILOP_DECR = 8
	D3DSTENCILOP_FORCE_DWORD = &h7fffffff
end enum

enum D3DSTATEBLOCKTYPE
	D3DSBT_ALL = 1
	D3DSBT_PIXELSTATE = 2
	D3DSBT_VERTEXSTATE = 3
	D3DSBT_FORCE_DWORD = &hffffffff
end enum

enum D3DSWAPEFFECT
	D3DSWAPEFFECT_DISCARD = 1
	D3DSWAPEFFECT_FLIP = 2
	D3DSWAPEFFECT_COPY = 3
	D3DSWAPEFFECT_COPY_VSYNC = 4
	D3DSWAPEFFECT_FORCE_DWORD = &hffffffff
end enum

enum D3DTEXTUREADDRESS
	D3DTADDRESS_WRAP = 1
	D3DTADDRESS_MIRROR = 2
	D3DTADDRESS_CLAMP = 3
	D3DTADDRESS_BORDER = 4
	D3DTADDRESS_MIRRORONCE = 5
	D3DTADDRESS_FORCE_DWORD = &hffffffff
end enum

enum D3DTEXTUREFILTERTYPE
	D3DTEXF_NONE = 0
	D3DTEXF_POINT = 1
	D3DTEXF_LINEAR = 2
	D3DTEXF_ANISOTROPIC = 3
	D3DTEXF_PYRAMIDALQUAD = 6
	D3DTEXF_GAUSSIANQUAD = 7
	D3DTEXF_FORCE_DWORD = &hffffffff
end enum

enum D3DTEXTURESTAGESTATETYPE
	D3DTSS_COLOROP = 1
	D3DTSS_COLORARG1 = 2
	D3DTSS_COLORARG2 = 3
	D3DTSS_ALPHAOP = 4
	D3DTSS_ALPHAARG1 = 5
	D3DTSS_ALPHAARG2 = 6
	D3DTSS_BUMPENVMAT00 = 7
	D3DTSS_BUMPENVMAT01 = 8
	D3DTSS_BUMPENVMAT10 = 9
	D3DTSS_BUMPENVMAT11 = 10
	D3DTSS_TEXCOORDINDEX = 11
	D3DTSS_BUMPENVLSCALE = 22
	D3DTSS_BUMPENVLOFFSET = 23
	D3DTSS_TEXTURETRANSFORMFLAGS = 24
	D3DTSS_ADDRESSW = 25
	D3DTSS_COLORARG0 = 26
	D3DTSS_ALPHAARG0 = 27
	D3DTSS_RESULTARG = 28
	D3DTSS_CONSTANT = 32
	D3DTSS_FORCE_DWORD = &hffffffff
end enum

enum D3DTEXTUREOP
	D3DTOP_DISABLE = 1
	D3DTOP_SELECTARG1 = 2
	D3DTOP_SELECTARG2 = 3
	D3DTOP_MODULATE = 4
	D3DTOP_MODULATE2X = 5
	D3DTOP_MODULATE4X = 6
	D3DTOP_ADD = 7
	D3DTOP_ADDSIGNED = 8
	D3DTOP_ADDSIGNED2X = 9
	D3DTOP_SUBTRACT = 10
	D3DTOP_ADDSMOOTH = 11
	D3DTOP_BLENDDIFFUSEALPHA = 12
	D3DTOP_BLENDTEXTUREALPHA = 13
	D3DTOP_BLENDFACTORALPHA = 14
	D3DTOP_BLENDTEXTUREALPHAPM = 15
	D3DTOP_BLENDCURRENTALPHA = 16
	D3DTOP_PREMODULATE = 17
	D3DTOP_MODULATEALPHA_ADDCOLOR = 18
	D3DTOP_MODULATECOLOR_ADDALPHA = 19
	D3DTOP_MODULATEINVALPHA_ADDCOLOR = 20
	D3DTOP_MODULATEINVCOLOR_ADDALPHA = 21
	D3DTOP_BUMPENVMAP = 22
	D3DTOP_BUMPENVMAPLUMINANCE = 23
	D3DTOP_DOTPRODUCT3 = 24
	D3DTOP_MULTIPLYADD = 25
	D3DTOP_LERP = 26
	D3DTOP_FORCE_DWORD = &hffffffff
end enum

enum D3DTEXTURETRANSFORMFLAGS
	D3DTTFF_DISABLE = 0
	D3DTTFF_COUNT1 = 1
	D3DTTFF_COUNT2 = 2
	D3DTTFF_COUNT3 = 3
	D3DTTFF_COUNT4 = 4
	D3DTTFF_PROJECTED = 256
	D3DTTFF_FORCE_DWORD = &hffffffff
end enum

enum D3DTRANSFORMSTATETYPE
	D3DTS_VIEW = 2
	D3DTS_PROJECTION = 3
	D3DTS_TEXTURE0 = 16
	D3DTS_TEXTURE1 = 17
	D3DTS_TEXTURE2 = 18
	D3DTS_TEXTURE3 = 19
	D3DTS_TEXTURE4 = 20
	D3DTS_TEXTURE5 = 21
	D3DTS_TEXTURE6 = 22
	D3DTS_TEXTURE7 = 23
	D3DTS_FORCE_DWORD = &hffffffff
end enum

enum D3DVERTEXBLENDFLAGS
	D3DVBF_DISABLE = 0
	D3DVBF_1WEIGHTS = 1
	D3DVBF_2WEIGHTS = 2
	D3DVBF_3WEIGHTS = 3
	D3DVBF_TWEENING = 255
	D3DVBF_0WEIGHTS = 256
	D3DVBF_FORCE_DWORD = &hffffffff
end enum

enum D3DZBUFFERTYPE
	D3DZB_FALSE = 0
	D3DZB_TRUE = 1
	D3DZB_USEW = 2
	D3DZB_FORCE_DWORD = &hffffffff
end enum

type D3DADAPTER_IDENTIFIER9
	Driver as zstring * 512
	Description as zstring * 512
	DeviceName as zstring * 32
	DriverVersion_ as LARGE_INTEGER
	VendorId as DWORD
	DeviceId as DWORD
	SubSysId as DWORD
	Revision as DWORD
	DeviceIdentifier as GUID
	WHQLLevel as DWORD
end type

type D3DBOX
	Left as UINT
	Top as UINT
	Right as UINT
	Bottom as UINT
	Front as UINT
	Back as UINT
end type

type D3DCLIPSTATUS9
	ClipUnion as DWORD
	ClipIntersection as DWORD
end type

type D3DCOLORVALUE
	r as single
	g as single
	b as single
	a as single
end type

type D3DRESOURCESTATS
	bThrashing as BOOL
	ApproxBytesDownloaded as DWORD
	NumEvicts as DWORD
	NumVidCreates as DWORD
	LastPri as DWORD
	NumUsed as DWORD
	NumUsedInVidMem as DWORD
	WorkingSet as DWORD
	WorkingSetBytes as DWORD
	TotalManaged as DWORD
	TotalBytes as DWORD
end type

type D3DDEVICE_CREATION_PARAMETERS
	AdapterOrdinal as UINT
	DeviceType as D3DDEVTYPE
	hFocusWindow as HWND
	BehaviorFlags as DWORD
end type

type D3DDEVINFO_RESOURCEMANAGER
	stats(0 to (D3DRTYPE_INDEXBUFFER+1)-1) as D3DRESOURCESTATS
end type

type LPD3DDEVINFO_RESOURCEMANAGER as D3DDEVINFO_RESOURCEMANAGER ptr

type D3DDEVINFO_D3DVERTEXSTATS
	NumRenderedTriangles as DWORD
	NumExtraClippingTriangles as DWORD
end type

type LPD3DDEVINFO_D3DVERTEXSTATS as D3DDEVINFO_D3DVERTEXSTATS ptr

type D3DDEVINFO_VCACHE
	Pattern as DWORD
	OptMethod as DWORD
	CacheSize as DWORD
	MagicNumber as DWORD
end type

type LPD3DDEVINFO_VCACHE as D3DDEVINFO_VCACHE ptr

type D3DDISPLAYMODE
	Width as UINT
	Height as UINT
	RefreshRate as UINT
	Format as D3DFORMAT
end type

type D3DGAMMARAMP
	red(0 to 256-1) as WORD
	green(0 to 256-1) as WORD
	blue(0 to 256-1) as WORD
end type

type D3DINDEXBUFFER_DESC
	Format as D3DFORMAT
	Type as D3DRESOURCETYPE
	Usage as DWORD
	Pool as D3DPOOL
	Size as UINT
end type

type D3DVECTOR
	x as single
	y as single
	z as single
end type

type D3DLIGHT9
	Type as D3DLIGHTTYPE
	Diffuse as D3DCOLORVALUE
	Specular as D3DCOLORVALUE
	Ambient as D3DCOLORVALUE
	Position as D3DVECTOR
	Direction as D3DVECTOR
	Range as single
	Falloff as single
	Attenuation0 as single
	Attenuation1 as single
	Attenuation2 as single
	Theta as single
	Phi as single
end type

type D3DLOCKED_BOX
	RowPitch as INT_
	SlicePitch as INT_
	pBits as any ptr
end type

type D3DLOCKED_RECT
	Pitch as INT_
	pBits as any ptr
end type

type D3DMATERIAL9
	Diffuse as D3DCOLORVALUE
	Ambient as D3DCOLORVALUE
	Specular as D3DCOLORVALUE
	Emissive as D3DCOLORVALUE
	Power as single
end type

union D3DMATRIX
	type
		_11 as single
		_12 as single
		_13 as single
		_14 as single
		_21 as single
		_22 as single
		_23 as single
		_24 as single
		_31 as single
		_32 as single
		_33 as single
		_34 as single
		_41 as single
		_42 as single
		_43 as single
		_44 as single
	end type
	m(0 to 4-1, 0 to 4-1) as single
end union

type D3DPRESENT_PARAMETERS
	BackBufferWidth as UINT
	BackBufferHeight as UINT
	BackBufferFormat as D3DFORMAT
	BackBufferCount as UINT
	MultiSampleType as D3DMULTISAMPLE_TYPE
	MultiSampleQuality as DWORD
	SwapEffect as D3DSWAPEFFECT
	hDeviceWindow as HWND
	Windowed as BOOL
	EnableAutoDepthStencil as BOOL
	AutoDepthStencilFormat as D3DFORMAT
	Flags as DWORD
	FullScreen_RefreshRateInHz as UINT
	PresentationInterval as UINT
end type

type D3DRANGE
	Offset as UINT
	Size as UINT
end type

type D3DRASTER_STATUS
	InVBlank as BOOL
	ScanLine as UINT
end type

type D3DRECT
	x1 as LONG
	y1 as LONG
	x2 as LONG
	y2 as LONG
end type

type D3DRECTPATCH_INFO
	StartVertexOffsetWidth as UINT
	StartVertexOffsetHeight as UINT
	Width as UINT
	Height as UINT
	Stride as UINT
	Basis as D3DBASISTYPE
	Order as D3DORDERTYPE
end type

type D3DSURFACE_DESC
	Format as D3DFORMAT
	Type as D3DRESOURCETYPE
	Usage as DWORD
	Pool as D3DPOOL
	Size as UINT
	MultiSampleType as D3DMULTISAMPLE_TYPE
	Width as UINT
	Height as UINT
end type

type D3DTRIPATCH_INFO
	StartVertexOffset as UINT
	NumVertices as UINT
	Basis as D3DBASISTYPE
	Order as D3DORDERTYPE
end type

type D3DVERTEXBUFFER_DESC
	Format as D3DFORMAT
	Type as D3DRESOURCETYPE
	Usage as DWORD
	Pool as D3DPOOL
	Size as UINT
	FVF as DWORD
end type

type D3DVERTEXELEMENT9
	Stream as WORD
	Offset as WORD
	Type as UBYTE
	Method as UBYTE
	Usage as UBYTE
	UsageIndex as UBYTE
end type

type LPD3DVERTEXELEMENT9 as D3DVERTEXELEMENT9 ptr

type D3DVIEWPORT9
	X as DWORD
	Y as DWORD
	Width as DWORD
	Height as DWORD
	MinZ as single
	MaxZ as single
end type

type D3DVOLUME_DESC
	Format as D3DFORMAT
	Type as D3DRESOURCETYPE
	Usage as DWORD
	Pool as D3DPOOL
	Width as UINT
	Height as UINT
	Depth as UINT
end type

#endif
