/*************************************************************************
** BMP.H: Header File
*************************************************************************/

typedef struct tagBITMAPFILEHEADER
{
        WORD  bfType;                   // "BM" or 0x4D42
        unsigned long bfSize;                   // Size of file in bytes
        WORD  bfReserved1;              // Set to 0
        WORD  bfReserved2;              // Set to 0
        unsigned long bfOffBits;                // Offset in file where
                                                // the bits begin
} BITMAPFILEHEADER;

typedef struct tagBITMAPINFOHEADER
{
        unsigned long biSize;                   // Size of the structure
        unsigned long biWidth;                  // Width in pixels
        unsigned long biHeight;                 // Height in pixels
        WORD  biPlanes;                 // # of color Planes: Set to 1
        WORD  biBitCount;               // Color bits per pixel
        unsigned long biCompression;            // Compression Scheme
        unsigned long biSizeImage;              // Number of bitmap bytes
        unsigned long biXPelsPerMeter;          // Horizontal Resolution
        unsigned long biYPelsPerMeter;          // Vertical Resolution
        unsigned long biClrUsed;                // Number of colors used
        unsigned long biClrImportant;           // Important colors

} BITMAPINFOHEADER;

typedef struct tagRGBQUAD {
   unsigned char    rgbBlue;  //Specifies the intensity of blue in the color. 
   unsigned char    rgbGreen; //Specifies the intensity of green in the color. 
   unsigned char    rgbRed;	 //Specifies the intensity of red in the color. 
   unsigned char    rgbReserved;//Is not used and must be set to zero. 
} RGBQUAD;


#ifndef BMP_OK
#define BMP_OK -1
#define BMP_BadDriver 0
#define BMP_TooBig 1
#define BMP_WrongVideo 2
#define BMP_Compression 3
#define BMP_FileError 4
#define BMP_TrueColour 5
#define BMP_Unknown 6
#define BMP_Memory 6
#endif

